/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.IOException;

public class BmpReader
extends ImageReader
implements FileTypes {
    String filename;
    int xSize;
    int ySize = 0;
    boolean typeNotified = false;
    int maxval = 0;
    long offset = 0L;
    long fileSize = 0L;
    long lutOffset = 0L;
    int bitsPerPixel = 0;
    long byteSize = 0L;
    int[] colorLut;
    int colorDepth;

    public BmpReader(String string) {
        this.filename = string;
        this.readHeader();
    }

    public int getXSize() {
        if (this.typeNotified) {
            return this.xSize;
        }
        return 0;
    }

    public int getYSize() {
        if (this.typeNotified) {
            return this.ySize;
        }
        return 0;
    }

    private int modulo(int n, int n2) {
        return n - n / n2 * n2;
    }

    public int[] readFile() {
        if (this.typeNotified) {
            try {
                int n = 0;
                int n2 = this.xSize * this.ySize;
                int[] nArray = new int[n2];
                FileInputStream fileInputStream = new FileInputStream(this.filename);
                int n3 = 0;
                while ((long)n3 < this.offset) {
                    n = fileInputStream.read();
                    ++n3;
                }
                if (this.bitsPerPixel == 24) {
                    int n4 = this.xSize * 3 % 4;
                    int n5 = this.ySize - 1;
                    while (n5 >= 0) {
                        int n6 = 0;
                        while (n6 < this.xSize) {
                            int n7 = n5 * this.xSize + n6;
                            if (n7 < nArray.length) {
                                nArray[n7] = fileInputStream.read();
                                int n8 = n7;
                                nArray[n8] = nArray[n8] + fileInputStream.read() * 256;
                                int n9 = n7;
                                nArray[n9] = nArray[n9] + fileInputStream.read() * 65536;
                                int n10 = n7;
                                nArray[n10] = nArray[n10] + -16777216;
                            }
                            ++n6;
                        }
                        int n11 = 0;
                        while (n11 < (4 - n4) % 4) {
                            n = fileInputStream.read();
                            ++n11;
                        }
                        --n5;
                    }
                } else if (this.bitsPerPixel == 8) {
                    int n12 = this.ySize - 1;
                    while (n12 >= 0) {
                        int n13 = 0;
                        while (n13 < this.xSize) {
                            int n14 = n12 * this.xSize + n13;
                            n = fileInputStream.read();
                            nArray[n14] = this.colorLut[n];
                            ++n13;
                        }
                        int n15 = 0;
                        while (n15 < (4 - this.xSize % 4) % 4) {
                            n = fileInputStream.read();
                            ++n15;
                        }
                        --n12;
                    }
                } else if (this.bitsPerPixel <= 4) {
                    int n16 = 0;
                    int n17 = 0;
                    int n18 = this.ySize - 1;
                    while (n18 >= 0) {
                        int n19 = 0;
                        while (n19 < this.xSize) {
                            int n20 = n18 * this.xSize + n19;
                            if (n16 == 0) {
                                n = fileInputStream.read();
                                ++n17;
                            }
                            int n21 = (n << n16 & 256 - (int)Math.pow(2.0, 8 - this.bitsPerPixel)) >>> 8 - this.bitsPerPixel;
                            nArray[n20] = this.colorLut[n21];
                            if ((n16 += this.bitsPerPixel) == 8) {
                                n16 = 0;
                            }
                            ++n19;
                        }
                        int n22 = 0;
                        while (n22 < (4 - n17 % 4) % 4) {
                            n = fileInputStream.read();
                            ++n22;
                        }
                        n17 = 0;
                        n16 = 0;
                        --n18;
                    }
                }
                fileInputStream.close();
                return nArray;
            }
            catch (IOException iOException) {
                System.out.println("Error: java.io.IOException!!");
                return null;
            }
        }
        return null;
    }

    private void readHeader() {
        try {
            String string = "";
            FileInputStream fileInputStream = new FileInputStream(this.filename);
            int n = 0;
            while (n < 2) {
                string = String.valueOf(string) + (char)fileInputStream.read();
                ++n;
            }
            if (string.equals("BM")) {
                int n2;
                this.typeNotified = true;
                int n3 = 0;
                while (n3 < 4) {
                    this.fileSize += (long)(fileInputStream.read() * (int)Math.pow(256.0, n3));
                    ++n3;
                }
                int n4 = 0;
                while (n4 < 4) {
                    n2 = fileInputStream.read();
                    ++n4;
                }
                int n5 = 0;
                while (n5 < 4) {
                    this.offset += (long)(fileInputStream.read() * (int)Math.pow(256.0, n5));
                    ++n5;
                }
                int n6 = 0;
                while (n6 < 4) {
                    this.lutOffset += (long)(fileInputStream.read() * (int)Math.pow(256.0, n6));
                    ++n6;
                }
                int n7 = 0;
                while (n7 < 4) {
                    this.xSize += fileInputStream.read() * (int)Math.pow(256.0, n7);
                    ++n7;
                }
                int n8 = 0;
                while (n8 < 4) {
                    this.ySize += fileInputStream.read() * (int)Math.pow(256.0, n8);
                    ++n8;
                }
                int n9 = 0;
                while (n9 < 2) {
                    n2 = fileInputStream.read();
                    ++n9;
                }
                int n10 = 0;
                while (n10 < 2) {
                    this.bitsPerPixel += fileInputStream.read() * (int)Math.pow(256.0, n10);
                    ++n10;
                }
                int n11 = 0;
                while (n11 < 4) {
                    n2 = fileInputStream.read();
                    if (n2 != 0) {
                        this.typeNotified = false;
                    }
                    ++n11;
                }
                int n12 = 0;
                while (n12 < 4) {
                    this.byteSize += (long)(fileInputStream.read() * (int)Math.pow(256.0, n12));
                    ++n12;
                }
                int n13 = 0;
                while (n13 < 16) {
                    n2 = fileInputStream.read();
                    ++n13;
                }
                this.colorDepth = (int)Math.pow(2.0, this.bitsPerPixel);
                if (this.bitsPerPixel < 9) {
                    this.colorLut = new int[this.colorDepth];
                    int n14 = 0;
                    while (n14 < this.colorDepth) {
                        this.colorLut[n14] = -16777216;
                        int n15 = 0;
                        while (n15 < 3) {
                            int n16 = n14;
                            this.colorLut[n16] = this.colorLut[n16] + fileInputStream.read() * (int)Math.pow(256.0, n15);
                            ++n15;
                        }
                        n2 = fileInputStream.read();
                        ++n14;
                    }
                }
            }
            fileInputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("Error: java.io.IOException!!");
        }
    }
}

