/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Random;

public class EmbeddWM
implements WMSettings {
    RasterImage img;
    int xSize;
    int ySize;
    int size;
    int pin;
    Random r;
    String l;
    static int[][] P_MX;
    float DENSITY;
    float VALUE;
    byte[] label;
    int bit_no = 0;
    URL matrUrl;

    public EmbeddWM(RasterImage rasterImage, int n, float f, float f2, URL uRL) {
        this.img = rasterImage;
        this.pin = n;
        this.DENSITY = f;
        this.VALUE = f2;
        this.matrUrl = uRL;
        this.xSize = rasterImage.getXSize();
        this.ySize = rasterImage.getYSize();
        this.size = this.xSize * this.ySize;
        this.r = new Random(n);
        P_MX = new int[5][5];
        this.loadMatrix();
    }

    private float calcPredict(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 2;
        int n6 = -1 * n5;
        while (n6 <= n5) {
            int n7 = -1 * n5;
            while (n7 <= n5) {
                int n8 = this.getIndex(n + n6, n2 + n7);
                if (n8 != -1) {
                    n4 += this.getBlue(this.img.getPixel(n8)) * P_MX[n6 + n5][n7 + n5];
                    n3 += P_MX[n6 + n5][n7 + n5];
                }
                ++n7;
            }
            ++n6;
        }
        return n4 / n3;
    }

    private boolean checkPoint() {
        float f = this.r.nextFloat();
        return f < this.DENSITY;
    }

    private int combineRGB(int n, int n2, int n3) {
        return n3 + n2 * 256 + n * 65536 + -16777216;
    }

    private byte[] createLabel(String string) {
        byte[] byArray = string.getBytes();
        byte[] byArray2 = new byte[8];
        byArray2[0] = -86;
        int n = 1;
        while (n < 8) {
            byArray2[n] = n <= byArray.length ? byArray[n - 1] : " ".getBytes()[0];
            ++n;
        }
        return byArray2;
    }

    private boolean even(int n) {
        return n == n / 2 * 2;
    }

    private int exp(int n) {
        int n2 = 1;
        int n3 = 0;
        while (n3 < n) {
            n2 *= 2;
            ++n3;
        }
        return n2;
    }

    private int getBlue(int n) {
        return n & 0xFF;
    }

    private int getGreen(int n) {
        return n >> 8 & 0xFF;
    }

    private int getIndex(int n, int n2) {
        int n3 = -1;
        if (n >= 0 && n2 >= 0 && n < this.xSize && n2 < this.ySize) {
            n3 = n2 * this.xSize + n;
        }
        return n3;
    }

    private int getRed(int n) {
        return n >> 16 & 0xFF;
    }

    private int getXCords(int n) {
        return n - n / this.xSize * this.xSize;
    }

    private int getYCords(int n) {
        return n / this.xSize;
    }

    private void loadDefaultMatrix() {
        int n = 2;
        int n2 = 0;
        while (n2 < 5) {
            int n3 = 0;
            while (n3 < 5) {
                EmbeddWM.P_MX[n2][n3] = n2 == n && n3 != n || n2 != n && n3 == n ? 1 : 0;
                ++n3;
            }
            ++n2;
        }
    }

    private void loadMatrix() {
        try {
            String string = new String("");
            InputStream inputStream = this.matrUrl.openStream();
            char c = (char)inputStream.read();
            int n = 0;
            while (n < 5) {
                int n2 = 0;
                while (n2 < 5) {
                    if (c != '\uffffffff') {
                        while (Character.isWhitespace(c) && c != '\uffffffff') {
                            c = (char)inputStream.read();
                        }
                        while (!Character.isWhitespace(c) && c != '\uffffffff') {
                            if (c != '\uffffffff') {
                                string = String.valueOf(string) + c;
                            }
                            c = (char)inputStream.read();
                        }
                        EmbeddWM.P_MX[n][n2] = Integer.parseInt(string);
                        string = "";
                    }
                    ++n2;
                }
                ++n;
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("Error: File 'matrix.ini' not found. Loading defaults!!");
            this.loadDefaultMatrix();
        }
    }

    public void mark(String string) {
        this.label = this.createLabel(string);
        this.bit_no = 0;
        this.zigzagCourse();
    }

    public void markPixel(int n) {
        int n2;
        int n3 = (this.label[this.bit_no / 8] & this.exp(this.bit_no - this.bit_no / 8 * 8)) == 0 ? 0 : 1;
        int n4 = this.getRed(this.img.getPixel(n));
        int n5 = this.getGreen(this.img.getPixel(n));
        int n6 = this.getBlue(this.img.getPixel(n));
        int n7 = this.getXCords(n);
        float f = this.calcPredict(n7, n2 = this.getYCords(n));
        n6 = (int)f;
        int n8 = (int)((double)n6 + (double)(2 * n3 - 1) * (0.299 * (double)n4 + 0.587 * (double)n5 + 0.114 * (double)n6) * (double)this.VALUE);
        if (n8 < 0) {
            n8 = 0;
        }
        if (n8 > 255) {
            n8 = 255;
        }
        this.img.setPixel(n, this.combineRGB(n4, n5, n8));
        ++this.bit_no;
        if (this.bit_no == 64) {
            this.bit_no = 0;
        }
    }

    public void zigzagCourse() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.xSize;
        if (this.ySize > this.xSize) {
            n5 = this.ySize;
        }
        int n6 = 0;
        while (n6 < n5 * n5) {
            if (this.checkPoint()) {
                n3 = (int)Math.sqrt(n6);
                if (this.even(n3)) {
                    if (n6 <= n3 * n3 + n3) {
                        n2 = n3;
                        n = n6 - n3 * n3;
                    } else {
                        n2 = n3 * n3 + 2 * n3 - n6;
                        n = n3;
                    }
                } else if (n6 <= n3 * n3 + n3) {
                    n = n3;
                    n2 = n6 - n3 * n3;
                } else {
                    n = n3 * n3 + 2 * n3 - n6;
                    n2 = n3;
                }
                n4 = this.getIndex(n, n2);
                if (n4 != -1) {
                    this.markPixel(n4);
                } else {
                    ++this.bit_no;
                    if (this.bit_no == 64) {
                        this.bit_no = 0;
                    }
                }
            }
            ++n6;
        }
    }
}

