/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Random;

public class RetrieveWM
implements WMSettings {
    RasterImage img;
    RasterImage tempImg;
    int xSize;
    int ySize;
    int size;
    int pin;
    int xoff = 0;
    int yoff = 0;
    Random r;
    static int[][] P_MX;
    float DENSITY;
    float[] av_delta;
    int[] occurences;
    int bit_no;
    float geoLevel = 0.0f;
    URL matrUrl;

    public RetrieveWM(RasterImage rasterImage, int n, float f, URL uRL) {
        this.img = rasterImage;
        this.pin = n;
        this.DENSITY = f;
        this.matrUrl = uRL;
        this.xSize = rasterImage.getXSize();
        this.ySize = rasterImage.getYSize();
        this.size = this.xSize * this.ySize;
        P_MX = new int[5][5];
        this.loadMatrix();
        this.av_delta = new float[64];
        this.occurences = new int[64];
    }

    private float calcPredict(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 2;
        int n6 = -1 * n5;
        while (n6 <= n5) {
            int n7 = -1 * n5;
            while (n7 <= n5) {
                int n8 = this.getIndex(n + n6, n2 + n7);
                if (n8 != -1) {
                    n4 += this.getBlue(this.img.getPixel(n8)) * P_MX[n6 + n5][n7 + n5];
                    n3 += P_MX[n6 + n5][n7 + n5];
                }
                ++n7;
            }
            ++n6;
        }
        return n4 / n3;
    }

    private boolean checkPoint() {
        return this.r.nextFloat() < this.DENSITY;
    }

    private boolean even(int n) {
        return n == n / 2 * 2;
    }

    private int exp(int n) {
        int n2 = 1;
        int n3 = 0;
        while (n3 < n) {
            n2 *= 2;
            ++n3;
        }
        return n2;
    }

    private String finish() {
        boolean bl = false;
        byte[] byArray = new byte[7];
        int n = 0;
        while (n < 7) {
            byArray[n] = 0;
            ++n;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        int n2 = 0;
        while (n2 < 64) {
            this.av_delta[n2] = this.av_delta[n2] / (float)this.occurences[n2];
            ++n2;
        }
        int n3 = 0;
        while (n3 < 8) {
            f += this.av_delta[n3];
            ++n3;
        }
        f2 = f / 8.0f;
        int n4 = 0;
        while (n4 < 64) {
            bl = this.av_delta[n4] > f2;
            if (n4 > 7 && bl) {
                byArray[n4 / 8 - 1] = (byte)(byArray[n4 / 8 - 1] + this.exp(n4 - n4 / 8 * 8));
            }
            ++n4;
        }
        String string = new String(byArray);
        return string;
    }

    private void geometrySearch(int n) {
        if (this.bit_no < 8) {
            int n2 = this.getRed(this.img.getPixel(n));
            int n3 = this.getGreen(this.img.getPixel(n));
            int n4 = this.getBlue(this.img.getPixel(n));
            int n5 = this.getXCords(n);
            int n6 = this.getYCords(n);
            float f = this.calcPredict(n5, n6);
            float f2 = (float)n4 - f;
            this.av_delta[this.bit_no] = this.av_delta[this.bit_no] + f2;
            int n7 = this.bit_no;
            this.occurences[n7] = this.occurences[n7] + 1;
        }
        ++this.bit_no;
        if (this.bit_no == 64) {
            this.bit_no = 0;
        }
    }

    private int getBlue(int n) {
        return n & 0xFF;
    }

    private int getGreen(int n) {
        return n >> 8 & 0xFF;
    }

    private int getIndex(int n, int n2) {
        int n3 = -1;
        if (n >= 0 && n2 >= 0 && n < this.xSize && n2 < this.ySize) {
            n3 = n2 * this.xSize + n;
        }
        return n3;
    }

    private int getRed(int n) {
        return n >> 16 & 0xFF;
    }

    private int getXCords(int n) {
        return n - n / this.xSize * this.xSize;
    }

    private int getYCords(int n) {
        return n / this.xSize;
    }

    private void labelSearch(int n) {
        int n2 = this.getRed(this.img.getPixel(n));
        int n3 = this.getGreen(this.img.getPixel(n));
        int n4 = this.getBlue(this.img.getPixel(n));
        int n5 = this.getXCords(n);
        int n6 = this.getYCords(n);
        float f = this.calcPredict(n5, n6);
        float f2 = (float)n4 - f;
        this.av_delta[this.bit_no] = this.av_delta[this.bit_no] + f2;
        int n7 = this.bit_no++;
        this.occurences[n7] = this.occurences[n7] + 1;
        if (this.bit_no == 64) {
            this.bit_no = 0;
        }
    }

    private void loadDefaultMatrix() {
        int n = 2;
        int n2 = 0;
        while (n2 < 5) {
            int n3 = 0;
            while (n3 < 5) {
                RetrieveWM.P_MX[n2][n3] = n2 == n && n3 != n || n2 != n && n3 == n ? 1 : 0;
                ++n3;
            }
            ++n2;
        }
    }

    private void loadMatrix() {
        try {
            String string = new String("");
            InputStream inputStream = this.matrUrl.openStream();
            char c = (char)inputStream.read();
            int n = 0;
            while (n < 5) {
                int n2 = 0;
                while (n2 < 5) {
                    if (c != '\uffffffff') {
                        while (Character.isWhitespace(c) && c != '\uffffffff') {
                            c = (char)inputStream.read();
                        }
                        while (!Character.isWhitespace(c) && c != '\uffffffff') {
                            if (c != '\uffffffff') {
                                string = String.valueOf(string) + c;
                            }
                            c = (char)inputStream.read();
                        }
                        RetrieveWM.P_MX[n][n2] = Integer.parseInt(string);
                        string = "";
                    }
                    ++n2;
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            System.out.println("Error: File 'matrix.ini' not found. Loading defaults!!");
            this.loadDefaultMatrix();
        }
    }

    public String retrieve() {
        this.zigzagCourse(false);
        return this.finish();
    }

    public void retrieveGeometry(int n, int n2, float f, float f2, int n3) {
        float f3 = 0.0f;
        int n4 = 0;
        int n5 = 0;
        float f4 = 1.0f;
        float f5 = Math.abs(Math.abs(f2) - Math.abs(f)) / 10.0f;
        if (f5 == 0.0f) {
            f5 = 1.0f;
            n3 = 0;
        }
        this.tempImg = this.img.copy();
        int n6 = n;
        while (n6 <= n2) {
            int n7 = n;
            while (n7 <= n2) {
                this.xoff = n6;
                this.yoff = n7;
                float f6 = f;
                while (f6 <= f2) {
                    if (f6 != 1.0f) {
                        this.img = this.tempImg.scale(f6, f6);
                        this.xSize = this.img.getXSize();
                        this.ySize = this.img.getYSize();
                        this.size = this.xSize * this.ySize;
                    }
                    this.zigzagCourse(true);
                    if (this.geoLevel > f3) {
                        f3 = this.geoLevel;
                        n4 = n6;
                        n5 = n7;
                        f4 = f6;
                    }
                    f6 += f5;
                }
                ++n7;
            }
            ++n6;
        }
        if (n3 > 0) {
            this.retrieveGeometry(n, n2, f4 - f5, f4 + f5, n3 - 1);
        } else {
            this.xoff = n4;
            this.yoff = n5;
            this.img = this.tempImg.scale(f4, f4);
            this.xSize = this.img.getXSize();
            this.ySize = this.img.getYSize();
            this.size = this.xSize * this.ySize;
        }
    }

    private void zigzagCourse(boolean bl) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        this.r = new Random(this.pin);
        this.bit_no = 0;
        int n5 = 0;
        while (n5 < 64) {
            this.av_delta[n5] = 0.0f;
            ++n5;
        }
        int n6 = 0;
        while (n6 < 64) {
            this.occurences[n6] = 0;
            ++n6;
        }
        int n7 = this.xSize + this.xoff;
        if (this.ySize + this.yoff > this.xSize + this.xoff) {
            n7 = this.ySize + this.yoff;
        }
        int n8 = 0;
        while (n8 < n7 * n7) {
            if (this.checkPoint()) {
                n3 = (int)Math.sqrt(n8);
                if (this.even(n3)) {
                    if (n8 <= n3 * n3 + n3) {
                        n2 = n3;
                        n = n8 - n3 * n3;
                    } else {
                        n2 = n3 * n3 + 2 * n3 - n8;
                        n = n3;
                    }
                } else if (n8 <= n3 * n3 + n3) {
                    n = n3;
                    n2 = n8 - n3 * n3;
                } else {
                    n = n3 * n3 + 2 * n3 - n8;
                    n2 = n3;
                }
                n4 = this.getIndex(n - this.xoff, n2 - this.yoff);
                if (n4 != -1) {
                    if (!bl) {
                        this.labelSearch(n4);
                    } else {
                        this.geometrySearch(n4);
                    }
                } else {
                    ++this.bit_no;
                    if (this.bit_no == 64) {
                        this.bit_no = 0;
                    }
                }
            }
            ++n8;
        }
        if (bl) {
            float f = 0.0f;
            float f2 = 0.0f;
            int n9 = 0;
            while (n9 < 8) {
                this.av_delta[n9] = this.av_delta[n9] / (float)this.occurences[n9];
                ++n9;
            }
            int n10 = 0;
            while (n10 < 8) {
                if (!this.even(n10)) {
                    f += this.av_delta[n10];
                } else {
                    f2 += this.av_delta[n10];
                }
                ++n10;
            }
            this.geoLevel = f - f2;
        }
    }
}

