/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

public class RasterImage
extends Component
implements FileTypes,
Cloneable {
    private int[] rasterData;
    private String filename;
    private byte fileType;
    private int xSize;
    private int ySize;
    private String error;

    public RasterImage(int n, int n2) {
        this.xSize = n;
        this.ySize = n2;
        int n3 = n * n2;
        this.rasterData = new int[n3];
        this.fileType = 0;
        this.filename = "";
        this.error = "";
    }

    public RasterImage(Image image) {
        this.xSize = image.getWidth(this);
        this.ySize = image.getHeight(this);
        int n = this.xSize * this.ySize;
        this.rasterData = new int[n];
        this.fileType = 0;
        this.filename = "";
        this.error = "";
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, this.xSize, this.ySize, this.rasterData, 0, this.xSize);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Process failed");
        }
    }

    public RasterImage(String string) {
        this.setFilename(string);
        this.error = "";
        if (this.fileType != 0) {
            ImageReader imageReader;
            switch (this.fileType) {
                case 1: {
                    imageReader = new PpmReader(string);
                    break;
                }
                case 2: {
                    imageReader = new GifReader(string);
                    break;
                }
                case 3: {
                    imageReader = new GifReader(string);
                    break;
                }
                case 4: {
                    imageReader = new BmpReader(string);
                    break;
                }
                case 5: {
                    imageReader = new PcxReader(string);
                    break;
                }
                default: {
                    imageReader = new NothingReader(string);
                    this.fileType = 0;
                }
            }
            this.xSize = imageReader.getXSize();
            this.ySize = imageReader.getYSize();
            int n = this.xSize * this.ySize;
            if (n > 0) {
                this.rasterData = new int[n];
                this.rasterData = imageReader.readFile();
            } else {
                this.fileType = 0;
            }
        }
    }

    private byte checkFiletype(String string) {
        int n = !string.equals("") ? (string.endsWith(".ppm") ? 1 : (string.endsWith(".PPM") ? 1 : (string.endsWith(".gif") ? 2 : (string.endsWith(".GIF") ? 2 : (string.endsWith(".jpg") ? 3 : (string.endsWith(".jpeg") ? 3 : (string.endsWith(".JPEG") ? 3 : (string.endsWith(".JPG") ? 3 : (string.endsWith(".bmp") ? 4 : (string.endsWith(".BMP") ? 4 : (string.endsWith(".pcx") ? 5 : (string.endsWith(".PCX") ? 5 : 0)))))))))))) : 0;
        return (byte)n;
    }

    public static int combineRGB(int n, int n2, int n3) {
        return n3 + n2 * 256 + n * 65536 + -16777216;
    }

    public RasterImage copy() {
        RasterImage rasterImage = new RasterImage(this.xSize, this.ySize);
        int n = this.xSize * this.ySize;
        int n2 = 0;
        while (n2 < n) {
            rasterImage.setPixel(n2, this.rasterData[n2]);
            ++n2;
        }
        return rasterImage;
    }

    public RasterImage cut(int n, int n2, int n3, int n4) {
        if (n3 >= this.xSize) {
            n3 = this.xSize - 1;
        }
        if (n4 >= this.ySize) {
            n4 = this.ySize - 1;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n >= n3) {
            n = n3 - 1;
        }
        if (n2 >= n4) {
            n2 = n4 - 1;
        }
        RasterImage rasterImage = new RasterImage(n3 - n + 1, n4 - n2 + 1);
        int n5 = n;
        while (n5 <= n3) {
            int n6 = n2;
            while (n6 <= n4) {
                rasterImage.setPixel(rasterImage.getIndex(n5 - n, n6 - n2), this.rasterData[this.getIndex(n5, n6)]);
                ++n6;
            }
            ++n5;
        }
        return rasterImage;
    }

    public static int getBlue(int n) {
        return n & 0xFF;
    }

    public byte getFileType() {
        return this.fileType;
    }

    public String getFilename() {
        return this.filename;
    }

    public static int getGreen(int n) {
        return n >> 8 & 0xFF;
    }

    private int getIndex(int n, int n2) {
        int n3 = -1;
        if (n >= 0 && n2 >= 0 && n < this.xSize && n2 < this.ySize) {
            n3 = n2 * this.xSize + n;
        }
        return n3;
    }

    public int getPixel(int n) {
        return this.rasterData[n];
    }

    public static int getRed(int n) {
        return n >> 16 & 0xFF;
    }

    public int getXSize() {
        return this.xSize;
    }

    public int getYSize() {
        return this.ySize;
    }

    public Image makeImage() {
        Image image = this.createImage(new MemoryImageSource(this.xSize, this.ySize, this.rasterData, 0, this.xSize));
        return image;
    }

    public RasterImage reduceCol(int n) {
        if (n < 8) {
            n = 8;
        }
        if (n > 2048383) {
            n = 2048383;
        }
        int n2 = (int)Math.pow(n, 0.3333334);
        RasterImage rasterImage = new RasterImage(this.xSize, this.ySize);
        int n3 = this.xSize * this.ySize;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = this.rasterData[n4];
            int n6 = RasterImage.getRed(n5);
            int n7 = RasterImage.getGreen(n5);
            int n8 = RasterImage.getBlue(n5);
            n6 = n6 / (256 / n2) * (256 / n2);
            n7 = n7 / (256 / n2) * (256 / n2);
            n8 = n8 / (256 / n2) * (256 / n2);
            rasterImage.setPixel(n4, n8 + n7 * 256 + n6 * 65536 + -16777216);
            ++n4;
        }
        return rasterImage;
    }

    public RasterImage rotate(int n) {
        if (n > 360 || n < -360) {
            n = 0;
        }
        double d = -1.0 * ((double)n / 360.0 * 2.0 * Math.PI);
        RasterImage rasterImage = new RasterImage(this.xSize, this.ySize);
        int n2 = 0;
        while (n2 < this.xSize) {
            int n3 = 0;
            while (n3 < this.ySize) {
                int n4;
                int n5;
                int n6 = n2 - this.xSize / 2;
                int n7 = n3 - this.ySize / 2;
                int n8 = (int)((double)n6 * Math.cos(d) - (double)n7 * Math.sin(d));
                int n9 = n8 + this.xSize / 2;
                int n10 = this.getIndex(n9, n5 = (n4 = (int)((double)n7 * Math.cos(d) + (double)n6 * Math.sin(d))) + this.ySize / 2) != -1 ? this.rasterData[this.getIndex(n9, n5)] : 0;
                rasterImage.setPixel(rasterImage.getIndex(n2, n3), n10);
                ++n3;
            }
            ++n2;
        }
        return rasterImage;
    }

    public RasterImage scale(float f, float f2) {
        if (f < 0.01f) {
            f = 0.01f;
        }
        if (f2 < 0.01f) {
            f2 = 0.01f;
        }
        if (f > 100.0f) {
            f = 100.0f;
        }
        if (f2 > 100.0f) {
            f2 = 100.0f;
        }
        int n = (int)((float)this.xSize * f + 0.5f);
        int n2 = (int)((float)this.ySize * f2 + 0.5f);
        RasterImage rasterImage = new RasterImage(n, n2);
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                int n5 = (int)((float)n3 / f);
                int n6 = (int)((float)n4 / f2);
                rasterImage.setPixel(rasterImage.getIndex(n3, n4), this.rasterData[this.getIndex(n5, n6)]);
                ++n4;
            }
            ++n3;
        }
        return rasterImage;
    }

    public void setFileType(byte by) {
        this.fileType = by;
    }

    public void setFilename(String string) {
        this.filename = string;
        this.fileType = this.checkFiletype(string);
    }

    public void setPixel(int n, int n2) {
        this.rasterData[n] = n2;
    }

    public void tester() {
        System.out.println(this.rasterData.length);
        int n = 0;
        while (n < this.rasterData.length) {
            System.out.print(String.valueOf(n) + ":" + this.rasterData[n] + "  ");
            ++n;
        }
    }

    private void write(String string, byte by) {
        this.error = "";
        if (by != 1 && by != 4) {
            by = 0;
        }
        if (by == 0) {
            System.out.println("Filetype unknown. Save as default.");
            this.error = "Filetype unknown. Save as default.";
            by = 1;
            int n = string.indexOf(46);
            String string2 = string;
            if (n != -1) {
                string2 = string.substring(0, n);
            }
            string = String.valueOf(string2) + ".ppm";
        }
        if (this.xSize > 0 && this.ySize > 0 && this.rasterData != null) {
            ImageWriter imageWriter;
            switch (by) {
                case 1: {
                    imageWriter = new PpmWriter(string, this.xSize, this.ySize);
                    break;
                }
                case 2: {
                    imageWriter = new GifWriter(string, this.xSize, this.ySize);
                    break;
                }
                case 3: {
                    imageWriter = new JpegWriter(string, this.xSize, this.ySize);
                    break;
                }
                case 4: {
                    imageWriter = new BmpWriter(string, this.xSize, this.ySize);
                    break;
                }
                case 5: {
                    imageWriter = new PcxWriter(string, this.xSize, this.ySize);
                    break;
                }
                default: {
                    imageWriter = new NothingWriter(string, this.xSize, this.ySize);
                    by = 0;
                }
            }
            imageWriter.writeout(this.rasterData);
        } else {
            System.out.println("Error during the writing. ");
            this.error = "Error during the writing.";
        }
    }

    public void writeImage() {
        if (this.filename.equals("")) {
            this.filename = "default.ppm";
            this.fileType = 1;
        }
        this.write(this.filename, this.fileType);
    }

    public String writeImage(String string) {
        if (string.equals("")) {
            string = "default.ppm";
        }
        this.fileType = this.checkFiletype(string);
        this.write(string, this.fileType);
        return this.error;
    }

    public void writeImage(String string, byte by) {
        if (string.equals("")) {
            string = "default.ppm";
        }
        this.fileType = this.checkFiletype(string);
        if (this.fileType != by) {
            System.out.println("Filetype / Filename do not belong together!!");
        }
        this.write(string, this.fileType);
    }
}

