/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.swing.DesktopManager;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JInternalFrame;
import com.sun.java.swing.JLayeredPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;

public class DefaultDesktopManager
implements DesktopManager {
    static final String PREVIOUS_BOUNDS_PROPERTY = "previousBounds";
    static final String HAS_BEEN_ICONIFIED_PROPERTY = "wasIconOnce";

    public void openFrame(JInternalFrame jInternalFrame) {
        if (jInternalFrame.getDesktopIcon().getParent() != null) {
            jInternalFrame.getDesktopIcon().getParent().add(jInternalFrame);
            this.removeIconFor(jInternalFrame);
        }
    }

    public void closeFrame(JInternalFrame jInternalFrame) {
        if (jInternalFrame.getParent() != null) {
            Container container = jInternalFrame.getParent();
            container.remove(jInternalFrame);
            container.repaint(jInternalFrame.getX(), jInternalFrame.getY(), jInternalFrame.getWidth(), jInternalFrame.getHeight());
        }
        this.removeIconFor(jInternalFrame);
        if (this.getPreviousBounds(jInternalFrame) != null) {
            this.setPreviousBounds(jInternalFrame, null);
        }
        if (this.wasIcon(jInternalFrame)) {
            this.setWasIcon(jInternalFrame, null);
        }
    }

    public void maximizeFrame(JInternalFrame jInternalFrame) {
        Rectangle rectangle;
        if (!jInternalFrame.isIcon()) {
            this.setPreviousBounds(jInternalFrame, jInternalFrame.getBounds());
            rectangle = jInternalFrame.getParent().getBounds();
        } else {
            Container container = jInternalFrame.getDesktopIcon().getParent();
            if (container == null) {
                return;
            }
            rectangle = container.getBounds();
            try {
                jInternalFrame.setIcon(false);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
        this.setBoundsForFrame(jInternalFrame, 0, 0, rectangle.width, rectangle.height);
        try {
            jInternalFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.removeIconFor(jInternalFrame);
    }

    public void minimizeFrame(JInternalFrame jInternalFrame) {
        if (this.getPreviousBounds(jInternalFrame) != null) {
            Rectangle rectangle = this.getPreviousBounds(jInternalFrame);
            this.setPreviousBounds(jInternalFrame, null);
            try {
                jInternalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {}
            if (jInternalFrame.isIcon()) {
                try {
                    jInternalFrame.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
            this.setBoundsForFrame(jInternalFrame, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.removeIconFor(jInternalFrame);
    }

    public void iconifyFrame(JInternalFrame jInternalFrame) {
        JInternalFrame.JDesktopIcon jDesktopIcon = jInternalFrame.getDesktopIcon();
        if (!this.wasIcon(jInternalFrame)) {
            Rectangle rectangle = this.getBoundsForIconOf(jInternalFrame);
            jDesktopIcon.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.setWasIcon(jInternalFrame, Boolean.TRUE);
        }
        Container container = jInternalFrame.getParent();
        container.remove(jInternalFrame);
        container.add(jDesktopIcon);
        container.repaint(jInternalFrame.getX(), jInternalFrame.getY(), jInternalFrame.getWidth(), jInternalFrame.getHeight());
        try {
            jInternalFrame.setSelected(false);
            return;
        }
        catch (PropertyVetoException propertyVetoException) {
            return;
        }
    }

    public void deiconifyFrame(JInternalFrame jInternalFrame) {
        JInternalFrame.JDesktopIcon jDesktopIcon = jInternalFrame.getDesktopIcon();
        if (jDesktopIcon.getParent() != null) {
            jDesktopIcon.getParent().add(jInternalFrame);
            this.removeIconFor(jInternalFrame);
            try {
                jInternalFrame.setSelected(true);
                return;
            }
            catch (PropertyVetoException propertyVetoException) {
                return;
            }
        }
    }

    public void activateFrame(JInternalFrame jInternalFrame) {
        Component[] componentArray;
        Container container = jInternalFrame.getParent();
        if (container == null && (container = jInternalFrame.getDesktopIcon().getParent()) == null) {
            return;
        }
        if (container instanceof JLayeredPane) {
            JLayeredPane cfr_ignored_0 = (JLayeredPane)container;
            componentArray = ((JLayeredPane)container).getComponentsInLayer(JLayeredPane.getLayer(jInternalFrame));
        } else {
            componentArray = container.getComponents();
        }
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            JInternalFrame jInternalFrame2;
            if (componentArray[n2] != jInternalFrame && componentArray[n2] instanceof JInternalFrame) {
                jInternalFrame2 = (JInternalFrame)componentArray[n2];
                if (jInternalFrame2.isSelected()) {
                    try {
                        jInternalFrame2.setSelected(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                }
            } else if (componentArray[n2] instanceof JInternalFrame.JDesktopIcon && componentArray[n2] != jInternalFrame.getDesktopIcon() && (jInternalFrame2 = ((JInternalFrame.JDesktopIcon)componentArray[n2]).getInternalFrame()).isSelected()) {
                try {
                    jInternalFrame2.setSelected(false);
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
            ++n2;
        }
        jInternalFrame.moveToFront();
    }

    public void deactivateFrame(JInternalFrame jInternalFrame) {
    }

    public void beginDraggingFrame(JComponent jComponent) {
    }

    public void dragFrame(JComponent jComponent, int n, int n2) {
        this.setBoundsForFrame(jComponent, n, n2, jComponent.getWidth(), jComponent.getHeight());
    }

    public void endDraggingFrame(JComponent jComponent) {
    }

    public void beginResizingFrame(JComponent jComponent, int n) {
    }

    public void resizeFrame(JComponent jComponent, int n, int n2, int n3, int n4) {
        this.setBoundsForFrame(jComponent, n, n2, n3, n4);
    }

    public void endResizingFrame(JComponent jComponent) {
    }

    public void setBoundsForFrame(JComponent jComponent, int n, int n2, int n3, int n4) {
        boolean bl = jComponent.getWidth() != n3 || jComponent.getHeight() != n4;
        jComponent.setBounds(n, n2, n3, n4);
        if (bl) {
            jComponent.validate();
        }
    }

    protected void removeIconFor(JInternalFrame jInternalFrame) {
        JInternalFrame.JDesktopIcon jDesktopIcon = jInternalFrame.getDesktopIcon();
        Container container = jDesktopIcon.getParent();
        if (container != null) {
            container.remove(jDesktopIcon);
            container.repaint(jDesktopIcon.getX(), jDesktopIcon.getY(), jDesktopIcon.getWidth(), jDesktopIcon.getHeight());
        }
    }

    protected Rectangle getBoundsForIconOf(JInternalFrame jInternalFrame) {
        Rectangle rectangle = jInternalFrame.getParent().getBounds();
        Dimension dimension = jInternalFrame.getDesktopIcon().getPreferredSize();
        int n = dimension.width;
        int n2 = dimension.height;
        int n3 = 0;
        int n4 = rectangle.height - n2;
        if (jInternalFrame.getParent() == null && jInternalFrame.getDesktopIcon().getParent() == null) {
            return new Rectangle(n3, n4, n, n2);
        }
        Container container = jInternalFrame.getParent();
        if (container == null) {
            container = jInternalFrame.getDesktopIcon().getParent();
        }
        int n5 = container.getComponentCount();
        container.getComponents();
        int n6 = 0;
        int n7 = rectangle.height;
        int n8 = n5 - 1;
        while (n8 >= 0) {
            JInternalFrame jInternalFrame2 = null;
            if (container.getComponent(n8) instanceof JInternalFrame) {
                jInternalFrame2 = (JInternalFrame)container.getComponent(n8);
            } else if (container.getComponent(n8) instanceof JInternalFrame.JDesktopIcon) {
                jInternalFrame2 = ((JInternalFrame.JDesktopIcon)container.getComponent(n8)).getInternalFrame();
            }
            if (jInternalFrame2 != null && jInternalFrame2 != jInternalFrame && this.wasIcon(jInternalFrame2)) {
                Rectangle rectangle2 = jInternalFrame2.getDesktopIcon().getBounds();
                if (rectangle2.y < n7) {
                    n7 = rectangle2.y;
                    n6 = rectangle2.x + rectangle2.width;
                } else if (rectangle2.y == n7 && rectangle2.x + rectangle2.width > n6) {
                    n6 = rectangle2.x + rectangle2.width;
                }
            }
            --n8;
        }
        if (n7 != rectangle.height) {
            n4 = n7;
        }
        if (n6 + n > rectangle.width) {
            n4 -= n2;
            n3 = 0;
        } else {
            n3 = n6;
        }
        return new Rectangle(n3, n4, n, n2);
    }

    protected void setPreviousBounds(JInternalFrame jInternalFrame, Rectangle rectangle) {
        if (rectangle != null) {
            jInternalFrame.putClientProperty(PREVIOUS_BOUNDS_PROPERTY, rectangle);
        }
    }

    protected Rectangle getPreviousBounds(JInternalFrame jInternalFrame) {
        return (Rectangle)jInternalFrame.getClientProperty(PREVIOUS_BOUNDS_PROPERTY);
    }

    protected void setWasIcon(JInternalFrame jInternalFrame, Boolean bl) {
        if (bl != null) {
            jInternalFrame.putClientProperty(HAS_BEEN_ICONIFIED_PROPERTY, bl);
        }
    }

    protected boolean wasIcon(JInternalFrame jInternalFrame) {
        return jInternalFrame.getClientProperty(HAS_BEEN_ICONIFIED_PROPERTY) == Boolean.TRUE;
    }
}

