/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.accessibility.AccessibleContext;
import com.sun.java.accessibility.AccessibleState;
import com.sun.java.accessibility.AccessibleStateSet;
import com.sun.java.swing.Action;
import com.sun.java.swing.BoundedRangeModel;
import com.sun.java.swing.DefaultBoundedRangeModel;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.SwingConstants;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ChangeListener;
import com.sun.java.swing.text.Document;
import com.sun.java.swing.text.JTextComponent;
import com.sun.java.swing.text.PlainDocument;
import com.sun.java.swing.text.TextAction;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class JTextField
extends JTextComponent
implements SwingConstants {
    public static final String notifyAction = "notify-field-accept";
    private BoundedRangeModel visibility;
    private int horizontalAlignment = 2;
    private int columns;
    private int columnWidth;
    private String command;
    private static final String base = "textfield";
    private static int nameCounter;
    private static final Action[] defaultActions;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public JTextField() {
        this(null, null, 0);
    }

    public JTextField(String string) {
        this(null, string, 0);
    }

    public JTextField(int n) {
        this(null, null, n);
    }

    public JTextField(String string, int n) {
        this(null, string, n);
    }

    public JTextField(Document document, String string, int n) {
        this.setName(base + nameCounter++);
        if (n < 0) {
            throw new IllegalArgumentException("columns less than zero.");
        }
        this.visibility = new DefaultBoundedRangeModel();
        this.visibility.addChangeListener(new ScrollRepainter());
        this.columns = n;
        if (document == null) {
            document = this.createDefaultModel();
        }
        this.setDocument(document);
        if (string != null) {
            this.setText(string);
        }
    }

    public String getUIClassID() {
        return "TextFieldUI";
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int n) {
        if (n == this.horizontalAlignment) {
            return;
        }
        int n2 = this.horizontalAlignment;
        if (n != 2 && n != 0 && n != 4) {
            throw new IllegalArgumentException("horizontalAlignment");
        }
        this.horizontalAlignment = n;
        this.firePropertyChange("horizontalAlignment", n2, this.horizontalAlignment);
        this.invalidate();
        this.repaint();
    }

    protected Document createDefaultModel() {
        return new PlainDocument();
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int n) {
        int n2 = this.columns;
        if (n < 0) {
            throw new IllegalArgumentException("columns less than zero.");
        }
        if (n != n2) {
            this.columns = n;
            this.invalidate();
        }
    }

    protected int getColumnWidth() {
        if (this.columnWidth == 0) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            this.columnWidth = fontMetrics.charWidth('m');
        }
        return this.columnWidth;
    }

    public Dimension getPreferredSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Dimension dimension = super.getPreferredSize();
            if (this.columns != 0) {
                dimension.width = this.columns * this.getColumnWidth();
            }
            Dimension dimension2 = dimension;
            Object var3_4 = null;
            return dimension2;
        }
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.columnWidth = 0;
        this.revalidate();
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.listenerList.add(class$java$awt$event$ActionListener != null ? class$java$awt$event$ActionListener : (class$java$awt$event$ActionListener = JComponent.class$("java.awt.event.ActionListener")), actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(class$java$awt$event$ActionListener != null ? class$java$awt$event$ActionListener : (class$java$awt$event$ActionListener = JComponent.class$("java.awt.event.ActionListener")), actionListener);
    }

    protected void fireActionPerformed() {
        Object[] objectArray = this.listenerList.getListenerList();
        ActionEvent actionEvent = new ActionEvent(this, 1001, this.command != null ? this.command : this.getText());
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$awt$event$ActionListener != null ? class$java$awt$event$ActionListener : JComponent.class$("java.awt.event.ActionListener"))) {
                ((ActionListener)objectArray[n + 1]).actionPerformed(actionEvent);
            }
            n -= 2;
        }
    }

    public void setActionCommand(String string) {
        this.command = string;
    }

    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), defaultActions);
    }

    public void postActionEvent() {
        this.fireActionPerformed();
    }

    protected String paramString() {
        return String.valueOf(super.paramString()) + ",columns=" + this.columns + ",command=" + this.command;
    }

    public BoundedRangeModel getHorizontalVisibility() {
        return this.visibility;
    }

    public int getScrollOffset() {
        return this.visibility.getValue();
    }

    public void setScrollOffset(int n) {
        this.visibility.setValue(n);
    }

    public void scrollRectToVisible(Rectangle rectangle) {
        int n = rectangle.x + this.visibility.getValue();
        if (n < this.visibility.getValue()) {
            this.visibility.setValue(n - 2);
            return;
        }
        if (n > this.visibility.getValue() + this.visibility.getExtent()) {
            this.visibility.setValue(n - this.visibility.getExtent() + 2);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTextField();
        }
        return this.accessibleContext;
    }

    static {
        defaultActions = new Action[]{new NotifyAction()};
    }

    static class NotifyAction
    extends TextAction {
        NotifyAction() {
            super(JTextField.notifyAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getFocusedComponent();
            if (jTextComponent instanceof JTextField) {
                JTextField jTextField = (JTextField)jTextComponent;
                jTextField.postActionEvent();
            }
        }
    }

    class ScrollRepainter
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            JTextField.this.repaint();
        }

        ScrollRepainter() {
            JTextField.this = JTextField.this;
        }
    }

    protected class AccessibleJTextField
    extends JTextComponent.AccessibleJTextComponent {
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.SINGLE_LINE);
            return accessibleStateSet;
        }

        AccessibleJTextField() {
            super(JTextField.this);
            JTextField.this = JTextField.this;
        }
    }
}

