/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.swing.JApplet;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JLayeredPane;
import com.sun.java.swing.JToolTip;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.Timer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;

public class ToolTipManager
extends MouseAdapter
implements MouseMotionListener {
    Timer enterTimer = new Timer(750, new insideTimerAction());
    Timer exitTimer;
    Timer insideTimer;
    String toolTipText;
    Point preferredLocation;
    JComponent insideComponent;
    MouseEvent mouseEvent;
    boolean showImmediately;
    static final ToolTipManager sharedInstance = new ToolTipManager();
    Popup tipWindow;
    JToolTip tip;
    boolean enabled = true;
    boolean mouseAboveToolTip = false;
    private static final int INIT_POPUP = 0;
    private static final int MEDIUM_POPUP = 1;
    private static final int HEAVY_POPUP = 2;
    private int tipType = 0;

    ToolTipManager() {
        this.enterTimer.setRepeats(false);
        this.exitTimer = new Timer(500, new outsideTimerAction());
        this.exitTimer.setRepeats(false);
        this.insideTimer = new Timer(4000, new stillInsideTimerAction());
        this.insideTimer.setRepeats(false);
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (!bl) {
            this.hideTipWindow();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setInitialDelay(int n) {
        this.enterTimer.setInitialDelay(n);
    }

    public int getInitialDelay() {
        return this.enterTimer.getInitialDelay();
    }

    public void setDismissDelay(int n) {
        this.insideTimer.setDelay(n);
    }

    public int getDismissDelay() {
        return this.insideTimer.getDelay();
    }

    public void setReshowDelay(int n) {
        this.exitTimer.setDelay(n);
    }

    public int getReshowDelay() {
        return this.exitTimer.getDelay();
    }

    void showTipWindow() {
        if (this.insideComponent == null || !this.insideComponent.isShowing()) {
            return;
        }
        if (this.enabled) {
            Point point = this.insideComponent.getLocationOnScreen();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Point point2 = new Point();
            this.hideTipWindow();
            this.tip = this.insideComponent.createToolTip();
            this.tip.setTipText(this.toolTipText);
            Dimension dimension2 = this.tip.getPreferredSize();
            switch (this.tipType) {
                case 0: {
                    Container container = this.insideComponent.getParent();
                    while (container != null) {
                        if (container instanceof JApplet) {
                            this.tipType = 1;
                            this.tipWindow = new PanelPopup(this.tip, dimension2);
                        }
                        container = container.getParent();
                    }
                    if (this.tipType != 0) break;
                    this.tipWindow = new WindowPopup(ToolTipManager.frameForComponent(this.insideComponent), this.tip, dimension2);
                    this.tipType = 2;
                    break;
                }
                case 2: {
                    this.tipWindow = new WindowPopup(ToolTipManager.frameForComponent(this.insideComponent), this.tip, dimension2);
                    break;
                }
                case 1: {
                    this.tipWindow = new PanelPopup(this.tip, dimension2);
                    break;
                }
                default: {
                    this.tipWindow = new WindowPopup(ToolTipManager.frameForComponent(this.insideComponent), this.tip, dimension2);
                }
            }
            this.tipWindow.addMouseListener(this);
            if (this.preferredLocation != null) {
                point2.x = point.x + this.preferredLocation.x;
                point2.y = point.y + this.preferredLocation.y;
            } else {
                point2.x = point.x + this.mouseEvent.getX();
                point2.y = point.y + this.mouseEvent.getY() + 20;
                if (point2.x + dimension2.width > dimension.width) {
                    point2.x -= dimension2.width;
                }
                if (point2.y + dimension2.height > dimension.height) {
                    point2.y -= dimension2.height + 20;
                }
            }
            this.tipWindow.show(this.insideComponent, point2.x, point2.y);
            this.insideTimer.start();
        }
    }

    void hideTipWindow() {
        if (this.tipWindow != null) {
            this.tipWindow.removeMouseListener(this);
            this.tipWindow.hide();
            this.tipWindow = null;
            this.tip.getUI().uninstallUI(this.tip);
            this.tip = null;
            this.insideTimer.stop();
        }
    }

    public static ToolTipManager sharedInstance() {
        return sharedInstance;
    }

    public void registerComponent(JComponent jComponent) {
        jComponent.removeMouseListener(this);
        jComponent.addMouseListener(this);
    }

    public void unregisterComponent(JComponent jComponent) {
        jComponent.removeMouseListener(this);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.tipWindow) {
            return;
        }
        JComponent jComponent = (JComponent)mouseEvent.getSource();
        this.toolTipText = jComponent.getToolTipText(mouseEvent);
        this.preferredLocation = jComponent.getToolTipLocation(mouseEvent);
        this.exitTimer.stop();
        Point point = mouseEvent.getPoint();
        if (point.x < 0 || point.x >= jComponent.getWidth() || point.y < 0 || point.y >= jComponent.getHeight()) {
            return;
        }
        if (this.insideComponent != null) {
            this.enterTimer.stop();
            this.insideComponent = null;
        }
        jComponent.addMouseMotionListener(this);
        this.insideComponent = jComponent;
        if (this.toolTipText != null) {
            this.mouseEvent = mouseEvent;
            if (this.showImmediately) {
                this.showTipWindow();
                return;
            }
            this.enterTimer.start();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        boolean bl = true;
        if (mouseEvent.getSource() == this.tipWindow) {
            Container container = this.insideComponent.getTopLevelAncestor();
            Rectangle rectangle = this.tipWindow.getBounds();
            Point point = mouseEvent.getPoint();
            point.x += rectangle.x;
            point.y += rectangle.y;
            rectangle = container.getBounds();
            point.x -= rectangle.x;
            point.y -= rectangle.y;
            point = SwingUtilities.convertPoint(null, point, this.insideComponent);
            bl = point.x < 0 || point.x >= this.insideComponent.getWidth() || point.y < 0 || point.y >= this.insideComponent.getHeight();
        } else if (mouseEvent.getSource() == this.insideComponent && this.tipWindow != null) {
            Point point = SwingUtilities.convertPoint(this.insideComponent, mouseEvent.getPoint(), null);
            Rectangle rectangle = this.insideComponent.getTopLevelAncestor().getBounds();
            point.x += rectangle.x;
            point.y += rectangle.y;
            rectangle = this.tipWindow.getBounds();
            bl = point.x < rectangle.x || point.x >= rectangle.x + rectangle.width || point.y < rectangle.y || point.y >= rectangle.y + rectangle.height;
        }
        if (bl) {
            this.enterTimer.stop();
            if (this.insideComponent != null) {
                this.insideComponent.removeMouseMotionListener(this);
            }
            this.insideComponent = null;
            this.toolTipText = null;
            this.mouseEvent = null;
            this.hideTipWindow();
            this.exitTimer.start();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.hideTipWindow();
        this.enterTimer.stop();
        this.showImmediately = false;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        JComponent jComponent = (JComponent)mouseEvent.getSource();
        String string = jComponent.getToolTipText(mouseEvent);
        Point point = jComponent.getToolTipLocation(mouseEvent);
        if (string != null || point != null) {
            this.mouseEvent = mouseEvent;
            if ((string != null && string.equals(this.toolTipText) || string == null) && (point != null && point.equals(this.preferredLocation) || point == null)) {
                if (this.tipWindow != null) {
                    this.insideTimer.restart();
                    return;
                }
                this.enterTimer.restart();
                return;
            }
            this.toolTipText = string;
            this.preferredLocation = point;
            if (this.showImmediately) {
                this.hideTipWindow();
                this.showTipWindow();
                return;
            }
            this.enterTimer.restart();
            return;
        }
        this.toolTipText = null;
        this.preferredLocation = null;
        this.mouseEvent = null;
        this.hideTipWindow();
        this.enterTimer.stop();
        this.exitTimer.start();
    }

    static Frame frameForComponent(Component component) {
        while (!(component instanceof Frame)) {
            component = component.getParent();
        }
        return (Frame)component;
    }

    protected class insideTimerAction
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (ToolTipManager.this.insideComponent != null && ToolTipManager.this.insideComponent.isShowing()) {
                ToolTipManager.this.showImmediately = true;
                ToolTipManager.this.showTipWindow();
            }
        }

        insideTimerAction() {
            ToolTipManager.this = ToolTipManager.this;
        }
    }

    protected class outsideTimerAction
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ToolTipManager.this.showImmediately = false;
        }

        outsideTimerAction() {
            ToolTipManager.this = ToolTipManager.this;
        }
    }

    protected class stillInsideTimerAction
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ToolTipManager.this.hideTipWindow();
            ToolTipManager.this.enterTimer.stop();
            ToolTipManager.this.showImmediately = false;
        }

        stillInsideTimerAction() {
            ToolTipManager.this = ToolTipManager.this;
        }
    }

    private interface Popup {
        public void show(JComponent var1, int var2, int var3);

        public void hide();

        public void addMouseListener(ToolTipManager var1);

        public void removeMouseListener(ToolTipManager var1);

        public Rectangle getBounds();
    }

    class PanelPopup
    extends Panel
    implements Popup {
        public PanelPopup(JComponent jComponent, Dimension dimension) {
            ToolTipManager.this = ToolTipManager.this;
            this.setLayout(new BorderLayout());
            this.add((Component)jComponent, "Center");
            this.setSize(dimension);
        }

        public Rectangle getBounds() {
            return super.getBounds();
        }

        public void show(JComponent jComponent, int n, int n2) {
            Point point = new Point(n, n2);
            SwingUtilities.convertPointFromScreen(point, jComponent.getRootPane().getLayeredPane());
            this.setBounds(point.x, point.y, this.getSize().width, this.getSize().height);
            jComponent.getRootPane().getLayeredPane().add(this, JLayeredPane.POPUP_LAYER, 0);
        }

        public void hide() {
            Container container = this.getParent();
            Rectangle rectangle = this.getBounds();
            if (container != null) {
                container.remove(this);
            }
            container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        public void addMouseListener(ToolTipManager toolTipManager) {
            super.addMouseListener(toolTipManager);
        }

        public void removeMouseListener(ToolTipManager toolTipManager) {
            super.removeMouseListener(toolTipManager);
        }
    }

    class WindowPopup
    extends Window
    implements Popup {
        boolean firstShow = true;

        public WindowPopup(Frame frame, JComponent jComponent, Dimension dimension) {
            super(frame);
            ToolTipManager.this = ToolTipManager.this;
            this.add(jComponent);
            ((Component)this).setSize(dimension);
        }

        public Rectangle getBounds() {
            return super.getBounds();
        }

        public void show(JComponent jComponent, int n, int n2) {
            ((Component)this).setBounds(n, n2, this.getSize().width, this.getSize().height);
            ((Component)this).setLocation(n, n2);
            ((Component)this).setVisible(true);
            if (this.firstShow) {
                this.hide();
                ((Component)this).setVisible(true);
                this.firstShow = false;
            }
        }

        public void hide() {
            super.hide();
            ((Container)this).removeNotify();
        }

        public void addMouseListener(ToolTipManager toolTipManager) {
            super.addMouseListener(toolTipManager);
        }

        public void removeMouseListener(ToolTipManager toolTipManager) {
            super.removeMouseListener(toolTipManager);
        }
    }
}

