/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.swing.Icon;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.plaf.ComponentUI;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class UIDefaults
extends Hashtable {
    private static final Object PENDING = new String("Pending");
    private PropertyChangeSupport changeSupport;
    static /* synthetic */ Class class$com$sun$java$swing$JComponent;

    public UIDefaults() {
    }

    public UIDefaults(Object[] objectArray) {
        super(objectArray.length / 2);
        int n = 0;
        while (n < objectArray.length) {
            super.put(objectArray[n], objectArray[n + 1]);
            n += 2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object get(Object object) {
        Object object2 = super.get(object);
        if (object2 != PENDING && !(object2 instanceof ActiveValue) && !(object2 instanceof LazyValue)) {
            return object2;
        }
        UIDefaults uIDefaults = this;
        synchronized (uIDefaults) {
            object2 = super.get(object);
            if (object2 == PENDING) {
                do {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                } while ((object2 = super.get(object)) == PENDING);
                return object2;
            }
            if (object2 instanceof LazyValue) {
                super.put(object, PENDING);
            } else if (!(object2 instanceof ActiveValue)) {
                return object2;
            }
        }
        if (!(object2 instanceof LazyValue)) return ((ActiveValue)object2).createValue(this);
        try {
            object2 = ((LazyValue)object2).createValue(this);
        }
        catch (Throwable throwable) {
            uIDefaults = null;
            UIDefaults uIDefaults2 = this;
            synchronized (uIDefaults2) {
                if (object2 == null) {
                    super.remove(object);
                } else {
                    super.put(object, object2);
                }
                this.notify();
                throw throwable;
            }
        }
        uIDefaults = null;
        UIDefaults uIDefaults3 = this;
        synchronized (uIDefaults3) {
            if (object2 == null) {
                super.remove(object);
            } else {
                super.put(object, object2);
            }
            this.notify();
            return object2;
        }
    }

    public Object put(Object object, Object object2) {
        Object object3;
        Object object4 = object3 = object2 == null ? super.remove(object) : super.put(object, object2);
        if (object instanceof String) {
            this.firePropertyChange((String)object, object3, object2);
        }
        return object3;
    }

    public void putDefaults(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n + 1];
            if (object == null) {
                super.remove(objectArray[n]);
            } else {
                super.put(objectArray[n], object);
            }
            n += 2;
        }
        this.firePropertyChange("UIDefaults", null, null);
    }

    public Font getFont(Object object) {
        Object object2 = this.get(object);
        if (object2 instanceof Font) {
            return (Font)object2;
        }
        return null;
    }

    public Color getColor(Object object) {
        Object object2 = this.get(object);
        if (object2 instanceof Color) {
            return (Color)object2;
        }
        return null;
    }

    public Icon getIcon(Object object) {
        Object object2 = this.get(object);
        if (object2 instanceof Icon) {
            return (Icon)object2;
        }
        return null;
    }

    public Border getBorder(Object object) {
        Object object2 = this.get(object);
        if (object2 instanceof Border) {
            return (Border)object2;
        }
        return null;
    }

    public String getString(Object object) {
        Object object2 = this.get(object);
        if (object2 instanceof String) {
            return (String)object2;
        }
        return null;
    }

    public Class getUIClass(String string) {
        Object object = this.get(string);
        try {
            if (object instanceof String) {
                return Class.forName((String)object);
            }
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    protected void getUIError(String string) {
        try {
            throw new Error();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.err.println("UIDefaults.getUI() failed: " + string);
            return;
        }
    }

    public ComponentUI getUI(JComponent jComponent) {
        Class clazz = this.getUIClass(jComponent.getUIClassID());
        Object object = null;
        if (clazz == null) {
            this.getUIError("no ComponentUI class for: " + jComponent);
        } else {
            try {
                Class clazz2 = class$com$sun$java$swing$JComponent != null ? class$com$sun$java$swing$JComponent : (class$com$sun$java$swing$JComponent = UIDefaults.class$("com.sun.java.swing.JComponent"));
                Method method = clazz.getMethod("createUI", clazz2);
                object = method.invoke(null, jComponent);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.getUIError("static createUI() method not found in " + clazz);
            }
            catch (Exception exception) {
                this.getUIError("createUI() failed for " + jComponent + " " + exception);
            }
        }
        return (ComponentUI)object;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, object, object2);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public interface LazyValue {
        public Object createValue(UIDefaults var1);
    }

    public interface ActiveValue {
        public Object createValue(UIDefaults var1);
    }
}

