/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.swing.Icon;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.LookAndFeel;
import com.sun.java.swing.MultiUIDefaults;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.UIDefaults;
import com.sun.java.swing.UnsupportedLookAndFeelException;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.plaf.ComponentUI;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class UIManager
implements Serializable {
    private static final Object lafStateACKey = new StringBuffer("LookAndFeel State");
    private static final String defaultLAFKey = "swing.defaultlaf";
    private static final String auxiliaryLAFsKey = "swing.auxiliarylaf";
    private static final String multiplexingLAFKey = "swing.plaf.multiplexinglaf";
    private static final String installedLAFsKey = "swing.installedlafs";
    private static LookAndFeelInfo[] installedLAFs = new LookAndFeelInfo[]{new LookAndFeelInfo("Metal", "com.sun.java.swing.plaf.metal.MetalLookAndFeel"), new LookAndFeelInfo("CDE/Motif", "com.sun.java.swing.plaf.motif.MotifLookAndFeel"), new LookAndFeelInfo("Windows", "com.sun.java.swing.plaf.windows.WindowsLookAndFeel")};
    static /* synthetic */ Class class$com$sun$java$swing$UIManager;

    private static LAFState getLAFState() {
        LAFState lAFState = (LAFState)SwingUtilities.appContextGet(lafStateACKey);
        if (lAFState != null) {
            return lAFState;
        }
        Class clazz = class$com$sun$java$swing$UIManager != null ? class$com$sun$java$swing$UIManager : (class$com$sun$java$swing$UIManager = UIManager.class$("com.sun.java.swing.UIManager"));
        synchronized (clazz) {
            lAFState = (LAFState)SwingUtilities.appContextGet(lafStateACKey);
            if (lAFState != null) {
                LAFState lAFState2 = lAFState;
                Object var3_4 = null;
                return lAFState2;
            }
            lAFState = new LAFState();
            SwingUtilities.appContextPut(lafStateACKey, lAFState);
            LAFState lAFState3 = lAFState;
            Object var3_5 = null;
            return lAFState3;
        }
    }

    private static String makeInstalledLAFKey(String string, String string2) {
        return "swing.installedlaf." + string + "." + string2;
    }

    private static String makeSwingPropertiesFilename() {
        String string = File.separator;
        String string2 = System.getProperty("java.home", "<java.home undefined>");
        return String.valueOf(string2) + string + "lib" + string + "swing.properties";
    }

    public static LookAndFeelInfo[] getInstalledLookAndFeels() {
        UIManager.maybeInitialize();
        LookAndFeelInfo[] lookAndFeelInfoArray = installedLAFs;
        LookAndFeelInfo[] lookAndFeelInfoArray2 = new LookAndFeelInfo[lookAndFeelInfoArray.length];
        System.arraycopy(lookAndFeelInfoArray, 0, lookAndFeelInfoArray2, 0, lookAndFeelInfoArray.length);
        return lookAndFeelInfoArray2;
    }

    public static void setInstalledLookAndFeels(LookAndFeelInfo[] lookAndFeelInfoArray) throws SecurityException {
        LookAndFeelInfo[] lookAndFeelInfoArray2 = new LookAndFeelInfo[lookAndFeelInfoArray.length];
        System.arraycopy(lookAndFeelInfoArray, 0, lookAndFeelInfoArray2, 0, lookAndFeelInfoArray.length);
        installedLAFs = lookAndFeelInfoArray2;
    }

    public static void installLookAndFeel(LookAndFeelInfo lookAndFeelInfo) {
        LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        LookAndFeelInfo[] lookAndFeelInfoArray2 = new LookAndFeelInfo[lookAndFeelInfoArray.length + 1];
        System.arraycopy(lookAndFeelInfoArray, 0, lookAndFeelInfoArray2, 0, lookAndFeelInfoArray.length);
        lookAndFeelInfoArray2[lookAndFeelInfoArray.length] = lookAndFeelInfo;
        UIManager.setInstalledLookAndFeels(lookAndFeelInfoArray2);
    }

    public static void installLookAndFeel(String string, String string2) {
        UIManager.installLookAndFeel(new LookAndFeelInfo(string, string2));
    }

    public static LookAndFeel getLookAndFeel() {
        UIManager.maybeInitialize();
        return UIManager.getLAFState().lookAndFeel;
    }

    public static void setLookAndFeel(LookAndFeel lookAndFeel) throws UnsupportedLookAndFeelException {
        if (lookAndFeel != null && !lookAndFeel.isSupportedLookAndFeel()) {
            String string = String.valueOf(lookAndFeel.toString()) + " not supported on this platform";
            throw new UnsupportedLookAndFeelException(string);
        }
        LookAndFeel lookAndFeel2 = UIManager.getLAFState().lookAndFeel;
        if (lookAndFeel2 != null) {
            lookAndFeel2.uninitialize();
        }
        UIManager.getLAFState().lookAndFeel = lookAndFeel;
        if (lookAndFeel != null) {
            lookAndFeel.initialize();
            UIManager.getLAFState().setLookAndFeelDefaults(lookAndFeel.getDefaults());
        } else {
            UIManager.getLAFState().setLookAndFeelDefaults(null);
        }
        UIManager.getLAFState().changeSupport.firePropertyChange("lookAndFeel", lookAndFeel2, lookAndFeel);
    }

    public static void setLookAndFeel(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        Class<?> clazz = Class.forName(string);
        UIManager.setLookAndFeel((LookAndFeel)clazz.newInstance());
    }

    public static String getSystemLookAndFeelClassName() {
        String string = System.getProperty("os.name");
        if (string != null) {
            if (string.indexOf("Windows") != -1) {
                return "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
            }
            if (string.indexOf("Solaris") != -1) {
                return "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
            }
        }
        return UIManager.getCrossPlatformLookAndFeelClassName();
    }

    public static String getCrossPlatformLookAndFeelClassName() {
        return "com.sun.java.swing.plaf.metal.MetalLookAndFeel";
    }

    public static UIDefaults getDefaults() {
        UIManager.maybeInitialize();
        return UIManager.getLAFState().multiUIDefaults;
    }

    public static Font getFont(Object object) {
        return UIManager.getDefaults().getFont(object);
    }

    public static Color getColor(Object object) {
        return UIManager.getDefaults().getColor(object);
    }

    public static Icon getIcon(Object object) {
        return UIManager.getDefaults().getIcon(object);
    }

    public static Border getBorder(Object object) {
        return UIManager.getDefaults().getBorder(object);
    }

    public static String getString(Object object) {
        return UIManager.getDefaults().getString(object);
    }

    public static Object get(Object object) {
        return UIManager.getDefaults().get(object);
    }

    public static Object put(Object object, Object object2) {
        return UIManager.getDefaults().put(object, object2);
    }

    public static ComponentUI getUI(JComponent jComponent) {
        UIManager.maybeInitialize();
        ComponentUI componentUI = null;
        LookAndFeel lookAndFeel = UIManager.getLAFState().multiLookAndFeel;
        if (lookAndFeel != null) {
            componentUI = lookAndFeel.getDefaults().getUI(jComponent);
        }
        if (componentUI == null) {
            componentUI = UIManager.getDefaults().getUI(jComponent);
        }
        return componentUI;
    }

    public static UIDefaults getLookAndFeelDefaults() {
        UIManager.maybeInitialize();
        return UIManager.getLAFState().getLookAndFeelDefaults();
    }

    public static LookAndFeel[] getAuxiliaryLookAndFeels() {
        UIManager.maybeInitialize();
        Vector vector = UIManager.getLAFState().auxLookAndFeels;
        if (vector == null || vector.size() == 0) {
            return null;
        }
        LookAndFeel[] lookAndFeelArray = new LookAndFeel[vector.size()];
        int n = 0;
        while (n < lookAndFeelArray.length) {
            lookAndFeelArray[n] = (LookAndFeel)vector.elementAt(n);
            ++n;
        }
        return lookAndFeelArray;
    }

    public static synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        UIManager.getLAFState().changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public static synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        UIManager.getLAFState().changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    private static Properties loadSwingProperties() {
        Properties properties;
        block2: {
            properties = new Properties();
            if ((class$com$sun$java$swing$UIManager != null ? class$com$sun$java$swing$UIManager : (class$com$sun$java$swing$UIManager = UIManager.class$("com.sun.java.swing.UIManager"))).getClassLoader() != null) break block2;
            try {
                File file = new File(UIManager.makeSwingPropertiesFilename());
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                properties.load(bufferedInputStream);
                ((FilterInputStream)bufferedInputStream).close();
            }
            catch (Exception exception) {
                ((Hashtable)properties).clear();
            }
        }
        return properties;
    }

    private static void initializeInstalledLAFs(Properties properties) {
        String string = properties.getProperty(installedLAFsKey);
        if (string == null) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        Vector<LookAndFeelInfo> vector2 = new Vector<LookAndFeelInfo>(vector.size());
        int n = 0;
        while (n < vector.size()) {
            String string2 = (String)vector.elementAt(n);
            String string3 = properties.getProperty(UIManager.makeInstalledLAFKey(string2, "name"), string2);
            String string4 = properties.getProperty(UIManager.makeInstalledLAFKey(string2, "class"));
            if (string4 != null) {
                vector2.addElement(new LookAndFeelInfo(string3, string4));
            }
            ++n;
        }
        installedLAFs = new LookAndFeelInfo[vector2.size()];
        int n2 = 0;
        while (n2 < vector2.size()) {
            UIManager.installedLAFs[n2] = (LookAndFeelInfo)vector2.elementAt(n2);
            ++n2;
        }
    }

    private static void initializeDefaultLAF(Properties properties) {
        String string;
        if (UIManager.getLAFState().lookAndFeel != null) {
            return;
        }
        String string2 = string = UIManager.getCrossPlatformLookAndFeelClassName();
        String string3 = "<undefined>";
        try {
            string3 = properties.getProperty(defaultLAFKey, string2);
            Class<?> clazz = Class.forName(string3);
            UIManager.setLookAndFeel((LookAndFeel)clazz.newInstance());
            return;
        }
        catch (Exception exception) {
            try {
                string3 = properties.getProperty(defaultLAFKey, string);
                Class<?> clazz = Class.forName(string3);
                UIManager.setLookAndFeel((LookAndFeel)clazz.newInstance());
                return;
            }
            catch (Exception exception2) {
                throw new Error("can't load " + string3);
            }
        }
    }

    private static void initializeAuxiliaryLAFs(Properties properties) {
        Object object;
        String string;
        String string2 = properties.getProperty(auxiliaryLAFsKey);
        if (string2 == null) {
            return;
        }
        Vector vector = new Vector();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            try {
                object = Class.forName(string);
                vector.addElement(((Class)object).newInstance());
            }
            catch (Exception exception) {
                System.err.println("UIManager: failed loading auxiliary look and feel " + string);
            }
        }
        if (vector.size() == 0) {
            vector = null;
        } else {
            string = "com.sun.java.swing.plaf.multi.MultiLookAndFeel";
            object = properties.getProperty(multiplexingLAFKey, string);
            try {
                Class<?> clazz = Class.forName((String)object);
                UIManager.getLAFState().multiLookAndFeel = (LookAndFeel)clazz.newInstance();
            }
            catch (Exception exception) {
                System.err.println("UIManager: failed loading " + (String)object);
                vector = null;
            }
        }
        UIManager.getLAFState().auxLookAndFeels = vector;
    }

    private static void initializeSystemDefaults(Properties properties) {
        Object[] objectArray = new Object[]{"FocusManagerClassName", "com.sun.java.swing.DefaultFocusManager"};
        UIManager.getLAFState().setSystemDefaults(new UIDefaults(objectArray));
    }

    private static void initialize() {
        Properties properties = UIManager.loadSwingProperties();
        UIManager.initializeSystemDefaults(properties);
        UIManager.initializeDefaultLAF(properties);
        UIManager.initializeAuxiliaryLAFs(properties);
        UIManager.initializeInstalledLAFs(properties);
    }

    private static synchronized void maybeInitialize() {
        if (!UIManager.getLAFState().initialized) {
            UIManager.initialize();
            UIManager.getLAFState().initialized = true;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class LAFState {
        private UIDefaults[] tables = new UIDefaults[2];
        boolean initialized = false;
        MultiUIDefaults multiUIDefaults = new MultiUIDefaults(this.tables);
        LookAndFeel lookAndFeel;
        LookAndFeel multiLookAndFeel;
        Vector auxLookAndFeels;
        PropertyChangeSupport changeSupport = new PropertyChangeSupport(class$com$sun$java$swing$UIManager != null ? class$com$sun$java$swing$UIManager : (class$com$sun$java$swing$UIManager = UIManager.class$("com.sun.java.swing.UIManager")));

        UIDefaults getLookAndFeelDefaults() {
            return this.tables[0];
        }

        void setLookAndFeelDefaults(UIDefaults uIDefaults) {
            this.tables[0] = uIDefaults;
        }

        UIDefaults getSystemDefaults() {
            return this.tables[1];
        }

        void setSystemDefaults(UIDefaults uIDefaults) {
            this.tables[1] = uIDefaults;
        }

        LAFState() {
        }
    }

    public static class LookAndFeelInfo {
        private String name;
        private String className;

        public LookAndFeelInfo(String string, String string2) {
            this.name = string;
            this.className = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getClassName() {
            return this.className;
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + "[" + this.getName() + " " + this.getClassName() + "]";
        }
    }
}

