/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.AbstractAction;
import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.CellRendererPane;
import com.sun.java.swing.ComboBoxEditor;
import com.sun.java.swing.ComboBoxModel;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JDialog;
import com.sun.java.swing.JList;
import com.sun.java.swing.JPopupMenu;
import com.sun.java.swing.JRootPane;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.KeyStroke;
import com.sun.java.swing.ListCellRenderer;
import com.sun.java.swing.LookAndFeel;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.Timer;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.plaf.ComboBoxUI;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.UIResource;
import com.sun.java.swing.plaf.basic.BasicArrowButton;
import com.sun.java.swing.plaf.basic.BasicGraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;

public class BasicComboBoxUI
extends ComboBoxUI
implements LayoutManager,
MouseListener,
MouseMotionListener,
ItemListener,
FocusListener,
KeyListener,
PropertyChangeListener,
Serializable {
    protected static final Color selectionBackgroundColor = new Color(0, 0, 128);
    protected static final int BORDER_THICKNESS = 2;
    protected JComboBox comboBox;
    protected CellRendererPane currentValuePane = new CellRendererPane();
    protected JButton arrowButton;
    protected Component editor;
    protected JPopupMenu menu;
    protected JList listBox;
    protected JScrollPane scrollPane;
    protected Timer autoscrollTimer;
    protected Point lastMouseLocation;
    protected static JComboBox showingComboBox = null;
    protected Point popupLocation;
    protected boolean hasFocus = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicComboBoxUI();
    }

    public void installUI(JComponent jComponent) {
        this.comboBox = (JComboBox)jComponent;
        this.addArrowButton();
        this.comboBox.add(this.currentValuePane);
        this.comboBox.setLayout(this);
        this.comboBox.addItemListener(this);
        this.comboBox.addFocusListener(this);
        this.comboBox.addMouseListener(this);
        this.comboBox.addMouseMotionListener(this);
        this.comboBox.addKeyListener(this);
        this.comboBox.addPropertyChangeListener(this);
        if (this.comboBox.getRenderer() == null) {
            this.comboBox.setRenderer((ListCellRenderer)UIManager.get("ComboBox.renderer"));
        }
        this.editablePropertyChanged();
        this.addKeyAccelerators(this.comboBox);
        this.configureComboBox();
    }

    public void uninstallUI(JComponent jComponent) {
        this.hidePopup();
        this.removeEditor();
        this.removeArrowButton();
        this.comboBox.setLayout(null);
        this.comboBox.removeFocusListener(this);
        if (this.listBox != null) {
            this.listBox.removeMouseListener(this);
            this.listBox.removeMouseMotionListener(this);
        }
        this.comboBox.removeItemListener(this);
        this.comboBox.removeMouseListener(this);
        this.comboBox.removeMouseMotionListener(this);
        this.comboBox.removeKeyListener(this);
        this.comboBox.resetKeyboardActions();
        this.comboBox.remove(this.currentValuePane);
        this.comboBox.removePropertyChangeListener(this);
        if (this.comboBox.getRenderer() instanceof UIResource) {
            this.comboBox.setRenderer(null);
        }
        if (this.comboBox.getEditor() instanceof UIResource) {
            this.comboBox.setEditor(null);
        }
        this.comboBox = null;
        this.unconfigureComboBox();
    }

    public boolean isFocusTraversable() {
        return !this.comboBox.isEditable();
    }

    protected void configureComboBox() {
        LookAndFeel.installColorsAndFont(this.comboBox, "ComboBox.background", "ComboBox.foreground", "ComboBox.font");
    }

    protected void unconfigureComboBox() {
    }

    public void editablePropertyChanged() {
        if (this.comboBox.isEditable()) {
            this.addEditor();
            return;
        }
        this.removeEditor();
    }

    public void enablePropertyChanged() {
        boolean bl = this.comboBox.isEnabled();
        if (bl) {
            if (this.editor != null) {
                this.editor.setEnabled(true);
            }
            if (this.arrowButton != null) {
                this.arrowButton.setEnabled(true);
            }
        } else {
            if (this.editor != null) {
                this.editor.setEnabled(false);
            }
            if (this.arrowButton != null) {
                this.arrowButton.setEnabled(false);
            }
        }
        this.comboBox.repaint();
    }

    public void addEditor() {
        if (this.editor != null) {
            this.removeEditor();
        }
        if (this.comboBox.getEditor() == null) {
            this.comboBox.setEditor((ComboBoxEditor)UIManager.get("ComboBox.editor"));
        }
        this.editor = this.comboBox.getEditor().getEditorComponent();
        this.comboBox.add(this.editor);
        this.editor.setFont(this.comboBox.getFont());
        this.editor.setBackground(this.comboBox.getBackground());
        this.editor.setForeground(this.comboBox.getForeground());
        this.comboBox.configureEditor(this.comboBox.getEditor(), this.comboBox.getSelectedItem());
    }

    public void removeEditor() {
        if (this.editor != null) {
            this.comboBox.remove(this.editor);
            this.editor = null;
        }
    }

    public void addArrowButton() {
        this.arrowButton = this.createArrowButton();
        this.arrowButton.setRequestFocusEnabled(false);
        this.arrowButton.addMouseListener(this);
        this.arrowButton.addMouseMotionListener(this);
        this.arrowButton.resetKeyboardActions();
        this.comboBox.add(this.arrowButton);
    }

    public void removeArrowButton() {
        if (this.arrowButton != null) {
            this.comboBox.remove(this.arrowButton);
            this.arrowButton.removeMouseListener(this);
            this.arrowButton.removeMouseMotionListener(this);
            this.arrowButton = null;
        }
    }

    protected JList createListBox(ComboBoxModel comboBoxModel) {
        return new JList(comboBoxModel);
    }

    public JList getList() {
        return this.listBox;
    }

    protected JButton createArrowButton() {
        return new BasicArrowButton(5);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Rectangle rectangle = jComponent.getBounds();
        BasicGraphicsUtils.drawEtchedRect(graphics, 0, 0, rectangle.width, rectangle.height);
        boolean bl = this.comboBox.hasFocus();
        if (!this.comboBox.isEditable()) {
            Rectangle rectangle2 = this.rectangleForCurrentValue();
            this.paintCurrentValueBackground(graphics, rectangle2, bl);
            this.paintCurrentValue(graphics, rectangle2, bl);
        }
    }

    public void paintCurrentValue(Graphics graphics, Rectangle rectangle, boolean bl) {
        Component component;
        ListCellRenderer listCellRenderer = this.comboBox.getRenderer();
        this.validateMenu();
        if (bl && !this.popupIsVisible()) {
            component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, false);
        } else {
            component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
            component.setBackground(UIManager.getColor("ComboBox.background"));
        }
        component.setFont(this.comboBox.getFont());
        if (bl && !this.popupIsVisible()) {
            component.setForeground(this.listBox.getSelectionForeground());
            component.setBackground(this.listBox.getSelectionBackground());
        } else if (this.comboBox.isEnabled()) {
            component.setForeground(this.comboBox.getForeground());
            component.setBackground(this.comboBox.getBackground());
        } else {
            component.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
            component.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
        }
        this.currentValuePane.paintComponent(graphics, component, this.comboBox, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void paintCurrentValueBackground(Graphics graphics, Rectangle rectangle, boolean bl) {
        Color color = graphics.getColor();
        if (this.comboBox.isEnabled()) {
            graphics.setColor(UIManager.getColor("ComboBox.background"));
        } else {
            graphics.setColor(UIManager.getColor("ComboBox.disabledBackground"));
        }
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(color);
    }

    protected Dimension getDefaultSize() {
        return new Dimension(100, 20);
    }

    protected Dimension getMaxPreferredSize() {
        Dimension dimension = new Dimension();
        ListCellRenderer listCellRenderer = this.comboBox.getRenderer();
        ComboBoxModel comboBoxModel = this.comboBox.getModel();
        this.validateMenu();
        if (listCellRenderer != null && comboBoxModel.getSize() > 0) {
            Dimension dimension2;
            int n = 0;
            int n2 = comboBoxModel.getSize();
            while (n < n2) {
                Component component = listCellRenderer.getListCellRendererComponent(this.listBox, comboBoxModel.getElementAt(n), -1, false, false);
                this.currentValuePane.add(component);
                component.setFont(this.comboBox.getFont());
                dimension2 = component.getPreferredSize();
                this.currentValuePane.remove(component);
                dimension.width = Math.max(dimension.width, dimension2.width);
                dimension.height = Math.max(dimension.height, dimension2.height);
                ++n;
            }
            if (this.comboBox.isEditable()) {
                dimension2 = this.editor.getPreferredSize();
                dimension.width = Math.max(dimension.width, dimension2.width);
                dimension.height = Math.max(dimension.height, dimension2.height);
            }
            return dimension;
        }
        return this.getDefaultSize();
    }

    protected Dimension getMaxMinimumSize() {
        Dimension dimension = new Dimension();
        ListCellRenderer listCellRenderer = this.comboBox.getRenderer();
        ComboBoxModel comboBoxModel = this.comboBox.getModel();
        this.validateMenu();
        if (listCellRenderer != null && comboBoxModel.getSize() > 0) {
            Dimension dimension2;
            int n = 0;
            int n2 = comboBoxModel.getSize();
            while (n < n2) {
                Component component = listCellRenderer.getListCellRendererComponent(this.listBox, comboBoxModel.getElementAt(n), -1, false, false);
                this.currentValuePane.add(component);
                component.setFont(this.comboBox.getFont());
                dimension2 = component.getMinimumSize();
                this.currentValuePane.remove(component);
                dimension.width = Math.max(dimension.width, dimension2.width);
                dimension.height = Math.max(dimension.height, dimension2.height);
                ++n;
            }
            if (this.comboBox.isEditable()) {
                dimension2 = this.editor.getMinimumSize();
                dimension.width = Math.max(dimension.width, dimension2.width);
                dimension.height = Math.max(dimension.height, dimension2.height);
            }
            return dimension;
        }
        return this.getDefaultSize();
    }

    protected Dimension getMaxMaximumSize() {
        Dimension dimension = new Dimension();
        ListCellRenderer listCellRenderer = this.comboBox.getRenderer();
        ComboBoxModel comboBoxModel = this.comboBox.getModel();
        this.validateMenu();
        if (listCellRenderer != null && comboBoxModel.getSize() > 0) {
            Dimension dimension2;
            int n = 0;
            int n2 = comboBoxModel.getSize();
            while (n < n2) {
                Component component = listCellRenderer.getListCellRendererComponent(this.listBox, comboBoxModel.getElementAt(n), -1, false, false);
                this.currentValuePane.add(component);
                component.setFont(this.comboBox.getFont());
                dimension2 = component.getMaximumSize();
                this.currentValuePane.remove(component);
                dimension.width = Math.max(dimension.width, dimension2.width);
                dimension.height = Math.max(dimension.height, dimension2.height);
                ++n;
            }
            if (this.comboBox.isEditable()) {
                dimension2 = this.editor.getMaximumSize();
                dimension.width = Math.max(dimension.width, dimension2.width);
                dimension.height = Math.max(dimension.height, dimension2.height);
            }
            return dimension;
        }
        return this.getDefaultSize();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = this.getMaxPreferredSize();
        dimension.height += 4;
        int n = dimension.height - 4;
        dimension.width += 4 + n;
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = this.getMaxMinimumSize();
        dimension.height += 4;
        int n = dimension.height - 4;
        dimension.width += 4 + n;
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getMaxMaximumSize();
        dimension.height += 4;
        dimension.width = Short.MAX_VALUE;
        return dimension;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        JComboBox cfr_ignored_0 = (JComboBox)container;
        return container.getPreferredSize();
    }

    public Dimension minimumLayoutSize(Container container) {
        JComboBox cfr_ignored_0 = (JComboBox)container;
        return container.getMinimumSize();
    }

    protected Rectangle rectangleForCurrentValue() {
        Dimension dimension = this.comboBox.getSize();
        int n = dimension.height - 4;
        return new Rectangle(2, 2, dimension.width - 4 - n, dimension.height - 4);
    }

    public void layoutContainer(Container container) {
        JComboBox jComboBox = (JComboBox)container;
        Dimension dimension = jComboBox.getSize();
        int n = dimension.height - 4;
        if (this.editor != null) {
            Rectangle rectangle = this.rectangleForCurrentValue();
            this.editor.setBounds(rectangle);
        }
        if (this.arrowButton != null) {
            this.arrowButton.setBounds(2 + dimension.width - 4 - n, 2, n, n);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ComboBoxModel comboBoxModel = this.comboBox.getModel();
        Object object = comboBoxModel.getSelectedItem();
        if (this.editor != null) {
            this.comboBox.configureEditor(this.comboBox.getEditor(), object);
        } else {
            Rectangle rectangle = this.rectangleForCurrentValue();
            this.comboBox.repaint(0L, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (this.popupIsVisible()) {
            this.updateListBoxSelection();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (!this.comboBox.isEditable()) {
            this.repaintCurrentValue();
            this.hasFocus = true;
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!this.comboBox.isEditable()) {
            this.repaintCurrentValue();
            this.hasFocus = false;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("model") && this.listBox != null) {
            this.listBox.setModel(this.comboBox.getModel());
            if (this.popupIsVisible()) {
                this.hidePopup();
            }
        }
    }

    void repaintCurrentValue() {
        Rectangle rectangle = this.rectangleForCurrentValue();
        this.comboBox.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.stopAutoscrolling();
        if (this.popupIsVisible()) {
            if (mouseEvent.getSource() == this.listBox) {
                this.updateListBoxSelectionForEvent(mouseEvent, true);
                this.comboBox.getModel().setSelectedItem(this.listBox.getSelectedValue());
                this.hidePopup();
                return;
            }
            if (mouseEvent.getSource() == this.arrowButton && !SwingUtilities.getLocalBounds(this.arrowButton).contains(mouseEvent.getPoint())) {
                MouseEvent mouseEvent2 = this.convertEventToListBox(mouseEvent);
                this.updateListBoxSelectionForEvent(mouseEvent2, true);
                Object object = this.listBox.getSelectedValue();
                if (object != null) {
                    this.comboBox.getModel().setSelectedItem(object);
                }
                this.hidePopup();
                return;
            }
            if (mouseEvent.getSource() == this.comboBox && !SwingUtilities.getLocalBounds(this.comboBox).contains(mouseEvent.getPoint())) {
                MouseEvent mouseEvent3 = this.convertEventToListBox(mouseEvent);
                this.updateListBoxSelectionForEvent(mouseEvent3, true);
                Object object = this.listBox.getSelectedValue();
                if (object != null) {
                    this.comboBox.getModel().setSelectedItem(object);
                }
                this.hidePopup();
            }
        }
    }

    protected boolean shouldActivatePopupForEvent(MouseEvent mouseEvent) {
        Rectangle rectangle = this.rectangleForCurrentValue();
        return rectangle.contains(mouseEvent.getPoint());
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        if (!this.comboBox.isEnabled()) {
            return;
        }
        if (mouseEvent.getSource() == this.arrowButton) {
            Rectangle rectangle = SwingUtilities.getLocalBounds(this.arrowButton);
            if (rectangle.contains(mouseEvent.getX(), mouseEvent.getY())) {
                if (this.popupIsVisible()) {
                    this.hidePopup();
                    return;
                }
                this.showPopup();
                return;
            }
        } else if (mouseEvent.getSource() == this.comboBox && this.shouldActivatePopupForEvent(mouseEvent)) {
            if (this.popupIsVisible()) {
                this.hidePopup();
                return;
            }
            this.showPopup();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.popupIsVisible() && (mouseEvent.getSource() == this.arrowButton && !SwingUtilities.getLocalBounds(this.arrowButton).contains(mouseEvent.getPoint()) || mouseEvent.getSource() == this.comboBox && !SwingUtilities.getLocalBounds(this.comboBox).contains(mouseEvent.getPoint()))) {
            MouseEvent mouseEvent2 = this.convertEventToListBox(mouseEvent);
            this.updateListBoxSelectionForEvent(mouseEvent2, true);
            this.lastMouseLocation = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), null);
            Window window = SwingUtilities.windowForComponent((Component)mouseEvent.getSource());
            this.lastMouseLocation.x += window.getBounds().x;
            this.lastMouseLocation.y += window.getBounds().y;
            this.startAutoscrolling();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (this.popupIsVisible() && object == this.listBox) {
            Point point = mouseEvent.getPoint();
            Rectangle rectangle = new Rectangle();
            this.listBox.computeVisibleRect(rectangle);
            if (rectangle.contains(point)) {
                this.updateListBoxSelectionForEvent(mouseEvent, false);
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if ((keyEvent.getSource() == this.comboBox && !this.comboBox.isEditable() || keyEvent.getSource() == this.listBox && !this.comboBox.isEditable()) && this.comboBox.selectWithKeyChar(keyEvent.getKeyChar())) {
            keyEvent.consume();
        }
    }

    public void validateMenu() {
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            this.menu.setLayout(new BoxLayout(this.menu, 1));
            this.menu.setBorderPainted(true);
            this.menu.setBorder(BorderFactory.createLineBorder(Color.black));
            this.menu.setOpaque(false);
            this.listBox = this.createListBox(this.comboBox.getModel());
            this.listBox.setRequestFocusEnabled(false);
            this.listBox.setBorder(null);
            this.listBox.setCellRenderer(this.comboBox.getRenderer());
            this.listBox.addMouseListener(this);
            this.listBox.addMouseMotionListener(this);
            this.listBox.addKeyListener(this);
            this.listBox.setBorder(null);
            this.scrollPane = new JScrollPane(this.listBox, 20, 31);
            this.scrollPane.setRequestFocusEnabled(false);
            this.scrollPane.getVerticalScrollBar().setRequestFocusEnabled(false);
            this.scrollPane.setBorder(null);
            this.menu.add(this.scrollPane);
            this.menu.setDoubleBuffered(true);
            this.menu.registerKeyboardAction(new 1(), KeyStroke.getKeyStroke(27, 0), 1);
            this.menu.registerKeyboardAction(new 2(), KeyStroke.getKeyStroke(10, 0), 1);
            this.addKeyAccelerators(this.menu);
        }
    }

    private Dialog getDialog() {
        Container container = this.comboBox.getParent();
        while (container != null && !(container instanceof Dialog) && !(container instanceof Window)) {
            container = container.getParent();
        }
        if (container instanceof Dialog) {
            return (Dialog)container;
        }
        return null;
    }

    private boolean inModalDialog() {
        return this.getDialog() != null;
    }

    protected Rectangle computePopupBounds(int n, int n2, int n3, int n4) {
        Rectangle rectangle;
        Serializable serializable;
        Rectangle rectangle2 = new Rectangle(n, n2, n3, n4);
        boolean bl = this.inModalDialog();
        if (bl) {
            Point point;
            serializable = this.getDialog();
            if (serializable instanceof JDialog) {
                JRootPane jRootPane = ((JDialog)serializable).getRootPane();
                point = jRootPane.getLocationOnScreen();
                rectangle = jRootPane.getBounds();
                rectangle.x = point.x;
                rectangle.y = point.y;
            } else {
                rectangle = serializable.getBounds();
            }
            point = new Point(rectangle.x, rectangle.y);
            SwingUtilities.convertPointFromScreen(point, this.comboBox);
            rectangle.x = point.x;
            rectangle.y = point.y;
        } else {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            rectangle = new Rectangle();
            serializable = new Point(0, 0);
            SwingUtilities.convertPointFromScreen((Point)serializable, this.comboBox);
            rectangle.x = ((Point)serializable).x;
            rectangle.y = ((Point)serializable).y;
            rectangle.width = dimension.width;
            rectangle.height = dimension.height;
        }
        if (SwingUtilities.isRectangleContainingRectangle(rectangle, rectangle2)) {
            return rectangle2;
        }
        serializable = new Rectangle(0, -rectangle2.height, rectangle2.width, rectangle2.height);
        if (SwingUtilities.isRectangleContainingRectangle(rectangle, (Rectangle)serializable)) {
            return serializable;
        }
        if (bl) {
            SwingUtilities.computeIntersection(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle2);
            SwingUtilities.computeIntersection(rectangle.x, rectangle.y, rectangle.width, rectangle.height, (Rectangle)serializable);
            if (rectangle2.height > ((Rectangle)serializable).height) {
                return rectangle2;
            }
            return serializable;
        }
        return serializable;
    }

    public void showPopup() {
        Rectangle rectangle = this.comboBox.getBounds();
        this.popupLocation = new Point(rectangle.x, rectangle.y);
        if (showingComboBox != null && showingComboBox != this.comboBox) {
            showingComboBox.getUI().hidePopup();
            showingComboBox = null;
        }
        this.validateMenu();
        this.comboBox.requestFocus();
        this.setupListBox(this.listBox, this.comboBox);
        Dimension dimension = new Dimension(rectangle.width, this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
        Border border = this.menu.getBorder();
        if (border != null) {
            Insets insets = border.getBorderInsets(this.menu);
            dimension.width -= insets.left + insets.right;
            dimension.height -= insets.top + insets.bottom;
        }
        this.updateListBoxSelection();
        this.listBox.invalidate();
        Rectangle rectangle2 = this.computePopupBounds(0, this.comboBox.getBounds().height, dimension.width, dimension.height);
        dimension.width = rectangle2.width;
        dimension.height = rectangle2.height;
        this.scrollPane.setMaximumSize(dimension);
        this.scrollPane.setPreferredSize(dimension);
        this.scrollPane.setMinimumSize(dimension);
        this.menu.setLightWeightPopupEnabled(this.comboBox.isLightWeightPopupEnabled());
        this.menu.show(this.comboBox, rectangle2.x, rectangle2.y);
        this.menu.repaint();
        this.comboBox.registerKeyboardAction(new 3(), KeyStroke.getKeyStroke(27, 0), 2);
        this.comboBox.registerKeyboardAction(new 4(), KeyStroke.getKeyStroke(10, 0), 2);
        this.repaintCurrentValue();
        this.listBox.requestFocus();
        showingComboBox = this.comboBox;
    }

    protected void setupListBox(JList jList, JComboBox jComboBox) {
        ((Component)jList).setFont(jComboBox.getFont());
        jList.setForeground(jComboBox.getForeground());
        jList.setBackground(jComboBox.getBackground());
    }

    public void hidePopup() {
        if (this.menu == null || this.listBox == null) {
            return;
        }
        if (!this.popupIsVisible()) {
            return;
        }
        this.menu.setVisible(false);
        this.requestFocusLater();
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
    }

    protected void requestFocusLater() {
        if (this.comboBox.isEditable()) {
            BasicComboBoxUI.requestFocusLaterForComponent(this.comboBox.getEditor().getEditorComponent());
            return;
        }
        BasicComboBoxUI.requestFocusLaterForComponent(this.comboBox);
        this.repaintCurrentValue();
    }

    protected int getPopupHeightForRowCount(int n) {
        int n2 = this.comboBox.getModel().getSize();
        if (n2 > 0) {
            Rectangle rectangle = this.listBox.getCellBounds(0, 0);
            if (rectangle.height <= 2) {
                rectangle.height = 17;
            }
            if (n < n2) {
                return rectangle.height * n + 2;
            }
            return rectangle.height * n2 + 2;
        }
        return 100;
    }

    public boolean popupIsVisible() {
        if (this.menu == null) {
            return false;
        }
        this.validateMenu();
        return this.menu.isVisible();
    }

    public void maximumRowCountChanged() {
        if (this.popupIsVisible()) {
            this.hidePopup();
            this.showPopup();
        }
    }

    protected void updateListBoxSelection() {
        Object object = this.comboBox.getModel().getSelectedItem();
        if (object == null && this.listBox != null) {
            this.listBox.setSelectedIndex(-1);
            return;
        }
        this.listBox.setSelectedValue(object, true);
    }

    protected void startAutoscrolling() {
        if (this.autoscrollTimer == null) {
            this.autoscrollTimer = new Timer(100, new 5());
        }
        this.autoscrollTimer.start();
    }

    protected void stopAutoscrolling() {
        if (this.autoscrollTimer != null) {
            this.autoscrollTimer.stop();
        }
        this.lastMouseLocation = null;
    }

    protected void autoscroll() {
        if (this.listBox == null) {
            return;
        }
        Window window = SwingUtilities.windowForComponent(this.listBox);
        if (this.lastMouseLocation != null && window != null) {
            Point point = new Point(this.lastMouseLocation.x - window.getBounds().x, this.lastMouseLocation.y - window.getBounds().y);
            int n = this.listBox.locationToIndex(point = SwingUtilities.convertPoint(null, point, this.listBox));
            if (n == -1) {
                n = point.y < 0 ? 0 : this.comboBox.getModel().getSize() - 1;
            }
            this.listBox.setSelectedIndex(n);
            this.listBox.ensureIndexIsVisible(n);
        }
    }

    protected void updateListBoxSelectionForEvent(MouseEvent mouseEvent, boolean bl) {
        Point point = mouseEvent.getPoint();
        if (this.listBox == null) {
            return;
        }
        int n = this.listBox.locationToIndex(point);
        if (n == -1) {
            n = point.y < 0 ? 0 : this.comboBox.getModel().getSize() - 1;
        }
        this.listBox.setSelectedIndex(n);
        if (bl) {
            this.listBox.ensureIndexIsVisible(n);
        }
    }

    protected void selectNextPossibleValue() {
        this.validateMenu();
        int n = this.popupIsVisible() ? this.listBox.getSelectedIndex() : this.comboBox.getSelectedIndex();
        if (n < this.comboBox.getModel().getSize() - 1) {
            this.comboBox.setSelectedIndex(n + 1);
        }
    }

    protected void selectPreviousPossibleValue() {
        this.validateMenu();
        int n = this.popupIsVisible() ? this.listBox.getSelectedIndex() : this.comboBox.getSelectedIndex();
        if (n > 0) {
            this.comboBox.setSelectedIndex(n - 1);
        }
    }

    protected void toggleOpenClose() {
        if (this.popupIsVisible()) {
            this.hidePopup();
            return;
        }
        this.showPopup();
    }

    protected MouseEvent convertEventToListBox(MouseEvent mouseEvent) {
        MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent((Component)mouseEvent.getSource(), mouseEvent, null);
        Window window = SwingUtilities.windowForComponent((Component)mouseEvent.getSource());
        Rectangle rectangle = window.getBounds();
        mouseEvent2.translatePoint(rectangle.x, rectangle.y);
        Window window2 = SwingUtilities.windowForComponent(this.listBox);
        rectangle = window2.getBounds();
        mouseEvent2.translatePoint(-rectangle.x, -rectangle.y);
        mouseEvent2 = SwingUtilities.convertMouseEvent(null, mouseEvent2, this.listBox);
        return mouseEvent2;
    }

    protected void addKeyAccelerators(JComponent jComponent) {
        jComponent.registerKeyboardAction(new 6(), KeyStroke.getKeyStroke(40, 0), 1);
        jComponent.registerKeyboardAction(new 7(), KeyStroke.getKeyStroke(38, 0), 1);
        jComponent.registerKeyboardAction(new 8(), KeyStroke.getKeyStroke(38, 8), 1);
        jComponent.registerKeyboardAction(new 9(), KeyStroke.getKeyStroke(40, 8), 1);
    }

    protected void removeKeyAccelerators(JComponent jComponent) {
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke(40, 0));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke(38, 0));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke(40, 8));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke(38, 8));
    }

    protected static void requestFocusLaterForComponent(Component component) {
        new FocusRequestHelper(component);
    }

    private final class 1
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            BasicComboBoxUI.this.hidePopup();
        }

        public boolean isEnabled() {
            return true;
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            BasicComboBoxUI.this.hidePopup();
        }

        public boolean isEnabled() {
            return true;
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            BasicComboBoxUI.this.hidePopup();
        }

        public boolean isEnabled() {
            return true;
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            BasicComboBoxUI.this.hidePopup();
        }

        public boolean isEnabled() {
            return true;
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            BasicComboBoxUI.this.autoscroll();
        }

        public boolean isEnabled() {
            return true;
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            BasicComboBoxUI.this.selectNextPossibleValue();
        }

        public boolean isEnabled() {
            return BasicComboBoxUI.this.comboBox.isEnabled();
        }

        /* synthetic */ 6() {
        }
    }

    private final class 7
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            BasicComboBoxUI.this.selectPreviousPossibleValue();
        }

        public boolean isEnabled() {
            return BasicComboBoxUI.this.comboBox.isEnabled();
        }

        /* synthetic */ 7() {
        }
    }

    private final class 8
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            BasicComboBoxUI.this.toggleOpenClose();
        }

        public boolean isEnabled() {
            return BasicComboBoxUI.this.comboBox.isEnabled();
        }

        /* synthetic */ 8() {
        }
    }

    private final class 9
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            BasicComboBoxUI.this.toggleOpenClose();
        }

        public boolean isEnabled() {
            return BasicComboBoxUI.this.comboBox.isEnabled();
        }

        /* synthetic */ 9() {
        }
    }

    static class FocusRequestHelper
    implements WindowListener,
    ActionListener,
    Serializable {
        Window window = null;
        Component component;
        Timer timer;

        FocusRequestHelper(Component component) {
            this.component = component;
            Container container = component.getParent();
            while (container != null) {
                if (container instanceof Window) {
                    this.window = (Window)container;
                    break;
                }
                container = container.getParent();
            }
            if (this.window == null) {
                return;
            }
            this.window.addWindowListener(this);
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
            this.window.removeWindowListener(this);
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowActivated(WindowEvent windowEvent) {
            this.window.removeWindowListener(this);
            this.startTimer();
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        void startTimer() {
            this.timer = new Timer(20, this);
            this.timer.start();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.timer != null) {
                this.timer.stop();
            }
            if (this.component != null) {
                this.component.requestFocus();
            }
            this.component = null;
            this.timer = null;
            this.window = null;
        }
    }
}

