/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.AbstractAction;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JTabbedPane;
import com.sun.java.swing.KeyStroke;
import com.sun.java.swing.LookAndFeel;
import com.sun.java.swing.SwingConstants;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ChangeListener;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.TabbedPaneUI;
import com.sun.java.swing.plaf.basic.BasicGraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;

public class BasicTabbedPaneUI
extends TabbedPaneUI
implements LayoutManager,
ChangeListener,
Serializable,
SwingConstants {
    protected static int spacingHeight = 2;
    protected static int spacingWidth = 4;
    protected static int iconSpacingWidth = 4;
    protected static int selectedTabRaisePad = 3;
    protected static int selectedTabWidenPad = 4;
    protected static Insets contentBorderInsets = new Insets(2, 2, 3, 3);
    protected static Insets tabsOnTopTabInsets = new Insets(3, 2, 0, 2);
    protected static Insets tabsOnLeftTabInsets = new Insets(2, 3, 2, 0);
    protected static Insets tabsOnBottomTabInsets = new Insets(0, 2, 3, 2);
    protected static Insets tabsOnRightTabInsets = new Insets(2, 0, 2, 3);
    protected int overlay = 2;
    protected int xNudge;
    protected int yNudge;
    protected Color tabHighlight;
    protected Color tabShadow;
    protected Color tabDarkShadow;
    protected Color focus;
    protected int[] tabRuns = new int[10];
    protected int runCount;
    protected int selectedRun;
    protected Rectangle[] rects = new Rectangle[0];
    protected int maxTabHeight;
    protected int maxTabWidth;
    protected Component visibleComponent;
    protected MouseListener mouseGetter;
    protected FocusListener focusGetter;
    protected ChangeListener tabChangeListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTabbedPaneUI();
    }

    public void installUI(JComponent jComponent) {
        jComponent.setLayout(this);
        this.installDefaults(jComponent);
        this.installListeners(jComponent);
        this.installKeyboardActions(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions(jComponent);
        this.uninstallListeners(jComponent);
        this.uninstallDefaults(jComponent);
        jComponent.setLayout(null);
    }

    protected void installDefaults(JComponent jComponent) {
        LookAndFeel.installColorsAndFont(jComponent, "TabbedPane.tabBackground", "TabbedPane.tabForeground", "TabbedPane.font");
        this.tabHighlight = UIManager.getColor("TabbedPane.tabHighlight");
        this.tabShadow = UIManager.getColor("TabbedPane.tabShadow");
        this.tabDarkShadow = UIManager.getColor("TabbedPane.tabDarkShadow");
        this.focus = UIManager.getColor("TabbedPane.focus");
    }

    protected void uninstallDefaults(JComponent jComponent) {
    }

    protected void installListeners(JComponent jComponent) {
        this.mouseGetter = this.createMouseListener(jComponent);
        if (this.mouseGetter != null) {
            jComponent.addMouseListener(this.mouseGetter);
        }
        if ((this.focusGetter = this.createFocusListener(jComponent)) != null) {
            jComponent.addFocusListener(this.focusGetter);
        }
        if ((this.tabChangeListener = this.createChangeListener(jComponent)) != null) {
            ((JTabbedPane)jComponent).addChangeListener(this.tabChangeListener);
        }
    }

    protected void uninstallListeners(JComponent jComponent) {
        if (this.mouseGetter != null) {
            jComponent.removeMouseListener(this.mouseGetter);
            this.mouseGetter = null;
        }
        if (this.focusGetter != null) {
            jComponent.removeFocusListener(this.focusGetter);
            this.focusGetter = null;
        }
        if (this.tabChangeListener != null) {
            ((JTabbedPane)jComponent).removeChangeListener(this.tabChangeListener);
        }
    }

    protected MouseListener createMouseListener(JComponent jComponent) {
        return new MouseGetter();
    }

    protected FocusListener createFocusListener(JComponent jComponent) {
        return new FocusGetter();
    }

    protected ChangeListener createChangeListener(JComponent jComponent) {
        return this;
    }

    protected void installKeyboardActions(JComponent jComponent) {
        JTabbedPane jTabbedPane = (JTabbedPane)jComponent;
        jComponent.registerKeyboardAction(new 1(jTabbedPane, this), KeyStroke.getKeyStroke(39, 0), 0);
        jComponent.registerKeyboardAction(new 2(jTabbedPane, this), KeyStroke.getKeyStroke(37, 0), 0);
        jComponent.registerKeyboardAction(new 3(jTabbedPane, this), KeyStroke.getKeyStroke(38, 0), 0);
        jComponent.registerKeyboardAction(new 4(jTabbedPane, this), KeyStroke.getKeyStroke(40, 0), 0);
    }

    protected void uninstallKeyboardActions(JComponent jComponent) {
        jComponent.resetKeyboardActions();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        JTabbedPane jTabbedPane = (JTabbedPane)jComponent;
        int n = jTabbedPane.getSelectedIndex();
        int n2 = jTabbedPane.getTabPlacement();
        int n3 = jTabbedPane.getTabCount();
        if (n3 != this.rects.length) {
            this.calculateLayoutInfo(jTabbedPane);
        }
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = graphics.getClipBounds();
        jTabbedPane.getInsets();
        int n4 = this.runCount - 1;
        while (n4 >= 0) {
            int n5 = this.tabRuns[n4];
            int n6 = this.tabRuns[n4 == this.runCount - 1 ? 0 : n4 + 1];
            int n7 = n6 != 0 ? n6 - 1 : n3 - 1;
            int n8 = n5;
            while (n8 <= n7) {
                if (this.rects[n8].intersects(rectangle3)) {
                    this.paintTab(graphics, jTabbedPane, n2, this.rects, n8, rectangle, rectangle2);
                }
                ++n8;
            }
            --n4;
        }
        if (n >= 0 && this.getRunForTab(jTabbedPane, n3, n) == 0 && this.rects[n].intersects(rectangle3)) {
            this.paintTab(graphics, jTabbedPane, n2, this.rects, n, rectangle, rectangle2);
        }
        this.paintContentBorder(graphics, jTabbedPane, n2, n);
    }

    protected void paintTab(Graphics graphics, JTabbedPane jTabbedPane, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2) {
        Rectangle rectangle3 = rectangleArray[n2];
        int n3 = jTabbedPane.getSelectedIndex();
        boolean bl = n3 == n2;
        this.xNudge = this.calculateXNudge(jTabbedPane, n, n2, bl);
        this.yNudge = this.calculateYNudge(jTabbedPane, n, n2, bl);
        this.paintTabBackground(graphics, jTabbedPane, n, n2, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl);
        this.paintTabBorder(graphics, jTabbedPane, n, n2, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl);
        String string = jTabbedPane.getTitleAt(n2);
        Font font = jTabbedPane.getFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        Icon icon = this.getIconForTab(jTabbedPane, n2);
        this.layoutLabel(n, fontMetrics, string, icon, rectangle3, rectangle, rectangle2, bl);
        this.paintText(graphics, jTabbedPane, n, font, fontMetrics, n2, string, rectangle2, bl);
        this.paintIcon(graphics, jTabbedPane, n, n2, icon, rectangle, bl);
        this.paintFocusIndicator(graphics, jTabbedPane, n, rectangleArray, n2, rectangle, rectangle2, bl);
    }

    protected void layoutLabel(int n, FontMetrics fontMetrics, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl) {
        rectangle2.y = 0;
        rectangle2.x = 0;
        rectangle3.y = 0;
        rectangle3.x = 0;
        SwingUtilities.layoutCompoundLabel(fontMetrics, string, icon, 0, 0, 0, 4, rectangle, rectangle2, rectangle3, iconSpacingWidth);
    }

    protected void paintIcon(Graphics graphics, JTabbedPane jTabbedPane, int n, int n2, Icon icon, Rectangle rectangle, boolean bl) {
        if (icon != null) {
            icon.paintIcon(jTabbedPane, graphics, rectangle.x + this.xNudge, rectangle.y + this.yNudge);
        }
    }

    protected void paintText(Graphics graphics, JTabbedPane jTabbedPane, int n, Font font, FontMetrics fontMetrics, int n2, String string, Rectangle rectangle, boolean bl) {
        graphics.setFont(font);
        if (jTabbedPane.isEnabledAt(n2)) {
            graphics.setColor(jTabbedPane.getForegroundAt(n2));
            graphics.drawString(string, rectangle.x + this.xNudge, rectangle.y + fontMetrics.getAscent() + this.yNudge);
            return;
        }
        graphics.setColor(jTabbedPane.getBackgroundAt(n2).brighter());
        graphics.drawString(string, rectangle.x + this.xNudge, rectangle.y + fontMetrics.getAscent() + this.yNudge);
        graphics.setColor(jTabbedPane.getBackgroundAt(n2).darker());
        graphics.drawString(string, rectangle.x + this.xNudge - 1, rectangle.y + fontMetrics.getAscent() + this.yNudge - 1);
    }

    protected int calculateXNudge(JTabbedPane jTabbedPane, int n, int n2, boolean bl) {
        Rectangle rectangle = this.rects[n2];
        int n3 = 0;
        switch (n) {
            case 2: {
                n3 = bl ? -1 : 1;
                break;
            }
            case 4: {
                n3 = bl ? 1 : -1;
                break;
            }
            default: {
                n3 = rectangle.width % 2;
            }
        }
        return n3;
    }

    protected int calculateYNudge(JTabbedPane jTabbedPane, int n, int n2, boolean bl) {
        Rectangle rectangle = this.rects[n2];
        int n3 = 0;
        switch (n) {
            case 3: {
                n3 = bl ? 1 : -1;
                break;
            }
            case 2: 
            case 4: {
                n3 = rectangle.height % 2;
                break;
            }
            default: {
                n3 = bl ? -1 : 1;
            }
        }
        return n3;
    }

    protected void paintFocusIndicator(Graphics graphics, JTabbedPane jTabbedPane, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        Rectangle rectangle3 = rectangleArray[n2];
        if (jTabbedPane.hasFocus() && bl) {
            int n3;
            int n4;
            int n5;
            int n6;
            graphics.setColor(this.focus);
            switch (n) {
                case 2: {
                    n6 = rectangle3.x + 3;
                    n5 = rectangle3.y + 3;
                    n4 = rectangle3.width - 5;
                    n3 = rectangle3.height - 6;
                    break;
                }
                case 4: {
                    n6 = rectangle3.x + 2;
                    n5 = rectangle3.y + 3;
                    n4 = rectangle3.width - 5;
                    n3 = rectangle3.height - 6;
                    break;
                }
                case 3: {
                    n6 = rectangle3.x + 3;
                    n5 = rectangle3.y + 2;
                    n4 = rectangle3.width - 6;
                    n3 = rectangle3.height - 5;
                    break;
                }
                default: {
                    n6 = rectangle3.x + 3;
                    n5 = rectangle3.y + 3;
                    n4 = rectangle3.width - 6;
                    n3 = rectangle3.height - 5;
                }
            }
            BasicGraphicsUtils.drawDashedRect(graphics, n6, n5, n4, n3);
        }
    }

    Rectangle getFocusedTabBounds(JTabbedPane jTabbedPane) {
        if (this.rects.length != jTabbedPane.getTabCount()) {
            this.calculateLayoutInfo(jTabbedPane);
        }
        return this.rects[jTabbedPane.getSelectedIndex()];
    }

    protected void paintTabBorder(Graphics graphics, JTabbedPane jTabbedPane, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        graphics.setColor(this.tabHighlight);
        switch (n) {
            case 2: {
                graphics.drawLine(n3 + 1, n4 + n6 - 2, n3 + 1, n4 + n6 - 2);
                graphics.drawLine(n3, n4 + 2, n3, n4 + n6 - 3);
                graphics.drawLine(n3 + 1, n4 + 1, n3 + 1, n4 + 1);
                graphics.drawLine(n3 + 2, n4, n3 + n5 - 1, n4);
                graphics.setColor(this.tabShadow);
                graphics.drawLine(n3 + 2, n4 + n6 - 2, n3 + n5 - 1, n4 + n6 - 2);
                graphics.setColor(this.tabDarkShadow);
                graphics.drawLine(n3 + 2, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
                return;
            }
            case 4: {
                graphics.drawLine(n3, n4, n3 + n5 - 3, n4);
                graphics.setColor(this.tabShadow);
                graphics.drawLine(n3, n4 + n6 - 2, n3 + n5 - 3, n4 + n6 - 2);
                graphics.drawLine(n3 + n5 - 2, n4 + 2, n3 + n5 - 2, n4 + n6 - 3);
                graphics.setColor(this.tabDarkShadow);
                graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 2, n4 + 1);
                graphics.drawLine(n3 + n5 - 2, n4 + n6 - 2, n3 + n5 - 2, n4 + n6 - 2);
                graphics.drawLine(n3 + n5 - 1, n4 + 2, n3 + n5 - 1, n4 + n6 - 3);
                graphics.drawLine(n3, n4 + n6 - 1, n3 + n5 - 3, n4 + n6 - 1);
                return;
            }
            case 3: {
                graphics.drawLine(n3, n4, n3, n4 + n6 - 3);
                graphics.drawLine(n3 + 1, n4 + n6 - 2, n3 + 1, n4 + n6 - 2);
                graphics.setColor(this.tabShadow);
                graphics.drawLine(n3 + 2, n4 + n6 - 2, n3 + n5 - 3, n4 + n6 - 2);
                graphics.drawLine(n3 + n5 - 2, n4, n3 + n5 - 2, n4 + n6 - 3);
                graphics.setColor(this.tabDarkShadow);
                graphics.drawLine(n3 + 2, n4 + n6 - 1, n3 + n5 - 3, n4 + n6 - 1);
                graphics.drawLine(n3 + n5 - 2, n4 + n6 - 2, n3 + n5 - 2, n4 + n6 - 2);
                graphics.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, n4 + n6 - 3);
                return;
            }
        }
        graphics.drawLine(n3, n4 + 2, n3, n4 + n6 - 1);
        graphics.drawLine(n3 + 1, n4 + 1, n3 + 1, n4 + 1);
        graphics.drawLine(n3 + 2, n4, n3 + n5 - 3, n4);
        graphics.setColor(this.tabShadow);
        graphics.drawLine(n3 + n5 - 2, n4 + 2, n3 + n5 - 2, n4 + n6 - 1);
        graphics.setColor(this.tabDarkShadow);
        graphics.drawLine(n3 + n5 - 1, n4 + 2, n3 + n5 - 1, n4 + n6 - 1);
        graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 2, n4 + 1);
    }

    protected void paintTabBackground(Graphics graphics, JTabbedPane jTabbedPane, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        graphics.setColor(jTabbedPane.getBackgroundAt(n2));
        switch (n) {
            case 2: {
                graphics.fillRect(n3 + 1, n4 + 1, n5 - 2, n6 - 3);
                return;
            }
            case 4: {
                graphics.fillRect(n3, n4 + 1, n5 - 2, n6 - 3);
                return;
            }
            case 3: {
                graphics.fillRect(n3 + 1, n4, n5 - 3, n6 - 1);
                return;
            }
        }
        graphics.fillRect(n3 + 1, n4 + 1, n5 - 3, n6 - 1);
    }

    protected void paintContentBorder(Graphics graphics, JTabbedPane jTabbedPane, int n, int n2) {
        Rectangle rectangle = jTabbedPane.getBounds();
        Insets insets = jTabbedPane.getInsets();
        int n3 = rectangle.height - (insets.top + insets.bottom);
        int n4 = rectangle.width - (insets.left + insets.right);
        int n5 = 0;
        int n6 = 0;
        int n7 = n4;
        int n8 = n3;
        switch (n) {
            case 2: {
                n5 = this.totalTabWidth(jTabbedPane, n, this.runCount);
                n7 -= n5;
                break;
            }
            case 4: {
                n7 -= this.totalTabWidth(jTabbedPane, n, this.runCount);
                break;
            }
            case 3: {
                n8 -= this.totalTabHeight(jTabbedPane, n, this.runCount);
                break;
            }
            default: {
                n6 = this.totalTabHeight(jTabbedPane, n, this.runCount);
                n8 -= n6;
            }
        }
        this.paintContentBorderTopEdge(graphics, n, n2, n5, n6, n7, n8);
        this.paintContentBorderLeftEdge(graphics, n, n2, n5, n6, n7, n8);
        this.paintContentBorderBottomEdge(graphics, n, n2, n5, n6, n7, n8);
        this.paintContentBorderRightEdge(graphics, n, n2, n5, n6, n7, n8);
    }

    protected void paintContentBorderTopEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(this.tabHighlight);
        if (n != 1 || n2 < 0 || this.rects[n2].y + this.rects[n2].height + 1 < n4) {
            graphics.drawLine(n3, n4, n3 + n5 - 2, n4);
            return;
        }
        Rectangle rectangle = this.rects[n2];
        graphics.drawLine(n3, n4, rectangle.x - 1, n4);
        if (rectangle.x + rectangle.width < n3 + n5 - 2) {
            graphics.drawLine(rectangle.x + rectangle.width, n4, n3 + n5 - 2, n4);
            return;
        }
        graphics.setColor(this.tabShadow);
        graphics.drawLine(n3 + n5 - 2, n4, n3 + n5 - 2, n4);
    }

    protected void paintContentBorderLeftEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(this.tabHighlight);
        if (n != 2 || n2 < 0 || this.rects[n2].x + this.rects[n2].width + 1 < n3) {
            graphics.drawLine(n3, n4, n3, n4 + n6 - 2);
            return;
        }
        Rectangle rectangle = this.rects[n2];
        graphics.drawLine(n3, n4, n3, rectangle.y - 1);
        if (rectangle.y + rectangle.height < n4 + n6 - 2) {
            graphics.drawLine(n3, rectangle.y + rectangle.height, n3, n4 + n6 - 2);
        }
    }

    protected void paintContentBorderBottomEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(this.tabShadow);
        if (n != 3 || n2 < 0 || this.rects[n2].y - 1 > n6) {
            graphics.drawLine(n3 + 1, n4 + n6 - 2, n3 + n5 - 2, n4 + n6 - 2);
            graphics.setColor(this.tabDarkShadow);
            graphics.drawLine(n3, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
            return;
        }
        Rectangle rectangle = this.rects[n2];
        graphics.drawLine(n3 + 1, n4 + n6 - 2, rectangle.x - 1, n4 + n6 - 2);
        graphics.setColor(this.tabDarkShadow);
        graphics.drawLine(n3, n4 + n6 - 1, rectangle.x - 1, n4 + n6 - 1);
        if (rectangle.x + rectangle.width < n3 + n5 - 2) {
            graphics.setColor(this.tabShadow);
            graphics.drawLine(rectangle.x + rectangle.width, n4 + n6 - 2, n3 + n5 - 2, n4 + n6 - 2);
            graphics.setColor(this.tabDarkShadow);
            graphics.drawLine(rectangle.x + rectangle.width, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
        }
    }

    protected void paintContentBorderRightEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(this.tabShadow);
        if (n != 4 || n2 < 0 || this.rects[n2].x - 1 > n5) {
            graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 2, n4 + n6 - 3);
            graphics.setColor(this.tabDarkShadow);
            graphics.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, n4 + n6 - 1);
            return;
        }
        Rectangle rectangle = this.rects[n2];
        graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 2, rectangle.y - 1);
        graphics.setColor(this.tabDarkShadow);
        graphics.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, rectangle.y - 1);
        if (rectangle.y + rectangle.height < n4 + n6 - 2) {
            graphics.setColor(this.tabShadow);
            graphics.drawLine(n3 + n5 - 2, rectangle.y + rectangle.height, n3 + n5 - 2, n4 + n6 - 2);
            graphics.setColor(this.tabDarkShadow);
            graphics.drawLine(n3 + n5 - 1, rectangle.y + rectangle.height, n3 + n5 - 1, n4 + n6 - 2);
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        JTabbedPane jTabbedPane = (JTabbedPane)jComponent;
        return this.calculateSize(jTabbedPane, jTabbedPane.getTabPlacement(), false);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        JTabbedPane jTabbedPane = (JTabbedPane)jComponent;
        return this.calculateSize(jTabbedPane, jTabbedPane.getTabPlacement(), true);
    }

    protected Dimension calculateSize(JTabbedPane jTabbedPane, int n, boolean bl) {
        Insets insets = jTabbedPane.getInsets();
        Insets insets2 = this.getContentBorderInsets(jTabbedPane, n);
        Dimension dimension = new Dimension(0, 0);
        int n2 = insets2.top + insets2.bottom;
        int n3 = insets2.left + insets2.right;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < jTabbedPane.getTabCount()) {
            Component component = jTabbedPane.getComponentAt(n6);
            Dimension dimension2 = dimension;
            if (component instanceof JComponent) {
                if (component.getFont() == null) {
                    component.setFont(jTabbedPane.getFont());
                }
                Dimension dimension3 = dimension2 = bl ? component.getMinimumSize() : component.getPreferredSize();
                if (dimension2 != null) {
                    n5 = Math.max(dimension2.height, n5);
                    n4 = Math.max(dimension2.width, n4);
                }
            }
            ++n6;
        }
        n3 += n4;
        n2 += n5;
        int n7 = 0;
        switch (n) {
            case 2: 
            case 4: {
                n7 = this.preferredTotalTabWidth(jTabbedPane, n, this.getMetrics(jTabbedPane), n2);
                n3 += n7;
                break;
            }
            default: {
                n7 = this.preferredTotalTabHeight(jTabbedPane, n, this.getMetrics(jTabbedPane), n3);
                n2 += n7;
            }
        }
        return new Dimension(n3 + insets.left + insets.right, n2 + insets.bottom + insets.top);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        return new Dimension(container.getBounds().width, container.getBounds().height);
    }

    public Dimension minimumLayoutSize(Container container) {
        return new Dimension(0, 0);
    }

    public void layoutContainer(Container container) {
        JTabbedPane jTabbedPane = (JTabbedPane)container;
        this.layoutTabbedPane(jTabbedPane, jTabbedPane.getTabPlacement());
    }

    protected void layoutTabbedPane(JTabbedPane jTabbedPane, int n) {
        Insets insets = jTabbedPane.getInsets();
        Insets insets2 = this.getContentBorderInsets(jTabbedPane, n);
        int n2 = jTabbedPane.getSelectedIndex();
        if (n2 < 0) {
            if (this.visibleComponent != null) {
                this.setVisibleComponent(jTabbedPane, null);
                return;
            }
        } else {
            int n3 = 0;
            int n4 = 0;
            Component component = jTabbedPane.getComponentAt(n2);
            boolean bl = false;
            if (component != null) {
                int n5;
                int n6;
                if (component.getParent() == null && this.visibleComponent != null && SwingUtilities.findFocusOwner(this.visibleComponent) != null) {
                    bl = true;
                }
                this.calculateLayoutInfo(jTabbedPane);
                Rectangle rectangle = jTabbedPane.getBounds();
                this.setVisibleComponent(jTabbedPane, component);
                switch (n) {
                    case 2: {
                        n3 = this.totalTabWidth(jTabbedPane, n, this.runCount);
                        n6 = insets.left + n3 + insets2.left;
                        n5 = insets.top + insets2.top;
                        break;
                    }
                    case 4: {
                        n3 = this.totalTabWidth(jTabbedPane, n, this.runCount);
                        n6 = insets.left + insets2.left;
                        n5 = insets.top + insets2.top;
                        break;
                    }
                    case 3: {
                        n4 = this.totalTabHeight(jTabbedPane, n, this.runCount);
                        n6 = insets.left + insets2.left;
                        n5 = insets.top + insets2.top;
                        break;
                    }
                    default: {
                        n4 = this.totalTabHeight(jTabbedPane, n, this.runCount);
                        n6 = insets.left + insets2.left;
                        n5 = insets.top + n4 + insets2.top;
                    }
                }
                int n7 = rectangle.width - n3 - insets.left - insets.right - insets2.left - insets2.right;
                int n8 = rectangle.height - n4 - insets.top - insets.bottom - insets2.top - insets2.bottom;
                component.setBounds(n6, n5, n7, n8);
                component.validate();
                if (bl) {
                    if (component.isFocusTraversable()) {
                        component.requestFocus();
                        bl = false;
                    } else if (component instanceof JComponent && ((JComponent)component).requestDefaultFocus()) {
                        bl = false;
                    }
                    if (bl) {
                        jTabbedPane.requestFocus();
                    }
                }
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
        jTabbedPane.doLayout();
        jTabbedPane.repaint();
    }

    protected Component getVisibleComponent(JTabbedPane jTabbedPane) {
        int n = jTabbedPane.getTabCount();
        while (n-- > 0) {
            Component component = jTabbedPane.getComponentAt(n);
            if (component == null || component.getParent() != jTabbedPane) continue;
            return component;
        }
        return null;
    }

    protected void setVisibleComponent(JTabbedPane jTabbedPane, Component component) {
        if (this.visibleComponent == component) {
            return;
        }
        if (this.visibleComponent != null) {
            jTabbedPane.remove(this.visibleComponent);
        }
        if (component != null) {
            jTabbedPane.add(component);
        }
        this.visibleComponent = component;
    }

    protected void calculateLayoutInfo(JTabbedPane jTabbedPane) {
        this.calculateLayoutInfo(jTabbedPane, jTabbedPane.getTabPlacement());
    }

    protected void calculateLayoutInfo(JTabbedPane jTabbedPane, int n) {
        Font font = jTabbedPane.getFont();
        int n2 = jTabbedPane.getTabCount();
        int n3 = jTabbedPane.getSelectedIndex();
        this.assureRectsCreated(n2);
        this.arrangeTabs(jTabbedPane, n, n2, font);
        this.padSelectedTab(jTabbedPane, n, n3);
    }

    protected void assureRectsCreated(int n) {
        int n2 = this.rects.length;
        if (n != n2) {
            Rectangle[] rectangleArray = new Rectangle[n];
            System.arraycopy(this.rects, 0, rectangleArray, 0, Math.min(n2, n));
            this.rects = rectangleArray;
            int n3 = n2;
            while (n3 < n) {
                this.rects[n3] = new Rectangle();
                ++n3;
            }
        }
    }

    protected void expandTabRunsArray() {
        int n = this.tabRuns.length;
        int[] nArray = new int[n + 10];
        System.arraycopy(this.tabRuns, 0, nArray, 0, this.runCount);
        this.tabRuns = nArray;
    }

    protected void arrangeTabs(JTabbedPane jTabbedPane, int n, int n2, Font font) {
        Rectangle rectangle;
        int n3;
        int n4;
        int n5;
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        Dimension dimension = jTabbedPane.getSize();
        Insets insets = jTabbedPane.getInsets();
        Insets insets2 = this.getTabAreaInsets(jTabbedPane, n);
        int n6 = fontMetrics.getHeight();
        int n7 = jTabbedPane.getSelectedIndex();
        boolean bl = n == 2 || n == 4;
        switch (n) {
            case 2: {
                this.maxTabWidth = this.maxTabWidth(jTabbedPane, fontMetrics);
                n5 = insets.left + insets2.left;
                n4 = insets.top + insets2.top;
                n3 = dimension.height - (insets.bottom + insets2.bottom);
                break;
            }
            case 4: {
                this.maxTabWidth = this.maxTabWidth(jTabbedPane, fontMetrics);
                n5 = dimension.width - insets.right - insets2.right - this.maxTabWidth;
                n4 = insets.top + insets2.top;
                n3 = dimension.height - (insets.bottom + insets2.bottom);
                break;
            }
            case 3: {
                this.maxTabHeight = this.maxTabHeight(jTabbedPane, fontMetrics);
                n5 = insets.left + insets2.left;
                n4 = dimension.height - insets.bottom - insets2.bottom - this.maxTabHeight;
                n3 = dimension.width - (insets.right + insets2.right);
                break;
            }
            default: {
                this.maxTabHeight = this.maxTabHeight(jTabbedPane, fontMetrics);
                n5 = insets.left + insets2.left;
                n4 = insets.top + insets2.top;
                n3 = dimension.width - (insets.right + insets2.right);
            }
        }
        int n8 = this.getTabOverlay(jTabbedPane, n);
        this.runCount = 0;
        this.selectedRun = -1;
        int n9 = 0;
        while (n9 < n2) {
            rectangle = this.rects[n9];
            if (!bl) {
                if (n9 > 0) {
                    rectangle.x = this.rects[n9 - 1].x + this.rects[n9 - 1].width;
                } else {
                    this.tabRuns[0] = 0;
                    this.runCount = 1;
                    this.maxTabWidth = 0;
                    rectangle.x = n5;
                }
                rectangle.width = this.tabWidth(jTabbedPane, n9, fontMetrics);
                this.maxTabWidth = Math.max(this.maxTabWidth, rectangle.width);
                if (rectangle.x != 2 + insets.left && rectangle.x + rectangle.width > n3) {
                    if (this.runCount > this.tabRuns.length - 1) {
                        this.expandTabRunsArray();
                    }
                    this.tabRuns[this.runCount] = n9;
                    ++this.runCount;
                    rectangle.x = n5;
                }
                rectangle.y = n4;
                rectangle.height = this.maxTabHeight;
            } else {
                if (n9 > 0) {
                    rectangle.y = this.rects[n9 - 1].y + this.rects[n9 - 1].height;
                } else {
                    this.tabRuns[0] = 0;
                    this.runCount = 1;
                    this.maxTabHeight = 0;
                    rectangle.y = n4;
                }
                rectangle.height = this.tabHeight(jTabbedPane, n9, n6);
                this.maxTabHeight = Math.max(this.maxTabHeight, rectangle.height);
                if (rectangle.y != 2 + insets.top && rectangle.y + rectangle.height > n3) {
                    if (this.runCount > this.tabRuns.length - 1) {
                        this.expandTabRunsArray();
                    }
                    this.tabRuns[this.runCount] = n9;
                    ++this.runCount;
                    rectangle.y = n4;
                }
                rectangle.x = n5;
                rectangle.width = this.maxTabWidth;
            }
            if (n9 == n7) {
                this.selectedRun = this.runCount - 1;
            }
            ++n9;
        }
        if (this.runCount > 1) {
            this.normalizeTabRuns(jTabbedPane, n, n2, bl ? n4 : n5, n3);
            this.selectedRun = this.getRunForTab(jTabbedPane, n2, n7);
            this.rotateTabRuns(jTabbedPane, n, this.selectedRun);
        }
        n9 = this.runCount - 1;
        while (n9 >= 0) {
            int n10;
            int n11;
            int n12 = this.tabRuns[n9];
            int n13 = this.tabRuns[n9 == this.runCount - 1 ? 0 : n9 + 1];
            int n14 = n11 = n13 != 0 ? n13 - 1 : n2 - 1;
            if (!bl) {
                n10 = n12;
                while (n10 <= n11) {
                    rectangle = this.rects[n10];
                    rectangle.y = n4;
                    rectangle.x += this.getRunIndent(jTabbedPane, n, n9);
                    ++n10;
                }
                if (this.shouldPadRun(jTabbedPane, n, n9)) {
                    this.padRun(jTabbedPane, n, n12, n11, n3);
                }
                n4 = n == 3 ? (n4 -= this.maxTabHeight - n8) : (n4 += this.maxTabHeight - n8);
            } else {
                n10 = n12;
                while (n10 <= n11) {
                    rectangle = this.rects[n10];
                    rectangle.x = n5;
                    rectangle.y += this.getRunIndent(jTabbedPane, n, n9);
                    ++n10;
                }
                if (this.shouldPadRun(jTabbedPane, n, n9)) {
                    this.padRun(jTabbedPane, n, n12, n11, n3);
                }
                n5 = n == 4 ? (n5 -= this.maxTabWidth - n8) : (n5 += this.maxTabWidth - n8);
            }
            --n9;
        }
    }

    protected int getTabOverlay(JTabbedPane jTabbedPane, int n) {
        return this.overlay;
    }

    protected int getRunForTab(JTabbedPane jTabbedPane, int n, int n2) {
        int n3 = 0;
        while (n3 < this.runCount) {
            int n4 = this.tabRuns[n3];
            int n5 = this.lastIndexInRun(n3, n);
            if (n2 >= n4 && n2 <= n5) {
                return n3;
            }
            ++n3;
        }
        return 0;
    }

    protected void rotateTabRuns(JTabbedPane jTabbedPane, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.tabRuns[0];
            int n5 = 1;
            while (n5 < this.runCount) {
                this.tabRuns[n5 - 1] = this.tabRuns[n5];
                ++n5;
            }
            this.tabRuns[this.runCount - 1] = n4;
            ++n3;
        }
    }

    protected int getRunIndent(JTabbedPane jTabbedPane, int n, int n2) {
        return 0;
    }

    protected void normalizeTabRuns(JTabbedPane jTabbedPane, int n, int n2, int n3, int n4) {
        boolean bl = n == 2 || n == 4;
        int n5 = this.runCount - 1;
        boolean bl2 = true;
        double d = 1.25;
        while (bl2) {
            int n6;
            int n7;
            int n8 = this.lastIndexInRun(n5, n2);
            int n9 = this.lastIndexInRun(n5 - 1, n2);
            if (!bl) {
                n7 = this.rects[n8].x + this.rects[n8].width;
                n6 = (int)((double)this.maxTabWidth * d);
            } else {
                n7 = this.rects[n8].y + this.rects[n8].height;
                n6 = (int)((double)this.maxTabHeight * d * 2.0);
            }
            if (n4 - n7 > n6) {
                this.tabRuns[n5] = n9;
                if (!bl) {
                    this.rects[n9].x = n3;
                } else {
                    this.rects[n9].y = n3;
                }
                int n10 = n9 + 1;
                while (n10 <= n8) {
                    if (!bl) {
                        this.rects[n10].x = this.rects[n10 - 1].x + this.rects[n10 - 1].width;
                    } else {
                        this.rects[n10].y = this.rects[n10 - 1].y + this.rects[n10 - 1].height;
                    }
                    ++n10;
                }
            } else if (n5 == this.runCount - 1) {
                bl2 = false;
            }
            if (n5 - 1 > 0) {
                --n5;
                continue;
            }
            n5 = this.runCount - 1;
            d += 0.25;
        }
    }

    protected int lastIndexInRun(int n, int n2) {
        int n3;
        if (this.runCount == 1) {
            return n2 - 1;
        }
        int n4 = n3 = n == this.runCount - 1 ? 0 : n + 1;
        if (this.tabRuns[n3] == 0) {
            return n2 - 1;
        }
        return this.tabRuns[n3] - 1;
    }

    protected boolean shouldPadRun(JTabbedPane jTabbedPane, int n, int n2) {
        return this.runCount > 1;
    }

    protected void padRun(JTabbedPane jTabbedPane, int n, int n2, int n3, int n4) {
        Rectangle rectangle = this.rects[n3];
        if (n == 1 || n == 3) {
            int n5 = rectangle.x + rectangle.width - this.rects[n2].x;
            int n6 = n4 - (rectangle.x + rectangle.width);
            float f = (float)n6 / (float)n5;
            int n7 = n2;
            while (n7 <= n3) {
                Rectangle rectangle2 = this.rects[n7];
                if (n7 > n2) {
                    rectangle2.x = this.rects[n7 - 1].x + this.rects[n7 - 1].width;
                }
                rectangle2.width += Math.round((float)rectangle2.width * f);
                ++n7;
            }
            rectangle.width = n4 - rectangle.x;
            return;
        }
        int n8 = rectangle.y + rectangle.height - this.rects[n2].y;
        int n9 = n4 - (rectangle.y + rectangle.height);
        float f = (float)n9 / (float)n8;
        int n10 = n2;
        while (n10 <= n3) {
            Rectangle rectangle3 = this.rects[n10];
            if (n10 > n2) {
                rectangle3.y = this.rects[n10 - 1].y + this.rects[n10 - 1].height;
            }
            rectangle3.height += Math.round((float)rectangle3.height * f);
            ++n10;
        }
        rectangle.height = n4 - rectangle.y;
    }

    protected void padSelectedTab(JTabbedPane jTabbedPane, int n, int n2) {
        if (n2 >= 0) {
            Rectangle rectangle = this.rects[n2];
            switch (n) {
                case 2: {
                    rectangle.x -= selectedTabRaisePad - 1;
                    rectangle.width += selectedTabRaisePad;
                    rectangle.y -= selectedTabWidenPad / 2;
                    rectangle.height += selectedTabWidenPad;
                    return;
                }
                case 4: {
                    --rectangle.x;
                    rectangle.width += selectedTabRaisePad;
                    rectangle.y -= selectedTabWidenPad / 2;
                    rectangle.height += selectedTabWidenPad;
                    return;
                }
                case 3: {
                    --rectangle.y;
                    rectangle.height += selectedTabRaisePad;
                    rectangle.x -= selectedTabWidenPad / 2;
                    rectangle.width += selectedTabWidenPad;
                    return;
                }
            }
            rectangle.y -= selectedTabRaisePad - 1;
            rectangle.height += selectedTabRaisePad;
            rectangle.x -= selectedTabWidenPad / 2;
            rectangle.width += selectedTabWidenPad;
        }
    }

    protected int tabHeight(JTabbedPane jTabbedPane, int n, int n2) {
        int n3 = n2;
        Icon icon = this.getIconForTab(jTabbedPane, n);
        if (icon != null) {
            n3 = Math.max(n3, icon.getIconHeight());
        }
        return n3 += 2 * spacingHeight + 2;
    }

    protected int maxTabHeight(JTabbedPane jTabbedPane) {
        return this.maxTabHeight(jTabbedPane, this.getMetrics(jTabbedPane));
    }

    protected int maxTabHeight(JTabbedPane jTabbedPane, FontMetrics fontMetrics) {
        int n = jTabbedPane.getTabCount();
        int n2 = 0;
        int n3 = fontMetrics.getHeight();
        int n4 = 0;
        while (n4 < n) {
            n2 = Math.max(this.tabHeight(jTabbedPane, n4, n3), n2);
            ++n4;
        }
        return n2;
    }

    protected int tabWidth(JTabbedPane jTabbedPane, int n, FontMetrics fontMetrics) {
        String string = jTabbedPane.getTitleAt(n);
        Icon icon = this.getIconForTab(jTabbedPane, n);
        int n2 = 2 * spacingWidth + 3;
        if (icon != null) {
            n2 += icon.getIconWidth() + iconSpacingWidth;
        }
        return n2 += fontMetrics.stringWidth(string);
    }

    protected int maxTabWidth(JTabbedPane jTabbedPane) {
        return this.maxTabWidth(jTabbedPane, this.getMetrics(jTabbedPane));
    }

    protected int maxTabWidth(JTabbedPane jTabbedPane, FontMetrics fontMetrics) {
        int n = jTabbedPane.getTabCount();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 = Math.max(this.tabWidth(jTabbedPane, n3, fontMetrics), n2);
            ++n3;
        }
        return n2;
    }

    protected Icon getIconForTab(JTabbedPane jTabbedPane, int n) {
        if (!jTabbedPane.isEnabledAt(n) && jTabbedPane.getDisabledIconAt(n) != null) {
            return jTabbedPane.getDisabledIconAt(n);
        }
        return jTabbedPane.getIconAt(n);
    }

    protected Insets getContentBorderInsets(JTabbedPane jTabbedPane, int n) {
        return contentBorderInsets;
    }

    protected Insets getTabAreaInsets(JTabbedPane jTabbedPane, int n) {
        Insets insets;
        switch (n) {
            case 2: {
                insets = tabsOnLeftTabInsets;
                break;
            }
            case 3: {
                insets = tabsOnBottomTabInsets;
                break;
            }
            case 4: {
                insets = tabsOnRightTabInsets;
                break;
            }
            default: {
                insets = tabsOnTopTabInsets;
            }
        }
        return insets;
    }

    protected FontMetrics getMetrics(JTabbedPane jTabbedPane) {
        Font font = jTabbedPane.getFont();
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public Rectangle getTabBounds(JTabbedPane jTabbedPane, int n) {
        this.calculateLayoutInfo(jTabbedPane);
        return this.rects[n];
    }

    public int getTabRunCount(JTabbedPane jTabbedPane) {
        return this.runCount;
    }

    protected int totalTabHeight(JTabbedPane jTabbedPane, int n, int n2) {
        Insets insets = this.getTabAreaInsets(jTabbedPane, n);
        int n3 = this.getTabOverlay(jTabbedPane, n);
        return n2 * (this.maxTabHeight - n3) + n3 + insets.top + insets.bottom;
    }

    protected int totalTabWidth(JTabbedPane jTabbedPane, int n, int n2) {
        Insets insets = this.getTabAreaInsets(jTabbedPane, n);
        int n3 = this.getTabOverlay(jTabbedPane, n);
        return n2 * (this.maxTabWidth - n3) + n3 + insets.left + insets.right;
    }

    protected int preferredTotalTabHeight(JTabbedPane jTabbedPane, int n, FontMetrics fontMetrics, int n2) {
        int n3 = jTabbedPane.getTabCount();
        int n4 = 0;
        if (n3 > 0) {
            int n5 = 1;
            int n6 = 0;
            this.maxTabHeight = this.maxTabHeight(jTabbedPane, fontMetrics);
            int n7 = 0;
            while (n7 < n3) {
                int n8 = this.tabWidth(jTabbedPane, n7, fontMetrics);
                if (n6 != 0 && n6 + n8 > n2) {
                    ++n5;
                    n6 = 0;
                }
                ++n7;
            }
            n4 = this.totalTabHeight(jTabbedPane, n, n5);
        }
        return n4;
    }

    protected int preferredTotalTabWidth(JTabbedPane jTabbedPane, int n, FontMetrics fontMetrics, int n2) {
        int n3 = jTabbedPane.getTabCount();
        int n4 = 0;
        if (n3 > 0) {
            int n5 = 1;
            int n6 = 0;
            int n7 = fontMetrics.getHeight();
            this.maxTabWidth = this.maxTabWidth(jTabbedPane, fontMetrics);
            int n8 = 0;
            while (n8 < n3) {
                int n9 = this.tabHeight(jTabbedPane, n8, n7);
                if (n6 != 0 && n6 + n9 > n2) {
                    ++n5;
                    n6 = 0;
                }
                ++n8;
            }
            n4 = this.totalTabWidth(jTabbedPane, n, n5);
        }
        return n4;
    }

    protected void navigateSelectedTab(JTabbedPane jTabbedPane, int n, int n2) {
        int n3 = jTabbedPane.getSelectedIndex();
        int n4 = jTabbedPane.getTabCount();
        switch (n) {
            case 2: 
            case 4: {
                switch (n2) {
                    case 1: {
                        this.selectPrevTab(jTabbedPane, n3);
                        return;
                    }
                    case 5: {
                        this.selectNextTab(jTabbedPane, n3);
                        return;
                    }
                    case 7: {
                        int n5 = this.getTabRunOffset(jTabbedPane, n, n4, n3, false);
                        this.selectAdjacentRunTab(jTabbedPane, n, n3, n5);
                        return;
                    }
                    case 3: {
                        int n6 = this.getTabRunOffset(jTabbedPane, n, n4, n3, true);
                        this.selectAdjacentRunTab(jTabbedPane, n, n3, n6);
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
        }
        switch (n2) {
            case 1: {
                int n7 = this.getTabRunOffset(jTabbedPane, n, n4, n3, false);
                this.selectAdjacentRunTab(jTabbedPane, n, n3, n7);
                return;
            }
            case 5: {
                int n8 = this.getTabRunOffset(jTabbedPane, n, n4, n3, true);
                this.selectAdjacentRunTab(jTabbedPane, n, n3, n8);
                return;
            }
            case 3: {
                this.selectNextTab(jTabbedPane, n3);
                return;
            }
            case 7: {
                this.selectPrevTab(jTabbedPane, n3);
                return;
            }
        }
    }

    public int getPrevTabIndex(JTabbedPane jTabbedPane, int n) {
        int n2 = n - 1;
        if (n2 < 0) {
            n2 = jTabbedPane.getTabCount() - 1;
        }
        return n2;
    }

    public int getNextTabIndex(JTabbedPane jTabbedPane, int n) {
        return (n + 1) % jTabbedPane.getTabCount();
    }

    public void selectNextTab(JTabbedPane jTabbedPane, int n) {
        int n2 = this.getNextTabIndex(jTabbedPane, n);
        while (!jTabbedPane.isEnabledAt(n2) && n2 != n) {
            n2 = this.getNextTabIndex(jTabbedPane, n2);
        }
        jTabbedPane.setSelectedIndex(n2);
    }

    public void selectPrevTab(JTabbedPane jTabbedPane, int n) {
        int n2 = this.getPrevTabIndex(jTabbedPane, n);
        while (!jTabbedPane.isEnabledAt(n2) && n2 != n) {
            n2 = this.getPrevTabIndex(jTabbedPane, n2);
        }
        jTabbedPane.setSelectedIndex(n2);
    }

    protected void selectAdjacentRunTab(JTabbedPane jTabbedPane, int n, int n2, int n3) {
        int n4;
        if (this.runCount < 2) {
            return;
        }
        Rectangle rectangle = this.rects[n2];
        switch (n) {
            case 2: 
            case 4: {
                n4 = this.tabForCoordinate(jTabbedPane, rectangle.x + rectangle.width / 2 + n3, rectangle.y + rectangle.height / 2);
                break;
            }
            default: {
                n4 = this.tabForCoordinate(jTabbedPane, rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2 + n3);
            }
        }
        if (n4 != -1) {
            while (!jTabbedPane.isEnabledAt(n4) && n4 != n2) {
                n4 = this.getNextTabIndex(jTabbedPane, n4);
            }
            jTabbedPane.setSelectedIndex(n4);
        }
    }

    protected int getTabRunOffset(JTabbedPane jTabbedPane, int n, int n2, int n3, boolean bl) {
        int n4;
        int n5 = this.getRunForTab(jTabbedPane, n2, n3);
        switch (n) {
            case 2: {
                if (n5 == 0) {
                    n4 = bl ? -(this.totalTabWidth(jTabbedPane, n, this.runCount) - this.maxTabWidth(jTabbedPane)) : -this.maxTabWidth(jTabbedPane);
                    break;
                }
                if (n5 == this.runCount - 1) {
                    n4 = bl ? this.maxTabWidth(jTabbedPane) : this.totalTabWidth(jTabbedPane, n, this.runCount) - this.maxTabWidth(jTabbedPane);
                    break;
                }
                n4 = bl ? this.maxTabWidth(jTabbedPane) : -this.maxTabWidth(jTabbedPane);
                break;
            }
            case 4: {
                if (n5 == 0) {
                    n4 = bl ? this.maxTabWidth(jTabbedPane) : this.totalTabWidth(jTabbedPane, n, this.runCount) - this.maxTabWidth(jTabbedPane);
                    break;
                }
                if (n5 == this.runCount - 1) {
                    n4 = bl ? -(this.totalTabWidth(jTabbedPane, n, this.runCount) - this.maxTabWidth(jTabbedPane)) : -this.maxTabWidth(jTabbedPane);
                    break;
                }
                n4 = bl ? this.maxTabWidth(jTabbedPane) : -this.maxTabWidth(jTabbedPane);
                break;
            }
            case 3: {
                if (n5 == 0) {
                    n4 = bl ? this.maxTabHeight(jTabbedPane) : this.totalTabHeight(jTabbedPane, n, this.runCount) - this.maxTabHeight(jTabbedPane);
                    break;
                }
                if (n5 == this.runCount - 1) {
                    n4 = bl ? -(this.totalTabHeight(jTabbedPane, n, this.runCount) - this.maxTabHeight(jTabbedPane)) : -this.maxTabHeight(jTabbedPane);
                    break;
                }
                n4 = bl ? this.maxTabHeight(jTabbedPane) : -this.maxTabHeight(jTabbedPane);
                break;
            }
            default: {
                n4 = n5 == 0 ? (bl ? -(this.totalTabHeight(jTabbedPane, n, this.runCount) - this.maxTabHeight(jTabbedPane)) : -this.maxTabHeight(jTabbedPane)) : (n5 == this.runCount - 1 ? (bl ? this.maxTabHeight(jTabbedPane) : this.totalTabHeight(jTabbedPane, n, this.runCount) - this.maxTabHeight(jTabbedPane)) : (bl ? this.maxTabHeight(jTabbedPane) : -this.maxTabHeight(jTabbedPane)));
            }
        }
        return n4;
    }

    public int tabForCoordinate(JTabbedPane jTabbedPane, int n, int n2) {
        int n3 = jTabbedPane.getTabCount();
        if (n3 != this.rects.length) {
            this.calculateLayoutInfo(jTabbedPane);
        }
        int n4 = 0;
        while (n4 < n3) {
            if (this.rects[n4].contains(n, n2)) {
                return n4;
            }
            ++n4;
        }
        return -1;
    }

    private static final class 1
    extends AbstractAction {
        private final /* synthetic */ BasicTabbedPaneUI this$0;
        private final /* synthetic */ JTabbedPane val$pane;

        public void actionPerformed(ActionEvent actionEvent) {
            this.this$0.navigateSelectedTab(this.val$pane, this.val$pane.getTabPlacement(), 3);
        }

        public boolean isEnabled() {
            return true;
        }

        /* synthetic */ 1(JTabbedPane jTabbedPane, BasicTabbedPaneUI basicTabbedPaneUI) {
            this.val$pane = jTabbedPane;
            this.this$0 = basicTabbedPaneUI;
        }
    }

    private static final class 2
    extends AbstractAction {
        private final /* synthetic */ BasicTabbedPaneUI this$0;
        private final /* synthetic */ JTabbedPane val$pane;

        public void actionPerformed(ActionEvent actionEvent) {
            this.this$0.navigateSelectedTab(this.val$pane, this.val$pane.getTabPlacement(), 7);
        }

        public boolean isEnabled() {
            return true;
        }

        /* synthetic */ 2(JTabbedPane jTabbedPane, BasicTabbedPaneUI basicTabbedPaneUI) {
            this.val$pane = jTabbedPane;
            this.this$0 = basicTabbedPaneUI;
        }
    }

    private static final class 3
    extends AbstractAction {
        private final /* synthetic */ BasicTabbedPaneUI this$0;
        private final /* synthetic */ JTabbedPane val$pane;

        public void actionPerformed(ActionEvent actionEvent) {
            this.this$0.navigateSelectedTab(this.val$pane, this.val$pane.getTabPlacement(), 1);
        }

        public boolean isEnabled() {
            return true;
        }

        /* synthetic */ 3(JTabbedPane jTabbedPane, BasicTabbedPaneUI basicTabbedPaneUI) {
            this.val$pane = jTabbedPane;
            this.this$0 = basicTabbedPaneUI;
        }
    }

    private static final class 4
    extends AbstractAction {
        private final /* synthetic */ BasicTabbedPaneUI this$0;
        private final /* synthetic */ JTabbedPane val$pane;

        public void actionPerformed(ActionEvent actionEvent) {
            this.this$0.navigateSelectedTab(this.val$pane, this.val$pane.getTabPlacement(), 5);
        }

        public boolean isEnabled() {
            return true;
        }

        /* synthetic */ 4(JTabbedPane jTabbedPane, BasicTabbedPaneUI basicTabbedPaneUI) {
            this.val$pane = jTabbedPane;
            this.this$0 = basicTabbedPaneUI;
        }
    }

    class MouseGetter
    extends MouseAdapter
    implements Serializable {
        public void mousePressed(MouseEvent mouseEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)mouseEvent.getSource();
            int n = BasicTabbedPaneUI.this.tabForCoordinate(jTabbedPane, mouseEvent.getX(), mouseEvent.getY());
            if (n >= 0 && jTabbedPane.isEnabledAt(n)) {
                if (n == jTabbedPane.getSelectedIndex()) {
                    jTabbedPane.requestFocus();
                    jTabbedPane.repaint(BasicTabbedPaneUI.this.rects[n]);
                    return;
                }
                jTabbedPane.setSelectedIndex(n);
            }
        }

        MouseGetter() {
            BasicTabbedPaneUI.this = BasicTabbedPaneUI.this;
        }
    }

    class FocusGetter
    extends FocusAdapter
    implements Serializable {
        public void focusGained(FocusEvent focusEvent) {
            ((JTabbedPane)focusEvent.getSource()).repaint(BasicTabbedPaneUI.this.getFocusedTabBounds((JTabbedPane)focusEvent.getSource()));
        }

        public void focusLost(FocusEvent focusEvent) {
            ((JTabbedPane)focusEvent.getSource()).repaint(BasicTabbedPaneUI.this.getFocusedTabBounds((JTabbedPane)focusEvent.getSource()));
        }

        FocusGetter() {
            BasicTabbedPaneUI.this = BasicTabbedPaneUI.this;
        }
    }
}

