/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JToolBar;
import com.sun.java.swing.LookAndFeel;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.ToolBarUI;
import com.sun.java.swing.plaf.UIResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;

public class BasicToolBarUI
extends ToolBarUI
implements Serializable {
    protected JToolBar toolBar;
    private boolean floating;
    private boolean floatable;
    private int floatingX;
    private int floatingY;
    private JFrame floatingFrame;
    private DragWindow dragWindow;
    private Container dockingSource;
    private DockingListener dockingListener;
    private int dockingSensitivity;
    protected Color dockingColor;
    protected Color floatingColor;
    protected Color dockingBorderColor;
    protected Color floatingBorderColor;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicToolBarUI();
    }

    public void installUI(JComponent jComponent) {
        this.toolBar = (JToolBar)jComponent;
        this.installDefaults(jComponent);
        this.dockingSensitivity = 0;
        this.floatable = false;
        this.floating = false;
        this.floatingY = 0;
        this.floatingX = 0;
        this.floatingFrame = this.createFloatingFrame(this.toolBar);
        this.setOrientation(0);
        this.installListeners(jComponent);
        jComponent.setOpaque(true);
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults(jComponent);
        this.setFloating(false, null);
        this.floatingFrame = null;
        this.dragWindow = null;
        this.dockingSource = null;
        this.uninstallListeners(jComponent);
    }

    protected void installDefaults(JComponent jComponent) {
        LookAndFeel.installBorder(jComponent, "ToolBar.border");
        LookAndFeel.installColorsAndFont(jComponent, "ToolBar.background", "ToolBar.foreground", "ToolBar.font");
        if (this.dockingColor == null || this.dockingColor instanceof UIResource) {
            this.dockingColor = UIManager.getColor("ToolBar.dockingColor");
        }
        if (this.floatingColor == null || this.floatingColor instanceof UIResource) {
            this.floatingColor = UIManager.getColor("ToolBar.floatingColor");
        }
        if (this.dockingBorderColor == null || this.dockingBorderColor instanceof UIResource) {
            this.dockingBorderColor = UIManager.getColor("ToolBar.dockingBorderColor");
        }
        if (this.floatingBorderColor == null || this.floatingBorderColor instanceof UIResource) {
            this.floatingBorderColor = UIManager.getColor("ToolBar.floatingBorderColor");
        }
    }

    protected void uninstallDefaults(JComponent jComponent) {
        LookAndFeel.uninstallBorder(jComponent);
        this.dockingColor = null;
        this.floatingColor = null;
        this.dockingBorderColor = null;
        this.floatingBorderColor = null;
    }

    protected void installListeners(JComponent jComponent) {
        this.dockingListener = this.createDockingListener((JToolBar)jComponent);
        this.setFloatable(true);
    }

    protected void uninstallListeners(JComponent jComponent) {
        this.setFloatable(false);
        if (this.dockingListener != null) {
            this.dockingListener = null;
        }
    }

    protected JFrame createFloatingFrame(JToolBar jToolBar) {
        JFrame jFrame = new JFrame(jToolBar.getName());
        WindowListener windowListener = this.createFrameListener();
        jFrame.addWindowListener(windowListener);
        return jFrame;
    }

    protected DragWindow createDragWindow(JToolBar jToolBar) {
        Container container;
        Frame frame = null;
        if (this.toolBar != null) {
            container = this.toolBar.getParent();
            while (container != null && !(container instanceof Frame)) {
                container = container.getParent();
            }
            if (container != null && container instanceof Frame) {
                frame = (Frame)container;
            }
        }
        if (frame == null) {
            frame = this.floatingFrame = this.createFloatingFrame(this.toolBar);
        }
        container = new DragWindow(frame);
        return container;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public void setFloatingLocation(int n, int n2) {
        this.floatingX = n;
        this.floatingY = n2;
    }

    public boolean isFloating() {
        return this.floating;
    }

    public void setFloating(boolean bl, Point point) {
        if (this.toolBar.isFloatable()) {
            Object object;
            if (this.dragWindow != null) {
                ((Component)this.dragWindow).setVisible(false);
            }
            this.floating = bl;
            if (bl) {
                if (this.dockingSource == null) {
                    this.dockingSource = this.toolBar.getParent();
                    this.dockingSource.remove(this.toolBar);
                }
                if (this.floatingFrame == null) {
                    this.floatingFrame = this.createFloatingFrame(this.toolBar);
                }
                this.floatingFrame.getContentPane().add((Component)this.toolBar, "Center");
                this.setOrientation(0);
                this.floatingFrame.pack();
                ((Component)this.floatingFrame).setLocation(this.floatingX, this.floatingY);
                this.floatingFrame.show();
            } else {
                ((Component)this.floatingFrame).setVisible(false);
                this.floatingFrame.getContentPane().remove(this.toolBar);
                object = this.getDockingConstraint(this.dockingSource, point);
                int n = this.mapConstraintToOrientation((String)object);
                this.setOrientation(n);
                if (this.dockingSource == null) {
                    this.dockingSource = this.toolBar.getParent();
                }
                this.dockingSource.add((String)object, this.toolBar);
            }
            this.dockingSource.invalidate();
            object = this.dockingSource.getParent();
            if (object != null) {
                ((Container)object).validate();
            }
            this.dockingSource.repaint();
        }
    }

    private int mapConstraintToOrientation(String string) {
        int n = 0;
        if (string != null && (string.equals("East") || string.equals("West"))) {
            n = 1;
        }
        return n;
    }

    public void setOrientation(int n) {
        if (n == 1) {
            this.toolBar.setLayout(new BoxLayout(this.toolBar, 1));
        } else {
            this.toolBar.setLayout(new BoxLayout(this.toolBar, 0));
        }
        if (this.dragWindow != null) {
            this.dragWindow.setOrientation(n);
        }
    }

    public Color getDockingColor() {
        return this.dockingColor;
    }

    public void setDockingColor(Color color) {
        this.dockingColor = color;
    }

    public Color getFloatingColor() {
        return this.floatingColor;
    }

    public void setFloatingColor(Color color) {
        this.floatingColor = color;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        propertyChangeEvent.getPropertyName();
        if (propertyChangeEvent.getPropertyName().equals("floatable")) {
            Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            this.setFloatable(bl);
        }
    }

    public void setFloatable(boolean bl) {
        if (bl) {
            this.toolBar.addMouseMotionListener(this.dockingListener);
            this.toolBar.addMouseListener(this.dockingListener);
            return;
        }
        this.toolBar.removeMouseMotionListener(this.dockingListener);
        this.toolBar.removeMouseListener(this.dockingListener);
    }

    public boolean canDock(Component component, Point point) {
        boolean bl = false;
        if (component.contains(point)) {
            if (this.dockingSensitivity == 0) {
                this.dockingSensitivity = this.toolBar.getSize().height;
            }
            if (point.y < this.dockingSensitivity) {
                bl = true;
            }
            if (point.y > component.getSize().height - this.dockingSensitivity) {
                bl = true;
            }
            if (point.x < this.dockingSensitivity) {
                bl = true;
            }
            if (point.x > component.getSize().width - this.dockingSensitivity) {
                bl = true;
            }
        }
        return bl;
    }

    private String getDockingConstraint(Component component, Point point) {
        String string = "North";
        if (point != null && component.contains(point)) {
            if (this.dockingSensitivity == 0) {
                this.dockingSensitivity = this.toolBar.getSize().height;
            }
            if (point.y > component.getSize().height - this.dockingSensitivity) {
                string = "South";
            }
            if (point.x < this.dockingSensitivity) {
                string = "West";
            }
            if (point.x > component.getSize().width - this.dockingSensitivity) {
                string = "East";
            }
            if (point.y < this.dockingSensitivity) {
                string = "North";
            }
        }
        return string;
    }

    protected void dragTo(Point point, Point point2) {
        if (this.toolBar.isFloatable()) {
            Object object;
            Cloneable cloneable;
            Point point3;
            if (this.dragWindow == null) {
                this.dragWindow = this.createDragWindow(this.toolBar);
            }
            if ((point3 = this.dragWindow.getOffset()) == null) {
                cloneable = this.toolBar.getPreferredSize();
                point3 = new Point(cloneable.width / 2, cloneable.height / 2);
                this.dragWindow.setOffset(point3);
            }
            cloneable = new Point(point2.x + point.x, point2.y + point.y);
            Point point4 = new Point(((Point)cloneable).x - point3.x, ((Point)cloneable).y - point3.y);
            if (this.dockingSource == null) {
                this.dockingSource = this.toolBar.getParent();
            }
            Point point5 = this.dockingSource.getLocationOnScreen();
            Point point6 = new Point(((Point)cloneable).x - point5.x, ((Point)cloneable).y - point5.y);
            if (this.canDock(this.dockingSource, point6)) {
                ((Component)this.dragWindow).setBackground(this.getDockingColor());
                object = this.getDockingConstraint(this.dockingSource, point6);
                int n = this.mapConstraintToOrientation((String)object);
                this.dragWindow.setOrientation(n);
                this.dragWindow.setBorderColor(this.dockingBorderColor);
            } else {
                ((Component)this.dragWindow).setBackground(this.getFloatingColor());
                this.dragWindow.setOrientation(0);
                this.dragWindow.setBorderColor(this.floatingBorderColor);
            }
            ((Component)this.dragWindow).setLocation(point4.x, point4.y);
            if (!this.dragWindow.isVisible()) {
                object = this.toolBar.getPreferredSize();
                ((Component)this.dragWindow).setSize(((Dimension)object).width, ((Dimension)object).height);
                this.dragWindow.show();
            }
        }
    }

    protected void floatAt(Point point, Point point2) {
        if (this.toolBar.isFloatable()) {
            Point point3 = this.dragWindow.getOffset();
            if (point3 == null) {
                point3 = point;
                this.dragWindow.setOffset(point3);
            }
            Point point4 = new Point(point2.x + point.x, point2.y + point.y);
            this.setFloatingLocation(point4.x - point3.x, point4.y - point3.y);
            if (this.dockingSource != null) {
                Point point5 = this.dockingSource.getLocationOnScreen();
                Point point6 = new Point(point4.x - point5.x, point4.y - point5.y);
                if (this.canDock(this.dockingSource, point6)) {
                    this.setFloating(false, point6);
                } else {
                    this.setFloating(true, null);
                }
            } else {
                this.setFloating(true, null);
            }
            this.dragWindow.setOffset(null);
        }
    }

    protected DockingListener createDockingListener(JToolBar jToolBar) {
        return new DockingListener(jToolBar);
    }

    protected WindowListener createFrameListener() {
        return new FrameListener();
    }

    class FrameListener
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            BasicToolBarUI.this.setFloating(false, null);
        }

        FrameListener() {
            BasicToolBarUI.this = BasicToolBarUI.this;
        }
    }

    class DockingListener
    implements MouseMotionListener,
    MouseListener,
    Serializable {
        JToolBar toolBar;
        private boolean isDragging = false;
        private Point origin;

        DockingListener(JToolBar jToolBar) {
            BasicToolBarUI.this = BasicToolBarUI.this;
            this.toolBar = jToolBar;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.isDragging = false;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.isDragging) {
                Point point = mouseEvent.getPoint();
                BasicToolBarUI.this.floatAt(point, this.origin);
            }
            this.origin = null;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.isDragging = true;
            Point point = mouseEvent.getPoint();
            if (this.origin == null) {
                this.origin = mouseEvent.getComponent().getLocationOnScreen();
            }
            BasicToolBarUI.this.dragTo(point, this.origin);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    static class DragWindow
    extends Window {
        Color borderColor = Color.gray;
        int orientation = 0;
        Point offset;

        DragWindow(Frame frame) {
            super(frame);
        }

        public void setOrientation(int n) {
            if (this.isShowing()) {
                if (n == this.orientation) {
                    return;
                }
                this.orientation = n;
                Dimension dimension = this.getSize();
                ((Component)this).setSize(new Dimension(dimension.height, dimension.width));
                if (this.offset != null) {
                    this.setOffset(new Point(this.offset.y, this.offset.x));
                }
                this.repaint();
            }
        }

        public Point getOffset() {
            return this.offset;
        }

        public void setOffset(Point point) {
            this.offset = point;
        }

        public void setBorderColor(Color color) {
            if (this.borderColor == color) {
                return;
            }
            this.borderColor = color;
            this.repaint();
        }

        public Color getBorderColor() {
            return this.borderColor;
        }

        public void paint(Graphics graphics) {
            Color color = graphics.getColor();
            graphics.setColor(((Component)this).getBackground());
            Dimension dimension = this.getSize();
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(this.getBorderColor());
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            graphics.setColor(color);
            super.paint(graphics);
        }

        public Insets getInsets() {
            return new Insets(1, 1, 1, 1);
        }
    }
}

