/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.metal;

import com.sun.java.swing.AbstractButton;
import com.sun.java.swing.ButtonModel;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JToggleButton;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.basic.BasicToggleButtonUI;
import com.sun.java.swing.plaf.metal.MetalButtonBorder;
import com.sun.java.swing.plaf.metal.MetalUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;

public class MetalToggleButtonUI
extends BasicToggleButtonUI {
    private static Color selectedColor;
    private static Color disabledTextColor;
    private static Color focusColor;
    protected static final Insets defaultMargin;
    private static final MetalToggleButtonUI metalToggleButtonUI;

    public static ComponentUI createUI(JComponent jComponent) {
        return metalToggleButtonUI;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        selectedColor = UIManager.getColor("ToggleButton.selected");
        disabledTextColor = UIManager.getColor("ToggleButton.disabledText");
        focusColor = UIManager.getColor("ToggleButton.focus");
    }

    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        Dimension dimension = abstractButton.getSize();
        graphics.setColor(selectedColor);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
    }

    public Insets getDefaultMargin(AbstractButton abstractButton) {
        return defaultMargin;
    }

    protected void paintFocus(Graphics graphics, Dimension dimension) {
        graphics.setColor(BasicToggleButtonUI.toggleButtonFocus);
        graphics.drawRect(2, 2, dimension.width - 5, dimension.height - 5);
    }

    static {
        defaultMargin = new Insets(2, 14, 2, 14);
        metalToggleButtonUI = new MetalToggleButtonUI();
    }

    static class MetalToggleButtonBorder
    extends MetalButtonBorder {
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JToggleButton jToggleButton = (JToggleButton)component;
            ButtonModel buttonModel = jToggleButton.getModel();
            if (buttonModel.isPressed() && buttonModel.isArmed()) {
                MetalUtils.drawPressed3DBorder(graphics, n, n2, n3, n4);
                return;
            }
            if (jToggleButton.hasFocus()) {
                MetalUtils.drawActiveButtonBorder(graphics, n, n2, n3, n4);
                return;
            }
            if (buttonModel.isSelected()) {
                MetalUtils.drawDark3DBorder(graphics, n, n2, n3, n4);
                return;
            }
            MetalUtils.drawFlush3DBorder(graphics, n, n2, n3, n4);
        }

        MetalToggleButtonBorder() {
        }
    }
}

