/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.text;

import com.sun.java.swing.JComponent;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.event.DocumentEvent;
import com.sun.java.swing.event.DocumentListener;
import com.sun.java.swing.plaf.TextUI;
import com.sun.java.swing.plaf.UIResource;
import com.sun.java.swing.text.BadLocationException;
import com.sun.java.swing.text.Caret;
import com.sun.java.swing.text.DefaultCaret;
import com.sun.java.swing.text.DefaultEditorKit;
import com.sun.java.swing.text.DefaultHighlighter;
import com.sun.java.swing.text.Document;
import com.sun.java.swing.text.EditorKit;
import com.sun.java.swing.text.Element;
import com.sun.java.swing.text.Highlighter;
import com.sun.java.swing.text.JTextComponent;
import com.sun.java.swing.text.Keymap;
import com.sun.java.swing.text.StateInvariantError;
import com.sun.java.swing.text.View;
import com.sun.java.swing.text.ViewFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public abstract class DefaultTextUI
extends TextUI
implements ViewFactory,
Serializable {
    private static final EditorKit defaultKit = new DefaultEditorKit();
    transient JTextComponent editor;
    transient boolean painted = false;
    transient RootView rootView = new RootView();
    transient UpdateHandler updateHandler = new UpdateHandler();

    protected Caret createCaret() {
        return new DefaultCaret();
    }

    protected Highlighter createHighlighter() {
        return new DefaultHighlighter();
    }

    protected abstract Keymap createKeymap();

    protected void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    protected abstract String getPropertyPrefix();

    protected void installDefaults(JComponent jComponent) {
        Border border;
        Color color;
        Color color2;
        Color color3;
        Color color4;
        Color color5;
        Color color6;
        String string = this.getPropertyPrefix();
        Font font = this.editor.getFont();
        if (font == null || font instanceof UIResource) {
            ((Component)this.editor).setFont(UIManager.getFont(String.valueOf(string) + ".font"));
        }
        if ((color6 = this.editor.getBackground()) == null || color6 instanceof UIResource) {
            this.editor.setBackground(UIManager.getColor(String.valueOf(string) + ".background"));
        }
        if ((color5 = this.editor.getForeground()) == null || color5 instanceof UIResource) {
            this.editor.setForeground(UIManager.getColor(String.valueOf(string) + ".foreground"));
        }
        if ((color4 = this.editor.getCaretColor()) == null || color4 instanceof UIResource) {
            this.editor.setCaretColor(UIManager.getColor(String.valueOf(string) + ".caretForeground"));
        }
        if ((color3 = this.editor.getSelectionColor()) == null || color3 instanceof UIResource) {
            this.editor.setSelectionColor(UIManager.getColor(String.valueOf(string) + ".selectionBackground"));
        }
        if ((color2 = this.editor.getSelectedTextColor()) == null || color2 instanceof UIResource) {
            this.editor.setSelectedTextColor(UIManager.getColor(String.valueOf(string) + ".selectionForeground"));
        }
        if ((color = this.editor.getDisabledTextColor()) == null || color instanceof UIResource) {
            this.editor.setDisabledTextColor(UIManager.getColor(String.valueOf(string) + ".inactiveForeground"));
        }
        if ((border = this.editor.getBorder()) == null || border instanceof UIResource) {
            this.editor.setBorder(UIManager.getBorder(String.valueOf(string) + ".border"));
        }
        Caret caret = this.createCaret();
        this.editor.setCaret(caret);
        Object object = UIManager.get(String.valueOf(string) + ".caretBlinkRate");
        if (object != null && object instanceof Integer) {
            Integer n = (Integer)object;
            caret.setBlinkRate(n);
        }
    }

    protected void uninstallDefaults(JComponent jComponent) {
        if (this.editor.getCaretColor() instanceof UIResource) {
            this.editor.setCaretColor(null);
        }
        if (this.editor.getSelectionColor() instanceof UIResource) {
            this.editor.setSelectionColor(null);
        }
        if (this.editor.getDisabledTextColor() instanceof UIResource) {
            this.editor.setDisabledTextColor(null);
        }
        if (this.editor.getSelectedTextColor() instanceof UIResource) {
            this.editor.setSelectedTextColor(null);
        }
        if (this.editor.getBorder() instanceof UIResource) {
            this.editor.setBorder(null);
        }
        this.editor.setCaret(null);
    }

    protected void installListeners(JComponent jComponent) {
    }

    protected void uninstallListeners(JComponent jComponent) {
    }

    protected void paintBackground(Graphics graphics) {
        graphics.setColor(this.editor.getBackground());
        Dimension dimension = this.editor.getSize();
        graphics.fillRect(0, 0, dimension.width, dimension.height);
    }

    protected final JTextComponent getComponent() {
        return this.editor;
    }

    protected void modelChanged() {
        ViewFactory viewFactory = this.rootView.getViewFactory();
        Document document = this.editor.getDocument();
        Element element = document.getDefaultRootElement();
        this.setView(viewFactory.create(element));
    }

    protected final void setView(View view) {
        this.rootView.setView(view);
        this.painted = false;
        this.editor.invalidate();
    }

    protected void paintSafely(Graphics graphics) {
        this.painted = true;
        Highlighter highlighter = this.editor.getHighlighter();
        Caret caret = this.editor.getCaret();
        if (this.editor.isOpaque()) {
            this.paintBackground(graphics);
        }
        if (highlighter != null) {
            highlighter.paint(graphics);
        }
        Rectangle rectangle = this.getVisibleEditorRect();
        this.rootView.paint(graphics, rectangle);
        if (caret != null) {
            caret.paint(graphics);
        }
    }

    public void installUI(JComponent jComponent) {
        if (jComponent instanceof JTextComponent) {
            this.editor = (JTextComponent)jComponent;
            this.installDefaults(jComponent);
            this.editor.setOpaque(true);
            this.editor.setAutoscrolls(true);
            this.editor.setHighlighter(this.createHighlighter());
            this.editor.addPropertyChangeListener(this.updateHandler);
            Document document = this.editor.getDocument();
            if (document == null) {
                this.editor.setDocument(this.getEditorKit().createDefaultDocument());
            } else {
                document.addDocumentListener(this.updateHandler);
                this.modelChanged();
            }
            this.installListeners(jComponent);
            this.editor.setKeymap(this.createKeymap());
            return;
        }
        throw new Error("TextUI needs JTextComponent");
    }

    public void uninstallUI(JComponent jComponent) {
        this.editor.removePropertyChangeListener(this.updateHandler);
        this.editor.getDocument().removeDocumentListener(this.updateHandler);
        this.painted = false;
        this.uninstallDefaults(jComponent);
        this.editor.setHighlighter(null);
        this.rootView.setView(null);
        jComponent.removeAll();
        this.editor.setKeymap(null);
        this.uninstallListeners(jComponent);
    }

    public final void paint(Graphics graphics, JComponent jComponent) {
        if (this.rootView.getViewCount() > 0 && this.rootView.getView(0) != null) {
            SafePainter safePainter = new SafePainter(graphics);
            Document document = this.editor.getDocument();
            document.render(safePainter);
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Insets insets = jComponent.getInsets();
        return new Dimension((int)Math.min((long)this.rootView.getPreferredSpan(0) + (long)insets.left + (long)insets.right, Integer.MAX_VALUE), (int)Math.min((long)this.rootView.getPreferredSpan(1) + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE));
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Insets insets = jComponent.getInsets();
        long l = this.rootView.getResizeWeight(0) > 0 ? 1L : Math.min((long)this.rootView.getPreferredSpan(0) + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        long l2 = this.rootView.getResizeWeight(1) > 0 ? 1L : Math.min((long)this.rootView.getPreferredSpan(1) + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        return new Dimension((int)l, (int)l2);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Insets insets = jComponent.getInsets();
        long l = this.rootView.getResizeWeight(0) > 0 ? Integer.MAX_VALUE : Math.min((long)this.rootView.getPreferredSpan(0) + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        long l2 = this.rootView.getResizeWeight(1) > 0 ? Integer.MAX_VALUE : Math.min((long)this.rootView.getPreferredSpan(1) + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        return new Dimension((int)l, (int)l2);
    }

    protected Rectangle getVisibleEditorRect() {
        Rectangle rectangle = new Rectangle(this.editor.getSize());
        Insets insets = this.editor.getInsets();
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        return rectangle;
    }

    public Rectangle modelToView(int n) throws BadLocationException {
        if (this.painted) {
            Rectangle rectangle = this.getVisibleEditorRect();
            Shape shape = this.rootView.modelToView(n, rectangle);
            return shape.getBounds();
        }
        return null;
    }

    public int viewToModel(Point point) {
        if (this.painted) {
            Rectangle rectangle = this.getVisibleEditorRect();
            return this.rootView.viewToModel(point.x, point.y, rectangle);
        }
        return -1;
    }

    public void damageRange(int n, int n2) {
        if (this.painted) {
            Rectangle rectangle = this.getVisibleEditorRect();
            try {
                Shape shape = this.rootView.modelToView(n, rectangle);
                Shape shape2 = this.rootView.modelToView(n2, rectangle);
                if (shape != null && shape2 != null) {
                    Rectangle rectangle2 = shape.getBounds();
                    Rectangle rectangle3 = shape2.getBounds();
                    if (rectangle2.y == rectangle3.y) {
                        this.editor.repaint(rectangle2.x, rectangle2.y, rectangle3.x - rectangle2.x + 1, rectangle2.height);
                        return;
                    }
                    this.editor.repaint(rectangle.x, rectangle2.y, rectangle.width, rectangle3.y - rectangle2.y + rectangle3.height);
                    return;
                }
            }
            catch (BadLocationException badLocationException) {
                return;
            }
        }
    }

    public EditorKit getEditorKit() {
        return defaultKit;
    }

    public View getRootView() {
        return this.rootView;
    }

    public Insets getDefaultMargin() {
        return new Insets(0, 0, 0, 0);
    }

    public View create(Element element) {
        return null;
    }

    public View create(Element element, int n, int n2) {
        return null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.rootView = new RootView();
        this.updateHandler = new UpdateHandler();
    }

    class RootView
    extends View {
        private View view;

        RootView() {
            super(null);
            DefaultTextUI.this = DefaultTextUI.this;
        }

        void setView(View view) {
            if (this.view != null) {
                this.view.setParent(null);
            }
            this.view = view;
            if (this.view != null) {
                this.view.setParent(this);
            }
        }

        public float getPreferredSpan(int n) {
            if (this.view != null) {
                return this.view.getPreferredSpan(n);
            }
            return 10.0f;
        }

        public void preferenceChanged(View view, boolean bl, boolean bl2) {
            DefaultTextUI.this.editor.revalidate();
        }

        public float getAlignment(int n) {
            if (this.view != null) {
                return this.view.getAlignment(n);
            }
            return 0.0f;
        }

        public void paint(Graphics graphics, Shape shape) {
            if (this.view != null) {
                Rectangle rectangle = shape.getBounds();
                this.view.setSize(rectangle.width, rectangle.height);
                this.view.paint(graphics, shape);
            }
        }

        public void setParent(View view) {
            throw new StateInvariantError("Can't set parent on root view");
        }

        public int getViewCount() {
            return 1;
        }

        public View getView(int n) {
            return this.view;
        }

        public Shape getChildAllocation(int n, Shape shape) {
            return shape;
        }

        public Shape modelToView(int n, Shape shape) throws BadLocationException {
            if (this.view != null) {
                return this.view.modelToView(n, shape);
            }
            return null;
        }

        public int viewToModel(float f, float f2, Shape shape) {
            if (this.view != null) {
                return this.view.viewToModel(f, f2, shape);
            }
            return -1;
        }

        public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.view != null) {
                this.view.insertUpdate(documentEvent, shape, viewFactory);
            }
        }

        public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.view != null) {
                this.view.removeUpdate(documentEvent, shape, viewFactory);
            }
        }

        public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.view != null) {
                this.view.changedUpdate(documentEvent, shape, viewFactory);
            }
        }

        public Document getDocument() {
            return DefaultTextUI.this.editor.getDocument();
        }

        public int getStartOffset() {
            if (this.view != null) {
                return this.view.getStartOffset();
            }
            return this.getElement().getStartOffset();
        }

        public int getEndOffset() {
            if (this.view != null) {
                return this.view.getEndOffset();
            }
            return this.getElement().getEndOffset();
        }

        public Element getElement() {
            if (this.view != null) {
                return this.view.getElement();
            }
            return DefaultTextUI.this.editor.getDocument().getDefaultRootElement();
        }

        public View breakView(int n, float f, Shape shape) {
            throw new StateInvariantError("Can't break root view");
        }

        public int getResizeWeight(int n) {
            if (this.view != null) {
                return this.view.getResizeWeight(n);
            }
            return 0;
        }

        public void setSize(float f, float f2) {
            if (this.view != null) {
                this.view.setSize(f, f2);
            }
        }

        public Container getContainer() {
            return DefaultTextUI.this.editor;
        }

        public ViewFactory getViewFactory() {
            EditorKit editorKit = DefaultTextUI.this.getEditorKit();
            ViewFactory viewFactory = editorKit.getViewFactory();
            if (viewFactory != null) {
                return viewFactory;
            }
            return DefaultTextUI.this;
        }
    }

    class SafePainter
    implements Runnable {
        Graphics g;

        SafePainter(Graphics graphics) {
            DefaultTextUI.this = DefaultTextUI.this;
            this.g = graphics;
        }

        public void run() {
            DefaultTextUI.this.paintSafely(this.g);
        }
    }

    class UpdateHandler
    implements PropertyChangeListener,
    DocumentListener {
        public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            if (object instanceof Document || object2 instanceof Document) {
                if (object != null) {
                    ((Document)object).removeDocumentListener(this);
                }
                if (object2 != null) {
                    ((Document)object2).addDocumentListener(this);
                }
                DefaultTextUI.this.modelChanged();
            }
            DefaultTextUI.this.propertyChange(propertyChangeEvent);
        }

        public final void insertUpdate(DocumentEvent documentEvent) {
            Rectangle rectangle = DefaultTextUI.this.painted ? new Rectangle(DefaultTextUI.this.editor.getSize()) : null;
            DefaultTextUI.this.rootView.insertUpdate(documentEvent, rectangle, DefaultTextUI.this.rootView.getViewFactory());
        }

        public final void removeUpdate(DocumentEvent documentEvent) {
            Rectangle rectangle = DefaultTextUI.this.painted ? new Rectangle(DefaultTextUI.this.editor.getSize()) : null;
            DefaultTextUI.this.rootView.removeUpdate(documentEvent, rectangle, DefaultTextUI.this.rootView.getViewFactory());
        }

        public final void changedUpdate(DocumentEvent documentEvent) {
            Rectangle rectangle = DefaultTextUI.this.painted ? new Rectangle(DefaultTextUI.this.editor.getSize()) : null;
            DefaultTextUI.this.rootView.changedUpdate(documentEvent, rectangle, DefaultTextUI.this.rootView.getViewFactory());
        }

        UpdateHandler() {
            DefaultTextUI.this = DefaultTextUI.this;
        }
    }
}

