/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.text;

import com.sun.java.accessibility.Accessible;
import com.sun.java.accessibility.AccessibleContext;
import com.sun.java.accessibility.AccessibleRole;
import com.sun.java.accessibility.AccessibleState;
import com.sun.java.accessibility.AccessibleStateSet;
import com.sun.java.accessibility.AccessibleText;
import com.sun.java.swing.AbstractAction;
import com.sun.java.swing.Action;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.KeyStroke;
import com.sun.java.swing.Scrollable;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.event.CaretEvent;
import com.sun.java.swing.event.CaretListener;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ChangeListener;
import com.sun.java.swing.event.DocumentEvent;
import com.sun.java.swing.event.DocumentListener;
import com.sun.java.swing.plaf.TextUI;
import com.sun.java.swing.text.AttributeSet;
import com.sun.java.swing.text.BadLocationException;
import com.sun.java.swing.text.Caret;
import com.sun.java.swing.text.DefaultEditorKit;
import com.sun.java.swing.text.Document;
import com.sun.java.swing.text.EditorKit;
import com.sun.java.swing.text.Element;
import com.sun.java.swing.text.Highlighter;
import com.sun.java.swing.text.Keymap;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Writer;
import java.text.BreakIterator;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class JTextComponent
extends JComponent
implements Scrollable,
Accessible {
    public static final String FOCUS_ACCELERATOR_KEY = "focusAcceleratorKey";
    private Document model;
    private transient Caret caret;
    private transient Highlighter highlighter;
    private transient Keymap keymap;
    private boolean opaque;
    private transient MutableCaretEvent caretEvent;
    private Color caretColor;
    private Color selectionColor;
    private Color selectedTextColor;
    private Color disabledTextColor;
    private boolean editable;
    private Insets margin;
    private char focusAccelerator;
    private Action focusAction = new FocusAction();
    private static ClipboardOwner defaultClipboardOwner = new ClipboardObserver();
    static final IllegalArgumentException illegalDocumentPosition = new IllegalArgumentException("Illegal document position");
    private static Hashtable keymapTable = null;
    private JTextComponent editor;
    private static JTextComponent focusedComponent;
    public static final String DEFAULT_KEYMAP = "default";
    static final KeyBinding[] defaultBindings;
    static /* synthetic */ Class class$com$sun$java$swing$event$CaretListener;

    public JTextComponent() {
        this.enableEvents(8L);
        this.caretEvent = new MutableCaretEvent(this);
        this.addMouseListener(this.caretEvent);
        this.addFocusListener(this.caretEvent);
        this.setEditable(true);
        this.setLayout(null);
        this.updateUI();
    }

    public TextUI getUI() {
        return (TextUI)this.ui;
    }

    public void setUI(TextUI textUI) {
        super.setUI(textUI);
    }

    public void updateUI() {
        this.setUI((TextUI)UIManager.getUI(this));
        this.invalidate();
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public void setOpaque(boolean bl) {
        this.opaque = bl;
    }

    public void addCaretListener(CaretListener caretListener) {
        this.listenerList.add(class$com$sun$java$swing$event$CaretListener != null ? class$com$sun$java$swing$event$CaretListener : (class$com$sun$java$swing$event$CaretListener = JTextComponent.class$("com.sun.java.swing.event.CaretListener")), caretListener);
    }

    public void removeCaretListener(CaretListener caretListener) {
        this.listenerList.remove(class$com$sun$java$swing$event$CaretListener != null ? class$com$sun$java$swing$event$CaretListener : (class$com$sun$java$swing$event$CaretListener = JTextComponent.class$("com.sun.java.swing.event.CaretListener")), caretListener);
    }

    protected void fireCaretUpdate(CaretEvent caretEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$sun$java$swing$event$CaretListener != null ? class$com$sun$java$swing$event$CaretListener : JTextComponent.class$("com.sun.java.swing.event.CaretListener"))) {
                ((CaretListener)objectArray[n + 1]).caretUpdate(caretEvent);
            }
            n -= 2;
        }
    }

    public void setDocument(Document document) {
        if (this.accessibleContext != null) {
            this.model.removeDocumentListener((AccessibleJTextComponent)this.accessibleContext);
        }
        Document document2 = this.model;
        this.model = document;
        this.firePropertyChange("document", document2, document);
        this.revalidate();
        this.repaint();
        if (this.accessibleContext != null) {
            this.model.addDocumentListener((AccessibleJTextComponent)this.accessibleContext);
        }
    }

    public Document getDocument() {
        return this.model;
    }

    public Action[] getActions() {
        return this.getUI().getEditorKit().getActions();
    }

    public void setMargin(Insets insets) {
        Insets insets2 = this.margin;
        this.margin = insets;
        this.firePropertyChange("margin", insets2, insets);
        this.invalidate();
    }

    public Insets getMargin() {
        if (this.margin == null) {
            return ((TextUI)this.ui).getDefaultMargin();
        }
        return this.margin;
    }

    public Caret getCaret() {
        return this.caret;
    }

    public void setCaret(Caret caret) {
        if (this.caret != null) {
            this.caret.removeChangeListener(this.caretEvent);
            this.caret.deinstall(this);
        }
        Caret caret2 = this.caret;
        this.caret = caret;
        if (this.caret != null) {
            this.caret.install(this);
            this.caret.addChangeListener(this.caretEvent);
        }
        this.firePropertyChange("caret", caret2, this.caret);
    }

    public Highlighter getHighlighter() {
        return this.highlighter;
    }

    public void setHighlighter(Highlighter highlighter) {
        if (this.highlighter != null) {
            this.highlighter.deinstall(this);
        }
        Highlighter highlighter2 = this.highlighter;
        this.highlighter = highlighter;
        if (this.highlighter != null) {
            this.highlighter.install(this);
        }
        this.firePropertyChange("highlighter", highlighter2, highlighter);
    }

    public void setKeymap(Keymap keymap) {
        Keymap keymap2 = this.keymap;
        this.keymap = keymap;
        this.firePropertyChange("keymap", keymap2, this.keymap);
    }

    public Keymap getKeymap() {
        return this.keymap;
    }

    public static Keymap addKeymap(String string, Keymap keymap) {
        DefaultKeymap defaultKeymap = new DefaultKeymap(string, keymap);
        if (string != null) {
            keymapTable.put(string, defaultKeymap);
        }
        return defaultKeymap;
    }

    public static Keymap removeKeymap(String string) {
        return (Keymap)keymapTable.remove(string);
    }

    public static Keymap getKeymap(String string) {
        return (Keymap)keymapTable.get(string);
    }

    public static void loadKeymap(Keymap keymap, KeyBinding[] keyBindingArray, Action[] actionArray) {
        Object object;
        Hashtable<String, Action> hashtable = new Hashtable<String, Action>();
        int n = 0;
        while (n < actionArray.length) {
            Action action = actionArray[n];
            object = (String)action.getValue("Name");
            hashtable.put((String)(object != null ? object : ""), action);
            ++n;
        }
        int n2 = 0;
        while (n2 < keyBindingArray.length) {
            object = (Action)hashtable.get(keyBindingArray[n2].actionName);
            if (object != null) {
                keymap.addActionForKeyStroke(keyBindingArray[n2].key, (Action)object);
            }
            ++n2;
        }
    }

    private final boolean mapEventToAction(KeyEvent keyEvent) {
        KeyStroke keyStroke;
        Action action;
        Keymap keymap = this.getKeymap();
        if (keymap != null && (action = keymap.getAction(keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent))) != null) {
            String string = null;
            if (keyEvent.getKeyChar() != '\u0000') {
                string = String.valueOf(keyEvent.getKeyChar());
            }
            ActionEvent actionEvent = new ActionEvent(this, 1001, string, keyEvent.getModifiers());
            action.actionPerformed(actionEvent);
            keyEvent.consume();
            return true;
        }
        return false;
    }

    public Color getCaretColor() {
        return this.caretColor;
    }

    public void setCaretColor(Color color) {
        Color color2 = this.caretColor;
        this.caretColor = color;
        this.firePropertyChange("caretColor", color2, this.caretColor);
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color color) {
        Color color2 = this.selectionColor;
        this.selectionColor = color;
        this.firePropertyChange("selectionColor", color2, this.selectionColor);
    }

    public Color getSelectedTextColor() {
        return this.selectedTextColor;
    }

    public void setSelectedTextColor(Color color) {
        Color color2 = this.selectedTextColor;
        this.selectedTextColor = color;
        this.firePropertyChange("selectedTextColor", color2, this.selectedTextColor);
    }

    public Color getDisabledTextColor() {
        return this.disabledTextColor;
    }

    public void setDisabledTextColor(Color color) {
        Color color2 = this.disabledTextColor;
        this.disabledTextColor = color;
        this.firePropertyChange("disabledTextColor", color2, this.disabledTextColor);
    }

    public void replaceSelection(String string) {
        if (!this.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        Document document = this.getDocument();
        if (document != null) {
            try {
                int n = Math.min(this.caret.getDot(), this.caret.getMark());
                int n2 = Math.max(this.caret.getDot(), this.caret.getMark());
                if (n != n2) {
                    document.remove(n, n2 - n);
                }
                if (string != null && string.length() > 0) {
                    document.insertString(n, string, null);
                    return;
                }
            }
            catch (BadLocationException badLocationException) {
                this.getToolkit().beep();
                return;
            }
        }
    }

    public String getText(int n, int n2) throws BadLocationException {
        return this.getDocument().getText(n, n2);
    }

    public Rectangle modelToView(int n) throws BadLocationException {
        return this.getUI().modelToView(n);
    }

    public int viewToModel(Point point) {
        return this.getUI().viewToModel(point);
    }

    public void cut() {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            int n = Math.min(this.caret.getDot(), this.caret.getMark());
            int n2 = Math.max(this.caret.getDot(), this.caret.getMark());
            if (n != n2) {
                Document document = this.getDocument();
                String string = document.getText(n, n2 - n);
                StringSelection stringSelection = new StringSelection(string);
                clipboard.setContents(stringSelection, defaultClipboardOwner);
                document.remove(n, n2 - n);
                return;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    public void copy() {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            int n = Math.min(this.caret.getDot(), this.caret.getMark());
            int n2 = Math.max(this.caret.getDot(), this.caret.getMark());
            if (n != n2) {
                Document document = this.getDocument();
                String string = document.getText(n, n2 - n);
                StringSelection stringSelection = new StringSelection(string);
                clipboard.setContents(stringSelection, defaultClipboardOwner);
                return;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    public void paste() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        if (transferable != null) {
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                this.replaceSelection(string);
                return;
            }
            catch (Exception exception) {
                System.err.println("Couldn't get clipboard contents in format: " + DataFlavor.stringFlavor.getHumanPresentableName());
                return;
            }
        }
    }

    public void moveCaretPosition(int n) {
        this.caret.moveDot(n);
    }

    public void setFocusAccelerator(char c) {
        c = Character.toUpperCase(c);
        KeyStroke[] keyStrokeArray = this.getRegisteredKeyStrokes();
        int n = 0;
        int n2 = keyStrokeArray.length;
        while (n < n2) {
            if (this.getActionForKeyStroke(keyStrokeArray[n]) == this.focusAction) {
                if (keyStrokeArray[n].getKeyChar() == c) {
                    return;
                }
                this.unregisterKeyboardAction(keyStrokeArray[n]);
                break;
            }
            ++n;
        }
        if (c != '\u0000') {
            this.registerKeyboardAction(this.focusAction, KeyStroke.getKeyStroke((int)c, 8), 2);
        }
        char c2 = this.focusAccelerator;
        this.focusAccelerator = c;
        this.firePropertyChange(FOCUS_ACCELERATOR_KEY, c2, this.focusAccelerator);
    }

    public char getFocusAccelerator() {
        return this.focusAccelerator;
    }

    public void read(Reader reader, Object object) throws IOException {
        EditorKit editorKit = this.getUI().getEditorKit();
        Document document = editorKit.createDefaultDocument();
        if (object != null) {
            document.putProperty("stream", object);
        }
        try {
            editorKit.read(reader, document, 0);
            this.setDocument(document);
            return;
        }
        catch (BadLocationException badLocationException) {
            throw new IOException(badLocationException.getMessage());
        }
    }

    public void write(Writer writer) throws IOException {
        Document document = this.getDocument();
        try {
            this.getUI().getEditorKit().write(writer, document, 0, document.getLength());
            return;
        }
        catch (BadLocationException badLocationException) {
            throw new IOException(badLocationException.getMessage());
        }
    }

    public boolean isFocusTraversable() {
        return this.isEnabled();
    }

    protected void processComponentKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getID();
        switch (n) {
            case 400: {
                Action action;
                Keymap keymap;
                if (this.mapEventToAction(keyEvent) || (keymap = this.getKeymap()) == null || (action = keymap.getDefaultAction()) == null) break;
                ActionEvent actionEvent = new ActionEvent(this, 1001, String.valueOf(keyEvent.getKeyChar()), keyEvent.getModifiers());
                action.actionPerformed(actionEvent);
                keyEvent.consume();
                return;
            }
            case 401: {
                this.mapEventToAction(keyEvent);
                return;
            }
            case 402: {
                this.mapEventToAction(keyEvent);
                return;
            }
        }
    }

    public void setCaretPosition(int n) {
        Document document = this.getDocument();
        if (document != null) {
            this.caret.setDot(n);
        }
    }

    public int getCaretPosition() {
        return this.caret.getDot();
    }

    public void setText(String string) {
        try {
            Document document = this.getDocument();
            document.remove(0, document.getLength());
            document.insertString(0, string, null);
            return;
        }
        catch (BadLocationException badLocationException) {
            this.getToolkit().beep();
            return;
        }
    }

    public String getText() {
        String string;
        Document document = this.getDocument();
        try {
            string = document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            string = null;
        }
        return string;
    }

    public String getSelectedText() {
        int n;
        String string = null;
        int n2 = Math.min(this.caret.getDot(), this.caret.getMark());
        if (n2 != (n = Math.max(this.caret.getDot(), this.caret.getMark()))) {
            try {
                Document document = this.getDocument();
                string = document.getText(n2, n - n2);
            }
            catch (BadLocationException badLocationException) {
                throw illegalDocumentPosition;
            }
        }
        return string;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public int getSelectionStart() {
        int n = Math.min(this.caret.getDot(), this.caret.getMark());
        return n;
    }

    public void setSelectionStart(int n) {
        this.select(n, this.getSelectionEnd());
    }

    public int getSelectionEnd() {
        int n = Math.max(this.caret.getDot(), this.caret.getMark());
        return n;
    }

    public void setSelectionEnd(int n) {
        this.select(this.getSelectionStart(), n);
    }

    public void select(int n, int n2) {
        this.setCaretPosition(n);
        this.moveCaretPosition(n2);
    }

    public void selectAll() {
        Document document = this.getDocument();
        if (document != null) {
            this.setCaretPosition(0);
            this.moveCaretPosition(document.getLength());
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        switch (n) {
            case 1: {
                return rectangle.height / 10;
            }
            case 0: {
                return rectangle.width / 10;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + n);
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        switch (n) {
            case 1: {
                return rectangle.height;
            }
            case 0: {
                return rectangle.width;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + n);
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTextComponent();
        }
        return this.accessibleContext;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.caretEvent = new MutableCaretEvent(this);
        this.addMouseListener(this.caretEvent);
        this.addFocusListener(this.caretEvent);
        this.getUI().installUI(this);
    }

    static final JTextComponent getFocusedComponent() {
        return focusedComponent;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ JTextComponent access$1() {
        return focusedComponent;
    }

    static {
        defaultBindings = new KeyBinding[]{new KeyBinding(KeyStroke.getKeyStroke(8, 0), "delete-previous"), new KeyBinding(KeyStroke.getKeyStroke(127, 0), "delete-next"), new KeyBinding(KeyStroke.getKeyStroke(36, 0), "caret-begin"), new KeyBinding(KeyStroke.getKeyStroke(35, 0), "caret-end"), new KeyBinding(KeyStroke.getKeyStroke(39, 0), "caret-forward"), new KeyBinding(KeyStroke.getKeyStroke(37, 0), "caret-backward"), new KeyBinding(KeyStroke.getKeyStroke(38, 0), "caret-up"), new KeyBinding(KeyStroke.getKeyStroke(40, 0), "caret-down")};
        try {
            keymapTable = new Hashtable(17);
            Keymap keymap = JTextComponent.addKeymap(DEFAULT_KEYMAP, null);
            keymap.setDefaultAction(new DefaultEditorKit.DefaultKeyTypedAction());
            DefaultEditorKit defaultEditorKit = new DefaultEditorKit();
            JTextComponent.loadKeymap(keymap, defaultBindings, ((EditorKit)defaultEditorKit).getActions());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            keymapTable = new Hashtable(17);
        }
    }

    public static class KeyBinding {
        public KeyStroke key;
        public String actionName;

        public KeyBinding(KeyStroke keyStroke, String string) {
            this.key = keyStroke;
            this.actionName = string;
        }
    }

    public class AccessibleJTextComponent
    extends JComponent.AccessibleJComponent
    implements AccessibleText,
    CaretListener,
    DocumentListener {
        int caretPos;

        public AccessibleJTextComponent() {
            JTextComponent.this = JTextComponent.this;
            Document document = JTextComponent.this.getDocument();
            if (document != null) {
                document.addDocumentListener(this);
            }
            JTextComponent.this.addCaretListener(this);
            this.caretPos = this.getCaretPosition();
        }

        public void caretUpdate(CaretEvent caretEvent) {
            int n = caretEvent.getDot();
            int n2 = caretEvent.getMark();
            if (this.caretPos != n) {
                this.firePropertyChange("AccessibleCaret", new Integer(this.caretPos), new Integer(n));
                this.caretPos = n;
            }
            if (n2 != n) {
                this.firePropertyChange("AccessibleSelection", null, this.getSelectedText());
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            Caret caret = JTextComponent.this.getCaret();
            Integer n = new Integer(caret.getDot());
            this.firePropertyChange("AccessibleText", null, n);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            Caret caret = JTextComponent.this.getCaret();
            Integer n = new Integer(caret.getDot());
            this.firePropertyChange("AccessibleText", null, n);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            Caret caret = JTextComponent.this.getCaret();
            Integer n = new Integer(caret.getDot());
            this.firePropertyChange("AccessibleText", null, n);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (JTextComponent.this.isEditable()) {
                accessibleStateSet.add(AccessibleState.EDITABLE);
            }
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TEXT;
        }

        public AccessibleText getAccessibleText() {
            return this;
        }

        public int getIndexAtPoint(Point point) {
            if (point == null) {
                return -1;
            }
            return JTextComponent.this.viewToModel(point);
        }

        public Rectangle getCharacterBounds(int n) {
            Rectangle rectangle;
            if (n < 0 || n > JTextComponent.this.model.getLength() - 1) {
                return null;
            }
            try {
                rectangle = JTextComponent.this.modelToView(n);
            }
            catch (BadLocationException badLocationException) {
                rectangle = null;
            }
            return rectangle;
        }

        public int getCharCount() {
            return JTextComponent.this.model.getLength();
        }

        public int getCaretPosition() {
            return JTextComponent.this.getCaretPosition();
        }

        public AttributeSet getCharacterAttribute(int n) {
            Element element = null;
            element = JTextComponent.this.model.getDefaultRootElement();
            while (!element.isLeaf()) {
                int n2 = element.getElementIndex(n);
                element = element.getElement(n2);
            }
            return element.getAttributes();
        }

        public int getSelectionStart() {
            return JTextComponent.this.getSelectionStart();
        }

        public int getSelectionEnd() {
            return JTextComponent.this.getSelectionEnd();
        }

        public String getSelectedText() {
            return JTextComponent.this.getSelectedText();
        }

        public String getAtIndex(int n, int n2) {
            if (n2 < 0 || n2 > JTextComponent.this.model.getLength() - 1) {
                return null;
            }
            switch (n) {
                case 1: {
                    try {
                        return JTextComponent.this.model.getText(n2, 1);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                case 2: {
                    try {
                        String string = JTextComponent.this.model.getText(0, JTextComponent.this.model.getLength());
                        BreakIterator breakIterator = BreakIterator.getWordInstance();
                        breakIterator.setText(string);
                        int n3 = breakIterator.following(n2);
                        return string.substring(breakIterator.previous(), n3);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                case 3: {
                    try {
                        String string = JTextComponent.this.model.getText(0, JTextComponent.this.model.getLength());
                        BreakIterator breakIterator = BreakIterator.getSentenceInstance();
                        breakIterator.setText(string);
                        int n4 = breakIterator.following(n2);
                        return string.substring(breakIterator.previous(), n4);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
            }
            return null;
        }

        public String getAfterIndex(int n, int n2) {
            if (n2 < 0 || n2 > JTextComponent.this.model.getLength() - 1) {
                return null;
            }
            switch (n) {
                case 1: {
                    try {
                        return JTextComponent.this.model.getText(n2 + 1, 1);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                case 2: {
                    try {
                        String string = JTextComponent.this.model.getText(0, JTextComponent.this.model.getLength());
                        BreakIterator breakIterator = BreakIterator.getWordInstance();
                        breakIterator.setText(string);
                        int n3 = breakIterator.following(n2);
                        return string.substring(n3, breakIterator.following(n3));
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                case 3: {
                    try {
                        String string = JTextComponent.this.model.getText(0, JTextComponent.this.model.getLength());
                        BreakIterator breakIterator = BreakIterator.getSentenceInstance();
                        breakIterator.setText(string);
                        int n4 = breakIterator.following(n2);
                        return string.substring(n4, breakIterator.following(n4));
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
            }
            return null;
        }

        public String getBeforeIndex(int n, int n2) {
            if (n2 < 0 || n2 > JTextComponent.this.model.getLength() - 1) {
                return null;
            }
            switch (n) {
                case 1: {
                    try {
                        return JTextComponent.this.model.getText(n2 - 1, 1);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                case 2: {
                    try {
                        String string = JTextComponent.this.model.getText(0, JTextComponent.this.model.getLength());
                        BreakIterator breakIterator = BreakIterator.getWordInstance();
                        breakIterator.setText(string);
                        int n3 = breakIterator.next(n2);
                        n3 = breakIterator.previous();
                        return string.substring(breakIterator.previous(), n3);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                case 3: {
                    try {
                        String string = JTextComponent.this.model.getText(0, JTextComponent.this.model.getLength());
                        BreakIterator breakIterator = BreakIterator.getSentenceInstance();
                        breakIterator.setText(string);
                        int n4 = breakIterator.next(n2);
                        n4 = breakIterator.previous();
                        return string.substring(breakIterator.previous(), n4);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
            }
            return null;
        }
    }

    static class ClipboardObserver
    implements ClipboardOwner {
        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        }

        ClipboardObserver() {
        }
    }

    static class DefaultKeymap
    implements Keymap {
        String nm;
        Keymap parent;
        Hashtable bindings;
        Action defaultAction;

        DefaultKeymap(String string, Keymap keymap) {
            this.nm = string;
            this.parent = keymap;
            this.bindings = new Hashtable();
        }

        public Action getDefaultAction() {
            if (this.defaultAction != null) {
                return this.defaultAction;
            }
            if (this.parent != null) {
                return this.parent.getDefaultAction();
            }
            return null;
        }

        public void setDefaultAction(Action action) {
            this.defaultAction = action;
        }

        public String getName() {
            return this.nm;
        }

        public Action getAction(KeyStroke keyStroke) {
            Action action = (Action)this.bindings.get(keyStroke);
            if (action == null && this.parent != null) {
                action = this.parent.getAction(keyStroke);
            }
            return action;
        }

        public KeyStroke[] getBoundKeyStrokes() {
            KeyStroke[] keyStrokeArray = new KeyStroke[this.bindings.size()];
            int n = 0;
            Enumeration enumeration = this.bindings.keys();
            while (enumeration.hasMoreElements()) {
                keyStrokeArray[n++] = (KeyStroke)enumeration.nextElement();
            }
            return keyStrokeArray;
        }

        public Action[] getBoundActions() {
            Action[] actionArray = new Action[this.bindings.size()];
            int n = 0;
            Enumeration enumeration = this.bindings.elements();
            while (enumeration.hasMoreElements()) {
                actionArray[n++] = (Action)enumeration.nextElement();
            }
            return actionArray;
        }

        public KeyStroke[] getKeyStrokesForAction(Action action) {
            return null;
        }

        public boolean isLocallyDefined(KeyStroke keyStroke) {
            return this.bindings.containsKey(keyStroke);
        }

        public void addActionForKeyStroke(KeyStroke keyStroke, Action action) {
            this.bindings.put(keyStroke, action);
        }

        public void removeKeyStrokeBinding(KeyStroke keyStroke) {
            this.bindings.remove(keyStroke);
        }

        public void removeBindings() {
            this.bindings.clear();
        }

        public Keymap getResolveParent() {
            return this.parent;
        }

        public void setResolveParent(Keymap keymap) {
            this.parent = keymap;
        }

        public String toString() {
            return "Keymap[" + this.nm + "]" + this.bindings;
        }
    }

    static class MutableCaretEvent
    extends CaretEvent
    implements ChangeListener,
    MouseListener,
    FocusListener {
        private boolean dragActive;
        private int dot;
        private int mark;

        MutableCaretEvent(JTextComponent jTextComponent) {
            super(jTextComponent);
        }

        final void fire() {
            JTextComponent jTextComponent = (JTextComponent)this.getSource();
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                this.dot = caret.getDot();
                this.mark = caret.getMark();
                jTextComponent.fireCaretUpdate(this);
            }
        }

        public final String toString() {
            return "dot=" + this.dot + "," + "mark=" + this.mark;
        }

        public final int getDot() {
            return this.dot;
        }

        public final int getMark() {
            return this.mark;
        }

        public final void stateChanged(ChangeEvent changeEvent) {
            if (!this.dragActive) {
                this.fire();
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            focusedComponent = (JTextComponent)this.getSource();
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        public final void mousePressed(MouseEvent mouseEvent) {
            this.dragActive = true;
        }

        public final void mouseReleased(MouseEvent mouseEvent) {
            this.dragActive = false;
            this.fire();
        }

        public final void mouseClicked(MouseEvent mouseEvent) {
        }

        public final void mouseEntered(MouseEvent mouseEvent) {
        }

        public final void mouseExited(MouseEvent mouseEvent) {
        }
    }

    class FocusAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent.this.requestFocus();
        }

        public boolean isEnabled() {
            return JTextComponent.this.isEditable();
        }

        FocusAction() {
            JTextComponent.this = JTextComponent.this;
        }
    }
}

