/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.text;

import com.sun.java.swing.event.DocumentEvent;
import com.sun.java.swing.text.AttributeSet;
import com.sun.java.swing.text.BadLocationException;
import com.sun.java.swing.text.Document;
import com.sun.java.swing.text.Element;
import com.sun.java.swing.text.Segment;
import com.sun.java.swing.text.StateInvariantError;
import com.sun.java.swing.text.StyleConstants;
import com.sun.java.swing.text.StyledDocument;
import com.sun.java.swing.text.TabExpander;
import com.sun.java.swing.text.TabableView;
import com.sun.java.swing.text.Utilities;
import com.sun.java.swing.text.View;
import com.sun.java.swing.text.ViewFactory;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;

public class LabelView
extends View
implements TabableView {
    Font font;
    FontMetrics metrics;
    Color fg;
    Segment text = new Segment();
    boolean underline;
    TabExpander expander;
    int x;

    public LabelView(Element element) {
        super(element);
    }

    final void loadText(int n, int n2) {
        try {
            Document document = this.getDocument();
            document.getText(n, n2 - n, this.text);
            return;
        }
        catch (BadLocationException badLocationException) {
            throw new StateInvariantError("LabelView: Stale view: " + badLocationException);
        }
    }

    final void paintText(Graphics graphics, Shape shape, int n, int n2) {
        Rectangle rectangle = shape.getBounds();
        this.sync();
        this.loadText(n, n2);
        int n3 = rectangle.y + rectangle.height - this.metrics.getDescent();
        graphics.setFont(this.font);
        graphics.setColor(this.fg);
        Utilities.drawTabbedText(this.text, rectangle.x, n3, graphics, this.expander, n);
        if (this.underline) {
            graphics.drawLine(rectangle.x, ++n3, rectangle.x + rectangle.width, n3);
        }
    }

    final void sync() {
        if (this.font == null) {
            Element element = this.getElement();
            Document document = this.getDocument();
            if (document instanceof StyledDocument) {
                StyledDocument styledDocument = (StyledDocument)document;
                AttributeSet attributeSet = element.getAttributes();
                this.font = styledDocument.getFont(attributeSet);
                this.fg = styledDocument.getForeground(attributeSet);
                this.underline = StyleConstants.isUnderline(attributeSet);
                this.metrics = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
                return;
            }
            throw new StateInvariantError("LabelView needs StyledDocument");
        }
    }

    final float getPreferredSpan(int n, int n2, int n3, int n4) {
        this.sync();
        switch (n) {
            case 0: {
                this.loadText(n2, n3);
                int n5 = Utilities.getTabbedTextWidth(this.text, this.metrics, n4, this.expander, n2);
                return Math.max(n5, 1);
            }
            case 1: {
                return this.metrics.getHeight();
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    Shape modelToView(int n, Shape shape, int n2, int n3) throws BadLocationException {
        Rectangle rectangle = shape.getBounds();
        if (n >= n2 && n <= n3) {
            this.loadText(n2, n);
            this.sync();
            int n4 = Utilities.getTabbedTextWidth(this.text, this.metrics, rectangle.x, this.expander, n2);
            return new Rectangle(rectangle.x + n4, rectangle.y, 0, this.metrics.getHeight());
        }
        throw new BadLocationException("modelToView - can't convert", n3);
    }

    int viewToModel(float f, float f2, Shape shape, int n, int n2) {
        Rectangle rectangle = shape.getBounds();
        this.sync();
        this.loadText(n, n2);
        int n3 = Utilities.getTabbedTextOffset(this.text, this.metrics, rectangle.x, (int)f, this.expander, n);
        return n + n3;
    }

    int getBreakWeight(int n, float f, float f2, int n2, int n3) {
        if (n == 0) {
            this.sync();
            this.loadText(n2, n3);
            int n4 = Utilities.getTabbedTextOffset(this.text, this.metrics, (int)f, (int)(f + f2), this.expander, n2);
            if (n4 == 0) {
                return 0;
            }
            int n5 = this.text.offset + Math.min(n4, this.text.count - 1);
            while (n5 >= this.text.offset) {
                char c = this.text.array[n5];
                if (Character.isWhitespace(c)) {
                    return 2000;
                }
                --n5;
            }
            return 1000;
        }
        return super.getBreakWeight(n, f, f2);
    }

    public float getTabbedSpan(float f, TabExpander tabExpander) {
        this.expander = tabExpander;
        this.x = (int)f;
        return this.getPreferredSpan(0, this.getStartOffset(), this.getEndOffset(), this.x);
    }

    public float getPartialSpan(int n, int n2) {
        int n3 = 0;
        try {
            Segment segment = new Segment();
            this.getDocument().getText(n, n2, segment);
            n3 = Utilities.getTabbedTextWidth(segment, this.metrics, this.x, this.expander, n);
        }
        catch (BadLocationException badLocationException) {}
        return n3;
    }

    public void paint(Graphics graphics, Shape shape) {
        this.paintText(graphics, shape, this.getStartOffset(), this.getEndOffset());
    }

    public float getPreferredSpan(int n) {
        return this.getPreferredSpan(n, this.getStartOffset(), this.getEndOffset(), this.x);
    }

    public float getAlignment(int n) {
        if (n == 1) {
            float f = this.metrics.getHeight();
            float f2 = this.metrics.getDescent();
            float f3 = (f - f2) / f;
            return f3;
        }
        return super.getAlignment(n);
    }

    public Shape modelToView(int n, Shape shape) throws BadLocationException {
        return this.modelToView(n, shape, this.getStartOffset(), this.getEndOffset());
    }

    public int viewToModel(float f, float f2, Shape shape) {
        return this.viewToModel(f, f2, shape, this.getStartOffset(), this.getEndOffset());
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.font = null;
    }

    public int getBreakWeight(int n, float f, float f2) {
        return this.getBreakWeight(n, f, f2, this.getStartOffset(), this.getEndOffset());
    }

    public View breakView(int n, int n2, float f, float f2) {
        if (n == 0) {
            char c;
            this.sync();
            this.loadText(n2, this.getEndOffset());
            int n3 = Utilities.getTabbedTextOffset(this.text, this.metrics, (int)f, (int)(f + f2), this.expander, n2);
            int n4 = this.text.offset + Math.min(n3, this.text.count - 1);
            while (n4 >= this.text.offset) {
                c = this.text.array[n4];
                if (Character.isWhitespace(c)) {
                    n3 = n4 - this.text.offset + 1;
                    break;
                }
                --n4;
            }
            c = n2 + n3;
            return new LabelFragment(this.getElement(), n2, c);
        }
        return this;
    }

    public View createFragment(int n, int n2) {
        Element element = this.getElement();
        return new LabelFragment(element, n, n2);
    }

    class LabelFragment
    extends View {
        short offset;
        short length;
        int x;

        public LabelFragment(Element element, int n, int n2) {
            super(element);
            LabelView.this = LabelView.this;
            this.offset = (short)(n - element.getStartOffset());
            this.length = (short)(n2 - n);
        }

        public float getTabbedSpan(float f, TabExpander tabExpander) {
            LabelView.this.expander = tabExpander;
            this.x = (int)f;
            return LabelView.this.getPreferredSpan(0, this.getStartOffset(), this.getEndOffset(), this.x);
        }

        public float getPartialSpan(int n, int n2) {
            return LabelView.this.getPartialSpan(n, n2);
        }

        public int getStartOffset() {
            Element element = this.getElement();
            return element.getStartOffset() + this.offset;
        }

        public int getEndOffset() {
            Element element = this.getElement();
            return element.getStartOffset() + this.offset + this.length;
        }

        public void paint(Graphics graphics, Shape shape) {
            LabelView.this.paintText(graphics, shape, this.getStartOffset(), this.getEndOffset());
        }

        public float getPreferredSpan(int n) {
            return LabelView.this.getPreferredSpan(n, this.getStartOffset(), this.getEndOffset(), this.x);
        }

        public float getAlignment(int n) {
            return LabelView.this.getAlignment(n);
        }

        public Shape modelToView(int n, Shape shape) throws BadLocationException {
            return LabelView.this.modelToView(n, shape, this.getStartOffset(), this.getEndOffset());
        }

        public int viewToModel(float f, float f2, Shape shape) {
            return LabelView.this.viewToModel(f, f2, shape, this.getStartOffset(), this.getEndOffset());
        }

        public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            LabelView.this.changedUpdate(documentEvent, shape, viewFactory);
        }

        public int getBreakWeight(int n, float f, float f2) {
            return LabelView.this.getBreakWeight(n, f, f2, this.getStartOffset(), this.getEndOffset());
        }

        public View breakView(int n, int n2, float f, float f2) {
            return LabelView.this.breakView(n, n2, f, f2);
        }
    }
}

