/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.text;

import com.sun.java.swing.event.DocumentEvent;
import com.sun.java.swing.text.AttributeSet;
import com.sun.java.swing.text.BadLocationException;
import com.sun.java.swing.text.BoxView;
import com.sun.java.swing.text.Element;
import com.sun.java.swing.text.Segment;
import com.sun.java.swing.text.StateInvariantError;
import com.sun.java.swing.text.StyleConstants;
import com.sun.java.swing.text.TabExpander;
import com.sun.java.swing.text.TabSet;
import com.sun.java.swing.text.TabStop;
import com.sun.java.swing.text.TabableView;
import com.sun.java.swing.text.View;
import com.sun.java.swing.text.ViewFactory;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Vector;

public class ParagraphView
extends BoxView
implements TabExpander {
    private int justification;
    private int lineSpacing;
    private int tabBase;
    private int layoutSpan;
    private Vector layoutPool;
    static char[] tabChars = new char[1];
    static char[] tabDecimalChars;

    public ParagraphView(Element element) {
        super(element, 1);
        AttributeSet attributeSet = element.getAttributes();
        this.setParagraphInsets(attributeSet);
        this.justification = StyleConstants.getAlignment(attributeSet);
        this.lineSpacing = (int)StyleConstants.getLineSpacing(attributeSet);
        this.layoutSpan = Integer.MAX_VALUE;
    }

    protected void loadChildren(ViewFactory viewFactory) {
        this.layoutPool = new Vector();
        Element element = this.getElement();
        int n = element.getElementCount();
        int n2 = 0;
        while (n2 < n) {
            this.layoutPool.addElement(viewFactory.create(element.getElement(n2)));
            ++n2;
        }
    }

    protected View getViewAtPosition(int n, Rectangle rectangle) {
        int n2 = this.getViewCount();
        int n3 = 0;
        while (n3 < n2) {
            View view = this.getView(n3);
            int n4 = view.getStartOffset();
            int n5 = view.getEndOffset();
            if (n >= n4 && n < n5) {
                this.childAllocation(n3, rectangle);
                return view;
            }
            ++n3;
        }
        return null;
    }

    protected void layout(int n, int n2) {
        if (this.layoutSpan != n) {
            int n3 = (int)this.getPreferredSpan(1);
            this.rebuildRows(n);
            int n4 = (int)this.getPreferredSpan(1);
            if (n3 != n4) {
                View view = this.getParent();
                view.preferenceChanged(this, false, true);
            }
        }
        super.layout(n, n2);
    }

    void rebuildRows(int n) {
        this.layoutSpan = n;
        int n2 = this.getStartOffset();
        int n3 = this.getEndOffset();
        this.removeAll();
        while (n2 < n3) {
            int n4 = n2;
            Row row = new Row(this.getElement());
            this.append(row);
            this.layoutRow(row, n2);
            n2 = row.getEndOffset();
            if (n2 > n4) continue;
            throw new StateInvariantError("infinite loop in formatting");
        }
    }

    void layoutRow(Row row, int n) {
        View view;
        int n2 = this.tabBase;
        int n3 = this.layoutSpan;
        int n4 = this.getEndOffset();
        while (n < n4 && n3 > 0) {
            view = this.createView(n);
            int n5 = view instanceof TabableView ? (int)((TabableView)((Object)view)).getTabbedSpan(n2, this) : (int)view.getPreferredSpan(0);
            n3 -= n5;
            n2 += n5;
            row.append(view);
            n = view.getEndOffset();
        }
        if (n3 < 0) {
            this.adjustRow(row, this.layoutSpan);
            return;
        }
        if (row.getViewCount() == 0) {
            view = this.createView(n);
            row.append(view);
        }
    }

    protected void adjustRow(Row row, int n) {
        int n2;
        View view;
        int n3 = row.getViewCount();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = -1;
        int n8 = 0;
        while (n8 < n3) {
            view = row.getView(n8);
            int n9 = view.getBreakWeight(0, n4, n2 = n - n4);
            if (n9 >= n5) {
                n5 = n9;
                n7 = n8;
                n6 = n4;
                if (n9 >= 3000) break;
            }
            n4 = (int)((float)n4 + view.getPreferredSpan(0));
            ++n8;
        }
        if (n7 < 0) {
            return;
        }
        n2 = n - n6;
        view = row.getView(n7);
        view = view.breakView(0, view.getStartOffset(), n6, n2);
        View[] viewArray = new View[]{view};
        row.replace(n7, n3 - n7, viewArray);
    }

    View createView(int n) {
        int n2 = this.getElement().getElementIndex(n);
        View view = (View)this.layoutPool.elementAt(n2);
        if (n == view.getStartOffset()) {
            return view;
        }
        view = view.createFragment(n, view.getEndOffset());
        return view;
    }

    public float nextTabStop(float f, int n) {
        int n2;
        f -= (float)this.tabBase;
        TabSet tabSet = StyleConstants.getTabSet(this.getElement().getAttributes());
        if (tabSet == null) {
            return this.tabBase + ((int)f / 72 + 1) * 72;
        }
        TabStop tabStop = tabSet.getTabAfter(f + 0.01f);
        if (tabStop == null) {
            return (float)this.tabBase + f + 5.0f;
        }
        int n3 = tabStop.getAlignment();
        switch (n3) {
            default: {
                return (float)this.tabBase + tabStop.getPosition();
            }
            case 5: {
                return (float)this.tabBase + tabStop.getPosition();
            }
            case 1: 
            case 2: {
                n2 = this.findOffsetToCharactersInString(tabChars, n + 1);
                break;
            }
            case 4: {
                n2 = this.findOffsetToCharactersInString(tabDecimalChars, n + 1);
            }
        }
        if (n2 == -1) {
            n2 = this.getEndOffset();
        }
        float f2 = this.getPartialSize(n + 1, n2);
        switch (n3) {
            case 1: 
            case 4: {
                return (float)this.tabBase + Math.max(f, tabStop.getPosition() - f2);
            }
            case 2: {
                return (float)this.tabBase + Math.max(f, tabStop.getPosition() - f2 / 2.0f);
            }
        }
        return f;
    }

    protected float getPartialSize(int n, int n2) {
        float f = 0.0f;
        int n3 = this.getViewCount();
        int n4 = this.getElement().getElementIndex(n);
        n3 = this.layoutPool.size();
        while (n < n2 && n4 < n3) {
            View view = (View)this.layoutPool.elementAt(n4++);
            int n5 = view.getEndOffset();
            int n6 = Math.min(n2, n5);
            if (view instanceof TabableView) {
                f += ((TabableView)((Object)view)).getPartialSpan(n, n6);
            } else if (n == view.getStartOffset() && n6 == view.getEndOffset()) {
                f += view.getPreferredSpan(0);
            } else {
                return 0.0f;
            }
            n = n5;
        }
        return f;
    }

    protected int findOffsetToCharactersInString(char[] cArray, int n) {
        int n2 = cArray.length;
        int n3 = this.getEndOffset();
        Segment segment = new Segment();
        try {
            this.getDocument().getText(n, n3 - n, segment);
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
        int n4 = segment.offset;
        int n5 = segment.offset + segment.count;
        while (n4 < n5) {
            char c = segment.array[n4];
            int n6 = 0;
            while (n6 < n2) {
                if (c == cArray[n6]) {
                    return n4 - segment.offset + n;
                }
                ++n6;
            }
            ++n4;
        }
        return -1;
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = shape.getBounds();
        this.tabBase = rectangle.x + this.getLeftInset();
        super.paint(graphics, shape);
    }

    public float getPreferredSpan(int n) {
        switch (n) {
            case 0: {
                int n2 = (int)Math.min((long)this.layoutSpan + (long)this.getLeftInset() + (long)this.getRightInset(), Integer.MAX_VALUE);
                if (this.layoutSpan != Integer.MAX_VALUE) {
                    return n2;
                }
                return super.getPreferredSpan(n);
            }
            case 1: {
                return super.getPreferredSpan(n);
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    public float getAlignment(int n) {
        switch (n) {
            case 1: {
                int n2 = (int)this.getPreferredSpan(1);
                View view = this.getView(0);
                int n3 = (int)view.getPreferredSpan(1);
                float f = n2 != 0 ? (float)(n3 / 2) / (float)n2 : 0.0f;
                return f;
            }
        }
        return super.getAlignment(n);
    }

    public int getResizeWeight(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    public View breakView(int n, float f, Shape shape) {
        if (n == 1) {
            if (shape != null) {
                Rectangle rectangle = shape.getBounds();
                this.setSize(rectangle.width, rectangle.height);
            }
            return this;
        }
        return this;
    }

    public int getBreakWeight(int n, float f) {
        if (n == 1) {
            return 0;
        }
        return 0;
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Element element = this.getElement();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        if (elementChange != null) {
            this.updateLogicalChildren(elementChange, viewFactory);
        }
        if (elementChange == null || elementChange.getChildrenRemoved().length == 0) {
            int n = documentEvent.getOffset();
            int n2 = element.getElementIndex(n);
            View view = (View)this.layoutPool.elementAt(n2);
            view.insertUpdate(documentEvent, null, viewFactory);
        }
        this.layoutSpan = Integer.MAX_VALUE;
        this.preferenceChanged(null, false, true);
        Rectangle rectangle = this.getInsideAllocation(shape);
        if (rectangle != null) {
            this.layout(rectangle.width, rectangle.height);
            Container container = this.getContainer();
            container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    void updateLogicalChildren(DocumentEvent.ElementChange elementChange, ViewFactory viewFactory) {
        Object object;
        int n = elementChange.getIndex();
        Element[] elementArray = elementChange.getChildrenRemoved();
        int n2 = 0;
        while (n2 < elementArray.length) {
            object = (View)this.layoutPool.elementAt(n);
            ((View)object).setParent(null);
            this.layoutPool.removeElementAt(n);
            ++n2;
        }
        object = elementChange.getChildrenAdded();
        int n3 = 0;
        while (n3 < ((Element[])object).length) {
            this.layoutPool.insertElementAt(viewFactory.create((Element)object[n3]), n + n3);
            ++n3;
        }
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Element element = this.getElement();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        if (elementChange != null) {
            this.updateLogicalChildren(elementChange, viewFactory);
        }
        if (elementChange == null || elementChange.getChildrenAdded().length == 0) {
            int n = documentEvent.getOffset();
            int n2 = element.getElementIndex(n);
            View view = (View)this.layoutPool.elementAt(n2);
            view.removeUpdate(documentEvent, null, viewFactory);
        }
        this.layoutSpan = Integer.MAX_VALUE;
        this.preferenceChanged(null, false, true);
        if (shape != null) {
            Rectangle rectangle = this.getInsideAllocation(shape);
            this.layout(rectangle.width, rectangle.height);
            Container container = this.getContainer();
            container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Object object;
        AttributeSet attributeSet = this.getElement().getAttributes();
        this.setParagraphInsets(attributeSet);
        this.justification = StyleConstants.getAlignment(attributeSet);
        this.lineSpacing = (int)StyleConstants.getLineSpacing(attributeSet);
        Element element = this.getElement();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        if (elementChange != null) {
            this.updateLogicalChildren(elementChange, viewFactory);
        }
        int n = documentEvent.getOffset();
        int n2 = n + documentEvent.getLength();
        int n3 = element.getElementIndex(n);
        int n4 = element.getElementIndex(n2 - 1);
        int n5 = n3;
        while (n5 <= n4) {
            object = (View)this.layoutPool.elementAt(n5);
            ((View)object).changedUpdate(documentEvent, null, viewFactory);
            ++n5;
        }
        this.layoutSpan = Integer.MAX_VALUE;
        this.preferenceChanged(null, false, true);
        if (shape != null) {
            object = this.getInsideAllocation(shape);
            this.layout(((Rectangle)object).width, ((Rectangle)object).height);
            Container container = this.getContainer();
            container.repaint(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
        }
    }

    static {
        ParagraphView.tabChars[0] = 9;
        tabDecimalChars = new char[2];
        ParagraphView.tabDecimalChars[0] = 9;
        ParagraphView.tabDecimalChars[1] = 46;
    }

    class Row
    extends BoxView {
        Row(Element element) {
            super(element, 0);
            ParagraphView.this = ParagraphView.this;
        }

        protected void loadChildren(ViewFactory viewFactory) {
        }

        public float getAlignment(int n) {
            if (n == 0) {
                switch (ParagraphView.this.justification) {
                    case 0: {
                        return 0.0f;
                    }
                    case 2: {
                        return 1.0f;
                    }
                    case 1: 
                    case 3: {
                        return 0.5f;
                    }
                }
            }
            return super.getAlignment(n);
        }

        public Shape modelToView(int n, Shape shape) throws BadLocationException {
            Rectangle rectangle = shape.getBounds();
            int n2 = rectangle.height;
            int n3 = rectangle.y;
            Shape shape2 = super.modelToView(n, shape);
            rectangle = shape2.getBounds();
            rectangle.height = n2;
            rectangle.y = n3;
            return rectangle;
        }

        public int getStartOffset() {
            int n = this.getViewCount();
            if (n > 0) {
                View view = this.getView(0);
                return view.getStartOffset();
            }
            return -1;
        }

        public int getEndOffset() {
            int n = this.getViewCount();
            if (n > 0) {
                View view = this.getView(n - 1);
                return view.getEndOffset();
            }
            return -1;
        }

        protected View getViewAtPosition(int n, Rectangle rectangle) {
            int n2 = this.getViewCount();
            int n3 = 0;
            while (n3 < n2) {
                View view = this.getView(n3);
                int n4 = view.getStartOffset();
                int n5 = view.getEndOffset();
                if (n >= n4 && n < n5) {
                    this.childAllocation(n3, rectangle);
                    return view;
                }
                ++n3;
            }
            return null;
        }
    }
}

