/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.text;

import com.sun.java.swing.event.DocumentEvent;
import com.sun.java.swing.text.BadLocationException;
import com.sun.java.swing.text.BoxView;
import com.sun.java.swing.text.Caret;
import com.sun.java.swing.text.Document;
import com.sun.java.swing.text.Element;
import com.sun.java.swing.text.JTextComponent;
import com.sun.java.swing.text.Segment;
import com.sun.java.swing.text.StateInvariantError;
import com.sun.java.swing.text.TabExpander;
import com.sun.java.swing.text.Utilities;
import com.sun.java.swing.text.View;
import com.sun.java.swing.text.ViewFactory;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;

public class WrappedPlainView
extends BoxView
implements TabExpander {
    FontMetrics metrics;
    Segment lineBuffer = new Segment();
    int layoutWidth = Short.MAX_VALUE;
    int tabSize;
    int sel0;
    int sel1;
    Color unselected;
    Color selected;

    public WrappedPlainView(Element element) {
        super(element, 1);
    }

    protected int getTabSize() {
        Integer n = (Integer)this.getDocument().getProperty("tabSize");
        int n2 = n != null ? n : 8;
        return n2;
    }

    protected void drawLine(int n, int n2, Graphics graphics, int n3, int n4) {
        try {
            n2 = Math.min(this.getDocument().getLength(), n2);
            if (this.sel0 == this.sel1) {
                this.drawUnselectedText(graphics, n3, n4, n, n2);
                return;
            }
            if (n >= this.sel0 && n <= this.sel1 && n2 >= this.sel0 && n2 <= this.sel1) {
                this.drawSelectedText(graphics, n3, n4, n, n2);
                return;
            }
            if (this.sel0 >= n && this.sel0 <= n2) {
                if (this.sel1 >= n && this.sel1 <= n2) {
                    n3 = this.drawUnselectedText(graphics, n3, n4, n, this.sel0);
                    n3 = this.drawSelectedText(graphics, n3, n4, this.sel0, this.sel1);
                    this.drawUnselectedText(graphics, n3, n4, this.sel1, n2);
                    return;
                }
                n3 = this.drawUnselectedText(graphics, n3, n4, n, this.sel0);
                this.drawSelectedText(graphics, n3, n4, this.sel0, n2);
                return;
            }
            if (this.sel1 >= n && this.sel1 <= n2) {
                n3 = this.drawSelectedText(graphics, n3, n4, n, this.sel1);
                this.drawUnselectedText(graphics, n3, n4, this.sel1, n2);
                return;
            }
            this.drawUnselectedText(graphics, n3, n4, n, n2);
            return;
        }
        catch (BadLocationException badLocationException) {
            throw new StateInvariantError("Can't render: " + n + "," + n2);
        }
    }

    protected int drawUnselectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        graphics.setColor(this.unselected);
        Document document = this.getDocument();
        document.getText(n3, n4 - n3, this.lineBuffer);
        return Utilities.drawTabbedText(this.lineBuffer, n, n2, graphics, this, n3);
    }

    protected int drawSelectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        graphics.setColor(this.selected);
        Document document = this.getDocument();
        document.getText(n3, n4 - n3, this.lineBuffer);
        return Utilities.drawTabbedText(this.lineBuffer, n, n2, graphics, this, n3);
    }

    protected final Segment getLineBuffer() {
        return this.lineBuffer;
    }

    protected void loadChildren(ViewFactory viewFactory) {
        Element element = this.getElement();
        int n = element.getElementCount();
        if (n > 0) {
            View[] viewArray = new View[n];
            int n2 = 0;
            while (n2 < n) {
                viewArray[n2] = new WrappedLine(element.getElement(n2));
                ++n2;
            }
            this.replace(0, 0, viewArray);
        }
    }

    void updateChildren(DocumentEvent documentEvent, Shape shape) {
        Element element = this.getElement();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        if (elementChange != null) {
            Element[] elementArray = elementChange.getChildrenRemoved();
            Element[] elementArray2 = elementChange.getChildrenAdded();
            View[] viewArray = new View[elementArray2.length];
            int n = 0;
            while (n < elementArray2.length) {
                viewArray[n] = new WrappedLine(elementArray2[n]);
                ++n;
            }
            this.replace(elementChange.getIndex(), elementArray.length, viewArray);
            if (shape != null) {
                this.preferenceChanged(null, true, true);
                this.getContainer().repaint();
            }
        }
        this.updateMetrics();
    }

    final void updateMetrics() {
        Container container = this.getContainer();
        Font font = container.getFont();
        this.metrics = container.getFontMetrics(font);
        this.tabSize = this.getTabSize() * this.metrics.charWidth('m');
    }

    public float nextTabStop(float f, int n) {
        int n2 = (int)f / this.tabSize;
        return (n2 + 1) * this.tabSize;
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = shape.getBounds();
        if (rectangle.width != this.layoutWidth) {
            this.layoutWidth = rectangle.width;
            this.preferenceChanged(null, true, true);
        }
        JTextComponent jTextComponent = (JTextComponent)this.getContainer();
        this.sel0 = jTextComponent.getSelectionStart();
        this.sel1 = jTextComponent.getSelectionEnd();
        this.unselected = jTextComponent.isEnabled() ? jTextComponent.getForeground() : jTextComponent.getDisabledTextColor();
        Caret caret = jTextComponent.getCaret();
        this.selected = caret.isSelectionVisible() ? jTextComponent.getSelectedTextColor() : this.unselected;
        this.updateMetrics();
        graphics.setFont(jTextComponent.getFont());
        super.paint(graphics, shape);
    }

    public void setSize(float f, float f2) {
        this.updateMetrics();
        super.setSize(f, f2);
    }

    public float getPreferredSpan(int n) {
        this.updateMetrics();
        return super.getPreferredSpan(n);
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateChildren(documentEvent, shape);
        Rectangle rectangle = shape != null && this.isAllocationValid() ? this.getInsideAllocation(shape) : null;
        int n = documentEvent.getOffset();
        View view = this.getViewAtPosition(n, rectangle);
        if (view != null) {
            view.insertUpdate(documentEvent, rectangle, viewFactory);
        }
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateChildren(documentEvent, shape);
        Rectangle rectangle = shape != null && this.isAllocationValid() ? this.getInsideAllocation(shape) : null;
        int n = documentEvent.getOffset();
        View view = this.getViewAtPosition(n, rectangle);
        if (view != null) {
            view.removeUpdate(documentEvent, rectangle, viewFactory);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateChildren(documentEvent, shape);
    }

    class WrappedLine
    extends View {
        int nlines;

        WrappedLine(Element element) {
            super(element);
            WrappedPlainView.this = WrappedPlainView.this;
        }

        final void loadText(int n, int n2) {
            try {
                Document document = this.getDocument();
                document.getText(n, n2 - n, WrappedPlainView.this.lineBuffer);
                return;
            }
            catch (BadLocationException badLocationException) {
                throw new StateInvariantError("Can't get line text");
            }
        }

        final int calculateLineCount() {
            int n = 0;
            int n2 = this.getEndOffset();
            int n3 = this.getStartOffset();
            while (n3 < n2) {
                ++n;
                this.loadText(n3, n2);
                int n4 = n3 + Utilities.getTabbedTextOffset(WrappedPlainView.this.lineBuffer, WrappedPlainView.this.metrics, 0, WrappedPlainView.this.layoutWidth, WrappedPlainView.this, n3);
                int n5 = n3 = n4 == n3 ? n2 : n4;
            }
            return n;
        }

        public float getPreferredSpan(int n) {
            switch (n) {
                case 0: {
                    return WrappedPlainView.this.layoutWidth;
                }
                case 1: {
                    this.nlines = this.calculateLineCount();
                    int n2 = this.nlines * WrappedPlainView.this.metrics.getHeight();
                    return n2;
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + n);
        }

        public void paint(Graphics graphics, Shape shape) {
            Rectangle rectangle = shape.getBounds();
            int n = rectangle.y + WrappedPlainView.this.metrics.getAscent();
            int n2 = rectangle.x;
            int n3 = this.getEndOffset();
            int n4 = this.getStartOffset();
            while (n4 < n3) {
                this.loadText(n4, n3);
                int n5 = n4 + Utilities.getTabbedTextOffset(WrappedPlainView.this.lineBuffer, WrappedPlainView.this.metrics, n2, WrappedPlainView.this.layoutWidth, WrappedPlainView.this, n4);
                WrappedPlainView.this.drawLine(n4, n5, graphics, n2, n);
                n4 = n5 == n4 ? n3 : n5;
                n += WrappedPlainView.this.metrics.getHeight();
            }
        }

        public Shape modelToView(int n, Shape shape) throws BadLocationException {
            Rectangle rectangle = shape.getBounds();
            rectangle.height = WrappedPlainView.this.metrics.getHeight();
            rectangle.width = 1;
            int n2 = this.getEndOffset();
            int n3 = this.getStartOffset();
            while (n3 < n2) {
                this.loadText(n3, n2);
                int n4 = n3 + Utilities.getTabbedTextOffset(WrappedPlainView.this.lineBuffer, WrappedPlainView.this.metrics, rectangle.x, rectangle.x + WrappedPlainView.this.layoutWidth, WrappedPlainView.this, n3);
                if (n >= n3 && n < n4) {
                    this.loadText(n3, n);
                    rectangle.x += Utilities.getTabbedTextWidth(WrappedPlainView.this.lineBuffer, WrappedPlainView.this.metrics, rectangle.x, WrappedPlainView.this, n3);
                    return rectangle;
                }
                n3 = n4 == n3 ? n2 : n4;
                rectangle.y += rectangle.height;
            }
            throw new BadLocationException(null, n);
        }

        public int viewToModel(float f, float f2, Shape shape) {
            Rectangle rectangle = shape.getBounds();
            this.getDocument();
            int n = (int)f;
            int n2 = (int)f2;
            if (n2 < rectangle.y) {
                return this.getStartOffset();
            }
            if (n2 > rectangle.y + rectangle.height) {
                return this.getEndOffset() - 1;
            }
            rectangle.height = WrappedPlainView.this.metrics.getHeight();
            int n3 = this.getEndOffset();
            int n4 = this.getStartOffset();
            while (n4 < n3) {
                this.loadText(n4, n3);
                int n5 = n4 + Utilities.getTabbedTextOffset(WrappedPlainView.this.lineBuffer, WrappedPlainView.this.metrics, rectangle.x, rectangle.x + WrappedPlainView.this.layoutWidth, WrappedPlainView.this, n4);
                if (n2 >= rectangle.y && n2 < rectangle.y + rectangle.height) {
                    if (n < rectangle.x) {
                        return n4;
                    }
                    if (n > rectangle.x + rectangle.width) {
                        return n5;
                    }
                    int n6 = Utilities.getTabbedTextOffset(WrappedPlainView.this.lineBuffer, WrappedPlainView.this.metrics, rectangle.x, n, WrappedPlainView.this, n4);
                    return Math.min(n4 + n6, n3 - 1);
                }
                n4 = n5 == n4 ? n3 : n5;
                rectangle.y += rectangle.height;
            }
            return this.getEndOffset() - 1;
        }

        public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            int n = this.calculateLineCount();
            if (this.nlines != n) {
                this.nlines = n;
                WrappedPlainView.this.preferenceChanged(this, false, true);
                return;
            }
            if (shape != null) {
                Container container = this.getContainer();
                Rectangle rectangle = shape.getBounds();
                container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            int n = this.calculateLineCount();
            if (this.nlines != n) {
                this.nlines = n;
                WrappedPlainView.this.preferenceChanged(this, false, true);
                return;
            }
            if (shape != null) {
                Container container = this.getContainer();
                Rectangle rectangle = shape.getBounds();
                container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }
}

