/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.text.html;

import com.sun.java.swing.text.ComponentView;
import com.sun.java.swing.text.Element;
import com.sun.java.swing.text.LabelView;
import com.sun.java.swing.text.ParagraphView;
import com.sun.java.swing.text.TableView;
import com.sun.java.swing.text.View;
import com.sun.java.swing.text.ViewFactory;
import com.sun.java.swing.text.html.HRuleView;
import com.sun.java.swing.text.html.HTMLBoxView;
import com.sun.java.swing.text.html.HTMLDefs;
import com.sun.java.swing.text.html.HTMLRootView;
import com.sun.java.swing.text.html.ImageView;
import com.sun.java.swing.text.html.LineView;
import com.sun.java.swing.text.html.ListView;

class HTMLFactory
implements ViewFactory,
HTMLDefs {
    public View create(Element element) {
        String string = element.getName();
        if (string != null) {
            String string2 = string.intern();
            if (string2 == "content") {
                return new LabelView(element);
            }
            if (string2 == "paragraph" || string2 == "dt") {
                return new ParagraphView(element);
            }
            if (string2 == "menu" || string2 == "dir" || string2 == "ul" || string2 == "ol") {
                return new ListView(element);
            }
            if (string2 == "section") {
                return new HTMLRootView(element, 1);
            }
            if (string2 == "pre-line") {
                return new LineView(element);
            }
            if (string2 == "li" || string2 == "dl" || string2 == "dd" || string2 == "pre") {
                return new HTMLBoxView(element, 1);
            }
            if (string2 == "form") {
                return new HTMLBoxView(element, 0);
            }
            if (string2 == "component") {
                return new ComponentView(element);
            }
            if (string2 == "img") {
                return new ImageView(element);
            }
            if (string2 == "hr") {
                return new HRuleView(element);
            }
            if (string2 == "table") {
                return new TableView(element);
            }
        }
        System.err.println("don't know how to build a: " + string);
        return null;
    }

    HTMLFactory() {
    }
}

