/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.text.html;

import com.sun.java.swing.text.Style;
import com.sun.java.swing.text.StyleConstants;
import com.sun.java.swing.text.html.HTMLDefs;
import java.util.StringTokenizer;

class StyleSheet
implements HTMLDefs {
    public static final int DEFAULT_FONT_SIZE = 3;
    private int baseFontIndex;
    private int baseFontSize;
    private int docPtSize;
    private int docIndex;
    static int[] sizeMap;

    public StyleSheet(Style style) {
        this.docPtSize = StyleConstants.getFontSize(style);
        this.baseFontIndex = StyleSheet.getIndexOfSize(this.docPtSize);
        this.baseFontSize = 3;
        this.setPtSize(this.docPtSize);
    }

    public StyleSheet() {
        this.docPtSize = 12;
        this.baseFontIndex = StyleSheet.getIndexOfSize(this.docPtSize);
        this.baseFontSize = 3;
        this.setPtSize(this.docPtSize);
    }

    public void setFontSizes(String string) {
        int[] nArray = new int[32];
        StringTokenizer stringTokenizer = new StringTokenizer(string, ". \t\n");
        int n = 0;
        while (n < nArray.length && stringTokenizer.hasMoreTokens()) {
            nArray[n++] = Integer.valueOf(stringTokenizer.nextToken());
        }
        sizeMap = new int[n];
        System.arraycopy(nArray, 0, sizeMap, 0, n);
        this.baseFontIndex = StyleSheet.getIndexOfSize(this.docPtSize);
        this.setPtSize(this.docPtSize);
    }

    public void setBaseFontSize(int n) {
        this.baseFontSize = n < 1 ? 0 : (n > 7 ? 7 : n);
        int n2 = this.baseFontSize - 3;
        this.baseFontIndex = this.docIndex + n2;
        if (this.baseFontIndex > sizeMap.length - 1) {
            this.baseFontIndex = sizeMap.length - 1;
            return;
        }
        if (this.baseFontIndex < 0) {
            this.baseFontIndex = 0;
        }
    }

    public void setBaseFontSize(String string) {
        if (string != null) {
            if (string.startsWith("+")) {
                int n = Integer.valueOf(string.substring(1));
                int n2 = 3 - (this.baseFontSize + n);
                this.baseFontIndex = this.docIndex + n2;
            } else if (string.startsWith("-")) {
                int n = -Integer.valueOf(string.substring(1)).intValue();
                int n3 = 3 - (this.baseFontSize + n);
                this.baseFontIndex = this.docIndex + n3;
            } else {
                this.setBaseFontSize(Integer.valueOf(string));
                int n = this.baseFontSize - 3;
                this.baseFontIndex = this.docIndex + n;
            }
        }
        if (this.baseFontIndex > sizeMap.length - 1) {
            this.baseFontIndex = sizeMap.length - 1;
            return;
        }
        if (this.baseFontIndex < 0) {
            this.baseFontIndex = 0;
        }
    }

    public static int getIndexOfSize(int n) {
        int n2 = 0;
        while (n2 < sizeMap.length) {
            if (n <= sizeMap[n2]) {
                return n2;
            }
            ++n2;
        }
        return sizeMap.length - 1;
    }

    public int getPtSize(int n) {
        if (n < 0) {
            return sizeMap[0];
        }
        if (n > sizeMap.length - 1) {
            return sizeMap[sizeMap.length - 1];
        }
        return sizeMap[n];
    }

    public int getPtSize(String string) {
        if (string != null) {
            int n;
            if (string.startsWith("+")) {
                int n2 = Integer.valueOf(string.substring(1));
                int n3 = this.baseFontSize + n2 - 3;
                n = this.docIndex + n3;
            } else if (string.startsWith("-")) {
                int n4 = -Integer.valueOf(string.substring(1)).intValue();
                int n5 = this.baseFontSize + n4 - 3;
                n = this.docIndex + n5;
            } else {
                int n6 = Integer.valueOf(string);
                int n7 = n6 - 3;
                n = this.docIndex + n7;
            }
            if (n > sizeMap.length - 1) {
                n = sizeMap.length - 1;
            } else if (n < 0) {
                n = 0;
            }
            return sizeMap[n];
        }
        return sizeMap[this.baseFontIndex];
    }

    public void setPtSize(int n) {
        this.docPtSize = n;
        this.docIndex = StyleSheet.getIndexOfSize(this.docPtSize);
        int n2 = this.baseFontSize - 3;
        this.baseFontIndex = this.docIndex + n2;
    }

    public int getBigger(int n) {
        int n2 = StyleSheet.getIndexOfSize(n);
        n2 = n2 + 1 > sizeMap.length - 1 ? sizeMap.length - 1 : ++n2;
        return sizeMap[n2];
    }

    public int getSmaller(int n) {
        int n2 = StyleSheet.getIndexOfSize(n);
        n2 = n2 - 1 < 0 ? 0 : --n2;
        return sizeMap[n2];
    }

    public int getRelSize(int n) {
        int n2 = StyleSheet.getIndexOfSize(n);
        return n2 - this.baseFontIndex;
    }

    static {
        int[] nArray = new int[32];
        String string = "7,8,9,10,12,14,16,18,20,22,24,26,28";
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", \t\n");
        int n = 0;
        while (n < nArray.length && stringTokenizer.hasMoreTokens()) {
            nArray[n++] = Integer.valueOf(stringTokenizer.nextToken());
        }
        sizeMap = new int[n];
        System.arraycopy(nArray, 0, sizeMap, 0, n);
    }
}

