/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.text.html;

import com.sun.java.swing.text.AttributeSet;
import com.sun.java.swing.text.Style;
import com.sun.java.swing.text.StyleConstants;
import com.sun.java.swing.text.html.HTMLDebug;
import com.sun.java.swing.text.html.HTMLDefs;
import com.sun.java.swing.text.html.HTMLException;
import com.sun.java.swing.text.html.HTMLUtils;
import com.sun.java.swing.text.html.StyleDefs;
import com.sun.java.swing.text.html.StyleSheet;
import java.awt.Color;
import java.util.StringTokenizer;

class StyleXlater
implements HTMLDefs,
StyleDefs {
    public static void translateProperty(StyleSheet styleSheet, Style style, String string, String string2) {
        HTMLDebug.println("StyleXlater:translateProperty - name = " + string + "    value = " + string2);
        String string3 = HTMLUtils.removeSurroundingQuotes(string2);
        if (string.equalsIgnoreCase("font-family")) {
            if (string3.equalsIgnoreCase("monospace") || string3.equalsIgnoreCase("monospaced") || string3.equalsIgnoreCase("typewriter")) {
                StyleConstants.setFontFamily(style, "Monospaced");
                return;
            }
            StyleConstants.setFontFamily(style, string3);
            return;
        }
        if (string.equalsIgnoreCase("font-size")) {
            StyleXlater.setFontSize(string3, style, styleSheet);
            return;
        }
        if (string.equalsIgnoreCase("font-weight")) {
            StyleXlater.setFontStyle(string3, style);
            return;
        }
        if (string.equalsIgnoreCase("font-style")) {
            StyleXlater.setFontStyle(string3, style);
            return;
        }
        if (string.equalsIgnoreCase("margin-top")) {
            StyleConstants.setSpaceAbove(style, Integer.valueOf(string3).intValue());
            return;
        }
        if (string.equalsIgnoreCase("margin-bottom")) {
            StyleConstants.setSpaceBelow(style, Integer.valueOf(string3).intValue());
            return;
        }
        if (string.equalsIgnoreCase("margin-left")) {
            StyleConstants.setLeftIndent(style, Integer.valueOf(string3).intValue());
            return;
        }
        if (string.equalsIgnoreCase("margin-right")) {
            StyleConstants.setRightIndent(style, Integer.valueOf(string3).intValue());
            return;
        }
        if (string.equalsIgnoreCase("text-decoration")) {
            StyleXlater.setTextDecoration(string3, style);
            return;
        }
        if (string.equalsIgnoreCase("text-align")) {
            StyleXlater.setTextAlignment(string3, style);
            return;
        }
        if (string.equalsIgnoreCase("color")) {
            StyleXlater.setForegroundColor(string3, style);
            return;
        }
        if (string.equalsIgnoreCase("list-style-type") || string.equalsIgnoreCase("list-style-image")) {
            style.addAttribute(string.toLowerCase(), string3);
            return;
        }
        if (string.equalsIgnoreCase("font-sizes")) {
            styleSheet.setFontSizes(string3);
            return;
        }
        style.addAttribute(string.toLowerCase(), string3);
        HTMLDebug.println("StyleXlater - Warning! Unimplemented attribute: " + string);
    }

    static String convertFontSizeString(String string) {
        if (string.equalsIgnoreCase("xx-small") || string.equalsIgnoreCase("xxsmall")) {
            return "-3";
        }
        if (string.equalsIgnoreCase("x-small") || string.equalsIgnoreCase("xsmall")) {
            return "-2";
        }
        if (string.equalsIgnoreCase("small")) {
            return "-1";
        }
        if (string.equalsIgnoreCase("medium")) {
            return "+0";
        }
        if (string.equalsIgnoreCase("large")) {
            return "+1";
        }
        if (string.equalsIgnoreCase("x-large") || string.equalsIgnoreCase("xlarge")) {
            return "+2";
        }
        if (string.equalsIgnoreCase("xx-large") || string.equalsIgnoreCase("xxlarge")) {
            return "+3";
        }
        System.out.println("StyleXlater.convertFontSizeString - Warning!  Unimplemented font size value: " + string);
        return "0";
    }

    static void setFontStyle(String string, Style style) {
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase("bold") || string.equals("bolder")) {
            StyleConstants.setBold(style, true);
            return;
        }
        if (string.equalsIgnoreCase("italic")) {
            StyleConstants.setItalic(style, true);
            return;
        }
        if (string.equalsIgnoreCase("typewriter") || string.equalsIgnoreCase("monospace") || string.equalsIgnoreCase("monospaced")) {
            StyleConstants.setFontFamily(style, "Monospaced");
            return;
        }
        if (string.equalsIgnoreCase("bolditalic")) {
            StyleConstants.setBold(style, true);
            StyleConstants.setItalic(style, true);
            return;
        }
        if (!string.equalsIgnoreCase("normal")) {
            if (string.equalsIgnoreCase("light") || string.equals("lighter") || string.equalsIgnoreCase("oblique")) {
                HTMLDebug.println("StyleXlater.setFontStyle: Unsupported font style:" + string);
                return;
            }
            HTMLDebug.println("StyleXlater.setFontStyle: Unimplemented font style:" + string);
        }
    }

    static void setTextDecoration(String string, Style style) {
        if (string.equalsIgnoreCase("underline")) {
            StyleConstants.setUnderline(style, true);
        }
    }

    static void setTextAlignment(String string, Style style) {
        if (string.equalsIgnoreCase("left")) {
            StyleConstants.setAlignment(style, 0);
            return;
        }
        if (string.equalsIgnoreCase("center")) {
            StyleConstants.setAlignment(style, 1);
            return;
        }
        if (string.equalsIgnoreCase("right")) {
            StyleConstants.setAlignment(style, 2);
            return;
        }
        if (string.equalsIgnoreCase("justify")) {
            StyleConstants.setAlignment(style, 3);
            return;
        }
        System.out.println("HTMXlater.translateProperty:  Unsupported property value: " + string);
    }

    static void setForegroundColor(String string, Style style) {
        if (string.startsWith("#")) {
            Color color;
            try {
                color = HTMLUtils.stringToColor(string);
            }
            catch (HTMLException hTMLException) {
                System.out.println("StyleXlater.translateProperty: " + string + " " + hTMLException);
                return;
            }
            StyleConstants.setForeground(style, color);
            return;
        }
        if (string.startsWith("rgb") || string.startsWith("RGB")) {
            int n = string.indexOf("(");
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n + 1, string.length() - 1), ", \t \n");
            int n2 = 0;
            int[] nArray = new int[3];
            while (n2 < nArray.length && stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                nArray[n2] = string2.endsWith("%") ? Integer.valueOf(string2.substring(0, string2.length() - 1)) * 255 / 100 : Integer.valueOf(string2);
                ++n2;
            }
            if (n2 == 3) {
                Color color = new Color(nArray[0], nArray[1], nArray[2]);
                StyleConstants.setForeground(style, color);
                return;
            }
        } else {
            Color color;
            try {
                color = HTMLUtils.stringToColor(string);
            }
            catch (HTMLException hTMLException) {
                System.out.println("StyleXlater.translateProperty: " + string + " " + hTMLException);
                return;
            }
            StyleConstants.setForeground(style, color);
        }
    }

    static void setFontSize(String string, Style style, StyleSheet styleSheet) {
        String string2;
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "0123456789");
        if (stringTokenizer.countTokens() == 0) {
            n = Integer.valueOf(string);
            StyleConstants.setFontSize(style, n);
        } else if ((string.startsWith("+") || string.startsWith("-")) && string.endsWith("pt")) {
            System.out.println("StyleXlater.translateAttribute: Unimplemented font-size value " + string);
        } else if (string.toLowerCase().endsWith("pt")) {
            n = Integer.valueOf(string.substring(0, string.length() - 2));
            StyleConstants.setFontSize(style, n);
        } else {
            string2 = StyleXlater.convertFontSizeString(string);
            n = styleSheet.getPtSize(string2);
            StyleConstants.setFontSize(style, n);
        }
        string2 = (String)style.getAttribute(AttributeSet.NameAttribute);
        if (n != 0 && string2 != null && (string2.equals("body") || string2.equals("default"))) {
            styleSheet.setPtSize(n);
        }
    }
}

