/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.applet.AudioClip;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import sun.applet.AppletAudioClip;
import sun.applet.AppletClassEntry;
import sun.applet.AppletClassLoader;
import sun.applet.AppletImageRef;
import sun.applet.AppletSecurityException;
import sun.misc.Ref;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.tools.jar.JarImageSource;
import sun.tools.jar.JarVerifierStream;

public class AppletResourceLoader {
    static boolean debug;
    static boolean verboseResourceLoading;
    private static Hashtable imgHash;
    private static Hashtable audioHash;
    private static Hashtable resourceHash;
    private static Hashtable mimeHash;
    AppletClassLoader loader;

    private void verbose(String string) {
        if (verboseResourceLoading) {
            System.out.println(string);
        }
    }

    static void debug(String string) {
        if (debug) {
            System.out.println(string);
        }
    }

    static void debug(String string, Throwable throwable) {
        if (debug) {
            throwable.printStackTrace();
        }
        System.out.println("sun.applet.AppletResourceLoader:::" + string);
    }

    public AppletResourceLoader(AppletClassLoader appletClassLoader) {
        this.loader = appletClassLoader;
    }

    void loadJar(URL uRL, String string) throws IOException {
        URL uRL2 = AppletClassLoader.makeRelativeURLWithSecurity(uRL, string);
        URLConnection uRLConnection = uRL2.openConnection();
        InputStream inputStream = HttpURLConnection.openConnectionCheckRedirects(uRLConnection);
        this.loadJar(uRL, inputStream);
    }

    public void loadJar(URL uRL, InputStream inputStream) throws IOException {
        JarVerifierStream jarVerifierStream = null;
        Hashtable hashtable = new Hashtable();
        byte[] byArray = new byte[8192];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        try {
            try {
                jarVerifierStream = new JarVerifierStream(inputStream);
                ZipEntry zipEntry = null;
                while ((zipEntry = jarVerifierStream.getNextEntry()) != null) {
                    Object object;
                    int n;
                    String string = zipEntry.getName();
                    String string2 = null;
                    Object object2 = null;
                    byteArrayOutputStream.reset();
                    while ((n = jarVerifierStream.read(byArray, 0, byArray.length)) != -1) {
                        byteArrayOutputStream.write(byArray, 0, n);
                    }
                    byte[] byArray2 = byteArrayOutputStream.toByteArray();
                    if (string2 == null) {
                        string2 = this.guessManifestType(string);
                    }
                    if (string2 == null) {
                        object = new ByteArrayInputStream(byArray2);
                        string2 = URLConnection.guessContentTypeFromStream((InputStream)object);
                    }
                    if (string2 == null) {
                        string2 = "input-stream/input-stream";
                    }
                    AppletResourceLoader.debug("loading " + string + " (most likely guessed mime-type: " + string2 + ")");
                    if (string2.startsWith("image")) {
                        this.putLocalResource(new URL(uRL, string), byArray2, string2);
                    } else if (string2.startsWith("audio")) {
                        this.putLocalResource(new URL(uRL, string), byArray2, string2);
                        object = new AppletAudioClip(byArray2);
                        audioHash.put(new URL(uRL, string), object);
                        object2 = object;
                    } else if (string2.startsWith("application/java-vm") || string2.startsWith("application/x-java-vm")) {
                        this.markLocalClass(new URL(uRL, string));
                        object = string.substring(0, string.length() - 6).replace('/', '.');
                        AppletClassEntry appletClassEntry = this.loader.defineClassFromBytes((String)object, byArray2, 0, byArray2.length);
                        object2 = appletClassEntry;
                        appletClassEntry.ids = jarVerifierStream.getIdentities(string);
                    } else if (!string2.equals("manifest/manifest") && !string2.equals("manifest/signature-bin")) {
                        this.putLocalResource(new URL(uRL, string), byArray2, string2);
                    }
                    if (object2 == null) continue;
                    hashtable.put(string, object2);
                    object2 = null;
                }
            }
            catch (IOException iOException) {
                AppletResourceLoader.debug("IOException loading archive: " + iOException);
                iOException.printStackTrace();
            }
            Object var8_16 = null;
        }
        catch (Throwable throwable) {
            block17: {
                Object var8_17 = null;
                AppletResourceLoader.debug("Closing jar input stream");
                if (jarVerifierStream == null) break block17;
                jarVerifierStream.close();
            }
            throw throwable;
        }
        AppletResourceLoader.debug("Closing jar input stream");
        if (jarVerifierStream != null) {
            jarVerifierStream.close();
        }
    }

    String guessManifestType(String string) {
        if ((string = string.toUpperCase()).startsWith("/")) {
            string = string.substring(1);
        }
        if (!string.startsWith("META-INF/")) {
            return null;
        }
        if (string.equalsIgnoreCase("META-INF/MANIFEST.MF")) {
            return "manifest/manifest";
        }
        if (string.endsWith("DSA") || string.endsWith("PK7") || string.endsWith("PGP")) {
            return "manifest/signature-bin";
        }
        if (string.endsWith("SF")) {
            return "manifest/signature-asc";
        }
        return null;
    }

    public static synchronized AudioClip getAudioClip(URL uRL) {
        System.getSecurityManager().checkConnect(uRL.getHost(), uRL.getPort());
        AudioClip audioClip = (AudioClip)audioHash.get(uRL);
        if (audioClip == null) {
            audioClip = new AppletAudioClip(uRL);
            audioHash.put(uRL, audioClip);
        }
        return audioClip;
    }

    public static void flushAudioClips() {
        audioHash = new Hashtable();
    }

    Image createImage(byte[] byArray, URL uRL, String string, String string2) throws MalformedURLException {
        AppletResourceLoader.debug("creating image: " + string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(byArray));
        JarImageSource jarImageSource = new JarImageSource(uRL, bufferedInputStream, string2);
        Image image = Toolkit.getDefaultToolkit().createImage(jarImageSource);
        URL uRL2 = new URL(uRL, string);
        AppletImageRef appletImageRef = new AppletImageRef(uRL2);
        appletImageRef.setThing(image);
        imgHash.put(uRL2, appletImageRef);
        return image;
    }

    public static synchronized Image getImage(URL uRL) {
        return (Image)AppletResourceLoader.getImageRef(uRL).get();
    }

    public static synchronized Ref getImageRef(URL uRL) {
        System.getSecurityManager().checkConnect(uRL.getHost(), uRL.getPort());
        AppletImageRef appletImageRef = (AppletImageRef)imgHash.get(uRL);
        if (appletImageRef == null) {
            appletImageRef = new AppletImageRef(uRL);
            imgHash.put(uRL, appletImageRef);
        }
        return appletImageRef;
    }

    public static void flushImages() {
        imgHash = new Hashtable();
    }

    private void markLocalClass(URL uRL) {
        resourceHash.put(uRL, "A CLASS FILE");
        mimeHash.put(uRL, "application/java-vm");
    }

    private void putLocalResource(URL uRL, byte[] byArray, String string) {
        resourceHash.put(uRL, byArray);
        mimeHash.put(uRL, string);
    }

    public static synchronized Object getLocalResource(URL uRL) {
        System.getSecurityManager().checkConnect(uRL.getHost(), uRL.getPort());
        Object object = mimeHash.get(uRL);
        if (object == null) {
            return null;
        }
        String string = (String)object;
        if (string.startsWith("audio") && (object = audioHash.get(uRL)) != null) {
            return object;
        }
        object = resourceHash.get(uRL);
        if (object instanceof String) {
            throw new AppletSecurityException("getresource.noclassaccess", uRL.toString());
        }
        byte[] byArray = (byte[])object;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(byArray));
        if (string.startsWith("image")) {
            JarImageSource jarImageSource = new JarImageSource(uRL, bufferedInputStream, string);
            return jarImageSource;
        }
        return bufferedInputStream;
    }

    public static InputStream getLocalResourceStream(URL uRL) {
        System.getSecurityManager().checkConnect(uRL.getHost(), uRL.getPort());
        Object object = null;
        object = resourceHash.get(uRL);
        if (object != null) {
            if (object instanceof String) {
                throw new AppletSecurityException("getresource.noclassaccess", uRL.toString());
            }
            byte[] byArray = (byte[])object;
            object = new BufferedInputStream(new ByteArrayInputStream(byArray));
            return (InputStream)object;
        }
        return null;
    }

    public String getResourceAsName(String string) {
        URL uRL;
        this.verbose("AppletResourceLoader.getResourceAsName for name: " + string);
        URL uRL2 = this.loader.getCodeBase();
        try {
            uRL = new URL(uRL2, string);
        }
        catch (Exception exception) {
            return null;
        }
        Object object = resourceHash.get(uRL);
        if (object != null) {
            this.verbose("Found resource: " + string + " in some jar archive for base: " + uRL2);
            try {
                uRL = new URL("appletresource", uRL2.getHost(), uRL2.getPort(), "/" + uRL2.toExternalForm() + "/+/" + string);
                return uRL.toExternalForm();
            }
            catch (Exception exception) {
                this.verbose("Exception " + exception + " while building a resource URL");
                return null;
            }
        }
        return uRL.toExternalForm();
    }

    public InputStream getResourceAsStream(String string) {
        URL uRL;
        this.verbose("AppletResourceLoader.getResourceAsStream for name: " + string);
        URL uRL2 = this.loader.getCodeBase();
        try {
            uRL = new URL(uRL2, string);
        }
        catch (Exception exception) {
            return null;
        }
        InputStream inputStream = AppletResourceLoader.getLocalResourceStream(uRL);
        if (inputStream != null) {
            this.verbose("Found resource: " + string + " in jar archive file");
            return inputStream;
        }
        this.verbose("Opening stream to: " + uRL + " to get resource " + string);
        try {
            URLConnection uRLConnection = uRL.openConnection();
            if (uRLConnection instanceof java.net.HttpURLConnection) {
                java.net.HttpURLConnection httpURLConnection = (java.net.HttpURLConnection)uRLConnection;
                int n = httpURLConnection.getResponseCode();
                if (n == 200) {
                    inputStream = uRL.openStream();
                }
                if (n >= 400) {
                    inputStream = null;
                }
            } else {
                inputStream = uRL.openStream();
            }
        }
        catch (Exception exception) {
            return null;
        }
        return inputStream;
    }

    void resetLocalResources() {
        resourceHash.clear();
    }

    static {
        imgHash = new Hashtable();
        audioHash = new Hashtable();
        resourceHash = new Hashtable();
        mimeHash = new Hashtable();
    }
}

