/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalException;
import java.rmi.RemoteException;
import java.rmi.server.LogStream;
import java.rmi.server.RMISocketFactory;
import java.util.Enumeration;
import java.util.Vector;
import sun.rmi.transport.Channel;
import sun.rmi.transport.Connection;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.Notifiable;
import sun.rmi.transport.RMIThread;
import sun.rmi.transport.Utils;
import sun.rmi.transport.tcp.ConnectionAcceptor;
import sun.rmi.transport.tcp.ConnectionMultiplexer;
import sun.rmi.transport.tcp.TCPConnection;
import sun.rmi.transport.tcp.TCPEndpoint;
import sun.rmi.transport.tcp.TCPTransport;

public class TCPChannel
implements Channel,
Runnable {
    private TCPEndpoint ep;
    private TCPTransport tr;
    private Vector notifyList = new Vector();
    private Vector freeList = new Vector();
    private Reaper reaper;
    private boolean usingMultiplexer = false;
    private ConnectionMultiplexer multiplexer;
    private ConnectionAcceptor acceptor;
    private static long timeout = Utils.getLong("sun.rmi.transport.connectionTimeout", 15000L);

    TCPChannel(TCPTransport tCPTransport, TCPEndpoint tCPEndpoint) {
        this.tr = tCPTransport;
        this.ep = tCPEndpoint;
    }

    public Endpoint getEndpoint() {
        return this.ep;
    }

    public Connection newConnection() throws RemoteException {
        TCPConnection tCPConnection;
        Object object = this.freeList;
        synchronized (object) {
            if (this.freeList.size() > 0) {
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    securityManager.checkConnect(this.ep.getHost(), this.ep.getPort());
                }
                TCPConnection tCPConnection2 = (TCPConnection)this.freeList.lastElement();
                this.freeList.removeElementAt(this.freeList.size() - 1);
                if (TCPTransport.logLevel >= 10) {
                    LogStream.log("tcp").println("TCPChannel.newConnection: reuse connection");
                }
                TCPConnection tCPConnection3 = tCPConnection2;
                Object var4_10 = null;
                return tCPConnection3;
            }
        }
        if (TCPTransport.logLevel >= 10) {
            LogStream.log("tcp").println("TCPChannel.newConnection: create connection");
        }
        if (!this.usingMultiplexer) {
            Socket socket = this.openSocket();
            tCPConnection = new TCPConnection(this, socket);
            try {
                object = new DataOutputStream(tCPConnection.getOutputStream());
                if (!tCPConnection.isReusable()) {
                    ((DataOutputStream)object).writeByte(76);
                }
                ((DataOutputStream)object).writeByte(75);
                ((DataOutputStream)object).flush();
                DataInputStream dataInputStream = new DataInputStream(tCPConnection.getInputStream());
                byte by = dataInputStream.readByte();
                if (by != 78) {
                    throw new MarshalException("Transport protocol not supported by server");
                }
                TCPEndpoint tCPEndpoint = TCPEndpoint.read(dataInputStream);
                if (TCPTransport.logLevel >= 20) {
                    LogStream.log("tcp").println("TCPChannel.newConnection: server suggested endpoint " + tCPEndpoint);
                }
                TCPEndpoint.setLocalHost(tCPEndpoint.getHost());
                tCPEndpoint = TCPEndpoint.getLocalEndpoint(0);
                tCPEndpoint.write((DataOutput)object);
                if (TCPTransport.logLevel >= 20) {
                    LogStream.log("tcp").println("TCPChannel.newConnection: using endpoint " + tCPEndpoint);
                }
                ((DataOutputStream)object).flush();
            }
            catch (IOException iOException) {
                if (iOException instanceof RemoteException) {
                    throw (RemoteException)iOException;
                }
                throw new MarshalException("Error marshaling transport header", iOException);
            }
        } else {
            try {
                tCPConnection = this.multiplexer.openConnection();
            }
            catch (IOException iOException) {
                object = this;
                synchronized (object) {
                    this.usingMultiplexer = false;
                    this.multiplexer = null;
                }
                throw new ConnectIOException("Error creating multiplexed connection", iOException);
            }
        }
        return tCPConnection;
    }

    public void free(Connection connection, boolean bl) {
        if (connection == null) {
            return;
        }
        if (bl && connection.isReusable()) {
            if (TCPTransport.logLevel >= 10) {
                LogStream.log("tcp").println("TCPChannel.free: reuse connection");
            }
            Vector vector = this.freeList;
            synchronized (vector) {
                this.freeList.addElement(connection);
                if (this.reaper == null) {
                    if (TCPTransport.logLevel >= 10) {
                        LogStream.log("tcp").println("TCPChannel.free: create reaper");
                    }
                    this.reaper = new Reaper();
                    Thread thread = RMIThread.newThread(this.reaper, "ConnectionExpiration-" + this.ep.getHost() + ":" + this.ep.getPort(), true);
                    thread.start();
                }
            }
            ((TCPConnection)connection).setExpiration(System.currentTimeMillis() + timeout);
            return;
        }
        if (TCPTransport.logLevel >= 10) {
            LogStream.log("tcp").println("TCPChannel.free: close connection");
        }
        try {
            connection.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private Socket openSocket() throws RemoteException {
        Socket socket;
        RMISocketFactory rMISocketFactory;
        if (TCPTransport.logLevel >= 20) {
            LogStream.log("tcp").println("TCPChannel.openSocket: opening socket to " + this.ep.getHost() + ":" + this.ep.getPort());
        }
        if ((rMISocketFactory = RMISocketFactory.getSocketFactory()) == null) {
            rMISocketFactory = TCPTransport.defaultSocketFactory;
        }
        try {
            socket = rMISocketFactory.createSocket(this.ep.getHost(), this.ep.getPort());
        }
        catch (UnknownHostException unknownHostException) {
            throw new java.rmi.UnknownHostException("Unknown host: " + this.ep, unknownHostException);
        }
        catch (ConnectException connectException) {
            throw new java.rmi.ConnectException("Connection refused to host: " + this.ep, connectException);
        }
        catch (IOException iOException) {
            throw new ConnectIOException("Error creating connection to: " + this.ep, iOException);
        }
        try {
            socket.setTcpNoDelay(true);
        }
        catch (Exception exception) {}
        try {
            socket.getInputStream();
            OutputStream outputStream = socket.getOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.writeInt(1246907721);
            dataOutputStream.writeShort(2);
        }
        catch (IOException iOException) {
            throw new MarshalException("Error marshaling transport header", iOException);
        }
        return socket;
    }

    private ConnectionMultiplexer openMultiplexer() throws RemoteException {
        ConnectionMultiplexer connectionMultiplexer;
        Socket socket = this.openSocket();
        TCPConnection tCPConnection = new TCPConnection(this, socket);
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            if (!tCPConnection.isReusable()) {
                throw new ConnectIOException("Cannot open multiplexed connection to " + this.ep);
            }
            dataOutputStream.writeByte(77);
            dataOutputStream.flush();
            DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
            byte by = dataInputStream.readByte();
            if (by != 78) {
                throw new MarshalException("Transport protocol not supported by receiver");
            }
            TCPEndpoint tCPEndpoint = TCPEndpoint.read(dataInputStream);
            if (TCPTransport.logLevel >= 20) {
                LogStream.log("tcp").println("TCPTransport(" + tCPEndpoint.getPort() + ").run: " + "server suggested endpoint " + tCPEndpoint);
            }
            TCPEndpoint.setLocalHost(tCPEndpoint.getHost());
            TCPEndpoint.setDefaultPort(tCPEndpoint.getPort());
            tCPEndpoint = TCPEndpoint.getLocalEndpoint(0);
            tCPEndpoint.write(dataOutputStream);
            if (TCPTransport.logLevel >= 20) {
                LogStream.log("tcp").println("TCPTransport(" + tCPEndpoint.getPort() + ").run: " + "using endpoint " + tCPEndpoint);
            }
            dataOutputStream.flush();
            connectionMultiplexer = new ConnectionMultiplexer(this, socket.getInputStream(), socket.getOutputStream(), true);
        }
        catch (IOException iOException) {
            if (iOException instanceof RemoteException) {
                throw (RemoteException)iOException;
            }
            throw new MarshalException("Error marshaling transport header", iOException);
        }
        return connectionMultiplexer;
    }

    public void run() {
        try {
            this.multiplexer.run();
            return;
        }
        catch (IOException iOException) {
            if (TCPTransport.logLevel >= 20) {
                LogStream logStream;
                LogStream logStream2 = logStream = LogStream.log("tcp");
                synchronized (logStream2) {
                    logStream.print("exception occurred in multiplexer: ");
                    iOException.printStackTrace(logStream);
                }
            }
            this.multiplexer = null;
            try {
                this.haveMultiplexer();
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }
    }

    void haveMultiplexer() throws RemoteException {
        if (this.multiplexer == null) {
            if (TCPTransport.logLevel >= 20) {
                LogStream.log("tcp").println("TCPChannel.haveMultiplexer(): attempting to open multiplex connection");
            }
            this.multiplexer = this.openMultiplexer();
            Thread thread = RMIThread.newThread(this, "Multiplexer-" + this.ep.getHost() + ":" + this.ep.getPort(), true);
            thread.start();
        }
    }

    synchronized void useMultiplexer(ConnectionMultiplexer connectionMultiplexer) {
        this.multiplexer = connectionMultiplexer;
        this.usingMultiplexer = true;
    }

    void acceptMultiplexConnection(Connection connection) {
        if (this.acceptor == null) {
            this.acceptor = new ConnectionAcceptor(this.tr);
            this.acceptor.startNewAcceptor();
        }
        this.acceptor.accept(connection);
    }

    private boolean freeCachedConnections() {
        long l = System.currentTimeMillis();
        Vector vector = this.freeList;
        synchronized (vector) {
            Enumeration enumeration = this.freeList.elements();
            while (enumeration.hasMoreElements()) {
                TCPConnection tCPConnection = (TCPConnection)enumeration.nextElement();
                if (!tCPConnection.expired(l)) continue;
                if (TCPTransport.logLevel >= 10) {
                    LogStream.log("tcp").println("TCPChannel.freeCachedConnections: connection timeout expired");
                }
                try {
                    tCPConnection.close();
                }
                catch (IOException iOException) {}
                this.freeList.removeElement(tCPConnection);
            }
            if (this.freeList.isEmpty()) {
                this.reaper = null;
                boolean bl = false;
                Object var5_7 = null;
                return bl;
            }
            boolean bl = true;
            Object var5_8 = null;
            return bl;
        }
    }

    public void dead(int n) {
        Object object;
        Vector vector;
        if (n == 1) {
            vector = this.freeList;
            synchronized (vector) {
                object = this.freeList.elements();
                while (object.hasMoreElements()) {
                    Connection connection = (Connection)object.nextElement();
                    try {
                        connection.close();
                    }
                    catch (IOException iOException) {}
                }
                this.freeList.removeAllElements();
            }
        }
        Object object2 = this.notifyList;
        synchronized (object2) {
            vector = this.notifyList;
            this.notifyList = new Vector();
        }
        object2 = vector.elements();
        while (object2.hasMoreElements()) {
            object = (Notifiable)object2.nextElement();
            object.notify(this.ep, n);
        }
        vector = null;
    }

    public void addNotifiable(Endpoint endpoint, Notifiable notifiable) {
        Vector vector = this.notifyList;
        synchronized (vector) {
            if (!this.notifyList.contains(notifiable)) {
                this.notifyList.addElement(notifiable);
            }
            return;
        }
    }

    public void removeNotifiable(Endpoint endpoint, Notifiable notifiable) {
        this.notifyList.removeElement(notifiable);
    }

    private class Reaper
    implements Runnable {
        public void run() {
            do {
                try {
                    Thread.sleep(timeout);
                }
                catch (InterruptedException interruptedException) {}
                if (TCPTransport.logLevel < 20) continue;
                LogStream.log("tcp").println("TCPChannel.Reaper: wake up");
            } while (TCPChannel.this.freeCachedConnections());
            if (TCPTransport.logLevel >= 20) {
                LogStream.log("tcp").println("TCPChannel.Reaper: exit");
            }
        }

        Reaper() {
            TCPChannel.this = TCPChannel.this;
        }
    }
}

