/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.accessibility.Accessible;
import com.sun.java.accessibility.AccessibleContext;
import com.sun.java.accessibility.AccessibleRole;
import com.sun.java.swing.GrayFilter;
import com.sun.java.swing.Icon;
import com.sun.java.swing.ImageIcon;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.SwingConstants;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.LabelUI;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;

public class JLabel
extends JComponent
implements SwingConstants,
Accessible {
    private int mnemonic;
    private String text = "";
    private Icon defaultIcon;
    private Icon disabledIcon;
    private int verticalAlignment = 0;
    private int horizontalAlignment = 2;
    private int verticalTextPosition = 0;
    private int horizontalTextPosition = 4;
    private int iconTextGap = 4;
    protected Component labelFor;

    public JLabel(String string, Icon icon, int n) {
        this.setText(string);
        this.setIcon(icon);
        this.setHorizontalAlignment(n);
        this.updateUI();
        this.setAlignmentX(0.0f);
    }

    public JLabel(String string, int n) {
        this(string, null, n);
    }

    public JLabel(String string) {
        this(string, null, 2);
    }

    public JLabel(Icon icon, int n) {
        this(null, icon, n);
    }

    public JLabel(Icon icon) {
        this(null, icon, 0);
    }

    public JLabel() {
        this("", null, 2);
    }

    public LabelUI getUI() {
        return (LabelUI)this.ui;
    }

    public void setUI(LabelUI labelUI) {
        super.setUI(labelUI);
    }

    public void updateUI() {
        this.setUI((LabelUI)UIManager.getUI(this));
        this.invalidate();
    }

    public String getUIClassID() {
        return "LabelUI";
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        String string2 = null;
        if (this.accessibleContext != null) {
            string2 = this.accessibleContext.getAccessibleName();
        }
        String string3 = string;
        this.text = string;
        this.firePropertyChange("text", string3, string);
        if (this.accessibleContext != null && this.accessibleContext.getAccessibleName() != string2) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", string2, this.accessibleContext.getAccessibleName());
        }
        this.repaint();
    }

    public Icon getIcon() {
        return this.defaultIcon;
    }

    public void setIcon(Icon icon) {
        Icon icon2 = icon;
        this.defaultIcon = icon;
        this.firePropertyChange("icon", icon2, this.defaultIcon);
        if (this.accessibleContext != null && icon2 != this.defaultIcon) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", icon2, this.defaultIcon);
        }
        this.repaint(10L);
    }

    public Icon getDisabledIcon() {
        if (this.disabledIcon == null && this.defaultIcon != null && this.defaultIcon instanceof ImageIcon) {
            Image image = GrayFilter.createDisabledImage(((ImageIcon)this.defaultIcon).getImage());
            this.disabledIcon = new ImageIcon(image);
            this.firePropertyChange("disabledIcon", null, this.disabledIcon);
        }
        return this.disabledIcon;
    }

    public void setDisabledIcon(Icon icon) {
        Icon icon2 = this.disabledIcon;
        this.disabledIcon = icon;
        this.firePropertyChange("disabledIcon", icon2, icon);
        this.repaint(10L);
    }

    public void setDisplayedMnemonic(int n) {
        int n2 = this.mnemonic;
        this.mnemonic = n;
        this.firePropertyChange("displayedMnemonic", n2, this.mnemonic);
        this.repaint();
    }

    public void setDisplayedMnemonic(char n) {
        int n2 = n;
        if (n2 >= 97 && n2 <= 122) {
            n2 -= 32;
        }
        this.setDisplayedMnemonic(n2);
    }

    public int getDisplayedMnemonic() {
        return this.mnemonic;
    }

    protected int checkHorizontalKey(int n, String string) {
        if (n == 2 || n == 0 || n == 4) {
            return n;
        }
        throw new IllegalArgumentException(string);
    }

    protected int checkVerticalKey(int n, String string) {
        if (n == 1 || n == 0 || n == 3) {
            return n;
        }
        throw new IllegalArgumentException(string);
    }

    public int getIconTextGap() {
        return this.iconTextGap;
    }

    public void setIconTextGap(int n) {
        int n2 = n;
        this.iconTextGap = n;
        this.firePropertyChange("iconTextGap", n2, n);
        this.invalidate();
        this.repaint(10L);
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int n) {
        if (n == this.verticalAlignment) {
            return;
        }
        int n2 = this.verticalAlignment;
        this.verticalAlignment = this.checkVerticalKey(n, "verticalAlignment");
        this.firePropertyChange("verticalAlignment", n2, this.verticalAlignment);
        this.repaint(10L);
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int n) {
        if (n == this.horizontalAlignment) {
            return;
        }
        int n2 = this.horizontalAlignment;
        this.horizontalAlignment = this.checkHorizontalKey(n, "horizontalAlignment");
        this.firePropertyChange("horizontalAlignment", n2, this.horizontalAlignment);
        this.repaint(10L);
    }

    public int getVerticalTextPosition() {
        return this.verticalTextPosition;
    }

    public void setVerticalTextPosition(int n) {
        if (n == this.verticalTextPosition) {
            return;
        }
        int n2 = this.verticalTextPosition;
        this.verticalTextPosition = this.checkVerticalKey(n, "verticalTextPosition");
        this.firePropertyChange("verticalTextPosition", n2, this.verticalTextPosition);
        this.repaint(10L);
    }

    public int getHorizontalTextPosition() {
        return this.horizontalTextPosition;
    }

    public void setHorizontalTextPosition(int n) {
        if (n == this.horizontalTextPosition) {
            return;
        }
        this.horizontalTextPosition = this.checkHorizontalKey(n, "horizontalTextPosition");
        this.repaint(10L);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.repaint(10L);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJLabel();
        }
        return this.accessibleContext;
    }

    public Component getLabelFor() {
        return this.labelFor;
    }

    public void setLabelFor(Component component) {
        Component component2 = this.labelFor;
        this.labelFor = component;
        this.firePropertyChange("labelFor", component2, component);
    }

    protected class AccessibleJLabel
    extends JComponent.AccessibleJComponent {
        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (JLabel.this.getText() == null) {
                return super.getAccessibleName();
            }
            return JLabel.this.getText();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }

        AccessibleJLabel() {
            JLabel.this = JLabel.this;
        }
    }
}

