/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.AbstractAction;
import com.sun.java.swing.AbstractButton;
import com.sun.java.swing.ButtonModel;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JRootPane;
import com.sun.java.swing.KeyStroke;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ChangeListener;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;

public class BasicButtonListener
implements MouseListener,
MouseMotionListener,
FocusListener,
ChangeListener,
Serializable {
    private Rectangle tmpRect = new Rectangle();

    public BasicButtonListener(AbstractButton abstractButton) {
    }

    public void setupKeyboard(AbstractButton abstractButton) {
        ButtonModel buttonModel = abstractButton.getModel();
        abstractButton.resetKeyboardActions();
        abstractButton.registerKeyboardAction(new PressedAction(abstractButton), KeyStroke.getKeyStroke(32, 0, false), 0);
        abstractButton.registerKeyboardAction(new ReleasedAction(abstractButton), KeyStroke.getKeyStroke(32, 0, true), 0);
        if (buttonModel.getMnemonic() != 0) {
            abstractButton.registerKeyboardAction(new PressedAction(abstractButton), KeyStroke.getKeyStroke(buttonModel.getMnemonic(), 8, false), 2);
            abstractButton.registerKeyboardAction(new ReleasedAction(abstractButton), KeyStroke.getKeyStroke(buttonModel.getMnemonic(), 8, true), 2);
            abstractButton.registerKeyboardAction(new ReleasedAction(abstractButton), KeyStroke.getKeyStroke(buttonModel.getMnemonic(), 0, true), 2);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        AbstractButton abstractButton = (AbstractButton)changeEvent.getSource();
        abstractButton.repaint();
        this.setupKeyboard(abstractButton);
    }

    public void focusGained(FocusEvent focusEvent) {
        JRootPane jRootPane;
        AbstractButton abstractButton = (AbstractButton)focusEvent.getSource();
        if (abstractButton instanceof JButton && (jRootPane = abstractButton.getRootPane()) != null) {
            jRootPane.setDefaultButton((JButton)abstractButton);
        }
        abstractButton.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        AbstractButton abstractButton = (AbstractButton)focusEvent.getSource();
        abstractButton.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
        ButtonModel buttonModel = abstractButton.getModel();
        if (buttonModel.isPressed()) {
            this.tmpRect.width = abstractButton.getWidth();
            this.tmpRect.height = abstractButton.getHeight();
            if (this.tmpRect.contains(mouseEvent.getPoint())) {
                buttonModel.setArmed(true);
                return;
            }
            buttonModel.setArmed(false);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
            ButtonModel buttonModel = abstractButton.getModel();
            buttonModel.setArmed(true);
            buttonModel.setPressed(true);
            if (!abstractButton.hasFocus()) {
                abstractButton.requestFocus();
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
        ButtonModel buttonModel = abstractButton.getModel();
        buttonModel.setPressed(false);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
        if (abstractButton.isRolloverEnabled()) {
            abstractButton.getModel().setRollover(true);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
        if (abstractButton.isRolloverEnabled()) {
            abstractButton.getModel().setRollover(false);
        }
    }

    static class PressedAction
    extends AbstractAction {
        AbstractButton owner;

        PressedAction(AbstractButton abstractButton) {
            super("pressedAction");
            this.owner = abstractButton;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ButtonModel buttonModel = this.owner.getModel();
            buttonModel.setArmed(true);
            buttonModel.setPressed(true);
            if (!this.owner.hasFocus()) {
                this.owner.requestFocus();
            }
        }

        public boolean isEnabled() {
            return this.owner.getModel().isEnabled();
        }
    }

    static class ReleasedAction
    extends AbstractAction {
        AbstractButton owner;

        ReleasedAction(AbstractButton abstractButton) {
            super("releasedAction");
            this.owner = abstractButton;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ButtonModel buttonModel = this.owner.getModel();
            buttonModel.setPressed(false);
        }

        public boolean isEnabled() {
            return this.owner.getModel().isEnabled();
        }
    }
}

