/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JList;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.DirectoryPaneUI;
import com.sun.java.swing.plaf.basic.BasicListCellRenderer;
import com.sun.java.swing.preview.FileType;
import com.sun.java.swing.preview.JDirectoryPane;
import com.sun.java.swing.preview.TypedFile;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.IllegalComponentStateException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class BasicDirectoryPaneUI
extends DirectoryPaneUI {
    protected JDirectoryPane directoryPane;
    protected JList list;
    protected JScrollPane scroller;
    static Icon directoryIcon = null;
    static Icon fileIcon = null;
    static Icon computerIcon = null;
    static Icon hardDriveIcon = null;
    static Icon floppyDriveIcon = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicDirectoryPaneUI((JDirectoryPane)jComponent);
    }

    public BasicDirectoryPaneUI(JDirectoryPane jDirectoryPane) {
    }

    public void installUI(JComponent jComponent) {
        this.directoryPane = (JDirectoryPane)jComponent;
        this.directoryPane.setLayout(new BorderLayout());
        this.list = new JList();
        this.list.setCellRenderer(new LabelCellRenderer());
        this.list.setBackground(Color.white);
        this.list.setModel(this.directoryPane.getModel());
        this.list.addMouseListener(new 1());
        this.scroller = new JScrollPane(this.list);
        this.scroller.setBorder(BorderFactory.createLoweredBevelBorder());
        this.directoryPane.add((Component)this.scroller, "Center");
        this.list.setSelectionModel(this.directoryPane.getListSelectionModel());
    }

    public void uninstallUI(JComponent jComponent) {
        if (jComponent != this.directoryPane) {
            throw new IllegalComponentStateException(String.valueOf(this) + " was asked to deinstall() " + jComponent + " when it only knows about " + this.directoryPane + ".");
        }
        this.directoryPane.remove(this.scroller);
    }

    private final class 1
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                BasicDirectoryPaneUI.this.directoryPane.performDoubleClick();
            }
        }

        /* synthetic */ 1() {
        }
    }

    static class LabelCellRenderer
    extends BasicListCellRenderer {
        LabelCellRenderer() {
            if (directoryIcon == null) {
                directoryIcon = UIManager.getIcon("DirectoryPane.directoryIcon");
                fileIcon = UIManager.getIcon("DirectoryPane.fileIcon");
                computerIcon = UIManager.getIcon("DirectoryPane.computerIcon");
                hardDriveIcon = UIManager.getIcon("DirectoryPane.hardDriveIcon");
                floppyDriveIcon = UIManager.getIcon("DirectoryPane.floppyDriveIcon");
            }
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            TypedFile typedFile = (TypedFile)object;
            String string = typedFile.getName();
            if (string.equals("")) {
                string = typedFile.getPath();
            }
            this.setText(string);
            Icon icon = typedFile.getIcon();
            if (icon == null) {
                FileType fileType = typedFile.getType();
                icon = fileType instanceof FileType.Computer ? computerIcon : (fileType instanceof FileType.FloppyDrive ? floppyDriveIcon : (fileType instanceof FileType.HardDrive ? hardDriveIcon : (fileType instanceof FileType.Folder ? directoryIcon : fileIcon)));
            }
            this.setIcon(icon);
            return this;
        }
    }
}

