/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.Icon;
import com.sun.java.swing.ImageIcon;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JInternalFrame;
import com.sun.java.swing.JMenu;
import com.sun.java.swing.JMenuBar;
import com.sun.java.swing.JMenuItem;
import com.sun.java.swing.JSeparator;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.event.InternalFrameEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;

public class BasicInternalFrameTitlePane
extends JComponent
implements LayoutManager,
ActionListener,
PropertyChangeListener {
    JMenuBar menuBar;
    JButton iconButton;
    JButton maxButton;
    JButton closeButton;
    Icon maxIcon = UIManager.getIcon("InternalFrame.maximizeIcon");
    Icon minIcon = UIManager.getIcon("InternalFrame.minimizeIcon");
    Icon iconIcon = UIManager.getIcon("InternalFrame.iconifyIcon");
    Icon closeIcon = UIManager.getIcon("InternalFrame.closeIcon");
    JMenu windowMenu;
    JInternalFrame frame;
    private static Color selectedTitleColor = new Color(0, 0, 128);
    private static Color selectedTextColor = new Color(255, 255, 255);
    private static Color notSelectedTitleColor = new Color(128, 128, 128);
    private static Color notSelectedTextColor = new Color(192, 192, 192);
    final int RESTORE_MENU_ITEM = 0;
    final int MOVE_MENU_ITEM = 1;
    final int SIZE_MENU_ITEM = 2;
    final int MINIMIZE_MENU_ITEM = 3;
    final int MAXIMIZE_MENU_ITEM = 4;
    final int SEPARATOR_MENU_ITEM = 5;
    final int CLOSE_MENU_ITEM = 6;
    static /* synthetic */ Class class$com$sun$java$swing$JInternalFrame;

    public BasicInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        this.frame = jInternalFrame;
        this.setPreferredSize(new Dimension(100, 18));
        this.menuBar = new 1();
        this.menuBar.setBorderPainted(false);
        this.windowMenu = this.menuBar.add(new 2("    "));
        JMenuItem jMenuItem = this.windowMenu.add(new JMenuItem("Restore"));
        jMenuItem.setEnabled(false);
        jMenuItem.addActionListener(this);
        jMenuItem = this.windowMenu.add(new JMenuItem("Move"));
        jMenuItem.setEnabled(false);
        jMenuItem.addActionListener(this);
        jMenuItem = this.windowMenu.add(new JMenuItem("Size"));
        jMenuItem.setEnabled(false);
        jMenuItem.addActionListener(this);
        jMenuItem = this.windowMenu.add(new JMenuItem("Minimize"));
        jMenuItem.addActionListener(this);
        jMenuItem = this.windowMenu.add(new JMenuItem("Maximize"));
        jMenuItem.addActionListener(this);
        this.windowMenu.add(new JSeparator());
        jMenuItem = this.windowMenu.add(new JMenuItem("Close"));
        jMenuItem.addActionListener(this);
        this.iconButton = new NoFocusButton();
        this.iconButton.setFocusPainted(false);
        this.iconButton.addActionListener(this);
        this.iconButton.setActionCommand("Iconify");
        this.maxButton = new NoFocusButton();
        this.maxButton.setFocusPainted(false);
        this.maxButton.addActionListener(this);
        this.maxButton.setActionCommand("Maximize");
        this.setButtonIcons();
        this.closeButton = new NoFocusButton();
        this.closeButton.setIcon(this.closeIcon);
        this.closeButton.setFocusPainted(false);
        this.closeButton.addActionListener(this);
        this.closeButton.setActionCommand("Close");
        this.setLayout(this);
        this.add(this.menuBar);
        this.add(this.iconButton);
        this.add(this.maxButton);
        this.add(this.closeButton);
        this.frame.addPropertyChangeListener(this);
    }

    protected void setButtonIcons() {
        if (this.frame.isIcon()) {
            this.iconButton.setIcon(this.minIcon);
            this.maxButton.setIcon(this.maxIcon);
            return;
        }
        if (this.frame.isMaximum()) {
            this.iconButton.setIcon(this.iconIcon);
            this.maxButton.setIcon(this.minIcon);
            return;
        }
        this.iconButton.setIcon(this.iconIcon);
        this.maxButton.setIcon(this.maxIcon);
    }

    public void paint(Graphics graphics) {
        boolean bl = this.frame.isSelected();
        Color color = graphics.getColor();
        if (bl) {
            graphics.setColor(selectedTitleColor);
        } else {
            graphics.setColor(notSelectedTitleColor);
        }
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.frame.getTitle() != null) {
            Font font = graphics.getFont();
            graphics.setFont(UIManager.getFont("InternalFrame.titleFont"));
            if (bl) {
                graphics.setColor(selectedTextColor);
            } else {
                graphics.setColor(notSelectedTextColor);
            }
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = fontMetrics.getHeight() - fontMetrics.getLeading();
            int n2 = (18 - n) / 2 + fontMetrics.getAscent() + fontMetrics.getLeading();
            graphics.drawString(this.frame.getTitle(), this.menuBar.getX() + this.menuBar.getWidth() + 2, n2);
            graphics.setFont(font);
        }
        graphics.setColor(color);
        super.paint(graphics);
    }

    void postClosingEvent(JInternalFrame jInternalFrame) {
        InternalFrameEvent internalFrameEvent = new InternalFrameEvent(jInternalFrame, 25550);
        if ((class$com$sun$java$swing$JInternalFrame != null ? class$com$sun$java$swing$JInternalFrame : (class$com$sun$java$swing$JInternalFrame = BasicInternalFrameTitlePane.class$("com.sun.java.swing.JInternalFrame"))).getClassLoader() == null) {
            try {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(internalFrameEvent);
                return;
            }
            catch (SecurityException securityException) {}
        }
        this.dispatchEvent(internalFrameEvent);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block24: {
            if ("Close".equals(actionEvent.getActionCommand()) && this.frame.isClosable()) {
                this.postClosingEvent(this.frame);
                return;
            }
            if ("Iconify".equals(actionEvent.getActionCommand()) && this.frame.isIconifiable()) {
                if (!this.frame.isIcon()) {
                    try {
                        this.frame.setIcon(true);
                        return;
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        return;
                    }
                }
                try {
                    this.frame.setIcon(false);
                    if (this.frame.isMaximizable() && this.frame.isMaximum()) {
                        this.frame.setMaximum(false);
                        return;
                    }
                    break block24;
                }
                catch (PropertyVetoException propertyVetoException) {
                    return;
                }
            }
            if ("Minimize".equals(actionEvent.getActionCommand()) && this.frame.isIconifiable()) {
                try {
                    this.frame.setIcon(true);
                    return;
                }
                catch (PropertyVetoException propertyVetoException) {
                    return;
                }
            }
            if ("Maximize".equals(actionEvent.getActionCommand()) && this.frame.isMaximizable()) {
                if (!this.frame.isMaximum()) {
                    try {
                        this.frame.setMaximum(true);
                        return;
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        return;
                    }
                }
                try {
                    this.frame.setMaximum(false);
                    if (this.frame.isIconifiable() && this.frame.isIcon()) {
                        this.frame.setIcon(false);
                        return;
                    }
                    break block24;
                }
                catch (PropertyVetoException propertyVetoException) {
                    return;
                }
            }
            if ("Restore".equals(actionEvent.getActionCommand()) && this.frame.isMaximizable() && this.frame.isMaximum()) {
                try {
                    this.frame.setMaximum(false);
                    return;
                }
                catch (PropertyVetoException propertyVetoException) {
                    return;
                }
            }
            if ("Restore".equals(actionEvent.getActionCommand()) && this.frame.isIconifiable() && this.frame.isIcon()) {
                try {
                    this.frame.setIcon(false);
                    return;
                }
                catch (PropertyVetoException propertyVetoException) {
                    return;
                }
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        JInternalFrame cfr_ignored_0 = (JInternalFrame)propertyChangeEvent.getSource();
        boolean bl = false;
        if ("isSelected".equals(string)) {
            this.repaint();
            return;
        }
        if ("isMaximum".equals(string)) {
            bl = (Boolean)propertyChangeEvent.getNewValue();
            this.setButtonIcons();
            this.windowMenu.getItem(0).setEnabled(bl);
            this.windowMenu.getItem(4).setEnabled(!bl);
            return;
        }
        if ("isIcon".equals(string)) {
            bl = (Boolean)propertyChangeEvent.getNewValue();
            this.setButtonIcons();
            this.windowMenu.getItem(0).setEnabled(bl);
            this.windowMenu.getItem(4).setEnabled(!bl);
            this.windowMenu.getItem(3).setEnabled(!bl);
        }
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        return new Dimension(container.getSize().width, 18);
    }

    public Dimension minimumLayoutSize(Container container) {
        return new Dimension(container.getSize().width, 18);
    }

    public void layoutContainer(Container container) {
        int n = this.getWidth();
        int n2 = n - 16 - 2;
        this.menuBar.setBounds(2, 1, 16, 16);
        if (this.frame.isClosable()) {
            this.closeButton.setBounds(n2, 2, 16, 14);
            n2 -= 16;
        } else if (this.closeButton.getParent() != null) {
            this.closeButton.getParent().remove(this.closeButton);
        }
        if (this.frame.isMaximizable()) {
            this.maxButton.setBounds(n2 - 2, 2, 16, 14);
            n2 -= 18;
        } else if (this.maxButton.getParent() != null) {
            this.maxButton.getParent().remove(this.maxButton);
        }
        if (this.frame.isIconifiable()) {
            this.iconButton.setBounds(n2, 2, 16, 14);
            return;
        }
        if (this.iconButton.getParent() != null) {
            this.iconButton.getParent().remove(this.iconButton);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class NoFocusButton
    extends JButton {
        public boolean isFocusTraversable() {
            return false;
        }

        public void requestFocus() {
        }

        public boolean isOpaque() {
            return true;
        }

        NoFocusButton() {
            BasicInternalFrameTitlePane.this = BasicInternalFrameTitlePane.this;
        }
    }

    private final class 1
    extends JMenuBar {
        public boolean isFocusTraversable() {
            return false;
        }

        public void requestFocus() {
        }

        public void paint(Graphics graphics) {
            Icon icon = BasicInternalFrameTitlePane.this.frame.getFrameIcon();
            if (icon == null) {
                icon = UIManager.getIcon("InternalFrame.icon");
            }
            if (icon != null) {
                if (icon instanceof ImageIcon && (icon.getIconWidth() > 16 || icon.getIconHeight() > 16)) {
                    Image image = ((ImageIcon)icon).getImage();
                    ((ImageIcon)icon).setImage(image.getScaledInstance(16, 16, 4));
                }
                icon.paintIcon(this, graphics, 0, 0);
            }
        }

        public boolean isOpaque() {
            return true;
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends JMenu {
        boolean neverBeenSet = true;

        public void setPopupMenuVisible(boolean bl) {
            if (this.neverBeenSet) {
                if (!BasicInternalFrameTitlePane.this.frame.isIconifiable()) {
                    BasicInternalFrameTitlePane.this.windowMenu.getItem(3).setEnabled(false);
                }
                if (!BasicInternalFrameTitlePane.this.frame.isMaximizable()) {
                    BasicInternalFrameTitlePane.this.windowMenu.getItem(4).setEnabled(false);
                }
                if (!BasicInternalFrameTitlePane.this.frame.isMaximizable() && !BasicInternalFrameTitlePane.this.frame.isIconifiable()) {
                    BasicInternalFrameTitlePane.this.windowMenu.getItem(0).setEnabled(false);
                }
                if (!BasicInternalFrameTitlePane.this.frame.isClosable()) {
                    BasicInternalFrameTitlePane.this.windowMenu.getItem(6).setEnabled(false);
                }
                this.neverBeenSet = false;
            }
            super.setPopupMenuVisible(bl);
        }

        /* synthetic */ 2(String string) {
            super(string);
        }
    }
}

