/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.ColorChooserPanel;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JSlider;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ChangeListener;
import com.sun.java.swing.plaf.basic.ColumnLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.Serializable;

public class BasicRGBChooserPanel
extends ColorChooserPanel
implements ChangeListener,
Serializable {
    protected Color color = Color.red;
    protected JSlider redSlider;
    protected JSlider greenSlider;
    protected JSlider blueSlider;
    protected JPanel resultColor;
    String redString = "Red";
    String greenString = "Green";
    String blueString = "Blue";

    public BasicRGBChooserPanel() {
    }

    public BasicRGBChooserPanel(Color color) {
        this.color = color;
    }

    public void setColor(Color color) {
        this.redSlider.setValue(color.getRed());
        this.greenSlider.setValue(color.getGreen());
        this.blueSlider.setValue(color.getBlue());
    }

    public Color getColor() {
        return this.color;
    }

    public void installChooserPanel() {
        this.setLayout(new BorderLayout());
        this.resultColor = new 1();
        JPanel jPanel = new JPanel();
        jPanel.add(this.resultColor);
        this.resultColor.setBackground(this.color);
        this.add((Component)this.resultColor, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new ColumnLayout());
        this.add((Component)jPanel2, "West");
        this.redSlider = new JSlider(0, 0, 255, this.color.getRed());
        this.redSlider.setMajorTickSpacing(85);
        this.redSlider.setMinorTickSpacing(17);
        this.redSlider.setPaintTicks(true);
        this.redSlider.setPaintLabels(true);
        JPanel jPanel3 = new JPanel();
        JLabel jLabel = new JLabel("Red");
        jPanel3.add(jLabel);
        jPanel3.add(this.redSlider);
        jPanel2.add(jPanel3);
        this.greenSlider = new JSlider(0, 0, 255, this.color.getRed());
        this.greenSlider.setMajorTickSpacing(85);
        this.greenSlider.setMinorTickSpacing(17);
        this.greenSlider.setPaintTicks(true);
        this.greenSlider.setPaintLabels(true);
        JPanel jPanel4 = new JPanel();
        JLabel jLabel2 = new JLabel("Green");
        jPanel4.add(jLabel2);
        jPanel4.add(this.greenSlider);
        jPanel2.add(jPanel4);
        this.blueSlider = new JSlider(0, 0, 255, this.color.getRed());
        this.blueSlider.setMajorTickSpacing(85);
        this.blueSlider.setMinorTickSpacing(17);
        this.blueSlider.setPaintTicks(true);
        this.blueSlider.setPaintLabels(true);
        JPanel jPanel5 = new JPanel();
        JLabel jLabel3 = new JLabel("Blue");
        jPanel5.add(jLabel3);
        jPanel5.add(this.blueSlider);
        jPanel2.add(jPanel5);
        int n = Math.max(jLabel.getPreferredSize().width, jLabel2.getPreferredSize().width);
        n = Math.max(n, jLabel3.getPreferredSize().width);
        jLabel.setPreferredSize(new Dimension(n, jLabel.getPreferredSize().height));
        jLabel2.setPreferredSize(new Dimension(n, jLabel2.getPreferredSize().height));
        jLabel3.setPreferredSize(new Dimension(n, jLabel3.getPreferredSize().height));
        this.setPreferredSize(new Dimension(jPanel2.getPreferredSize().width + this.resultColor.getPreferredSize().width, jPanel2.getPreferredSize().height + this.resultColor.getPreferredSize().height));
        this.redSlider.addChangeListener(this);
        this.greenSlider.addChangeListener(this);
        this.blueSlider.addChangeListener(this);
    }

    public void uninstallChooserPanel() {
        this.color = null;
        this.redSlider = null;
        this.greenSlider = null;
        this.blueSlider = null;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() instanceof JSlider) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            Color color = this.color;
            if (jSlider == this.redSlider) {
                this.color = new Color(this.redSlider.getValue(), this.color.getGreen(), this.color.getBlue());
            } else if (jSlider == this.greenSlider) {
                this.color = new Color(this.color.getRed(), this.greenSlider.getValue(), this.color.getBlue());
            } else if (jSlider == this.blueSlider) {
                this.color = new Color(this.color.getRed(), this.color.getGreen(), this.blueSlider.getValue());
            }
            this.resultColor.setBackground(this.color);
            this.resultColor.repaint();
            this.fireColorPropertyChange(color, this.color);
        }
    }

    private final class 1
    extends JPanel {
        public Dimension getPreferredSize() {
            return new Dimension(30, 45);
        }

        /* synthetic */ 1() {
        }
    }
}

