/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.CellRendererPane;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JTable;
import com.sun.java.swing.LookAndFeel;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.TableHeaderUI;
import com.sun.java.swing.table.JTableHeader;
import com.sun.java.swing.table.TableCellRenderer;
import com.sun.java.swing.table.TableColumn;
import com.sun.java.swing.table.TableColumnModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.Enumeration;

public class BasicTableHeaderUI
extends TableHeaderUI
implements MouseListener,
MouseMotionListener,
FocusListener,
Serializable {
    protected JTableHeader header;
    protected CellRendererPane rendererPane = new CellRendererPane();
    protected transient int hitColumnIndex;
    protected transient TableColumn hitColumn;
    protected transient boolean isResizing;
    protected transient int originalWidth;
    protected transient int widthDelta;
    protected transient int lastMouseX;
    protected transient int realDraggedDistance;
    protected transient boolean isReordering;
    protected transient boolean okToReorder;
    protected transient boolean fireAction;
    protected transient boolean hasPress = false;
    static final Cursor defaultCursor = Cursor.getPredefinedCursor(0);
    static final Cursor resizeCursor = Cursor.getPredefinedCursor(11);

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTableHeaderUI();
    }

    public void installUI(JComponent jComponent) {
        this.header = (JTableHeader)jComponent;
        this.header.add(this.rendererPane);
        jComponent.addMouseListener(this);
        jComponent.addMouseMotionListener(this);
        jComponent.addFocusListener(this);
        LookAndFeel.installColorsAndFont(this.header, "TableHeader.background", "TableHeader.foreground", "TableHeader.font");
    }

    public void uninstallUI(JComponent jComponent) {
        this.header.remove(this.rendererPane);
        this.header = null;
        jComponent.removeMouseListener(this);
        jComponent.removeMouseMotionListener(this);
        jComponent.removeFocusListener(this);
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.getResizingColumn(mouseEvent.getPoint()) != -1) {
            if (this.header.getCursor() != resizeCursor) {
                this.header.setCursor(resizeCursor);
                return;
            }
        } else if (this.header.getCursor() != defaultCursor) {
            this.header.setCursor(defaultCursor);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.fireAction = false;
        int n = mouseEvent.getX();
        if (n == this.lastMouseX) {
            return;
        }
        if (this.isResizing) {
            this.widthDelta += n - this.lastMouseX;
            int n2 = this.originalWidth + this.widthDelta;
            this.hitColumn.setWidth(n2);
            this.header.revalidate();
            this.header.repaint();
            if (this.header.getUpdateTableInRealTime()) {
                JTable jTable = this.header.getTable();
                jTable.revalidate();
                jTable.repaint();
            }
        } else if (this.okToReorder || this.isReordering) {
            this.isReordering = true;
            this.move(mouseEvent);
        }
        this.lastMouseX = n;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.hasPress) {
            return;
        }
        this.hasPress = true;
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        int n = 0;
        this.isReordering = false;
        this.isResizing = false;
        this.fireAction = true;
        this.hitColumnIndex = -1;
        this.hitColumn = null;
        Point point = mouseEvent.getPoint();
        n = tableColumnModel.getColumnIndexAtX(point.x);
        if (n != -1) {
            Rectangle rectangle = this.header.getHeaderRect(n);
            int n2 = this.getResizingColumn(point);
            if (this.header.getResizingAllowed() && n2 != -1) {
                this.hitColumn = tableColumnModel.getColumn(n2);
                if (this.hitColumn.getResizable()) {
                    this.isResizing = true;
                    this.fireAction = false;
                    this.hitColumnIndex = n2;
                    this.originalWidth = this.hitColumn.getWidth();
                    this.widthDelta = 0;
                    this.header.setResizingColumn(this.hitColumn);
                    this.lastMouseX = point.x;
                    this.hitColumn.disableResizedPosting();
                    return;
                }
                this.hitColumn = null;
                return;
            }
            boolean bl = mouseEvent.isControlDown();
            if (this.header.getReorderingAllowed() && rectangle.contains(point)) {
                boolean bl2 = this.okToReorder = tableColumnModel.getColumnCount() > 1;
                if (bl) {
                    this.okToReorder = false;
                    this.fireAction = false;
                }
            }
            JTable jTable = this.header.getTable();
            if (tableColumnModel.getColumnSelectionAllowed() && rectangle.contains(point) && jTable != null) {
                if (bl) {
                    if (jTable.isColumnSelected(n)) {
                        jTable.removeColumnSelectionInterval(n, n);
                    } else {
                        jTable.addColumnSelectionInterval(n, n);
                    }
                } else {
                    jTable.setColumnSelectionInterval(n, n);
                }
            }
            this.hitColumnIndex = n;
            this.header.setDraggedColumn(this.hitColumn);
            this.header.setDraggedDistance(0);
            this.lastMouseX = point.x;
            this.realDraggedDistance = 0;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.hasPress = false;
        if (this.isResizing) {
            this.isResizing = false;
            this.originalWidth = 0;
            this.header.setResizingColumn(null);
            int n = this.hitColumn.getWidth();
            this.hitColumn.setWidth(this.originalWidth);
            this.hitColumn.enableResizedPosting();
            this.hitColumn.setWidth(n);
        } else if (this.isReordering) {
            this.isReordering = false;
            this.widthDelta = 0;
            this.originalWidth = 0;
            this.realDraggedDistance = 0;
        } else if (this.fireAction) {
            this.fireAction = false;
        }
        this.header.setDraggedColumn(null);
        this.header.setDraggedDistance(0);
        this.header.repaint();
        JTable jTable = this.header.getTable();
        if (jTable != null) {
            jTable.repaint();
        }
        this.okToReorder = false;
        this.hitColumnIndex = -1;
        this.hitColumn = null;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        TableCellRenderer tableCellRenderer;
        JTableHeader jTableHeader = (JTableHeader)jComponent;
        Rectangle rectangle = graphics.getClipBounds();
        Dimension dimension = jTableHeader.getSize();
        Component component = null;
        if (jTableHeader.getColumnModel() == null) {
            return;
        }
        Color color = jTableHeader.getBackground();
        if (color != null) {
            graphics.setColor(color);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        Rectangle rectangle2 = new Rectangle(0, 0, dimension.width, dimension.height);
        int n = 0;
        boolean bl = false;
        Rectangle rectangle3 = null;
        TableColumn tableColumn = null;
        int n2 = jTableHeader.getColumnModel().getColumnMargin();
        Enumeration enumeration = jTableHeader.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn2 = (TableColumn)enumeration.nextElement();
            rectangle2.width = tableColumn2.getWidth() + n2;
            if (rectangle2.intersects(rectangle)) {
                bl = true;
                if (tableColumn2 != jTableHeader.getDraggedColumn()) {
                    tableCellRenderer = tableColumn2.getHeaderRenderer();
                    component = tableCellRenderer.getTableCellRendererComponent(jTableHeader.getTable(), tableColumn2.getHeaderValue(), false, false, -1, n);
                    this.rendererPane.add(component);
                    this.rendererPane.paintComponent(graphics, component, jTableHeader, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, true);
                } else {
                    graphics.setColor(jTableHeader.getParent().getBackground());
                    graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    rectangle3 = new Rectangle(rectangle2);
                }
            } else if (bl) break;
            rectangle2.x += rectangle2.width;
            ++n;
        }
        tableColumn = jTableHeader.getDraggedColumn();
        if (tableColumn != null && rectangle3 != null) {
            tableCellRenderer = tableColumn.getHeaderRenderer();
            component = tableCellRenderer.getTableCellRendererComponent(jTableHeader.getTable(), tableColumn.getHeaderValue(), false, false, -1, n);
            rectangle3.x += jTableHeader.getDraggedDistance();
            SwingUtilities.paintComponent(graphics, component, jTableHeader, rectangle3);
        }
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        JTableHeader jTableHeader = (JTableHeader)jComponent;
        JTable jTable = jTableHeader.getTable();
        Dimension dimension = jTable.getPreferredSize();
        Dimension dimension2 = new Dimension();
        dimension2.width = dimension.width;
        int n = 0;
        Enumeration enumeration = jTableHeader.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
            Component component = tableCellRenderer.getTableCellRendererComponent(jTableHeader.getTable(), tableColumn.getHeaderValue(), false, false, -1, n);
            dimension2.height = Math.max(dimension2.height, component.getPreferredSize().height);
            ++n;
        }
        return dimension2;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    private void move(MouseEvent mouseEvent) {
        JTable jTable;
        int n;
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        int n2 = tableColumnModel.getColumnCount() - 1;
        Rectangle rectangle = this.header.getHeaderRect(this.hitColumnIndex);
        rectangle.x += this.header.getDraggedDistance();
        int n3 = mouseEvent.getX() - this.lastMouseX;
        this.realDraggedDistance += n3;
        Rectangle rectangle2 = this.header.getHeaderRect(this.hitColumnIndex);
        rectangle2.x += this.realDraggedDistance;
        rectangle = rectangle.union(rectangle2);
        if (this.realDraggedDistance < 0 && this.hitColumnIndex != 0) {
            int n4 = tableColumnModel.getColumnMargin() + tableColumnModel.getColumn(this.hitColumnIndex - 1).getWidth();
            if (-this.realDraggedDistance > n4 / 2) {
                tableColumnModel.moveColumn(this.hitColumnIndex, this.hitColumnIndex - 1);
                this.realDraggedDistance = n4 + this.realDraggedDistance;
                --this.hitColumnIndex;
            }
        } else if (this.realDraggedDistance > 0 && this.hitColumnIndex != n2 && this.realDraggedDistance > (n = tableColumnModel.getColumnMargin() + tableColumnModel.getColumn(this.hitColumnIndex + 1).getWidth()) / 2) {
            tableColumnModel.moveColumn(this.hitColumnIndex, this.hitColumnIndex + 1);
            this.realDraggedDistance = -(n - this.realDraggedDistance);
            ++this.hitColumnIndex;
        }
        int n5 = this.realDraggedDistance;
        if (this.hitColumnIndex == 0) {
            if (n5 < 0) {
                n5 = 0;
            }
        } else if (this.hitColumnIndex == n2 && n5 > 0) {
            n5 = 0;
        }
        this.header.setDraggedColumn(tableColumnModel.getColumn(this.hitColumnIndex));
        this.header.setDraggedDistance(n5);
        this.header.repaint(rectangle.x, 0, rectangle.width, rectangle.height);
        if (this.header.getUpdateTableInRealTime() && (jTable = this.header.getTable()) != null) {
            jTable.repaint(rectangle.x, 0, rectangle.width, (jTable.getRowHeight() + jTable.getIntercellSpacing().height) * jTable.getRowCount());
        }
    }

    private int getResizingColumn(Point point) {
        int n = 0;
        Rectangle rectangle = new Rectangle(-3, 0, 6, this.header.getSize().height);
        int n2 = this.header.getColumnModel().getColumnMargin();
        Enumeration enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            rectangle.x += tableColumn.getWidth() + n2;
            if (rectangle.x > point.x) break;
            if (rectangle.contains(point)) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

