/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.JComponent;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.ImageObserver;

class ImageComponent
extends JComponent
implements ImageObserver {
    protected Image img;
    private boolean imgKnown;
    protected Dimension isize = new Dimension(-1, -1);
    protected Dimension prefsize = new Dimension(0, 0);
    boolean fixedSize = false;
    long lastUpdateTime;

    public ImageComponent() {
    }

    public ImageComponent(Image image) {
        this.setImage(image);
    }

    public ImageComponent(String string) {
        this.setImage(this.getToolkit().getImage(string));
    }

    public void setSize(int n, int n2) {
        if (n != this.isize.width || n2 != this.isize.height) {
            this.isize.width = n;
            this.isize.height = n2;
            this.invalidate();
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.setSize(n3, n4);
    }

    public void setImage(Image image) {
        if (this.img == image) {
            return;
        }
        this.img = image;
        if (image != null) {
            this.setSize(image.getWidth(this), image.getHeight(this));
        }
        if (this.isShowing()) {
            this.repaint(10L);
        }
    }

    private synchronized void waitSize() {
        if (this.img != null) {
            try {
                while (this.isize.width < 0 || this.isize.height < 0) {
                    this.wait();
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    protected boolean immediatePaint() {
        return true;
    }

    public synchronized boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        long l = System.currentTimeMillis();
        if ((n & 0x30) != 0) {
            if (this.immediatePaint()) {
                Graphics graphics = this.getGraphics();
                if (graphics != null) {
                    this.paint(graphics);
                    graphics.dispose();
                }
            } else {
                this.repaint(0L);
            }
            this.lastUpdateTime = l;
        }
        if ((n & 0xC0) != 0) {
            image = null;
            this.isize.width = 0;
            this.isize.height = 0;
            this.notifyAll();
            return false;
        }
        if ((n & 1) != 0) {
            this.isize.width = image.getWidth(this);
        }
        if ((n & 2) != 0) {
            this.isize.height = image.getHeight(this);
        }
        this.notifyAll();
        return (n & 0x20) == 0;
    }

    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        this.waitSize();
        this.prefsize.width = this.isize.width + insets.left + insets.right;
        this.prefsize.height = this.isize.height + insets.top + insets.bottom;
        return this.prefsize;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    protected void locateImage() {
    }

    public void paint(Graphics graphics) {
        Insets insets = this.getInsets();
        Image image = this.img;
        if (image == null) {
            this.locateImage();
            image = this.img;
            if (image == null) {
                return;
            }
        }
        if (graphics == null) {
            System.out.println("NULL GRAPHICS");
        }
        if (insets == null) {
            System.out.println("NULL INSETS");
        }
        graphics.drawImage(image, insets.left, insets.top, this);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

