/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.metal;

import com.sun.java.swing.Icon;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.ListCellRenderer;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.basic.BasicButtonListener;
import com.sun.java.swing.plaf.basic.BasicButtonUI;
import com.sun.java.swing.plaf.metal.MetalButtonUI;
import com.sun.java.swing.plaf.metal.MetalComboBoxUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;

public class MetalComboBoxButton
extends JButton {
    protected JComboBox comboBox;
    protected Icon comboIcon;
    protected boolean iconOnly = false;
    protected boolean forceDrawFocus = false;

    public final JComboBox getComboBox() {
        return this.comboBox;
    }

    public final void setComboBox(JComboBox jComboBox) {
        this.comboBox = jComboBox;
    }

    public final Icon getComboIcon() {
        return this.comboIcon;
    }

    public final void setComboIcon(Icon icon) {
        this.comboIcon = icon;
    }

    MetalComboBoxButton() {
        super("");
    }

    public MetalComboBoxButton(JComboBox jComboBox, Icon icon) {
        super("");
        this.comboBox = jComboBox;
        this.comboIcon = icon;
    }

    public MetalComboBoxButton(JComboBox jComboBox, Icon icon, boolean bl) {
        this(jComboBox, icon);
        this.iconOnly = bl;
    }

    public Insets getInsets() {
        if (this.comboBox != null) {
            return this.comboBox.getInsets();
        }
        return new Insets(0, 0, 0, 0);
    }

    public void paint(Graphics graphics) {
        int n;
        super.paint(graphics);
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        int n2 = insets.left + dimension.width;
        if (this.comboIcon != null) {
            int n3 = this.comboIcon.getIconWidth();
            int n4 = 8;
            n2 = this.iconOnly ? insets.left + dimension.width / 2 - n3 / 2 : (n2 -= n3 + n4);
            int n5 = this.comboIcon.getIconHeight();
            n = insets.top + dimension.height / 2 - n5 / 2;
            this.comboIcon.paintIcon(this, graphics, n2, n);
        }
        if (!this.iconOnly && this.comboBox != null) {
            MetalComboBoxUI metalComboBoxUI = (MetalComboBoxUI)this.comboBox.getUI();
            ListCellRenderer listCellRenderer = this.comboBox.getRenderer();
            metalComboBoxUI.validateMenu();
            n = this.getModel().isPressed();
            Component component = listCellRenderer.getListCellRendererComponent(metalComboBoxUI.getList(), this.comboBox.getSelectedItem(), -1, n != 0, false);
            component.setFont(metalComboBoxUI.getCurrentValuePane().getFont());
            if (this.model.isArmed() && this.model.isPressed()) {
                if (this.isOpaque()) {
                    component.setBackground(UIManager.getColor("Button.pressed"));
                }
            } else {
                component.setBackground(this.comboBox.getBackground());
            }
            component.setForeground(this.comboBox.getForeground());
            metalComboBoxUI.getCurrentValuePane().paintComponent(graphics, component, this, insets.left + 4, insets.top + 4, n2 - 8 - insets.left, insets.top + dimension.height - 8);
        }
    }

    public boolean hasFocus() {
        if (this.comboBox.isEditable()) {
            return super.hasFocus();
        }
        return this.forceDrawFocus;
    }

    public void forceDrawFocus(boolean bl) {
        this.forceDrawFocus = bl;
    }

    public boolean isFocusTraversable() {
        return this.comboBox.isEditable();
    }

    public void requestFocus() {
    }

    public void updateUI() {
        this.setUI(new MetalComboBoxButtonUI(this));
    }

    class MetalComboBoxButtonUI
    extends MetalButtonUI {
        MetalComboBoxButtonListener newListener;
        MetalComboBoxButtonKeyListener keyListener;
        MetalComboBoxButtonFocusListener focusListener;

        public MetalComboBoxButtonUI(MetalComboBoxButton metalComboBoxButton2) {
            MetalComboBoxButton.this = MetalComboBoxButton.this;
            MetalComboBoxButton metalComboBoxButton3 = MetalComboBoxButton.this;
            metalComboBoxButton3.getClass();
            this.newListener = metalComboBoxButton3.new MetalComboBoxButtonListener(metalComboBoxButton2);
            MetalComboBoxButton metalComboBoxButton4 = MetalComboBoxButton.this;
            metalComboBoxButton4.getClass();
            this.keyListener = metalComboBoxButton4.new MetalComboBoxButtonKeyListener(metalComboBoxButton2);
            MetalComboBoxButton metalComboBoxButton5 = MetalComboBoxButton.this;
            metalComboBoxButton5.getClass();
            this.focusListener = metalComboBoxButton5.new MetalComboBoxButtonFocusListener(metalComboBoxButton2);
        }

        public void installUI(JComponent jComponent) {
            super.installUI(jComponent);
            MetalComboBoxButton.this.removeMouseListener(BasicButtonUI.listener);
            MetalComboBoxButton.this.removeMouseMotionListener(BasicButtonUI.listener);
            MetalComboBoxButton.this.addMouseListener(this.newListener);
            MetalComboBoxButton.this.addMouseMotionListener(this.newListener);
            MetalComboBoxButton.this.addKeyListener(this.keyListener);
            MetalComboBoxButton.this.addFocusListener(this.focusListener);
        }

        public void uninstallUI(JComponent jComponent) {
            MetalComboBoxButton.this.removeMouseListener(this.newListener);
            MetalComboBoxButton.this.removeMouseMotionListener(this.newListener);
            MetalComboBoxButton.this.removeKeyListener(this.keyListener);
            MetalComboBoxButton.this.removeFocusListener(this.focusListener);
            super.uninstallUI(jComponent);
        }
    }

    class MetalComboBoxButtonKeyListener
    extends KeyAdapter
    implements Serializable {
        MetalComboBoxButton button;

        public MetalComboBoxButtonKeyListener(MetalComboBoxButton metalComboBoxButton2) {
            MetalComboBoxButton.this = MetalComboBoxButton.this;
            this.button = metalComboBoxButton2;
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 32) {
                MetalComboBoxUI metalComboBoxUI = (MetalComboBoxUI)this.button.getComboBox().getUI();
                if (metalComboBoxUI.popupIsVisible()) {
                    metalComboBoxUI.hidePopup();
                    return;
                }
                metalComboBoxUI.showPopup();
            }
        }
    }

    class MetalComboBoxButtonFocusListener
    extends FocusAdapter
    implements Serializable {
        MetalComboBoxButton button;

        public MetalComboBoxButtonFocusListener(MetalComboBoxButton metalComboBoxButton2) {
            MetalComboBoxButton.this = MetalComboBoxButton.this;
            this.button = metalComboBoxButton2;
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }

    class MetalComboBoxButtonListener
    extends BasicButtonListener {
        MetalComboBoxButton button;
        boolean isDraggingProtection = false;

        public MetalComboBoxButtonListener(MetalComboBoxButton metalComboBoxButton2) {
            super(metalComboBoxButton2);
            MetalComboBoxButton.this = MetalComboBoxButton.this;
            this.button = metalComboBoxButton2;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            MetalComboBoxUI metalComboBoxUI = (MetalComboBoxUI)this.button.getComboBox().getUI();
            if (this.isDraggingProtection) {
                return;
            }
            this.isDraggingProtection = true;
            if (!MetalComboBoxButton.this.comboBox.isEnabled()) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (metalComboBoxUI.popupIsVisible()) {
                metalComboBoxUI.hidePopup();
                return;
            }
            metalComboBoxUI.showPopup();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.isDraggingProtection = false;
            MetalComboBoxUI metalComboBoxUI = (MetalComboBoxUI)this.button.getComboBox().getUI();
            if (!SwingUtilities.getLocalBounds(this.button).contains(mouseEvent.getPoint())) {
                metalComboBoxUI.doMouseReleased(mouseEvent);
            }
            super.mouseReleased(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            MetalComboBoxUI metalComboBoxUI = (MetalComboBoxUI)this.button.getComboBox().getUI();
            if (!SwingUtilities.getLocalBounds(this.button).contains(mouseEvent.getPoint())) {
                metalComboBoxUI.doMouseDragged(mouseEvent);
            }
        }
    }
}

