/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.metal;

import com.sun.java.swing.BoundedRangeModel;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JProgressBar;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.basic.BasicProgressBarUI;
import com.sun.java.swing.plaf.metal.MetalLookAndFeel;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;

public class MetalProgressBarUI
extends BasicProgressBarUI {
    Dimension size;
    Dimension innerSize;
    int x;
    int y;
    int length;
    int min;
    int max;
    JProgressBar progressBar;
    BoundedRangeModel model;
    Insets b;
    long span;
    double bigWidth;
    double bigHeight;
    double bigValue;
    double fractionComplete;
    protected static final Dimension PREFERRED_INNER_HORIZONTAL = new Dimension(144, 12);
    protected static final Dimension PREFERRED_INNER_VERTICAL = new Dimension(12, 144);

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalProgressBarUI();
    }

    public Dimension getPreferredInnerHorizontal() {
        return PREFERRED_INNER_HORIZONTAL;
    }

    public Dimension getPreferredInnerVertical() {
        return PREFERRED_INNER_VERTICAL;
    }

    public int getBorderBuffer() {
        return 0;
    }

    public int getCellLength() {
        return 1;
    }

    public int getCellSpacing() {
        return 0;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.size = jComponent.getSize();
        this.progressBar = (JProgressBar)jComponent;
        this.model = this.progressBar.getModel();
        this.b = this.getBorderInsets(jComponent);
        this.x = this.b.left;
        this.y = this.b.top;
        this.innerSize = new Dimension(this.size.width - (this.b.left + this.b.right), this.size.height - (this.b.top + this.b.bottom));
        graphics.setColor(jComponent.getForeground());
        this.span = this.model.getMaximum() - this.model.getMinimum();
        this.length = 0;
        if (this.progressBar.getOrientation() == 0) {
            if (this.span != 0L) {
                this.bigWidth = this.innerSize.width;
                this.bigValue = this.model.getValue();
                this.fractionComplete = this.bigValue / (double)this.span;
                this.length = (int)(this.bigWidth * this.fractionComplete);
            }
            this.max = this.x + this.length;
            graphics.fillRect(this.x, this.y, this.max, this.innerSize.height);
            graphics.setColor(MetalLookAndFeel.getControlShadow());
            graphics.drawLine(this.x, this.y, this.innerSize.width, this.y);
            if (this.model.getValue() == 0) {
                graphics.setColor(MetalLookAndFeel.getControlShadow());
            } else {
                graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            }
            graphics.drawLine(this.x, this.y, this.x, this.y + this.innerSize.height);
            graphics.fillRect(this.x, this.y, this.max, this.y);
        } else {
            if (this.span != 0L) {
                this.bigHeight = this.innerSize.height;
                this.bigValue = this.model.getValue();
                this.fractionComplete = this.bigValue / (double)this.span;
                this.length = (int)(this.bigHeight * this.fractionComplete);
            }
            this.min = this.innerSize.height + this.y - this.length;
            graphics.fillRect(this.x, this.min, this.innerSize.width, this.length);
            graphics.setColor(MetalLookAndFeel.getControlShadow());
            graphics.drawLine(this.x, this.y, this.x, this.y + this.innerSize.height);
            if (this.model.getValue() == 0) {
                graphics.setColor(MetalLookAndFeel.getControlShadow());
            } else {
                graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            }
            graphics.drawLine(this.x, this.y + this.innerSize.height - 1, this.x + this.innerSize.width, this.y + this.innerSize.height - 1);
            graphics.fillRect(this.x, this.min, 1, this.length);
        }
        if (this.progressBar.isBorderPainted()) {
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.drawRect(0, 0, this.size.width - 1, this.size.height - 1);
        }
    }

    public Insets getBorderInsets(JComponent jComponent) {
        JProgressBar jProgressBar = (JProgressBar)jComponent;
        if (jProgressBar.isBorderPainted()) {
            return new Insets(1, 1, 1, 1);
        }
        return new Insets(0, 0, 0, 0);
    }
}

