/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.metal;

import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.ColorUIResource;
import com.sun.java.swing.plaf.basic.BasicArrowButton;
import com.sun.java.swing.plaf.metal.MetalLookAndFeel;
import com.sun.java.swing.plaf.metal.MetalUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

public class MetalScrollButton
extends BasicArrowButton {
    private static Color shadowColor;
    private static Color highlightColor;
    private boolean isFreeStanding = false;
    private int buttonWidth;

    public MetalScrollButton(int n, int n2, boolean bl) {
        super(n);
        shadowColor = UIManager.getColor("ScrollBar.shadow");
        highlightColor = UIManager.getColor("ScrollBar.highlight");
        this.buttonWidth = n2;
        this.isFreeStanding = bl;
    }

    public void setFreeStanding(boolean bl) {
        this.isFreeStanding = bl;
    }

    public void paint(Graphics graphics) {
        boolean bl = this.getParent().isEnabled();
        ColorUIResource colorUIResource = bl ? MetalLookAndFeel.getControlInfo() : MetalLookAndFeel.getControlDisabled();
        boolean bl2 = this.getModel().isPressed();
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        if (bl2) {
            graphics.setColor(MetalLookAndFeel.getControlShadow());
        } else {
            graphics.setColor(this.getBackground());
        }
        graphics.fillRect(0, 0, n, n2);
        if (this.getDirection() == 1) {
            if (!this.isFreeStanding) {
                n += 2;
            }
            graphics.setColor(colorUIResource);
            graphics.drawLine(7, 6, 8, 6);
            graphics.drawLine(6, 7, 9, 7);
            graphics.drawLine(5, 8, 10, 8);
            graphics.drawLine(4, 9, 11, 9);
            if (bl) {
                graphics.setColor(highlightColor);
                if (!bl2) {
                    graphics.drawLine(1, 1, n - 3, 1);
                    graphics.drawLine(1, 1, 1, n2 - 1);
                }
                graphics.drawLine(n - 1, 1, n - 1, n2 - 1);
                graphics.setColor(shadowColor);
                graphics.drawLine(0, 0, n - 2, 0);
                graphics.drawLine(0, 0, 0, n2 - 1);
                graphics.drawLine(n - 2, 2, n - 2, n2 - 1);
            } else {
                MetalUtils.drawDisabledBorder(graphics, 0, 0, n, n2 + 1);
            }
            if (!this.isFreeStanding) {
                n -= 2;
                return;
            }
        } else if (this.getDirection() == 5) {
            if (!this.isFreeStanding) {
                n += 2;
                ++n2;
            }
            graphics.setColor(colorUIResource);
            graphics.drawLine(4, 5, 11, 5);
            graphics.drawLine(5, 6, 10, 6);
            graphics.drawLine(6, 7, 9, 7);
            graphics.drawLine(7, 8, 8, 8);
            if (bl) {
                graphics.setColor(highlightColor);
                if (!bl2) {
                    graphics.drawLine(1, 0, n - 3, 0);
                    graphics.drawLine(1, 0, 1, n2 - 3);
                }
                graphics.drawLine(1, n2 - 1, n - 1, n2 - 1);
                graphics.drawLine(n - 1, 0, n - 1, n2 - 1);
                graphics.setColor(shadowColor);
                graphics.drawLine(0, 0, 0, n2 - 2);
                graphics.drawLine(n - 2, 0, n - 2, n2 - 2);
                graphics.drawLine(2, n2 - 2, n - 2, n2 - 2);
            } else {
                MetalUtils.drawDisabledBorder(graphics, 0, -1, n, n2 + 1);
            }
            if (!this.isFreeStanding) {
                n -= 2;
                --n2;
                return;
            }
        } else if (this.getDirection() == 3) {
            if (!this.isFreeStanding) {
                n2 += 2;
                ++n;
            }
            graphics.setColor(colorUIResource);
            graphics.drawLine(5, 4, 5, 11);
            graphics.drawLine(6, 5, 6, 10);
            graphics.drawLine(7, 6, 7, 9);
            graphics.drawLine(8, 7, 8, 8);
            if (bl) {
                graphics.setColor(highlightColor);
                if (!bl2) {
                    graphics.drawLine(0, 1, n - 3, 1);
                    graphics.drawLine(0, 1, 0, n2 - 3);
                }
                graphics.drawLine(n - 1, 1, n - 1, n2 - 1);
                graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
                graphics.setColor(shadowColor);
                graphics.drawLine(0, 0, n - 2, 0);
                graphics.drawLine(n - 2, 2, n - 2, n2 - 2);
                graphics.drawLine(0, n2 - 2, n - 2, n2 - 2);
            } else {
                MetalUtils.drawDisabledBorder(graphics, -1, 0, n + 1, n2);
            }
            if (!this.isFreeStanding) {
                n2 -= 2;
                --n;
                return;
            }
        } else if (this.getDirection() == 7) {
            if (!this.isFreeStanding) {
                n2 += 2;
                ++n;
                graphics.translate(-1, 0);
            }
            graphics.setColor(colorUIResource);
            graphics.drawLine(6, 7, 6, 8);
            graphics.drawLine(7, 6, 7, 9);
            graphics.drawLine(8, 5, 8, 10);
            graphics.drawLine(9, 4, 9, 11);
            if (bl) {
                graphics.setColor(highlightColor);
                if (!bl2) {
                    graphics.drawLine(1, 1, n - 1, 1);
                    graphics.drawLine(1, 1, 1, n2 - 3);
                }
                graphics.drawLine(1, n2 - 1, n - 1, n2 - 1);
                graphics.setColor(shadowColor);
                graphics.drawLine(0, 0, n - 1, 0);
                graphics.drawLine(0, 0, 0, n2 - 2);
                graphics.drawLine(2, n2 - 2, n - 1, n2 - 2);
            } else {
                MetalUtils.drawDisabledBorder(graphics, 0, 0, n + 1, n2);
            }
            if (!this.isFreeStanding) {
                n2 -= 2;
                --n;
                graphics.translate(1, 0);
            }
        }
    }

    public Dimension getPreferredSize() {
        if (this.getDirection() == 1) {
            return new Dimension(this.buttonWidth, this.buttonWidth - 2);
        }
        if (this.getDirection() == 5) {
            return new Dimension(this.buttonWidth, this.buttonWidth - (this.isFreeStanding ? 1 : 2));
        }
        if (this.getDirection() == 3) {
            return new Dimension(this.buttonWidth - (this.isFreeStanding ? 1 : 2), this.buttonWidth);
        }
        if (this.getDirection() == 7) {
            return new Dimension(this.buttonWidth - 2, this.buttonWidth);
        }
        return new Dimension(0, 0);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public int getButtonWidth() {
        return this.buttonWidth;
    }
}

