/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.text;

import com.sun.java.swing.event.DocumentEvent;
import com.sun.java.swing.text.BadLocationException;
import com.sun.java.swing.text.Caret;
import com.sun.java.swing.text.Document;
import com.sun.java.swing.text.Element;
import com.sun.java.swing.text.JTextComponent;
import com.sun.java.swing.text.Segment;
import com.sun.java.swing.text.StateInvariantError;
import com.sun.java.swing.text.TabExpander;
import com.sun.java.swing.text.Utilities;
import com.sun.java.swing.text.View;
import com.sun.java.swing.text.ViewFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;

public class PlainView
extends View
implements TabExpander {
    protected FontMetrics metrics;
    Segment lineBuffer = new Segment();
    int width;
    int tabSize;
    int tabBase;
    JTextComponent host;
    int sel0;
    int sel1;
    Color unselected;
    Color selected;

    public PlainView(Element element) {
        super(element);
    }

    protected int getTabSize() {
        Integer n = (Integer)this.getDocument().getProperty("tabSize");
        int n2 = n != null ? n : 8;
        return n2;
    }

    protected int getLineLimit() {
        Integer n = (Integer)this.getDocument().getProperty("lineLimit");
        if (n == null) {
            int n2 = 0;
            int n3 = this.getElement().getElementCount();
            int n4 = 0;
            while (n4 < n3) {
                Element element = this.getElement().getElement(n4);
                int n5 = element.getStartOffset();
                int n6 = element.getEndOffset();
                if (n6 - n5 > n2) {
                    n2 = n6 - n5;
                }
                ++n4;
            }
            n = new Integer(n2);
            this.getDocument().putProperty("lineLimit", n);
        }
        return n;
    }

    protected void drawLine(int n, Graphics graphics, int n2, int n3) {
        try {
            Element element = this.getElement().getElement(n);
            int n4 = element.getStartOffset();
            int n5 = element.getEndOffset();
            n5 = Math.min(this.getDocument().getLength(), n5);
            if (this.sel0 == this.sel1) {
                this.drawUnselectedText(graphics, n2, n3, n4, n5);
                return;
            }
            if (n4 >= this.sel0 && n4 <= this.sel1 && n5 >= this.sel0 && n5 <= this.sel1) {
                this.drawSelectedText(graphics, n2, n3, n4, n5);
                return;
            }
            if (this.sel0 >= n4 && this.sel0 <= n5) {
                if (this.sel1 >= n4 && this.sel1 <= n5) {
                    n2 = this.drawUnselectedText(graphics, n2, n3, n4, this.sel0);
                    n2 = this.drawSelectedText(graphics, n2, n3, this.sel0, this.sel1);
                    this.drawUnselectedText(graphics, n2, n3, this.sel1, n5);
                    return;
                }
                n2 = this.drawUnselectedText(graphics, n2, n3, n4, this.sel0);
                this.drawSelectedText(graphics, n2, n3, this.sel0, n5);
                return;
            }
            if (this.sel1 >= n4 && this.sel1 <= n5) {
                n2 = this.drawSelectedText(graphics, n2, n3, n4, this.sel1);
                this.drawUnselectedText(graphics, n2, n3, this.sel1, n5);
                return;
            }
            this.drawUnselectedText(graphics, n2, n3, n4, n5);
            return;
        }
        catch (BadLocationException badLocationException) {
            throw new StateInvariantError("Can't render line: " + n);
        }
    }

    protected int drawUnselectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        graphics.setColor(this.unselected);
        Document document = this.getDocument();
        document.getText(n3, n4 - n3, this.lineBuffer);
        return Utilities.drawTabbedText(this.lineBuffer, n, n2, graphics, this, n3);
    }

    protected int drawSelectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        graphics.setColor(this.selected);
        Document document = this.getDocument();
        document.getText(n3, n4 - n3, this.lineBuffer);
        return Utilities.drawTabbedText(this.lineBuffer, n, n2, graphics, this, n3);
    }

    protected final Segment getLineBuffer() {
        return this.lineBuffer;
    }

    final void updateMetrics() {
        Container container = this.getContainer();
        Font font = container.getFont();
        this.metrics = container.getFontMetrics(font);
        int n = this.metrics.charWidth('m');
        this.width = this.getLineLimit() * n;
        this.tabSize = this.getTabSize() * n;
    }

    public void setParent(View view) {
        super.setParent(view);
        this.host = (JTextComponent)this.getContainer();
    }

    public float getPreferredSpan(int n) {
        this.updateMetrics();
        switch (n) {
            case 0: {
                return this.width;
            }
            case 1: {
                return this.getElement().getElementCount() * this.metrics.getHeight();
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = shape.getBounds();
        this.tabBase = rectangle.x;
        graphics.setFont(this.host.getFont());
        this.sel0 = this.host.getSelectionStart();
        this.sel1 = this.host.getSelectionEnd();
        this.unselected = this.host.isEnabled() ? this.host.getForeground() : this.host.getDisabledTextColor();
        Caret caret = this.host.getCaret();
        this.selected = caret.isSelectionVisible() ? this.host.getSelectedTextColor() : this.unselected;
        this.updateMetrics();
        Rectangle rectangle2 = graphics.getClipBounds();
        int n = this.metrics.getHeight();
        int n2 = rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height);
        int n3 = Math.max(0, n2 / n);
        int n4 = rectangle2.y - rectangle.y;
        int n5 = Math.max(0, n4 / n);
        int n6 = rectangle.height / n;
        Rectangle rectangle3 = this.lineToRect(shape, n5);
        int n7 = rectangle3.y + this.metrics.getAscent();
        int n8 = rectangle3.x;
        Element element = this.getElement();
        int n9 = Math.min(element.getElementCount(), n6 - n3);
        int n10 = n5;
        while (n10 < n9) {
            this.drawLine(n10, graphics, n8, n7);
            n7 += n;
            ++n10;
        }
    }

    public void preferenceChanged(View view, boolean bl, boolean bl2) {
        this.getDocument().putProperty("lineLimit", null);
        super.preferenceChanged(view, bl, bl2);
    }

    public Shape modelToView(int n, Shape shape) throws BadLocationException {
        Document document = this.getDocument();
        Element element = this.getElement();
        int n2 = element.getElementIndex(n);
        Rectangle rectangle = this.lineToRect(shape, n2);
        this.tabBase = rectangle.x;
        this.tabBase = rectangle.x;
        Element element2 = element.getElement(n2);
        int n3 = element2.getStartOffset();
        document.getText(n3, n - n3, this.lineBuffer);
        int n4 = Utilities.getTabbedTextWidth(this.lineBuffer, this.metrics, 0, this, n3);
        rectangle.x += n4;
        rectangle.width = 1;
        rectangle.height = this.metrics.getHeight();
        return rectangle;
    }

    public int viewToModel(float f, float f2, Shape shape) {
        Rectangle rectangle = shape.getBounds();
        Document document = this.getDocument();
        int n = (int)f;
        int n2 = (int)f2;
        if (n2 < rectangle.y) {
            return this.getStartOffset();
        }
        if (n2 > rectangle.y + rectangle.height) {
            return this.getEndOffset() - 1;
        }
        Element element = document.getDefaultRootElement();
        int n3 = Math.abs((n2 - rectangle.y) / this.metrics.getHeight());
        if (n3 >= element.getElementCount()) {
            return this.getEndOffset() - 1;
        }
        Element element2 = element.getElement(n3);
        if (n < rectangle.x) {
            return element2.getStartOffset();
        }
        if (n > rectangle.x + rectangle.width) {
            return element2.getEndOffset() - 1;
        }
        try {
            int n4 = element2.getStartOffset();
            int n5 = element2.getEndOffset() - 1;
            document.getText(n4, n5 - n4, this.lineBuffer);
            this.tabBase = rectangle.x;
            int n6 = n4 + Utilities.getTabbedTextOffset(this.lineBuffer, this.metrics, this.tabBase, n, this, n4);
            return n6;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateDamage(documentEvent, shape, viewFactory);
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateDamage(documentEvent, shape, viewFactory);
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateDamage(documentEvent, shape, viewFactory);
    }

    public float nextTabStop(float f, int n) {
        int n2 = ((int)f - this.tabBase) / this.tabSize;
        return (n2 + 1) * this.tabSize;
    }

    void updateDamage(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        if (this.host.isShowing()) {
            Element[] elementArray;
            this.updateMetrics();
            Element element = this.getElement();
            DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
            Element[] elementArray2 = elementChange != null ? elementChange.getChildrenAdded() : null;
            Element[] elementArray3 = elementArray = elementChange != null ? elementChange.getChildrenRemoved() : null;
            if (elementArray2 != null && elementArray2.length > 0 || elementArray != null && elementArray.length > 0) {
                this.preferenceChanged(null, true, true);
                this.host.repaint();
                return;
            }
            this.preferenceChanged(null, true, false);
            Element element2 = this.getElement();
            int n = element2.getElementIndex(documentEvent.getOffset());
            this.damageLineRange(n, n, shape, this.host);
        }
    }

    private void damageLineRange(int n, int n2, Shape shape, Component component) {
        if (shape != null) {
            Rectangle rectangle = this.lineToRect(shape, n);
            Rectangle rectangle2 = this.lineToRect(shape, n2);
            if (rectangle != null && rectangle2 != null) {
                Rectangle rectangle3 = rectangle.union(rectangle2);
                component.repaint(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                return;
            }
            component.repaint();
        }
    }

    private Rectangle lineToRect(Shape shape, int n) {
        Rectangle rectangle = null;
        if (this.metrics != null) {
            Rectangle rectangle2 = shape.getBounds();
            rectangle = new Rectangle(rectangle2.x, rectangle2.y + n * this.metrics.getHeight(), rectangle2.width, this.metrics.getHeight());
        }
        return rectangle;
    }
}

