/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.text;

import com.sun.java.swing.Icon;
import com.sun.java.swing.text.AttributeSet;
import com.sun.java.swing.text.MutableAttributeSet;
import com.sun.java.swing.text.StyleContext;
import com.sun.java.swing.text.TabSet;
import java.awt.Color;
import java.awt.Component;

public class StyleConstants {
    public static final String ComponentElementName = "component";
    public static final String IconElementName = "icon";
    public static final Object NameAttribute = new StyleConstants("name");
    public static final Object ResolveAttribute = new StyleConstants("resolver");
    public static final Object FontFamily = CharacterConstants.Family;
    public static final Object FontSize = CharacterConstants.Size;
    public static final Object Bold = CharacterConstants.Bold;
    public static final Object Italic = CharacterConstants.Italic;
    public static final Object Underline = CharacterConstants.Underline;
    public static final Object Foreground = CharacterConstants.Foreground;
    public static final Object Background = CharacterConstants.Background;
    public static final Object ComponentAttribute = CharacterConstants.ComponentAttribute;
    public static final Object IconAttribute = CharacterConstants.IconAttribute;
    public static final Object FirstLineIndent = ParagraphConstants.FirstLineIndent;
    public static final Object LeftIndent = ParagraphConstants.LeftIndent;
    public static final Object RightIndent = ParagraphConstants.RightIndent;
    public static final Object LineSpacing = ParagraphConstants.LineSpacing;
    public static final Object SpaceAbove = ParagraphConstants.SpaceAbove;
    public static final Object SpaceBelow = ParagraphConstants.SpaceBelow;
    public static final Object Alignment = ParagraphConstants.Alignment;
    public static final Object TabSet = ParagraphConstants.TabSet;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int ALIGN_JUSTIFIED = 3;
    private static Object[] keys = new Object[]{NameAttribute, ResolveAttribute, FontFamily, FontSize, Bold, Italic, Underline, Foreground, Background, ComponentAttribute, IconAttribute, FirstLineIndent, LeftIndent, RightIndent, LineSpacing, SpaceAbove, SpaceBelow, Alignment, TabSet};
    private String representation;

    public String toString() {
        return this.representation;
    }

    public static Component getComponent(AttributeSet attributeSet) {
        return (Component)attributeSet.getAttribute(ComponentAttribute);
    }

    public static void setComponent(MutableAttributeSet mutableAttributeSet, Component component) {
        mutableAttributeSet.addAttribute("$ename", ComponentElementName);
        mutableAttributeSet.addAttribute(ComponentAttribute, component);
    }

    public static Icon getIcon(AttributeSet attributeSet) {
        return (Icon)attributeSet.getAttribute(IconAttribute);
    }

    public static void setIcon(MutableAttributeSet mutableAttributeSet, Icon icon) {
        mutableAttributeSet.addAttribute("$ename", IconElementName);
        mutableAttributeSet.addAttribute(IconAttribute, icon);
    }

    public static String getFontFamily(AttributeSet attributeSet) {
        String string = (String)attributeSet.getAttribute(FontFamily);
        if (string == null) {
            string = "Courier";
        }
        return string;
    }

    public static void setFontFamily(MutableAttributeSet mutableAttributeSet, String string) {
        mutableAttributeSet.addAttribute(FontFamily, string);
    }

    public static int getFontSize(AttributeSet attributeSet) {
        Integer n = (Integer)attributeSet.getAttribute(FontSize);
        if (n != null) {
            return n;
        }
        return 12;
    }

    public static void setFontSize(MutableAttributeSet mutableAttributeSet, int n) {
        mutableAttributeSet.addAttribute(FontSize, new Integer(n));
    }

    public static boolean isBold(AttributeSet attributeSet) {
        Boolean bl = (Boolean)attributeSet.getAttribute(Bold);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static void setBold(MutableAttributeSet mutableAttributeSet, boolean bl) {
        mutableAttributeSet.addAttribute(Bold, new Boolean(bl));
    }

    public static boolean isItalic(AttributeSet attributeSet) {
        Boolean bl = (Boolean)attributeSet.getAttribute(Italic);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static void setItalic(MutableAttributeSet mutableAttributeSet, boolean bl) {
        mutableAttributeSet.addAttribute(Italic, new Boolean(bl));
    }

    public static boolean isUnderline(AttributeSet attributeSet) {
        Boolean bl = (Boolean)attributeSet.getAttribute(Underline);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static void setUnderline(MutableAttributeSet mutableAttributeSet, boolean bl) {
        mutableAttributeSet.addAttribute(Underline, new Boolean(bl));
    }

    public static Color getForeground(AttributeSet attributeSet) {
        Color color = (Color)attributeSet.getAttribute(Foreground);
        if (color == null) {
            color = Color.black;
        }
        return color;
    }

    public static void setForeground(MutableAttributeSet mutableAttributeSet, Color color) {
        mutableAttributeSet.addAttribute(Foreground, color);
    }

    public static float getFirstLineIndent(AttributeSet attributeSet) {
        Float f = (Float)attributeSet.getAttribute(FirstLineIndent);
        if (f != null) {
            return f.floatValue();
        }
        return 0.0f;
    }

    public static void setFirstLineIndent(MutableAttributeSet mutableAttributeSet, float f) {
        mutableAttributeSet.addAttribute(FirstLineIndent, new Float(f));
    }

    public static float getRightIndent(AttributeSet attributeSet) {
        Float f = (Float)attributeSet.getAttribute(RightIndent);
        if (f != null) {
            return f.floatValue();
        }
        return 0.0f;
    }

    public static void setRightIndent(MutableAttributeSet mutableAttributeSet, float f) {
        mutableAttributeSet.addAttribute(RightIndent, new Float(f));
    }

    public static float getLeftIndent(AttributeSet attributeSet) {
        Float f = (Float)attributeSet.getAttribute(LeftIndent);
        if (f != null) {
            return f.floatValue();
        }
        return 0.0f;
    }

    public static void setLeftIndent(MutableAttributeSet mutableAttributeSet, float f) {
        mutableAttributeSet.addAttribute(LeftIndent, new Float(f));
    }

    public static float getLineSpacing(AttributeSet attributeSet) {
        Float f = (Float)attributeSet.getAttribute(LineSpacing);
        if (f != null) {
            return f.floatValue();
        }
        return 0.0f;
    }

    public static void setLineSpacing(MutableAttributeSet mutableAttributeSet, float f) {
        mutableAttributeSet.addAttribute(LineSpacing, new Float(f));
    }

    public static float getSpaceAbove(AttributeSet attributeSet) {
        Float f = (Float)attributeSet.getAttribute(SpaceAbove);
        if (f != null) {
            return f.floatValue();
        }
        return 0.0f;
    }

    public static void setSpaceAbove(MutableAttributeSet mutableAttributeSet, float f) {
        mutableAttributeSet.addAttribute(SpaceAbove, new Float(f));
    }

    public static float getSpaceBelow(AttributeSet attributeSet) {
        Float f = (Float)attributeSet.getAttribute(SpaceBelow);
        if (f != null) {
            return f.floatValue();
        }
        return 0.0f;
    }

    public static void setSpaceBelow(MutableAttributeSet mutableAttributeSet, float f) {
        mutableAttributeSet.addAttribute(SpaceBelow, new Float(f));
    }

    public static int getAlignment(AttributeSet attributeSet) {
        Integer n = (Integer)attributeSet.getAttribute(Alignment);
        if (n != null) {
            return n;
        }
        return 0;
    }

    public static void setAlignment(MutableAttributeSet mutableAttributeSet, int n) {
        mutableAttributeSet.addAttribute(Alignment, new Integer(n));
    }

    public static TabSet getTabSet(AttributeSet attributeSet) {
        TabSet tabSet = (TabSet)attributeSet.getAttribute(TabSet);
        return tabSet;
    }

    public static void setTabSet(MutableAttributeSet mutableAttributeSet, TabSet tabSet) {
        mutableAttributeSet.addAttribute(TabSet, tabSet);
    }

    private StyleConstants(String string) {
        this.representation = string;
    }

    static {
        try {
            int n = 0;
            while (n < keys.length) {
                StyleContext.registerStaticAttributeKey(keys[n]);
                ++n;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static class ParagraphConstants
    implements AttributeSet.ParagraphAttribute {
        public static final Object FirstLineIndent = new ParagraphConstants("FirstLineIndent");
        public static final Object LeftIndent = new ParagraphConstants("LeftIndent");
        public static final Object RightIndent = new ParagraphConstants("RightIndent");
        public static final Object LineSpacing = new ParagraphConstants("LineSpacing");
        public static final Object SpaceAbove = new ParagraphConstants("SpaceAbove");
        public static final Object SpaceBelow = new ParagraphConstants("SpaceBelow");
        public static final Object Alignment = new ParagraphConstants("Alignment");
        public static final Object TabSet = new ParagraphConstants("TabSet");
        private String representation;

        public String toString() {
            return this.representation;
        }

        private ParagraphConstants(String string) {
            this.representation = string;
        }
    }

    public static class CharacterConstants
    implements AttributeSet.CharacterAttribute {
        public static final Object Underline = new CharacterConstants("underline");
        public static final Object ComponentAttribute = new CharacterConstants("component");
        public static final Object IconAttribute = new CharacterConstants("icon");
        public static final Object Family = FontConstants.Family;
        public static final Object Size = FontConstants.Size;
        public static final Object Bold = FontConstants.Bold;
        public static final Object Italic = FontConstants.Italic;
        public static final Object Foreground = ColorConstants.Foreground;
        public static final Object Background = ColorConstants.Background;
        private String representation;

        public String toString() {
            return this.representation;
        }

        private CharacterConstants(String string) {
            this.representation = string;
        }
    }

    public static class ColorConstants
    implements AttributeSet.ColorAttribute,
    AttributeSet.CharacterAttribute {
        public static final Object Foreground = new ColorConstants("foreground");
        public static final Object Background = new ColorConstants("background");
        private String representation;

        public String toString() {
            return this.representation;
        }

        private ColorConstants(String string) {
            this.representation = string;
        }
    }

    public static class FontConstants
    implements AttributeSet.FontAttribute,
    AttributeSet.CharacterAttribute {
        public static final Object Family = new FontConstants("family");
        public static final Object Size = new FontConstants("size");
        public static final Object Bold = new FontConstants("bold");
        public static final Object Italic = new FontConstants("italic");
        private String representation;

        public String toString() {
            return this.representation;
        }

        private FontConstants(String string) {
            this.representation = string;
        }
    }
}

