/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.text.html;

import com.sun.java.swing.JButton;
import com.sun.java.swing.JCheckBox;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JRadioButton;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTextArea;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.text.AbstractDocument;
import com.sun.java.swing.text.AttributeSet;
import com.sun.java.swing.text.BadLocationException;
import com.sun.java.swing.text.DefaultStyledDocument;
import com.sun.java.swing.text.Element;
import com.sun.java.swing.text.MutableAttributeSet;
import com.sun.java.swing.text.SimpleAttributeSet;
import com.sun.java.swing.text.StringContent;
import com.sun.java.swing.text.Style;
import com.sun.java.swing.text.StyleConstants;
import com.sun.java.swing.text.StyleContext;
import com.sun.java.swing.text.html.HTMLDefs;
import com.sun.java.swing.text.html.HTMLException;
import com.sun.java.swing.text.html.HTMLParserCallbackDefault;
import com.sun.java.swing.text.html.HTMLUtils;
import com.sun.java.swing.text.html.ImageView;
import com.sun.java.swing.text.html.SpecialCharTable;
import com.sun.java.swing.text.html.StyleReader;
import com.sun.java.swing.text.html.StyleSheet;
import com.sun.java.swing.text.html.StyleXlater;
import com.sun.java.swing.text.html.html32;
import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Stack;
import java.util.Vector;

class HTMLDocument
extends DefaultStyledDocument
implements HTMLDefs {
    public static final String HTMLTagAttribute = "htmltag";
    public static final String BaseHrefProperty = "basehref";
    public static final String BGCOLOR = "BGCOLOR";
    public static final String BACKGROUND = "BACKGROUND";
    public static final String KEYWORDS = "Keywords";
    public static final String TEXT = "TEXT";
    public static final String LINK = "LINK";
    public static final String VLINK = "VLINK";
    public static final String ALINK = "ALINK";
    public static final String HTMLInputComponent = "input-component";
    URL reference;

    public HTMLDocument() {
    }

    public HTMLDocument(StyleContext styleContext) {
        super((AbstractDocument.Content)new StringContent(4096), styleContext);
    }

    public void setRootElementAttributes(MutableAttributeSet mutableAttributeSet) {
        Element element = this.getDefaultRootElement();
        try {
            this.writeLock();
            MutableAttributeSet mutableAttributeSet2 = (MutableAttributeSet)element.getAttributes();
            mutableAttributeSet2.addAttributes(mutableAttributeSet);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.writeUnlock();
            throw throwable;
        }
        Object var4_4 = null;
        this.writeUnlock();
    }

    public void read(Reader reader, int n) throws IOException {
        Object object = this.getProperty("stream");
        if (object instanceof URL) {
            this.reference = (URL)object;
        }
        HTMLReader hTMLReader = new HTMLReader();
        hTMLReader.read(n, reader);
    }

    protected void insert(int n, DefaultStyledDocument.ElementSpec[] elementSpecArray) throws BadLocationException {
        super.insert(n, elementSpecArray);
    }

    StyleContext getStyleContext() {
        return (StyleContext)this.getAttributeContext();
    }

    public void getComponents(Vector vector) {
        AbstractDocument.AbstractElement abstractElement = (AbstractDocument.AbstractElement)this.getDefaultRootElement();
        this.findComponents(abstractElement, vector);
    }

    private void findComponents(AbstractDocument.AbstractElement abstractElement, Vector vector) {
        if (abstractElement.isLeaf()) {
            String string;
            AttributeSet attributeSet = abstractElement.getAttributes();
            if (attributeSet.getAttribute(string = new String(HTMLInputComponent)) != null) {
                vector.addElement((Component)attributeSet.getAttribute(StyleConstants.ComponentAttribute));
                return;
            }
        } else {
            int n = abstractElement.getElementCount();
            int n2 = 0;
            while (n2 < n) {
                AbstractDocument.AbstractElement abstractElement2 = (AbstractDocument.AbstractElement)abstractElement.getElement(n2);
                this.findComponents(abstractElement2, vector);
                ++n2;
            }
        }
    }

    class HTMLReader
    extends HTMLParserCallbackDefault {
        boolean openTagSeen = false;
        boolean inPre = false;
        boolean inTitle = false;
        boolean inOption = false;
        Stack dataCountStack = new Stack();
        JComboBox combobox;
        Vector parseBuffer = new Vector();
        MutableAttributeSet charAttr = new SimpleAttributeSet();
        Stack charAttrStack = new Stack();
        Style resolver;
        Stack styleStack = new Stack();
        MutableAttributeSet attr = new SimpleAttributeSet();
        int inBlock;
        html32 parser;
        SpecialCharTable specTable = new SpecialCharTable();

        public void read(int n, Reader reader) throws IOException {
            this.parser = new html32(reader);
            StyleContext styleContext = HTMLDocument.this.getStyleContext();
            this.charAttr = styleContext.addStyle(null, null);
            this.attr = styleContext.addStyle(null, null);
            this.resolver = HTMLDocument.this.getStyle("default-hierarchy");
            String string = " ";
            DefaultStyledDocument.ElementSpec elementSpec = new DefaultStyledDocument.ElementSpec(null, 3, string.toCharArray(), 0, 1);
            this.parseBuffer.addElement(elementSpec);
            elementSpec = new DefaultStyledDocument.ElementSpec(null, 2);
            this.parseBuffer.addElement(elementSpec);
            this.parser.setCallback(this);
            try {
                this.parser.html();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new IOException(exception.toString());
            }
            Object[] objectArray = new DefaultStyledDocument.ElementSpec[this.parseBuffer.size()];
            this.parseBuffer.copyInto(objectArray);
            try {
                HTMLDocument.this.insert(n, (DefaultStyledDocument.ElementSpec[])objectArray);
                return;
            }
            catch (BadLocationException badLocationException) {
                throw new IOException("BadLocationException: " + badLocationException.getMessage());
            }
        }

        public Style getChildStyle(String string) {
            Style style = HTMLDocument.this.getStyle("SH" + string);
            return (Style)style.getAttribute("child-style");
        }

        public void attributeAction(String string, String string2) {
            if (string2 == null) {
                string2 = "#DEFAULT";
            }
            this.attr.addAttribute(string.toLowerCase(), string2);
        }

        private void setAlignment(MutableAttributeSet mutableAttributeSet) {
            String string = (String)mutableAttributeSet.getAttribute("align");
            if (string != null) {
                if ((string = string.toLowerCase()).equals("left")) {
                    StyleConstants.setAlignment(mutableAttributeSet, 0);
                    return;
                }
                if (string.equals("center")) {
                    StyleConstants.setAlignment(mutableAttributeSet, 1);
                    return;
                }
                if (string.equals("right")) {
                    StyleConstants.setAlignment(mutableAttributeSet, 2);
                }
            }
        }

        public void blockOpenAction(String string) {
            this.setAlignment(this.attr);
            this.blockOpen(string, false);
        }

        public void blockCloseAction(String string) {
            this.blockClose();
        }

        public void incrementPCData() {
            if (!this.dataCountStack.empty()) {
                DataCounter dataCounter = (DataCounter)this.dataCountStack.pop();
                dataCounter.incCounter();
                this.dataCountStack.push(dataCounter);
            }
        }

        public void pcdataAction(String string) {
            this.incrementPCData();
            String string2 = this.xlateSpecialChars(string);
            if (string2 != null) {
                string = string2;
            }
            if (this.inPre) {
                this.preContent(string);
            } else if (this.inTitle) {
                this.titleContent(string);
            } else if (this.inOption) {
                string = this.cleanString(string);
                this.combobox.addItem(string);
            } else if (this.inBlock > 0 && (string = this.cleanString(string)).length() >= 1) {
                AttributeSet attributeSet = this.charAttr.copyAttributes();
                DefaultStyledDocument.ElementSpec elementSpec = new DefaultStyledDocument.ElementSpec(attributeSet, 3, string.toCharArray(), 0, string.length());
                this.parseBuffer.addElement(elementSpec);
            }
            this.attr.removeAttributes(this.attr);
        }

        protected void cleanEndTag(boolean bl) {
            DefaultStyledDocument.ElementSpec elementSpec = (DefaultStyledDocument.ElementSpec)this.parseBuffer.lastElement();
            if (elementSpec == null) {
                return;
            }
            char[] cArray = elementSpec.getArray();
            if (cArray == null) {
                return;
            }
            String string = new String(cArray);
            if (string.length() == 0) {
                return;
            }
            if (this.isWhiteSpace(string.charAt(string.length() - 1))) {
                string = string.substring(0, string.length() - 1);
            }
            if (bl) {
                string = String.valueOf(string) + "\n";
            }
            DefaultStyledDocument.ElementSpec elementSpec2 = new DefaultStyledDocument.ElementSpec(elementSpec.getAttributes(), 3, string.toCharArray(), 0, string.length());
            this.parseBuffer.removeElementAt(this.parseBuffer.size() - 1);
            this.parseBuffer.addElement(elementSpec2);
        }

        protected boolean isWhiteSpace(char c) {
            return c == ' ' || c == '\n' || c == '\r' || c == '\t';
        }

        protected String cleanString(String string) {
            if (string.length() < 1) {
                return string;
            }
            String string2 = "";
            String string3 = "";
            if (string.length() > 1 && this.isWhiteSpace(string.charAt(string.length() - 1))) {
                string2 = new String(" ");
            }
            if (this.isWhiteSpace(string.charAt(0))) {
                string3 = new String(" ");
            }
            String string4 = String.valueOf(string3) + string.trim() + string2;
            if (this.openTagSeen && string3.equals(" ")) {
                string4 = string4.substring(1, string4.length());
            }
            this.openTagSeen = false;
            int n = 0;
            while (n < string4.length()) {
                int n2;
                if (!this.isWhiteSpace(string4.charAt(n2 = n++))) continue;
                while (n2 < string4.length() && this.isWhiteSpace(string4.charAt(n2))) {
                    ++n2;
                }
                string4 = String.valueOf(string4.substring(0, n)) + " " + string4.substring(n2, string4.length());
                n = n2;
            }
            return string4;
        }

        public void fontOpenAction() {
            String string;
            this.openTagSeen = true;
            this.pushCharacterStyle();
            Color color = this.getColor(this.attr);
            if (color != null) {
                StyleConstants.setForeground(this.charAttr, color);
            }
            if ((string = (String)this.attr.getAttribute("face")) != null) {
                StyleConstants.setFontFamily(this.charAttr, string);
            }
            String string2 = (String)this.attr.getAttribute("size");
            StyleSheet styleSheet = StyleReader.getStyleSheet();
            if (string2 != null) {
                StyleConstants.setFontSize(this.charAttr, styleSheet.getPtSize(string2));
            }
        }

        public void fontCloseAction() {
            this.popCharacterStyle();
        }

        public void htmlOpenAction() {
        }

        public void htmlCloseAction() {
        }

        public void headOpenAction() {
        }

        public void headCloseAction() {
        }

        public void bodyOpenAction() {
            HTMLDocument.this.setRootElementAttributes(this.attr);
        }

        public void bodyCloseAction() {
        }

        public void whitespaceAction(String string) {
            this.addContent(string);
        }

        public void titleOpenAction() {
            this.inTitle = true;
        }

        public void titleCloseAction() {
            this.inTitle = false;
        }

        public void preOpenAction() {
            this.inPre = true;
            this.blockOpen("pre", true);
            this.blockOpen("pre-line", true);
        }

        public void preCloseAction() {
            this.inPre = false;
            this.blockClose();
            this.blockClose();
        }

        void titleContent(String string) {
            HTMLDocument.this.putProperty("title", string);
        }

        void preContent(String string) {
            int n = 0;
            int n2 = string.indexOf(10);
            while (n2 >= 0) {
                String string2 = string.substring(n, n2);
                this.addContent(string2);
                this.blockClose();
                this.blockOpen("pre-line", true);
                n = n2 + 1;
                n2 = string.indexOf(10, n);
            }
            if (n < string.length()) {
                this.addContent(string.substring(n, string.length()));
            }
        }

        public void ttOpenAction() {
            this.pushCharacterStyle();
            this.attr.addAttribute("tt", "true");
            Style style = this.getChildStyle("tt");
            if (style != null) {
                this.charAttr.addAttributes(style);
                this.charAttr.removeAttribute(StyleConstants.ResolveAttribute);
            } else {
                StyleConstants.setFontFamily(this.charAttr, "Monospaced");
            }
            this.charAttr.addAttributes(this.attr);
        }

        public void ttCloseAction() {
            this.popCharacterStyle();
        }

        public void dfnOpenAction() {
            this.pushCharacterStyle();
            Style style = this.getChildStyle("dfn");
            if (style != null) {
                this.charAttr.addAttributes(style);
                this.charAttr.removeAttribute(StyleConstants.ResolveAttribute);
            } else {
                StyleConstants.setItalic(this.charAttr, true);
            }
            this.charAttr.addAttributes(this.attr);
        }

        public void dfnCloseAction() {
            this.popCharacterStyle();
        }

        public void citeOpenAction() {
            this.pushCharacterStyle();
            Style style = this.getChildStyle("cite");
            if (style != null) {
                this.charAttr.addAttributes(style);
                this.charAttr.removeAttribute(StyleConstants.ResolveAttribute);
            } else {
                StyleConstants.setItalic(this.charAttr, true);
            }
            this.charAttr.addAttributes(this.attr);
        }

        public void citeCloseAction() {
            this.popCharacterStyle();
        }

        public void bigOpenAction() {
            this.pushCharacterStyle();
            Style style = this.getChildStyle("big");
            if (style != null) {
                this.charAttr.addAttributes(style);
                this.charAttr.removeAttribute(StyleConstants.ResolveAttribute);
                return;
            }
            String string = StyleXlater.convertFontSizeString("x-large");
            StyleSheet styleSheet = StyleReader.getStyleSheet();
            int n = styleSheet.getPtSize(string);
            StyleConstants.setFontSize(this.charAttr, n);
        }

        public void bigCloseAction() {
            this.popCharacterStyle();
        }

        public void smallOpenAction() {
            this.pushCharacterStyle();
            Style style = this.getChildStyle("small");
            if (style != null) {
                this.charAttr.addAttributes(style);
                this.charAttr.removeAttribute(StyleConstants.ResolveAttribute);
                return;
            }
            String string = StyleXlater.convertFontSizeString("x-small");
            StyleSheet styleSheet = StyleReader.getStyleSheet();
            int n = styleSheet.getPtSize(string);
            StyleConstants.setFontSize(this.charAttr, n);
        }

        public void smallCloseAction() {
            this.popCharacterStyle();
        }

        public void sampOpenAction() {
            this.pushCharacterStyle();
            Style style = this.getChildStyle("samp");
            if (style != null) {
                this.charAttr.addAttributes(style);
                this.charAttr.removeAttribute(StyleConstants.ResolveAttribute);
                return;
            }
            String string = StyleXlater.convertFontSizeString("small");
            StyleSheet styleSheet = StyleReader.getStyleSheet();
            int n = styleSheet.getPtSize(string);
            StyleConstants.setFontSize(this.charAttr, n);
            StyleConstants.setFontFamily(this.charAttr, "Monospaced");
        }

        public void sampCloseAction() {
            this.popCharacterStyle();
        }

        public void codeOpenAction() {
            this.pushCharacterStyle();
            Style style = this.getChildStyle("code");
            if (style != null) {
                this.charAttr.addAttributes(style);
                this.charAttr.removeAttribute(StyleConstants.ResolveAttribute);
                return;
            }
            String string = StyleXlater.convertFontSizeString("small");
            StyleSheet styleSheet = StyleReader.getStyleSheet();
            int n = styleSheet.getPtSize(string);
            StyleConstants.setFontSize(this.charAttr, n);
            StyleConstants.setFontFamily(this.charAttr, "Monospaced");
        }

        public void codeCloseAction() {
            this.popCharacterStyle();
        }

        public void strikeOpenAction() {
            this.pushCharacterStyle();
            Style style = this.getChildStyle("strike");
            if (style != null) {
                this.charAttr.addAttributes(style);
                this.charAttr.removeAttribute(StyleConstants.ResolveAttribute);
            }
        }

        public void strikeCloseAction() {
            this.popCharacterStyle();
        }

        public void blockquoteOpenAction() {
            this.blockOpen("blockquote", false);
        }

        public void blockquoteCloseAction() {
            this.blockClose();
        }

        public void emOpenAction() {
            this.pushCharacterStyle();
            Style style = this.getChildStyle("em");
            if (style != null) {
                this.charAttr.addAttributes(style);
                this.charAttr.removeAttribute(StyleConstants.ResolveAttribute);
            } else {
                StyleConstants.setItalic(this.charAttr, true);
            }
            this.charAttr.addAttributes(this.attr);
        }

        public void emCloseAction() {
            this.popCharacterStyle();
        }

        public void addressOpenAction() {
            this.pushCharacterStyle();
            Style style = this.getChildStyle("address");
            if (style != null) {
                this.charAttr.addAttributes(style);
                this.charAttr.removeAttribute(StyleConstants.ResolveAttribute);
            } else {
                StyleConstants.setItalic(this.charAttr, true);
            }
            this.charAttr.addAttributes(this.attr);
        }

        public void addressCloseAction() {
            this.popCharacterStyle();
        }

        public void strongOpenAction() {
            this.pushCharacterStyle();
            Style style = this.getChildStyle("strong");
            if (style != null) {
                this.charAttr.addAttributes(style);
                this.charAttr.removeAttribute(StyleConstants.ResolveAttribute);
            } else {
                StyleConstants.setBold(this.charAttr, true);
            }
            this.charAttr.addAttributes(this.attr);
        }

        public void strongCloseAction() {
            this.popCharacterStyle();
        }

        public void varOpenAction() {
            this.pushCharacterStyle();
            Style style = this.getChildStyle("_var");
            if (style != null) {
                this.charAttr.addAttributes(style);
                this.charAttr.removeAttribute(StyleConstants.ResolveAttribute);
            } else {
                StyleConstants.setBold(this.charAttr, true);
                StyleConstants.setItalic(this.charAttr, true);
            }
            this.charAttr.addAttributes(this.attr);
        }

        public void varCloseAction() {
            this.popCharacterStyle();
        }

        public void basefontAction() {
            this.attr.addAttribute(HTMLDocument.HTMLTagAttribute, "basefont");
            this.addSpecialElement(this.attr);
        }

        public void brAction() {
        }

        public void aOpenAction() {
            this.pushCharacterStyle();
            Style style = this.getChildStyle("a");
            if (style != null) {
                this.charAttr.addAttributes(style);
                this.charAttr.removeAttribute(StyleConstants.ResolveAttribute);
            }
            this.charAttr.addAttributes(this.attr);
        }

        private void checkPCData() {
            DataCounter dataCounter;
            if (!this.dataCountStack.empty() && (dataCounter = (DataCounter)this.dataCountStack.peek()).noPCData()) {
                AttributeSet attributeSet = this.charAttr.copyAttributes();
                String string = new String("");
                DefaultStyledDocument.ElementSpec elementSpec = new DefaultStyledDocument.ElementSpec(attributeSet, 3, string.toCharArray(), 0, string.length());
                this.parseBuffer.addElement(elementSpec);
            }
        }

        public void aCloseAction() {
            this.checkPCData();
            this.popCharacterStyle();
        }

        public void hrAction() {
            this.setAlignment(this.attr);
            this.attr.addAttribute("$ename", "hr");
            this.addSpecialElement(this.attr);
        }

        public void imgAction() {
            this.attr.addAttribute("$ename", "img");
            this.attr.addAttributes(this.charAttr);
            ImageView.addImageDataAttribute(this.attr);
            this.addSpecialElement(this.attr);
        }

        public void iOpenAction() {
            this.pushCharacterStyle();
            Style style = this.getChildStyle("i");
            if (style != null) {
                this.charAttr.addAttributes(style);
                this.charAttr.removeAttribute(StyleConstants.ResolveAttribute);
            } else {
                StyleConstants.setItalic(this.charAttr, true);
            }
            this.charAttr.addAttributes(this.attr);
        }

        public void iCloseAction() {
            this.popCharacterStyle();
        }

        public void bOpenAction() {
            this.pushCharacterStyle();
            Style style = this.getChildStyle("b");
            if (style != null) {
                this.charAttr.addAttributes(style);
                this.charAttr.removeAttribute(StyleConstants.ResolveAttribute);
            } else {
                StyleConstants.setBold(this.charAttr, true);
            }
            this.charAttr.addAttributes(this.attr);
        }

        public void bCloseAction() {
            this.popCharacterStyle();
        }

        public void uOpenAction() {
            this.pushCharacterStyle();
            Style style = this.getChildStyle("u");
            if (style != null) {
                this.charAttr.addAttributes(style);
                this.charAttr.removeAttribute(StyleConstants.ResolveAttribute);
                return;
            }
            StyleConstants.setUnderline(this.charAttr, true);
        }

        public void uCloseAction() {
            this.popCharacterStyle();
        }

        public void kbdOpenAction() {
            this.pushCharacterStyle();
            Style style = this.getChildStyle("kbd");
            if (style != null) {
                this.charAttr.addAttributes(style);
                this.charAttr.removeAttribute(StyleConstants.ResolveAttribute);
            } else {
                StyleConstants.setFontFamily(this.charAttr, "Monospaced");
                String string = StyleXlater.convertFontSizeString("small");
                StyleSheet styleSheet = StyleReader.getStyleSheet();
                int n = styleSheet.getPtSize(string);
                StyleConstants.setFontSize(this.charAttr, n);
            }
            this.charAttr.addAttributes(this.attr);
        }

        public void kbdCloseAction() {
            this.popCharacterStyle();
        }

        public void baseAction() {
            String string = (String)this.attr.getAttribute("href");
            if (string != null) {
                HTMLDocument.this.putProperty(HTMLDocument.BaseHrefProperty, string);
                try {
                    HTMLDocument.this.reference = new URL(string);
                    return;
                }
                catch (MalformedURLException malformedURLException) {
                    return;
                }
            }
        }

        public void subOpenAction() {
            this.openTagSeen = true;
            this.pushCharacterStyle();
            Style style = this.getChildStyle("sub");
            if (style != null) {
                this.charAttr.addAttributes(style);
                this.charAttr.removeAttribute(StyleConstants.ResolveAttribute);
            }
            this.charAttr.addAttributes(this.attr);
        }

        public void subCloseAction() {
            this.cleanEndTag(false);
            this.popCharacterStyle();
        }

        public void supOpenAction() {
            this.openTagSeen = true;
            this.attr.addAttribute("sup", "true");
            this.pushCharacterStyle();
            Style style = this.getChildStyle("sup");
            if (style != null) {
                this.charAttr.addAttributes(style);
                this.charAttr.removeAttribute(StyleConstants.ResolveAttribute);
            }
            this.charAttr.addAttributes(this.attr);
        }

        public void supCloseAction() {
            this.cleanEndTag(false);
            this.popCharacterStyle();
        }

        public void liOpenAction() {
            this.blockOpen("li", true);
        }

        public void liCloseAction() {
            this.blockClose();
        }

        public void ulOpenAction() {
            this.blockOpen("ul", true);
        }

        public void ulCloseAction() {
            this.blockClose();
        }

        public void olOpenAction() {
            this.blockOpen("ol", true);
        }

        public void olCloseAction() {
            this.blockClose();
        }

        public void dlOpenAction() {
            this.blockOpen("dl", true);
        }

        public void dlCloseAction() {
            this.blockClose();
        }

        public void ddOpenAction() {
            this.blockOpen("dd", true);
        }

        public void ddCloseAction() {
            this.blockClose();
        }

        public void dtOpenAction() {
            this.blockOpen("dt", true);
        }

        public void dtCloseAction() {
            this.blockClose();
        }

        public void dirOpenAction() {
            this.blockOpen("dir", true);
        }

        public void dirCloseAction() {
            this.blockClose();
        }

        public void menuOpenAction() {
            this.blockOpen("menu", true);
        }

        public void menuCloseAction() {
            this.blockClose();
        }

        public void formOpenAction() {
        }

        public void formCloseAction() {
        }

        public void inputAction() {
            JComponent jComponent;
            String string = (String)this.attr.getAttribute("type");
            if (string == null) {
                string = new String("text");
            }
            if (string.equalsIgnoreCase("hidden")) {
                this.addSpecialElement(this.attr);
                return;
            }
            if (string.equalsIgnoreCase("submit") || string.equalsIgnoreCase("reset")) {
                String string2 = (String)this.attr.getAttribute("value");
                jComponent = new JButton(string2);
            } else if (string.equalsIgnoreCase("image")) {
                String string3 = (String)this.attr.getAttribute("src");
                jComponent = new JButton(string3);
            } else if (string.equalsIgnoreCase("checkbox")) {
                jComponent = new JCheckBox();
            } else if (string.equalsIgnoreCase("radio")) {
                String string4 = (String)this.attr.getAttribute("value");
                jComponent = new JRadioButton(string4);
            } else if (string.equalsIgnoreCase("text") || string.equalsIgnoreCase("password")) {
                int n;
                String string5 = (String)this.attr.getAttribute("size");
                if (string5 != null) {
                    try {
                        n = Integer.valueOf(string5);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n = 40;
                    }
                } else {
                    n = 40;
                }
                String string6 = (String)this.attr.getAttribute("value");
                jComponent = new JTextField(string6, n);
            } else {
                jComponent = new JButton();
            }
            this.attr.addAttribute(HTMLDocument.HTMLInputComponent, HTMLDocument.HTMLInputComponent);
            StyleConstants.setComponent(this.attr, jComponent);
            this.addSpecialElement(this.attr);
        }

        public void selectOpenAction() {
            String string;
            String string2 = (String)this.attr.getAttribute("rows");
            if (string2 != null) {
                try {
                    int n = Integer.valueOf(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    int n = 10;
                }
            } else {
                int n = 10;
            }
            if ((string = (String)this.attr.getAttribute("cols")) != null) {
                try {
                    int n = Integer.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    int n = 40;
                }
            } else {
                int n = 40;
            }
            String cfr_ignored_0 = (String)this.attr.getAttribute("value");
            this.combobox = new JComboBox();
            this.combobox.setEditable(false);
            JComboBox jComboBox = this.combobox;
            this.attr.addAttribute(HTMLDocument.HTMLInputComponent, HTMLDocument.HTMLInputComponent);
            StyleConstants.setComponent(this.attr, jComboBox);
            this.addSpecialElement(this.attr);
        }

        public void selectCloseAction() {
        }

        public void optionOpenAction() {
            this.inOption = true;
        }

        public void optionCloseAction() {
            this.inOption = false;
        }

        public void textareaOpenAction() {
            int n;
            String string;
            int n2;
            String string2 = (String)this.attr.getAttribute("rows");
            if (string2 != null) {
                try {
                    n2 = Integer.valueOf(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = 10;
                }
            } else {
                n2 = 10;
            }
            if ((string = (String)this.attr.getAttribute("cols")) != null) {
                try {
                    n = Integer.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    n = 40;
                }
            } else {
                n = 40;
            }
            String string3 = (String)this.attr.getAttribute("value");
            JTextArea jTextArea = new JTextArea(string3, n2, n);
            jTextArea.setEditable(true);
            JScrollPane jScrollPane = new JScrollPane(22, 32);
            jScrollPane.getViewport().add(jTextArea);
            JScrollPane jScrollPane2 = jScrollPane;
            this.attr.addAttribute(HTMLDocument.HTMLInputComponent, HTMLDocument.HTMLInputComponent);
            StyleConstants.setComponent(this.attr, jScrollPane2);
            this.addSpecialElement(this.attr);
        }

        public void textareaCloseAction() {
        }

        Color getColor(AttributeSet attributeSet) {
            String string = (String)this.attr.getAttribute("color");
            if (string != null) {
                try {
                    Color color = HTMLUtils.stringToColor(string);
                    return color;
                }
                catch (HTMLException hTMLException) {
                    return null;
                }
            }
            return null;
        }

        void pushCharacterStyle() {
            this.charAttrStack.push(this.charAttr.copyAttributes());
        }

        void popCharacterStyle() {
            this.charAttr = (MutableAttributeSet)this.charAttrStack.peek();
            this.charAttrStack.pop();
        }

        void pushStyle(String string) {
            this.styleStack.push(this.resolver);
            String string2 = "SH" + string;
            Style style = (Style)this.resolver.getAttribute(string2);
            if (style == null && string.equalsIgnoreCase("impliedp")) {
                string2 = new String("SHp");
                style = (Style)this.resolver.getAttribute(string2);
            }
            if (style != null) {
                this.resolver = style;
            }
        }

        void popStyle() {
            this.resolver = (Style)this.styleStack.peek();
            this.styleStack.pop();
        }

        void blockOpen(String string, boolean bl) {
            Object object;
            this.incrementPCData();
            this.dataCountStack.push(new DataCounter());
            this.openTagSeen = true;
            ++this.inBlock;
            this.pushStyle(string);
            if (this.resolver != null && (object = (Style)this.resolver.getAttribute("child-style")) != null) {
                this.attr.addAttribute(StyleConstants.ResolveAttribute, object);
            }
            if (bl) {
                this.attr.addAttribute("$ename", string);
            }
            if (string.equalsIgnoreCase("impliedp")) {
                this.attr.addAttribute("impliedp", "impliedp");
            }
            object = new DefaultStyledDocument.ElementSpec(this.attr.copyAttributes(), 1);
            this.parseBuffer.addElement(object);
            this.attr.removeAttributes(this.attr);
        }

        void blockClose() {
            this.checkPCData();
            this.dataCountStack.pop();
            this.cleanEndTag(true);
            --this.inBlock;
            this.popStyle();
            DefaultStyledDocument.ElementSpec elementSpec = (DefaultStyledDocument.ElementSpec)this.parseBuffer.lastElement();
            if (elementSpec != null && elementSpec.getType() == 1) {
                this.addContent(" ");
            }
            DefaultStyledDocument.ElementSpec elementSpec2 = new DefaultStyledDocument.ElementSpec(null, 2);
            this.parseBuffer.addElement(elementSpec2);
        }

        void addContent(String string) {
            AttributeSet attributeSet = this.charAttr.copyAttributes();
            DefaultStyledDocument.ElementSpec elementSpec = new DefaultStyledDocument.ElementSpec(attributeSet, 3, string.toCharArray(), 0, string.length());
            this.parseBuffer.addElement(elementSpec);
        }

        void addSpecialElement(AttributeSet attributeSet) {
            char[] cArray = new char[]{' '};
            attributeSet = attributeSet.copyAttributes();
            DefaultStyledDocument.ElementSpec elementSpec = new DefaultStyledDocument.ElementSpec(attributeSet.copyAttributes(), 3, cArray, 0, 1);
            this.parseBuffer.addElement(elementSpec);
            this.attr.removeAttributes(this.attr);
        }

        private String replaceSpecialChar(String string, int n, int n2, char c) {
            String string2 = null;
            string2 = String.valueOf(string.substring(0, n)) + c + string.substring(n2 + 1, string.length());
            return string2;
        }

        private String xlateSpecialChars(String string) {
            String string2 = null;
            int n = 0;
            n = string.indexOf(38);
            while (n < string.length() && n > 0) {
                char c;
                String string3;
                int n2 = 0;
                n2 = string.indexOf(59, n);
                if (n2 < 0) {
                    return null;
                }
                if (string.charAt(n + 1) == '#') {
                    string3 = string.substring(n + 2, n2);
                    c = Integer.valueOf(string3).intValue();
                    string2 = this.replaceSpecialChar(string, n, n2, c);
                } else {
                    string3 = string.substring(n + 1, n2);
                    c = ' ';
                    boolean bl = false;
                    try {
                        c = this.specTable.getSymbol(string3);
                        bl = true;
                    }
                    catch (HTMLException hTMLException) {}
                    if (bl) {
                        string2 = this.replaceSpecialChar(string, n, n2, c);
                    }
                }
                n = string.indexOf(38, n + 1);
            }
            return string2;
        }

        HTMLReader() {
            HTMLDocument.this = HTMLDocument.this;
        }

        class DataCounter {
            int dc;

            public DataCounter() {
                HTMLReader.this = HTMLReader.this;
            }

            public void incCounter() {
                ++this.dc;
            }

            public void decCounter() {
                --this.dc;
            }

            public boolean noPCData() {
                return this.dc <= 0;
            }
        }
    }
}

