/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.text.html;

import com.sun.java.swing.Action;
import com.sun.java.swing.JEditorPane;
import com.sun.java.swing.JToggleButton;
import com.sun.java.swing.event.HyperlinkEvent;
import com.sun.java.swing.text.AttributeSet;
import com.sun.java.swing.text.BadLocationException;
import com.sun.java.swing.text.Caret;
import com.sun.java.swing.text.Document;
import com.sun.java.swing.text.Element;
import com.sun.java.swing.text.JTextComponent;
import com.sun.java.swing.text.MutableAttributeSet;
import com.sun.java.swing.text.SimpleAttributeSet;
import com.sun.java.swing.text.Style;
import com.sun.java.swing.text.StyleConstants;
import com.sun.java.swing.text.StyleContext;
import com.sun.java.swing.text.StyledDocument;
import com.sun.java.swing.text.StyledEditorKit;
import com.sun.java.swing.text.TextAction;
import com.sun.java.swing.text.ViewFactory;
import com.sun.java.swing.text.html.HTMLDocument;
import com.sun.java.swing.text.html.HTMLException;
import com.sun.java.swing.text.html.HTMLFactory;
import com.sun.java.swing.text.html.HTMLWriter;
import com.sun.java.swing.text.html.StyleReader;
import com.sun.java.swing.text.html.StyleSheet;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public class HTMLEditorKit
extends StyledEditorKit {
    public static final String DEFAULT_CSS = "default.css";
    private StyleContext styleContext;
    private MouseListener linkHandler = new LinkController();
    public static final String BOLD_ACTION = "html-bold-action";
    public static final String ITALIC_ACTION = "html-italic-action";
    public static final String PARA_INDENT_LEFT = "html-para-indent-left";
    public static final String PARA_INDENT_RIGHT = "html-para-indent-right";
    public static final String FONT_CHANGE_BIGGER = "html-font-bigger";
    public static final String FONT_CHANGE_SMALLER = "html-font-smaller";
    public static final String COLOR_ACTION = "html-color-action";
    public static final String LOGICAL_STYLE_ACTION = "html-logical-style-action";
    public static final String IMG_ALIGN_TOP = "html-image-align-top";
    public static final String IMG_ALIGN_MIDDLE = "html-image-align-middle";
    public static final String IMG_ALIGN_BOTTOM = "html-image-align-bottom";
    public static final String IMG_BORDER = "html-image-border";
    private static final Action[] defaultActions = new Action[]{new HTMLBoldAction(), new HTMLItalicAction(), new FontSizeChangeAction("html-font-bigger", true), new FontSizeChangeAction("html-font-smaller", false), new ParagraphIndentAction("html-para-indent-left", true), new ParagraphIndentAction("html-para-indent-right", false), new ImgAlignAction("html-image-align-top", "top"), new ImgAlignAction("html-image-align-middle", "middle"), new ImgAlignAction("html-image-align-bottom", "bottom"), new ImgBorderAction("html-image-border"), new StyledEditorKit.ForegroundAction("html-color-action", Color.black), new LogicalStyleAction("Normal")};
    static final boolean DEBUG = false;

    public HTMLEditorKit() {
        this.styleContext = new StyleContext();
        this.loadStyleSheet(this.styleContext);
    }

    public Object clone() {
        return new HTMLEditorKit();
    }

    public String getContentType() {
        return "text/html";
    }

    public ViewFactory getViewFactory() {
        return new HTMLFactory();
    }

    public Document createDefaultDocument() {
        HTMLDocument hTMLDocument = new HTMLDocument(this.styleContext);
        return hTMLDocument;
    }

    public void read(Reader reader, Document document, int n) throws IOException, BadLocationException {
        if (document instanceof HTMLDocument) {
            HTMLDocument hTMLDocument = (HTMLDocument)document;
            hTMLDocument.read(reader, n);
            return;
        }
        super.read(reader, document, n);
    }

    public void write(Writer writer, Document document, int n, int n2) throws IOException, BadLocationException {
        if (document instanceof StyledDocument) {
            try {
                HTMLWriter hTMLWriter = new HTMLWriter();
                hTMLWriter.write(writer, (StyledDocument)document);
                return;
            }
            catch (HTMLException hTMLException) {
                throw new IOException("HTMLException: " + hTMLException.getMessage());
            }
        }
        super.write(writer, document, n, n2);
    }

    public void install(JEditorPane jEditorPane) {
        jEditorPane.addMouseListener(this.linkHandler);
        super.install(jEditorPane);
    }

    public void deinstall(JEditorPane jEditorPane) {
        jEditorPane.removeMouseListener(this.linkHandler);
        super.deinstall(jEditorPane);
    }

    private void loadStyleSheet(StyleContext styleContext) {
        InputStream inputStream = this.getClass().getResourceAsStream(DEFAULT_CSS);
        if (inputStream == null) {
            System.out.println("HTMLEditorKit.loadStyleSheet: default.css file not found");
            return;
        }
        StyleReader styleReader = new StyleReader(styleContext);
        styleReader.read(styleContext, 0, inputStream);
    }

    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), defaultActions);
    }

    static Vector getCharacterElements(JEditorPane jEditorPane, int n, int n2) {
        StyledDocument styledDocument = (StyledDocument)jEditorPane.getDocument();
        Vector<Element> vector = new Vector<Element>();
        int n3 = n;
        n = n > n2 ? n2 : n;
        n2 = n > n2 ? n3 : n2;
        n3 = n;
        while (n3 <= n2) {
            Element element = styledDocument.getCharacterElement(n3);
            if (element == null) {
                ++n3;
                continue;
            }
            vector.addElement(element);
            if (n3 < element.getEndOffset() + 1) {
                n3 = element.getEndOffset() + 1;
                continue;
            }
            ++n3;
        }
        return vector;
    }

    public static class LinkController
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            Point point;
            int n;
            JEditorPane jEditorPane = (JEditorPane)mouseEvent.getSource();
            if (!jEditorPane.isEditable() && (n = jEditorPane.viewToModel(point = new Point(mouseEvent.getX(), mouseEvent.getY()))) >= 0) {
                this.activateLink(n, jEditorPane);
            }
        }

        protected final void activateLink(int n, JEditorPane jEditorPane) {
            StyledDocument styledDocument;
            Element element;
            AttributeSet attributeSet;
            String string;
            Document document = jEditorPane.getDocument();
            if (document instanceof StyledDocument && (string = (String)(attributeSet = (element = (styledDocument = (StyledDocument)document).getCharacterElement(n)).getAttributes()).getAttribute("href")) != null) {
                URL uRL;
                try {
                    uRL = new URL(jEditorPane.getPage(), string);
                }
                catch (MalformedURLException malformedURLException) {
                    uRL = null;
                }
                HyperlinkEvent hyperlinkEvent = new HyperlinkEvent(jEditorPane, HyperlinkEvent.EventType.ACTIVATED, uRL);
                jEditorPane.fireHyperlinkUpdate(hyperlinkEvent);
            }
        }
    }

    static abstract class HtmlAction
    extends StyledEditorKit.StyledTextAction {
        HtmlAction(String string) {
            super(string);
        }

        protected final void setCharacterAttributes(JEditorPane jEditorPane, AttributeSet attributeSet, int n, int n2, boolean bl) {
            int n3;
            if (n > n2) {
                n3 = n2;
                n2 = n;
                n = n3;
            }
            n3 = jEditorPane.getSelectionStart();
            int n4 = jEditorPane.getSelectionEnd();
            if (n < n3) {
                n = n3;
            }
            if (n2 > n4) {
                n2 = n4;
            }
            if (n != n2) {
                StyledDocument styledDocument = this.getStyledDocument(jEditorPane);
                styledDocument.setCharacterAttributes(n, n2 - n, attributeSet, bl);
                return;
            }
            StyledEditorKit styledEditorKit = this.getStyledEditorKit(jEditorPane);
            MutableAttributeSet mutableAttributeSet = styledEditorKit.getInputAttributes();
            if (bl) {
                mutableAttributeSet.removeAttributes(mutableAttributeSet);
            }
            mutableAttributeSet.addAttributes(attributeSet);
        }
    }

    static class HTMLBoldAction
    extends HtmlAction {
        public HTMLBoldAction() {
            super(HTMLEditorKit.BOLD_ACTION);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getFocusedComponent();
            if (jTextComponent != null) {
                JEditorPane jEditorPane = (JEditorPane)jTextComponent;
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                Object object = actionEvent.getSource();
                boolean bl = true;
                if (object != null && object instanceof JToggleButton) {
                    bl = ((JToggleButton)object).isSelected();
                }
                StyleConstants.setBold(simpleAttributeSet, bl);
                this.setCharacterAttributes(jEditorPane, simpleAttributeSet, false);
            }
        }
    }

    static class HTMLItalicAction
    extends HtmlAction {
        public HTMLItalicAction() {
            super(HTMLEditorKit.ITALIC_ACTION);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getFocusedComponent();
            if (jTextComponent != null) {
                JEditorPane jEditorPane = (JEditorPane)jTextComponent;
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                Object object = actionEvent.getSource();
                boolean bl = true;
                if (object != null && object instanceof JToggleButton) {
                    bl = ((JToggleButton)object).isSelected();
                }
                StyleConstants.setItalic(simpleAttributeSet, bl);
                this.setCharacterAttributes(jEditorPane, simpleAttributeSet, false);
            }
        }
    }

    static class FontSizeChangeAction
    extends HtmlAction {
        private boolean bIncrease = true;

        FontSizeChangeAction(String string, boolean bl) {
            super(string);
            this.bIncrease = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getFocusedComponent();
            StyleSheet styleSheet = StyleReader.getStyleSheet();
            if (jTextComponent != null) {
                JEditorPane jEditorPane = (JEditorPane)jTextComponent;
                Caret caret = jEditorPane.getCaret();
                int n = caret.getDot();
                if (caret.getMark() == n) {
                    AttributeSet attributeSet = null;
                    if (attributeSet != null) {
                        int n2 = StyleConstants.getFontSize(attributeSet);
                        n2 = this.bIncrease ? styleSheet.getBigger(n2) : styleSheet.getSmaller(n2);
                        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                        StyleConstants.setFontSize(simpleAttributeSet, n2);
                        this.setCharacterAttributes(jEditorPane, simpleAttributeSet, false);
                        return;
                    }
                } else {
                    int n3;
                    int n4 = caret.getMark();
                    Vector vector = HTMLEditorKit.getCharacterElements(jEditorPane, n4, n3 = caret.getDot());
                    if (vector != null) {
                        int n5 = -1;
                        int n6 = -1;
                        int n7 = vector.size();
                        if (n7 > 0) {
                            boolean bl = false;
                            int[] nArray = new int[n7];
                            int n8 = 0;
                            while (n8 < n7 && !bl) {
                                try {
                                    AttributeSet attributeSet = ((Element)vector.elementAt(n8)).getAttributes();
                                    n5 = StyleConstants.getFontSize(attributeSet);
                                    int n9 = n6 = this.bIncrease ? styleSheet.getBigger(n5) : styleSheet.getSmaller(n5);
                                    if (n5 == n6) {
                                        System.out.println("Bigger/Smaller ABORTING:Size limit reached for element:" + ((Element)vector.elementAt(n8)).getName());
                                        bl = true;
                                    } else {
                                        nArray[n8] = n6;
                                    }
                                }
                                catch (NullPointerException nullPointerException) {
                                    System.out.println("Exception: Cannot find font size for element:" + n8);
                                    nArray[n8] = -1;
                                    bl = true;
                                }
                                ++n8;
                            }
                            if (!bl) {
                                int n10 = 0;
                                while (n10 < n7) {
                                    Element element = (Element)vector.elementAt(n10);
                                    int n11 = element.getStartOffset();
                                    int n12 = element.getEndOffset();
                                    if (n11 < n4) {
                                        n11 = n4;
                                    }
                                    if (n12 > n3) {
                                        n12 = n3;
                                    }
                                    if (nArray[n10] > 0) {
                                        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                                        StyleConstants.setFontSize(simpleAttributeSet, nArray[n10]);
                                        this.setCharacterAttributes(jEditorPane, simpleAttributeSet, n11, n12, false);
                                    }
                                    ++n10;
                                }
                                return;
                            }
                            System.out.println("Atleast one size at the limit, Aborting bigger/smaller");
                        }
                    }
                }
            }
        }
    }

    static class ParagraphIndentAction
    extends HtmlAction {
        boolean bLeft = false;

        ParagraphIndentAction(String string, boolean bl) {
            super(string);
            this.bLeft = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            StyledEditorKit styledEditorKit;
            MutableAttributeSet mutableAttributeSet;
            JEditorPane jEditorPane = (JEditorPane)this.getFocusedComponent();
            if (jEditorPane != null && (mutableAttributeSet = (styledEditorKit = this.getStyledEditorKit(jEditorPane)).getInputAttributes()) != null) {
                int n = StyleConstants.getAlignment(mutableAttributeSet);
                if (!this.bLeft) {
                    if (n == 0) {
                        n = 1;
                    } else if (n == 1) {
                        n = 2;
                    }
                } else if (n == 1) {
                    n = 0;
                } else if (n == 2) {
                    n = 1;
                }
                StyleConstants.setAlignment(mutableAttributeSet, n);
                this.setParagraphAttributes(jEditorPane, mutableAttributeSet, false);
            }
        }
    }

    static class LogicalStyleAction
    extends HtmlAction {
        String styleStr;

        LogicalStyleAction(String string) {
            super(HTMLEditorKit.LOGICAL_STYLE_ACTION);
            this.styleStr = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            StyledDocument styledDocument;
            Style style;
            JEditorPane jEditorPane = (JEditorPane)this.getFocusedComponent();
            if (jEditorPane != null && (style = (styledDocument = (StyledDocument)jEditorPane.getDocument()).getStyle(this.styleStr)) != null) {
                styledDocument.setLogicalStyle(jEditorPane.getCaretPosition(), style);
            }
        }

        public void setLogicalStyle(Object object, String string) {
            this.styleStr = string;
            this.actionPerformed(new ActionEvent(object, 0, "html-logical-style"));
        }
    }

    static class ImgAlignAction
    extends HtmlAction {
        String align;

        public ImgAlignAction(String string, String string2) {
            super(string);
            this.align = string2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getFocusedComponent();
            if (jTextComponent != null) {
                JEditorPane jEditorPane = (JEditorPane)jTextComponent;
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                simpleAttributeSet.addAttribute("align", this.align);
                this.setCharacterAttributes(jEditorPane, simpleAttributeSet, false);
            }
        }
    }

    static class ImgBorderAction
    extends HtmlAction {
        public ImgBorderAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JEditorPane jEditorPane = (JEditorPane)this.getFocusedComponent();
            AttributeSet attributeSet = this.getImageAttributes(jEditorPane);
            if (attributeSet != null) {
                boolean bl = attributeSet.isDefined("href");
                int n = bl ? 2 : 0;
                String string = (String)attributeSet.getAttribute("border");
                if (string != null) {
                    try {
                        n = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                boolean bl2 = false;
                if (n == 0 && !bl) {
                    simpleAttributeSet.addAttribute("border", "2");
                } else if (n != 0 && bl) {
                    simpleAttributeSet.addAttribute("border", "0");
                } else {
                    simpleAttributeSet.addAttributes(attributeSet);
                    simpleAttributeSet.removeAttribute("border");
                    bl2 = true;
                }
                this.setCharacterAttributes(jEditorPane, simpleAttributeSet, bl2);
            }
        }

        private AttributeSet getImageAttributes(JEditorPane jEditorPane) {
            if (jEditorPane != null) {
                StyledDocument styledDocument;
                Element element;
                int n = jEditorPane.getSelectionStart();
                int n2 = jEditorPane.getSelectionEnd();
                if (Math.abs(n2 - n) == 1 && (element = (styledDocument = (StyledDocument)jEditorPane.getDocument()).getCharacterElement(Math.min(n, n2))) != null && element.getName().equals("img")) {
                    return element.getAttributes();
                }
            }
            return null;
        }
    }
}

