/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.text.html;

import com.sun.java.swing.text.AbstractDocument;
import com.sun.java.swing.text.AttributeSet;
import com.sun.java.swing.text.BadLocationException;
import com.sun.java.swing.text.Element;
import com.sun.java.swing.text.Style;
import com.sun.java.swing.text.StyleConstants;
import com.sun.java.swing.text.StyledDocument;
import com.sun.java.swing.text.html.BranchTranslator;
import com.sun.java.swing.text.html.HTMLDebug;
import com.sun.java.swing.text.html.HTMLDefs;
import com.sun.java.swing.text.html.HTMLException;
import com.sun.java.swing.text.html.HTMLUtils;
import com.sun.java.swing.text.html.LeafTranslator;
import com.sun.java.swing.text.html.StyleReader;
import com.sun.java.swing.text.html.StyleSheet;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

class HTMLWriter
implements HTMLDefs {
    private Hashtable branchTable;
    private Hashtable leafTable;
    private boolean lowercase = true;
    private boolean indenting = false;
    private boolean writePre = false;
    private int nPrelines;
    private int inFont;
    private static final String GENERIC = "generic";
    private static final String SPACE = " ";
    private static final String EQUAL = "=";
    private static final String QUOTE = "\"";
    private static final String CR = "\n";

    public HTMLWriter() {
        this.initializeBranchTable();
        this.initializeLeafTable();
    }

    public void write(OutputStream outputStream, StyledDocument styledDocument) throws Exception {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        this.write((Writer)outputStreamWriter, styledDocument);
        outputStreamWriter.flush();
    }

    public void write(Writer writer, StyledDocument styledDocument) throws HTMLException, IOException {
        AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)styledDocument.getDefaultRootElement();
        this.writeStartTag(writer, "html");
        this.writeHead(writer, branchElement);
        this.writeBranch(writer, "", branchElement);
        this.writeEndTag(writer, "html");
        writer.flush();
    }

    public void setBranchTranslator(String string, BranchTranslator branchTranslator) {
        this.branchTable.put(string, branchTranslator);
    }

    public BranchTranslator getBranchTranslator(String string) {
        BranchTranslator branchTranslator = (BranchTranslator)this.branchTable.get(string);
        HTMLDebug.println("getBranchTranslator for " + string);
        if (branchTranslator == null) {
            branchTranslator = this.getBranchTranslator(GENERIC);
            System.out.println("HTMLWriter.getBranchTranslator: Using genericBranchTranslator for " + string);
        }
        return branchTranslator;
    }

    public void removeBranchTranslator(String string) {
        this.branchTable.remove(string);
    }

    public void setLeafTranslator(String string, LeafTranslator leafTranslator) {
        this.leafTable.put(string, leafTranslator);
    }

    public LeafTranslator getLeafTranslator(String string) {
        LeafTranslator leafTranslator = (LeafTranslator)this.leafTable.get(string);
        HTMLDebug.println("getLeafTranslator for " + string);
        if (leafTranslator == null) {
            HTMLDebug.println("getLeafTranslator generic ");
            leafTranslator = this.getLeafTranslator("content");
        }
        return leafTranslator;
    }

    public void removeLeafTranslator(String string) {
        this.leafTable.remove(string);
    }

    private void initializeBranchTable() {
        this.branchTable = new Hashtable();
        this.setBranchTranslator(GENERIC, new GenericBranchTranslator());
        this.setBranchTranslator("blockquote", new BlockquoteTranslator());
        this.setBranchTranslator("body", new BodyTranslator());
        this.setBranchTranslator("dd", new DdTranslator());
        this.setBranchTranslator("dl", new DlTranslator());
        this.setBranchTranslator("dt", new DtTranslator());
        this.setBranchTranslator("head", new HeadTranslator());
        this.setBranchTranslator("h1", new HTranslator());
        this.setBranchTranslator("h2", new HTranslator());
        this.setBranchTranslator("h3", new HTranslator());
        this.setBranchTranslator("h4", new HTranslator());
        this.setBranchTranslator("h5", new HTranslator());
        this.setBranchTranslator("h6", new HTranslator());
        this.setBranchTranslator("li", new LiTranslator());
        this.setBranchTranslator("menu", new MenuTranslator());
        this.setBranchTranslator("ol", new OlTranslator());
        this.setBranchTranslator("p", new PTranslator());
        this.setBranchTranslator("pre", new PreTranslator());
        this.setBranchTranslator("pre-line", new PreLineTranslator());
        this.setBranchTranslator("ul", new UlTranslator());
    }

    private void initializeLeafTable() {
        this.leafTable = new Hashtable();
        this.setLeafTranslator(GENERIC, new GenericLeafTranslator());
        this.setLeafTranslator("content", new ContentTranslator());
        this.setLeafTranslator("icon", new ImgTranslator());
        this.setLeafTranslator("img", new ImgTranslator());
        this.setLeafTranslator("font", new FontTranslator());
        this.setLeafTranslator("hr", new HrTranslator());
        this.setLeafTranslator("basefont", new BaseFontTranslator());
        this.setLeafTranslator("a", new ATranslator());
        this.setLeafTranslator("big", new BigTranslator());
        this.setLeafTranslator("small", new SmallTranslator());
        this.setLeafTranslator("code", new CodeTranslator());
        this.setLeafTranslator("cite", new CiteTranslator());
        this.setLeafTranslator("strike", new StrikeTranslator());
        this.setLeafTranslator("sub", new SubTranslator());
        this.setLeafTranslator("sup", new SupTranslator());
        this.setLeafTranslator("dfn", new DfnTranslator());
        this.setLeafTranslator("kbd", new KbdTranslator());
        this.setLeafTranslator("samp", new SampTranslator());
        this.setLeafTranslator("strong", new StrongTranslator());
        this.setLeafTranslator("_var", new VarTranslator());
        this.setLeafTranslator("em", new EmTranslator());
        this.setLeafTranslator("pre", new PreLeafTranslator());
        this.setLeafTranslator("tt", new TtTranslator());
    }

    public void writeLeaf(Writer writer, String string, Element element, Element element2) {
        String string2 = element2.getName();
        LeafTranslator leafTranslator = null;
        if (string2.equals("content")) {
            AttributeSet attributeSet = element2.getAttributes();
            String string3 = (String)attributeSet.getAttribute("htmltag");
            String string4 = (String)attributeSet.getAttribute(AttributeSet.NameAttribute);
            String string5 = (String)attributeSet.getAttribute("$ename");
            HTMLDebug.println("writeLeaf(): tagname = " + string3 + " styleName = " + string4 + " elementName " + string5);
            if (string3 != null) {
                string2 = string3;
            } else if (string4 != null) {
                string2 = string4;
            } else if (string5 != null && string5.equals("pre-line") && string4 != null) {
                string2 = string4;
            } else if (string5 == null && string4 != null) {
                string2 = string4;
            }
            if (string3 != null || string4 != null || string5 != null) {
                leafTranslator = this.getLeafTranslator(string2);
            }
        } else {
            leafTranslator = this.getLeafTranslator(string2);
        }
        if (string2.equals("hr") && this.indenting) {
            this.write(writer, string);
        }
        if (leafTranslator != null) {
            leafTranslator.translate(writer, element, element2);
        }
    }

    public void setUpperCase() {
        this.lowercase = false;
    }

    public void setLowerCase() {
        this.lowercase = true;
    }

    public void setIndent() {
        this.indenting = true;
    }

    public void setNoIndent() {
        this.indenting = false;
    }

    public void writeBranch(Writer writer, String string, Element element) {
        Object object;
        AttributeSet attributeSet;
        String string2;
        if (element.isLeaf()) {
            element.getAttributes();
            this.writeLeaf(writer, string, element.getParentElement(), element);
            return;
        }
        String string3 = element.getName();
        if (string3.equals("section")) {
            string2 = "body";
        } else if (string3.equals("paragraph")) {
            attributeSet = element.getAttributes();
            object = attributeSet.getResolveParent();
            string2 = (String)object.getAttribute(AttributeSet.NameAttribute);
            if (string2.endsWith(" p")) {
                string2 = "p";
            }
        } else {
            string2 = string3;
        }
        if (string2.equals("default")) {
            return;
        }
        attributeSet = element.getAttributes();
        object = (String)attributeSet.getAttribute("impliedp");
        boolean bl = false;
        if (object != null && ((String)object).equals("impliedp")) {
            bl = true;
        }
        if (this.indenting && !string2.equals("pre-line") && !bl) {
            this.write(writer, string);
        }
        if (!bl) {
            BranchTranslator branchTranslator = this.getBranchTranslator(string2);
            if (!this.indenting && !string2.equals("pre-line")) {
                this.write(writer, CR);
            }
            branchTranslator.translate(writer, element);
        }
        int n = element.getElementCount();
        int n2 = 0;
        while (n2 < n) {
            Element element2 = element.getElement(n2);
            if (this.indenting) {
                this.writeBranch(writer, String.valueOf(string) + "  ", element2);
            } else {
                this.writeBranch(writer, "", element2);
            }
            ++n2;
        }
        if (object != null && ((String)object).equals("impliedp")) {
            this.write(writer, "");
            return;
        }
        this.writeEndTag(writer, string2, string);
    }

    public void writeHead(Writer writer, Element element) {
        BranchTranslator branchTranslator = this.getBranchTranslator("head");
        branchTranslator.translate(writer, element);
    }

    public void writeStartTag(Writer writer, String string) {
        if (!this.lowercase) {
            string.toUpperCase();
        }
        this.write(writer, "<" + string + ">\n");
    }

    public void writeEndTag(Writer writer, String string) {
        if (!this.lowercase) {
            string.toUpperCase();
        }
        this.write(writer, "</" + string + ">\n");
    }

    public void writeEndTag(Writer writer, String string, String string2) {
        if (!this.lowercase) {
            string.toUpperCase();
        }
        if (string.equals("pre") || string.equals("p") || string.equals("h1") || string.equals("h2") || string.equals("h3") || string.equals("h4") || string.equals("h5") || string.equals("h6")) {
            this.write(writer, "</" + string + ">\n");
            return;
        }
        if (string.equals("dt") || string.equals("li") || string.equals("dd")) {
            this.write(writer, CR);
            return;
        }
        if (!(string.equals("li") || string.equals("dd") || string.equals("dt") || string.equals("hr") || string.equals("pre-line"))) {
            if (this.indenting) {
                this.write(writer, String.valueOf(string2) + "</" + string + ">\n");
                return;
            }
            this.write(writer, "</" + string + ">\n");
        }
    }

    public void write(Writer writer, String string) {
        HTMLDebug.println("Output=>" + string + "<=");
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            try {
                writer.write(string.charAt(n2));
            }
            catch (IOException iOException) {
                System.out.println("HTMLWriter.write: " + string + SPACE + iOException);
            }
            ++n2;
        }
    }

    private String convertCase(String string) {
        if (this.lowercase) {
            return string.toLowerCase();
        }
        return string.toUpperCase();
    }

    private String toAlignString(int n) {
        String string = "left";
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 2: {
                string = "right";
                break;
            }
            case 1: {
                string = "center";
                break;
            }
        }
        return string;
    }

    private boolean writeColor(AttributeSet attributeSet, Vector vector, AttributeSet attributeSet2) {
        Color color = StyleConstants.getForeground(attributeSet2);
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                Style style = (Style)vector.elementAt(n);
                if (color == StyleConstants.getForeground(style)) {
                    return false;
                }
                ++n;
            }
        }
        return color != StyleConstants.getForeground(attributeSet);
    }

    private boolean writeFamily(AttributeSet attributeSet, Vector vector, AttributeSet attributeSet2) {
        String string = StyleConstants.getFontFamily(attributeSet2);
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                Style style = (Style)vector.elementAt(n);
                if (string == StyleConstants.getFontFamily(style)) {
                    return false;
                }
                ++n;
            }
        }
        return string != StyleConstants.getFontFamily(attributeSet);
    }

    private boolean writeSize(AttributeSet attributeSet, Vector vector, AttributeSet attributeSet2) {
        int n = StyleConstants.getFontSize(attributeSet2);
        if (vector != null) {
            int n2 = 0;
            while (n2 < vector.size()) {
                Style style = (Style)vector.elementAt(n2);
                if (n == StyleConstants.getFontSize(style)) {
                    return false;
                }
                ++n2;
            }
        }
        return n != StyleConstants.getFontSize(attributeSet);
    }

    private boolean writeFontTag(AttributeSet attributeSet, Vector vector, AttributeSet attributeSet2) {
        if (this.writeColor(attributeSet, vector, attributeSet2)) {
            return true;
        }
        if (this.writeSize(attributeSet, vector, attributeSet2)) {
            return true;
        }
        return this.writeFamily(attributeSet, vector, attributeSet2);
    }

    private boolean writeBoldTag(AttributeSet attributeSet, Vector vector, AttributeSet attributeSet2) {
        if (StyleConstants.isBold(attributeSet2)) {
            if (vector != null) {
                int n = 0;
                while (n < vector.size()) {
                    Style style = (Style)vector.elementAt(n);
                    if (StyleConstants.isBold(style)) {
                        return false;
                    }
                    ++n;
                }
            }
            return !StyleConstants.isBold(attributeSet);
        }
        return false;
    }

    private boolean writeItalicTag(AttributeSet attributeSet, Vector vector, AttributeSet attributeSet2) {
        if (StyleConstants.isItalic(attributeSet2)) {
            if (vector != null) {
                int n = 0;
                while (n < vector.size()) {
                    Style style = (Style)vector.elementAt(n);
                    if (StyleConstants.isItalic(style)) {
                        return false;
                    }
                    ++n;
                }
            }
            return !StyleConstants.isItalic(attributeSet);
        }
        return false;
    }

    private boolean writeUnderlineTag(AttributeSet attributeSet, Vector vector, AttributeSet attributeSet2) {
        if (StyleConstants.isUnderline(attributeSet2)) {
            if (vector != null) {
                int n = 0;
                while (n < vector.size()) {
                    Style style = (Style)vector.elementAt(n);
                    if (StyleConstants.isUnderline(style)) {
                        return false;
                    }
                    ++n;
                }
            }
            return !StyleConstants.isUnderline(attributeSet);
        }
        return false;
    }

    private void writeContent(Writer writer, Vector vector, Element element, Element element2) {
        String string;
        boolean bl;
        boolean bl2;
        Object object;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        AttributeSet attributeSet = element.getAttributes();
        AttributeSet attributeSet2 = element2.getAttributes();
        AttributeSet attributeSet3 = attributeSet2.getResolveParent();
        String string2 = "b";
        String string3 = "i";
        String string4 = "u";
        boolean bl7 = this.writeBoldTag(attributeSet3, vector, attributeSet);
        if (bl7) {
            this.write(writer, "<" + this.convertCase(string2) + ">");
        }
        if (bl6 = this.writeItalicTag(attributeSet3, vector, attributeSet)) {
            this.write(writer, "<" + this.convertCase(string3) + ">");
        }
        if (bl5 = this.writeUnderlineTag(attributeSet3, vector, attributeSet)) {
            this.write(writer, "<" + this.convertCase(string4) + ">");
        }
        if (bl4 = this.writeFontTag(attributeSet3, vector, attributeSet)) {
            ++this.inFont;
            this.write(writer, "<" + this.convertCase("font"));
        }
        if (bl3 = this.writeColor(attributeSet3, vector, attributeSet)) {
            Color color = StyleConstants.getForeground(attributeSet);
            try {
                object = HTMLUtils.colorToHex(color);
                this.write(writer, SPACE + this.convertCase("color") + EQUAL + this.convertCase((String)object));
            }
            catch (HTMLException hTMLException) {
                HTMLDebug.println("Unable to convert Color string:" + color);
            }
        }
        if (bl2 = this.writeSize(attributeSet3, vector, attributeSet)) {
            int n;
            object = StyleReader.getStyleSheet();
            int n2 = ((StyleSheet)object).getRelSize(n = StyleConstants.getFontSize(attributeSet));
            if (n2 < 0) {
                this.write(writer, SPACE + this.convertCase("size") + EQUAL + n2);
            } else {
                this.write(writer, SPACE + this.convertCase("size") + "=+" + n2);
            }
        }
        if (bl = this.writeFamily(attributeSet3, vector, attributeSet)) {
            String string5 = StyleConstants.getFontFamily(attributeSet);
            this.write(writer, SPACE + this.convertCase("face") + "=\"" + string5 + QUOTE);
        }
        if (bl4) {
            this.write(writer, ">");
        }
        if ((string = (String)attributeSet.getAttribute(AttributeSet.NameAttribute)).equals("pre")) {
            this.writePreText(writer, element);
        } else {
            this.writeText(writer, element);
        }
        if (bl4) {
            this.write(writer, "</" + this.convertCase("font") + ">");
            --this.inFont;
        }
        if (bl5) {
            this.write(writer, "</" + this.convertCase(string4) + ">");
        }
        if (bl6) {
            this.write(writer, "</" + this.convertCase(string3) + ">");
        }
        if (bl7) {
            this.write(writer, "</" + this.convertCase(string2) + ">");
        }
    }

    private void writeText(Writer writer, Element element) {
        try {
            StyledDocument styledDocument = (StyledDocument)element.getDocument();
            String string = styledDocument.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
            if (string.endsWith(CR)) {
                this.writeText(writer, styledDocument.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset() - 1));
                return;
            }
            this.writeText(writer, styledDocument.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset()));
            return;
        }
        catch (BadLocationException badLocationException) {
            HTMLDebug.println("HTMLWriter.writeText:" + element);
            return;
        }
    }

    private void writePreText(Writer writer, Element element) {
        if (this.writePre && this.nPrelines >= 0) {
            try {
                StyledDocument styledDocument = (StyledDocument)element.getDocument();
                styledDocument.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
                if (element.getStartOffset() == element.getEndOffset() && this.nPrelines > 0) {
                    this.writeChar(writer, '\n');
                    this.writePre = false;
                    return;
                }
                if (this.nPrelines == 0 && element.getEndOffset() - 1 > element.getStartOffset() && styledDocument.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset()).endsWith(CR)) {
                    this.writeText(writer, styledDocument.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset() - 1));
                    this.writePre = true;
                    return;
                }
                this.writeText(writer, styledDocument.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset()));
                this.writePre = true;
                return;
            }
            catch (BadLocationException badLocationException) {
                HTMLDebug.println("HTMLWriter.writeText:" + element);
                return;
            }
        }
    }

    public void writeChar(Writer writer, char c) {
        HTMLDebug.println("Output=>" + c + "<=");
        try {
            switch (c) {
                case '<': {
                    writer.write("&lt;");
                    return;
                }
                case '>': {
                    writer.write("&gt;");
                    return;
                }
                case '&': {
                    writer.write("&amp;");
                    return;
                }
                case '\"': {
                    writer.write("&quot;");
                    return;
                }
            }
            if (c == '\n' || c == '\t' || c == '\r') {
                writer.write(c);
                return;
            }
            if (c < ' ' || c > '\u007f') {
                writer.write("&#");
                writer.write(String.valueOf((int)c));
                return;
            }
            writer.write(c);
            return;
        }
        catch (IOException iOException) {
            System.out.println("HTMLWriter.write: " + c + SPACE + iOException);
            return;
        }
    }

    private void writeText(Writer writer, String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            this.writeChar(writer, string.charAt(n2));
            ++n2;
        }
    }

    static /* synthetic */ boolean access$6(HTMLWriter hTMLWriter) {
        return hTMLWriter.writePre;
    }

    public class GenericBranchTranslator
    implements BranchTranslator {
        public void translate(Writer writer, Element element) {
            String string;
            AttributeSet attributeSet = element.getAttributes();
            AttributeSet attributeSet2 = attributeSet.getResolveParent();
            String string2 = element.getName();
            if (string2.equals("paragraph")) {
                string = (String)attributeSet2.getAttribute(AttributeSet.NameAttribute);
                if (string.endsWith(" p")) {
                    string = "p";
                }
            } else {
                string = string2;
            }
            string = HTMLWriter.this.convertCase(string);
            HTMLWriter.this.write(writer, "<" + string + ">");
        }

        public GenericBranchTranslator() {
            HTMLWriter.this = HTMLWriter.this;
        }
    }

    public class HeadTranslator
    implements BranchTranslator {
        public void translate(Writer writer, Element element) {
            String string;
            HTMLWriter.this.write(writer, "<" + HTMLWriter.this.convertCase("head") + ">\n");
            StyledDocument styledDocument = (StyledDocument)element.getDocument();
            String string2 = (String)styledDocument.getProperty("title");
            if (string2 != null) {
                if (HTMLWriter.this.indenting) {
                    HTMLWriter.this.write(writer, "  <" + HTMLWriter.this.convertCase("title") + ">" + string2 + "</" + HTMLWriter.this.convertCase("title") + ">\n");
                } else {
                    HTMLWriter.this.write(writer, "<" + HTMLWriter.this.convertCase("title") + ">" + string2 + "</" + HTMLWriter.this.convertCase("title") + ">\n");
                }
            }
            if ((string = (String)styledDocument.getProperty("basehref")) != null) {
                HTMLWriter.this.write(writer, "  <" + HTMLWriter.this.convertCase("base") + HTMLWriter.SPACE + HTMLWriter.this.convertCase("href") + "=\"" + string + "\">\n");
            }
            HTMLWriter.this.write(writer, "</" + HTMLWriter.this.convertCase("head") + ">\n");
        }

        public HeadTranslator() {
            HTMLWriter.this = HTMLWriter.this;
        }
    }

    public class BodyTranslator
    implements BranchTranslator {
        public void translate(Writer writer, Element element) {
            HTMLWriter.this.write(writer, "<" + HTMLWriter.this.convertCase("body"));
            AttributeSet attributeSet = element.getAttributes();
            String string = (String)attributeSet.getAttribute("text");
            if (string != null) {
                HTMLWriter.this.write(writer, String.valueOf(SPACE) + HTMLWriter.this.convertCase("text") + EQUAL);
                HTMLWriter.this.write(writer, HTMLWriter.this.convertCase(string));
            }
            if ((string = (String)attributeSet.getAttribute("background")) != null) {
                HTMLWriter.this.write(writer, String.valueOf(SPACE) + HTMLWriter.this.convertCase("background") + EQUAL);
                HTMLWriter.this.write(writer, string);
            }
            if ((string = (String)attributeSet.getAttribute("bgcolor")) != null) {
                HTMLWriter.this.write(writer, String.valueOf(SPACE) + HTMLWriter.this.convertCase("bgcolor") + EQUAL);
                HTMLWriter.this.write(writer, HTMLWriter.this.convertCase(string));
            }
            if ((string = (String)attributeSet.getAttribute("link")) != null) {
                HTMLWriter.this.write(writer, String.valueOf(SPACE) + HTMLWriter.this.convertCase("link") + EQUAL);
                HTMLWriter.this.write(writer, HTMLWriter.this.convertCase(string));
            }
            if ((string = (String)attributeSet.getAttribute("vlink")) != null) {
                HTMLWriter.this.write(writer, String.valueOf(SPACE) + HTMLWriter.this.convertCase("vlink") + EQUAL);
                HTMLWriter.this.write(writer, HTMLWriter.this.convertCase(string));
            }
            if ((string = (String)attributeSet.getAttribute("alink")) != null) {
                HTMLWriter.this.write(writer, String.valueOf(SPACE) + HTMLWriter.this.convertCase("alink") + EQUAL);
                HTMLWriter.this.write(writer, HTMLWriter.this.convertCase(string));
            }
            HTMLWriter.this.write(writer, ">");
        }

        public BodyTranslator() {
            HTMLWriter.this = HTMLWriter.this;
        }
    }

    public class HTranslator
    implements BranchTranslator {
        public void translate(Writer writer, Element element) {
            AttributeSet attributeSet = element.getAttributes();
            AttributeSet attributeSet2 = attributeSet.getResolveParent();
            String string = (String)attributeSet2.getAttribute(AttributeSet.NameAttribute);
            HTMLWriter.this.write(writer, "<");
            HTMLWriter.this.write(writer, HTMLWriter.this.convertCase(string));
            String string2 = (String)attributeSet.getAttribute("align");
            if (string2 != null) {
                HTMLWriter.this.write(writer, String.valueOf(SPACE) + HTMLWriter.this.convertCase("align") + EQUAL);
                HTMLWriter.this.write(writer, HTMLWriter.this.convertCase(string2));
            }
            HTMLWriter.this.write(writer, ">");
        }

        public HTranslator() {
            HTMLWriter.this = HTMLWriter.this;
        }
    }

    public class LiTranslator
    implements BranchTranslator {
        public void translate(Writer writer, Element element) {
            AttributeSet attributeSet = element.getAttributes();
            HTMLWriter.this.write(writer, "<");
            HTMLWriter.this.write(writer, HTMLWriter.this.convertCase("li"));
            String string = (String)attributeSet.getAttribute("type");
            if (string != null) {
                HTMLWriter.this.write(writer, String.valueOf(SPACE) + HTMLWriter.this.convertCase("type") + EQUAL);
                string = HTMLWriter.this.convertCase(string);
                HTMLWriter.this.write(writer, string);
            }
            if ((string = (String)attributeSet.getAttribute("value")) != null) {
                HTMLWriter.this.write(writer, String.valueOf(SPACE) + HTMLWriter.this.convertCase("value"));
                string = HTMLWriter.this.convertCase(string);
                HTMLWriter.this.write(writer, string);
            }
            HTMLWriter.this.write(writer, ">");
        }

        public LiTranslator() {
            HTMLWriter.this = HTMLWriter.this;
        }
    }

    public class PTranslator
    implements BranchTranslator {
        public void translate(Writer writer, Element element) {
            AttributeSet attributeSet = element.getAttributes();
            HTMLWriter.this.write(writer, "<");
            HTMLWriter.this.write(writer, HTMLWriter.this.convertCase("p"));
            String string = (String)attributeSet.getAttribute("align");
            if (string != null) {
                HTMLWriter.this.write(writer, String.valueOf(SPACE) + HTMLWriter.this.convertCase("align") + EQUAL);
                HTMLWriter.this.write(writer, HTMLWriter.this.convertCase(string));
            }
            HTMLWriter.this.write(writer, ">");
        }

        public PTranslator() {
            HTMLWriter.this = HTMLWriter.this;
        }
    }

    public class PreTranslator
    implements BranchTranslator {
        public void translate(Writer writer, Element element) {
            AttributeSet attributeSet = element.getAttributes();
            HTMLWriter.this.write(writer, "<" + HTMLWriter.this.convertCase("pre"));
            String string = (String)attributeSet.getAttribute("width");
            if (string != null) {
                HTMLWriter.this.write(writer, String.valueOf(SPACE) + HTMLWriter.this.convertCase("width") + EQUAL);
                HTMLWriter.this.write(writer, HTMLWriter.this.convertCase(string));
            }
            HTMLWriter.this.write(writer, ">");
            HTMLWriter.this.nPrelines = element.getElementCount();
        }

        public PreTranslator() {
            HTMLWriter.this = HTMLWriter.this;
        }
    }

    public class DlTranslator
    implements BranchTranslator {
        public void translate(Writer writer, Element element) {
            AttributeSet attributeSet = element.getAttributes();
            HTMLWriter.this.write(writer, "<" + HTMLWriter.this.convertCase("dl"));
            String string = (String)attributeSet.getAttribute("compact");
            if (string == "#DEFAULT") {
                HTMLWriter.this.write(writer, String.valueOf(SPACE) + HTMLWriter.this.convertCase("compact"));
            }
            HTMLWriter.this.write(writer, ">\n");
        }

        public DlTranslator() {
            HTMLWriter.this = HTMLWriter.this;
        }
    }

    public class DtTranslator
    implements BranchTranslator {
        public void translate(Writer writer, Element element) {
            element.getAttributes();
            HTMLWriter.this.write(writer, "<" + HTMLWriter.this.convertCase("dt") + ">");
        }

        public DtTranslator() {
            HTMLWriter.this = HTMLWriter.this;
        }
    }

    public class DdTranslator
    implements BranchTranslator {
        public void translate(Writer writer, Element element) {
            element.getAttributes();
            HTMLWriter.this.write(writer, "<" + HTMLWriter.this.convertCase("dd") + ">");
        }

        public DdTranslator() {
            HTMLWriter.this = HTMLWriter.this;
        }
    }

    public class PreLineTranslator
    implements BranchTranslator {
        public void translate(Writer writer, Element element) {
            HTMLWriter hTMLWriter = HTMLWriter.this;
            hTMLWriter.nPrelines = hTMLWriter.nPrelines - 1;
            HTMLWriter.this.writePre = true;
        }

        public PreLineTranslator() {
            HTMLWriter.this = HTMLWriter.this;
        }
    }

    public class UlTranslator
    implements BranchTranslator {
        public void translate(Writer writer, Element element) {
            AttributeSet attributeSet = element.getAttributes();
            HTMLWriter.this.write(writer, "<");
            HTMLWriter.this.write(writer, HTMLWriter.this.convertCase("ul"));
            String string = (String)attributeSet.getAttribute("type");
            if (string != null) {
                HTMLWriter.this.write(writer, String.valueOf(SPACE) + HTMLWriter.this.convertCase("type") + EQUAL);
                HTMLWriter.this.write(writer, HTMLWriter.this.convertCase(string));
            }
            if ((string = (String)attributeSet.getAttribute("compact")) == "#DEFAULT") {
                HTMLWriter.this.write(writer, String.valueOf(SPACE) + HTMLWriter.this.convertCase("compact"));
            }
            HTMLWriter.this.write(writer, ">\n");
        }

        public UlTranslator() {
            HTMLWriter.this = HTMLWriter.this;
        }
    }

    public class OlTranslator
    implements BranchTranslator {
        public void translate(Writer writer, Element element) {
            AttributeSet attributeSet = element.getAttributes();
            HTMLWriter.this.write(writer, "<");
            HTMLWriter.this.write(writer, HTMLWriter.this.convertCase("ol"));
            String string = (String)attributeSet.getAttribute("start");
            if (string != null) {
                HTMLWriter.this.write(writer, String.valueOf(SPACE) + HTMLWriter.this.convertCase("start") + EQUAL);
                HTMLWriter.this.write(writer, HTMLWriter.this.convertCase(string));
            }
            if ((string = (String)attributeSet.getAttribute("type")) != null) {
                HTMLWriter.this.write(writer, String.valueOf(SPACE) + HTMLWriter.this.convertCase("type") + EQUAL);
                HTMLWriter.this.write(writer, String.valueOf(QUOTE) + HTMLWriter.this.convertCase(string) + QUOTE);
            }
            if ((string = (String)attributeSet.getAttribute("compact")) == "#DEFAULT") {
                HTMLWriter.this.write(writer, String.valueOf(SPACE) + HTMLWriter.this.convertCase("compact"));
            }
            HTMLWriter.this.write(writer, ">\n");
        }

        public OlTranslator() {
            HTMLWriter.this = HTMLWriter.this;
        }
    }

    public class MenuTranslator
    implements BranchTranslator {
        public void translate(Writer writer, Element element) {
            AttributeSet attributeSet = element.getAttributes();
            HTMLWriter.this.write(writer, "<");
            HTMLWriter.this.write(writer, HTMLWriter.this.convertCase("menu"));
            String string = (String)attributeSet.getAttribute("type");
            if (string != null) {
                HTMLWriter.this.write(writer, String.valueOf(SPACE) + HTMLWriter.this.convertCase("type") + EQUAL);
                HTMLWriter.this.write(writer, HTMLWriter.this.convertCase(string));
            }
            HTMLWriter.this.write(writer, ">\n");
        }

        public MenuTranslator() {
            HTMLWriter.this = HTMLWriter.this;
        }
    }

    public class BlockquoteTranslator
    implements BranchTranslator {
        public void translate(Writer writer, Element element) {
            element.getAttributes();
            HTMLWriter.this.write(writer, "<");
            HTMLWriter.this.write(writer, HTMLWriter.this.convertCase("blockquote"));
            HTMLWriter.this.write(writer, ">\n");
        }

        public BlockquoteTranslator() {
            HTMLWriter.this = HTMLWriter.this;
        }
    }

    public class GenericLeafTranslator
    implements LeafTranslator {
        public void translate(Writer writer, Element element, Element element2) {
            String string = element2.getName();
            HTMLWriter.this.write(writer, "<" + HTMLWriter.this.convertCase(string) + ">");
        }

        public GenericLeafTranslator() {
            HTMLWriter.this = HTMLWriter.this;
        }
    }

    public class ContentTranslator
    implements LeafTranslator {
        public void translate(Writer writer, Element element, Element element2) {
            Object object;
            Stack<Object> stack = new Stack<Object>();
            Vector<Style> vector = new Vector<Style>();
            AttributeSet attributeSet = element2.getAttributes();
            AttributeSet attributeSet2 = element.getAttributes();
            attributeSet2.getResolveParent();
            Enumeration enumeration = attributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (object.toString().startsWith("$") || !attributeSet.getAttribute(object).equals("true")) continue;
                HTMLDebug.println(String.valueOf(object) + HTMLWriter.EQUAL + attributeSet.getAttribute(object));
                stack.push(object);
                HTMLWriter.this.write(writer, "<" + object + ">");
                StyledDocument styledDocument = (StyledDocument)element2.getDocument();
                Style style = styledDocument.getStyle(object.toString());
                if (style == null) continue;
                vector.addElement(style);
            }
            HTMLWriter.this.writeContent(writer, vector, element2, element);
            while (stack.size() != 0) {
                object = (String)stack.peek();
                HTMLWriter.this.write(writer, "</" + object + ">");
                stack.pop();
            }
        }

        public ContentTranslator() {
            HTMLWriter.this = HTMLWriter.this;
        }
    }

    public class ImgTranslator
    implements LeafTranslator {
        public void translate(Writer writer, Element element, Element element2) {
            AttributeSet attributeSet = element2.getAttributes();
            String string = (String)attributeSet.getAttribute("src");
            if (string == null) {
                System.out.println("HTMLWriter.ImgTranslator: No src attribute for img.");
                return;
            }
            HTMLWriter.this.write(writer, "<" + HTMLWriter.this.convertCase("img") + HTMLWriter.SPACE + HTMLWriter.this.convertCase("src") + HTMLWriter.EQUAL + QUOTE + string.toLowerCase() + QUOTE);
            string = (String)attributeSet.getAttribute("height");
            if (string != null) {
                HTMLWriter.this.write(writer, String.valueOf(SPACE) + HTMLWriter.this.convertCase("height") + EQUAL + HTMLWriter.this.convertCase(string));
            }
            if ((string = (String)attributeSet.getAttribute("width")) != null) {
                HTMLWriter.this.write(writer, String.valueOf(SPACE) + HTMLWriter.this.convertCase("width") + EQUAL + HTMLWriter.this.convertCase(string));
            }
            if ((string = (String)attributeSet.getAttribute("align")) != null) {
                HTMLWriter.this.write(writer, String.valueOf(SPACE) + HTMLWriter.this.convertCase("align") + EQUAL + HTMLWriter.this.convertCase(string));
            }
            if ((string = (String)attributeSet.getAttribute("hspace")) != null) {
                HTMLWriter.this.write(writer, String.valueOf(SPACE) + HTMLWriter.this.convertCase("hspace") + EQUAL + string);
            }
            if ((string = (String)attributeSet.getAttribute("vspace")) != null) {
                HTMLWriter.this.write(writer, String.valueOf(SPACE) + HTMLWriter.this.convertCase("vspace") + EQUAL + string);
            }
            if ((string = (String)attributeSet.getAttribute("alt")) != null) {
                HTMLWriter.this.write(writer, String.valueOf(SPACE) + HTMLWriter.this.convertCase("alt") + EQUAL + QUOTE + string + QUOTE);
            }
            if ((string = (String)attributeSet.getAttribute("border")) != null) {
                HTMLWriter.this.write(writer, String.valueOf(SPACE) + HTMLWriter.this.convertCase("border") + EQUAL + string);
            }
            if ((string = (String)attributeSet.getAttribute("usemap")) != null) {
                HTMLWriter.this.write(writer, String.valueOf(SPACE) + HTMLWriter.this.convertCase("usemap"));
            }
            if ((string = (String)attributeSet.getAttribute("ismap")) != null) {
                HTMLWriter.this.write(writer, String.valueOf(SPACE) + HTMLWriter.this.convertCase("ismap"));
            }
            HTMLWriter.this.write(writer, ">");
        }

        public ImgTranslator() {
            HTMLWriter.this = HTMLWriter.this;
        }
    }

    public class FontTranslator
    implements LeafTranslator {
        public void translate(Writer writer, Element element, Element element2) {
            Object object;
            AttributeSet attributeSet = element2.getAttributes();
            AttributeSet attributeSet2 = element.getAttributes();
            AttributeSet attributeSet3 = attributeSet2.getResolveParent();
            if (attributeSet.isDefined(StyleConstants.Foreground) || attributeSet.isDefined(StyleConstants.FontSize) || attributeSet.isDefined(StyleConstants.FontFamily)) {
                HTMLWriter hTMLWriter = HTMLWriter.this;
                hTMLWriter.inFont = hTMLWriter.inFont + 1;
                HTMLWriter.this.write(writer, "<" + HTMLWriter.this.convertCase("font"));
            }
            if (attributeSet.isDefined(StyleConstants.Foreground)) {
                object = StyleConstants.getForeground(attributeSet);
                try {
                    String string = HTMLUtils.colorToHex((Color)object);
                    HTMLWriter.this.write(writer, HTMLWriter.SPACE + HTMLWriter.this.convertCase("color") + HTMLWriter.EQUAL + HTMLWriter.this.convertCase(string));
                }
                catch (HTMLException hTMLException) {
                    HTMLDebug.println("Unable to convert Color string:" + object);
                }
            }
            if (attributeSet.isDefined(StyleConstants.FontSize)) {
                int n;
                object = StyleReader.getStyleSheet();
                int n2 = ((StyleSheet)object).getRelSize(n = StyleConstants.getFontSize(attributeSet));
                if (n2 < 0) {
                    HTMLWriter.this.write(writer, HTMLWriter.SPACE + HTMLWriter.this.convertCase("size") + HTMLWriter.EQUAL + n2);
                } else {
                    HTMLWriter.this.write(writer, HTMLWriter.SPACE + HTMLWriter.this.convertCase("size") + "=+" + n2);
                }
            }
            if (!attributeSet3.isDefined(StyleConstants.FontFamily) && attributeSet.isDefined(StyleConstants.FontFamily)) {
                object = StyleConstants.getFontFamily(attributeSet);
                HTMLWriter.this.write(writer, HTMLWriter.SPACE + HTMLWriter.this.convertCase("face") + "=\"" + (String)object + HTMLWriter.QUOTE);
            }
            if (HTMLWriter.this.inFont > 0) {
                HTMLWriter.this.write(writer, ">");
            }
        }

        public FontTranslator() {
            HTMLWriter.this = HTMLWriter.this;
        }
    }

    public class HrTranslator
    implements LeafTranslator {
        public void translate(Writer writer, Element element, Element element2) {
            AttributeSet attributeSet = element2.getAttributes();
            HTMLWriter.this.write(writer, "<");
            HTMLWriter.this.write(writer, HTMLWriter.this.convertCase("hr"));
            String string = (String)attributeSet.getAttribute("align");
            if (string != null) {
                HTMLWriter.this.write(writer, String.valueOf(SPACE) + HTMLWriter.this.convertCase("align") + EQUAL);
                HTMLWriter.this.write(writer, HTMLWriter.this.convertCase(string));
            }
            if ((string = (String)attributeSet.getAttribute("noshade")) != null) {
                HTMLWriter.this.write(writer, String.valueOf(SPACE) + HTMLWriter.this.convertCase("noshade"));
                HTMLWriter.this.write(writer, HTMLWriter.this.convertCase(string));
            }
            if ((string = (String)attributeSet.getAttribute("size")) != null) {
                HTMLWriter.this.write(writer, String.valueOf(SPACE) + HTMLWriter.this.convertCase("size") + EQUAL);
                HTMLWriter.this.write(writer, string);
            }
            if ((string = (String)attributeSet.getAttribute("width")) != null) {
                HTMLWriter.this.write(writer, String.valueOf(SPACE) + HTMLWriter.this.convertCase("width"));
                HTMLWriter.this.write(writer, string);
            }
            HTMLWriter.this.write(writer, ">\n");
        }

        public HrTranslator() {
            HTMLWriter.this = HTMLWriter.this;
        }
    }

    public class ATranslator
    implements LeafTranslator {
        public void translate(Writer writer, Element element, Element element2) {
            AttributeSet attributeSet = element2.getAttributes();
            HTMLWriter.this.write(writer, "<");
            HTMLWriter.this.write(writer, HTMLWriter.this.convertCase("a"));
            String string = (String)attributeSet.getAttribute("href");
            if (string != null) {
                HTMLWriter.this.write(writer, String.valueOf(SPACE) + HTMLWriter.this.convertCase("href") + EQUAL);
                HTMLWriter.this.write(writer, String.valueOf(QUOTE) + string + QUOTE);
            }
            if ((string = (String)attributeSet.getAttribute("name")) != null) {
                HTMLWriter.this.write(writer, String.valueOf(SPACE) + HTMLWriter.this.convertCase("name") + EQUAL);
                HTMLWriter.this.write(writer, String.valueOf(QUOTE) + string + QUOTE);
            }
            if ((string = (String)attributeSet.getAttribute("rel")) != null) {
                HTMLWriter.this.write(writer, String.valueOf(SPACE) + HTMLWriter.this.convertCase("rel") + EQUAL);
                HTMLWriter.this.write(writer, string);
            }
            if ((string = (String)attributeSet.getAttribute("rev")) != null) {
                HTMLWriter.this.write(writer, String.valueOf(SPACE) + HTMLWriter.this.convertCase("rev"));
                HTMLWriter.this.write(writer, string);
            }
            if ((string = (String)attributeSet.getAttribute("title")) != null) {
                HTMLWriter.this.write(writer, String.valueOf(SPACE) + HTMLWriter.this.convertCase("title"));
                HTMLWriter.this.write(writer, String.valueOf(QUOTE) + string + QUOTE);
            }
            HTMLWriter.this.write(writer, ">");
            StyledDocument styledDocument = (StyledDocument)element2.getDocument();
            Style style = styledDocument.getStyle("a");
            Vector<Style> vector = new Vector<Style>();
            if (style != null) {
                vector.addElement(style);
            }
            HTMLWriter.this.writeContent(writer, vector, element2, element);
            HTMLWriter.this.write(writer, "</" + HTMLWriter.this.convertCase("a") + ">");
        }

        public ATranslator() {
            HTMLWriter.this = HTMLWriter.this;
        }
    }

    public class CodeTranslator
    implements LeafTranslator {
        public void translate(Writer writer, Element element, Element element2) {
            element2.getAttributes();
            HTMLWriter.this.write(writer, "<");
            HTMLWriter.this.write(writer, HTMLWriter.this.convertCase("code"));
            HTMLWriter.this.write(writer, ">");
            StyledDocument styledDocument = (StyledDocument)element2.getDocument();
            Style style = styledDocument.getStyle("code");
            Vector<Style> vector = new Vector<Style>();
            if (style != null) {
                vector.addElement(style);
            }
            HTMLWriter.this.writeContent(writer, vector, element2, element);
            HTMLWriter.this.write(writer, "</" + HTMLWriter.this.convertCase("code") + ">");
        }

        public CodeTranslator() {
            HTMLWriter.this = HTMLWriter.this;
        }
    }

    public class EmTranslator
    implements LeafTranslator {
        public void translate(Writer writer, Element element, Element element2) {
            element2.getAttributes();
            HTMLWriter.this.write(writer, "<");
            HTMLWriter.this.write(writer, HTMLWriter.this.convertCase("em"));
            HTMLWriter.this.write(writer, ">");
            StyledDocument styledDocument = (StyledDocument)element2.getDocument();
            Style style = styledDocument.getStyle("em");
            Vector<Style> vector = new Vector<Style>();
            if (style != null) {
                vector.addElement(style);
            }
            HTMLWriter.this.writeContent(writer, vector, element2, element);
            HTMLWriter.this.write(writer, "</" + HTMLWriter.this.convertCase("em") + ">");
        }

        public EmTranslator() {
            HTMLWriter.this = HTMLWriter.this;
        }
    }

    public class CiteTranslator
    implements LeafTranslator {
        public void translate(Writer writer, Element element, Element element2) {
            element2.getAttributes();
            HTMLWriter.this.write(writer, "<");
            HTMLWriter.this.write(writer, HTMLWriter.this.convertCase("cite"));
            HTMLWriter.this.write(writer, ">");
            StyledDocument styledDocument = (StyledDocument)element2.getDocument();
            Style style = styledDocument.getStyle("cite");
            Vector<Style> vector = new Vector<Style>();
            if (style != null) {
                vector.addElement(style);
            }
            HTMLWriter.this.writeContent(writer, vector, element2, element);
            HTMLWriter.this.write(writer, "</" + HTMLWriter.this.convertCase("cite") + ">");
        }

        public CiteTranslator() {
            HTMLWriter.this = HTMLWriter.this;
        }
    }

    public class StrikeTranslator
    implements LeafTranslator {
        public void translate(Writer writer, Element element, Element element2) {
            element2.getAttributes();
            HTMLWriter.this.write(writer, "<");
            HTMLWriter.this.write(writer, HTMLWriter.this.convertCase("strike"));
            HTMLWriter.this.write(writer, ">");
            StyledDocument styledDocument = (StyledDocument)element2.getDocument();
            Style style = styledDocument.getStyle("strike");
            Vector<Style> vector = new Vector<Style>();
            if (style != null) {
                vector.addElement(style);
            }
            HTMLWriter.this.writeContent(writer, vector, element2, element);
            HTMLWriter.this.write(writer, "</" + HTMLWriter.this.convertCase("strike") + ">");
        }

        public StrikeTranslator() {
            HTMLWriter.this = HTMLWriter.this;
        }
    }

    public class SubTranslator
    implements LeafTranslator {
        public void translate(Writer writer, Element element, Element element2) {
            element2.getAttributes();
            HTMLWriter.this.write(writer, "<");
            HTMLWriter.this.write(writer, HTMLWriter.this.convertCase("sub"));
            HTMLWriter.this.write(writer, ">");
            StyledDocument styledDocument = (StyledDocument)element2.getDocument();
            Style style = styledDocument.getStyle("sub");
            Vector<Style> vector = new Vector<Style>();
            if (style != null) {
                vector.addElement(style);
            }
            HTMLWriter.this.writeContent(writer, vector, element2, element);
            HTMLWriter.this.write(writer, "</" + HTMLWriter.this.convertCase("sub") + ">");
        }

        public SubTranslator() {
            HTMLWriter.this = HTMLWriter.this;
        }
    }

    public class TtTranslator
    implements LeafTranslator {
        public void translate(Writer writer, Element element, Element element2) {
            element2.getAttributes();
            HTMLWriter.this.write(writer, "<");
            HTMLWriter.this.write(writer, HTMLWriter.this.convertCase("tt"));
            HTMLWriter.this.write(writer, ">");
            StyledDocument styledDocument = (StyledDocument)element2.getDocument();
            Style style = styledDocument.getStyle("tt");
            Vector<Style> vector = new Vector<Style>();
            if (style != null) {
                vector.addElement(style);
            }
            HTMLWriter.this.writeContent(writer, vector, element2, element);
            HTMLWriter.this.write(writer, "</" + HTMLWriter.this.convertCase("tt") + ">");
        }

        public TtTranslator() {
            HTMLWriter.this = HTMLWriter.this;
        }
    }

    public class SupTranslator
    implements LeafTranslator {
        public void translate(Writer writer, Element element, Element element2) {
            element2.getAttributes();
            HTMLWriter.this.write(writer, "<");
            HTMLWriter.this.write(writer, HTMLWriter.this.convertCase("sup"));
            HTMLWriter.this.write(writer, ">");
            StyledDocument styledDocument = (StyledDocument)element2.getDocument();
            Style style = styledDocument.getStyle("sup");
            Vector<Style> vector = new Vector<Style>();
            if (style != null) {
                vector.addElement(style);
            }
            HTMLWriter.this.writeContent(writer, vector, element2, element);
            HTMLWriter.this.write(writer, "</" + HTMLWriter.this.convertCase("sup") + ">");
        }

        public SupTranslator() {
            HTMLWriter.this = HTMLWriter.this;
        }
    }

    public class BigTranslator
    implements LeafTranslator {
        public void translate(Writer writer, Element element, Element element2) {
            element2.getAttributes();
            HTMLWriter.this.write(writer, "<");
            HTMLWriter.this.write(writer, HTMLWriter.this.convertCase("big"));
            HTMLWriter.this.write(writer, ">");
            StyledDocument styledDocument = (StyledDocument)element2.getDocument();
            Style style = styledDocument.getStyle("big");
            Vector<Style> vector = new Vector<Style>();
            if (style != null) {
                vector.addElement(style);
            }
            HTMLWriter.this.writeContent(writer, vector, element2, element);
            HTMLWriter.this.write(writer, "</" + HTMLWriter.this.convertCase("big") + ">");
        }

        public BigTranslator() {
            HTMLWriter.this = HTMLWriter.this;
        }
    }

    public class SmallTranslator
    implements LeafTranslator {
        public void translate(Writer writer, Element element, Element element2) {
            element2.getAttributes();
            HTMLWriter.this.write(writer, "<");
            HTMLWriter.this.write(writer, HTMLWriter.this.convertCase("small"));
            HTMLWriter.this.write(writer, ">");
            StyledDocument styledDocument = (StyledDocument)element2.getDocument();
            Style style = styledDocument.getStyle("small");
            Vector<Style> vector = new Vector<Style>();
            if (style != null) {
                vector.addElement(style);
            }
            HTMLWriter.this.writeContent(writer, vector, element2, element);
            HTMLWriter.this.write(writer, "</" + HTMLWriter.this.convertCase("small") + ">");
        }

        public SmallTranslator() {
            HTMLWriter.this = HTMLWriter.this;
        }
    }

    public class DfnTranslator
    implements LeafTranslator {
        public void translate(Writer writer, Element element, Element element2) {
            element2.getAttributes();
            HTMLWriter.this.write(writer, "<");
            HTMLWriter.this.write(writer, HTMLWriter.this.convertCase("dfn"));
            HTMLWriter.this.write(writer, ">");
            StyledDocument styledDocument = (StyledDocument)element2.getDocument();
            Style style = styledDocument.getStyle("dfn");
            Vector<Style> vector = new Vector<Style>();
            if (style != null) {
                vector.addElement(style);
            }
            HTMLWriter.this.writeContent(writer, vector, element2, element);
            HTMLWriter.this.write(writer, "</" + HTMLWriter.this.convertCase("dfn") + ">");
        }

        public DfnTranslator() {
            HTMLWriter.this = HTMLWriter.this;
        }
    }

    public class KbdTranslator
    implements LeafTranslator {
        public void translate(Writer writer, Element element, Element element2) {
            element2.getAttributes();
            HTMLWriter.this.write(writer, "<");
            HTMLWriter.this.write(writer, HTMLWriter.this.convertCase("kbd"));
            HTMLWriter.this.write(writer, ">");
            StyledDocument styledDocument = (StyledDocument)element2.getDocument();
            Style style = styledDocument.getStyle("kbd");
            Vector<Style> vector = new Vector<Style>();
            if (style != null) {
                vector.addElement(style);
            }
            HTMLWriter.this.writeContent(writer, vector, element2, element);
            HTMLWriter.this.write(writer, "</" + HTMLWriter.this.convertCase("kbd") + ">");
        }

        public KbdTranslator() {
            HTMLWriter.this = HTMLWriter.this;
        }
    }

    public class SampTranslator
    implements LeafTranslator {
        public void translate(Writer writer, Element element, Element element2) {
            element2.getAttributes();
            HTMLWriter.this.write(writer, "<");
            HTMLWriter.this.write(writer, HTMLWriter.this.convertCase("samp"));
            HTMLWriter.this.write(writer, ">");
            StyledDocument styledDocument = (StyledDocument)element2.getDocument();
            Style style = styledDocument.getStyle("samp");
            Vector<Style> vector = new Vector<Style>();
            if (style != null) {
                vector.addElement(style);
            }
            HTMLWriter.this.writeContent(writer, vector, element2, element);
            HTMLWriter.this.write(writer, "</" + HTMLWriter.this.convertCase("samp") + ">");
        }

        public SampTranslator() {
            HTMLWriter.this = HTMLWriter.this;
        }
    }

    public class StrongTranslator
    implements LeafTranslator {
        public void translate(Writer writer, Element element, Element element2) {
            element2.getAttributes();
            HTMLWriter.this.write(writer, "<");
            HTMLWriter.this.write(writer, HTMLWriter.this.convertCase("strong"));
            HTMLWriter.this.write(writer, ">");
            StyledDocument styledDocument = (StyledDocument)element2.getDocument();
            Style style = styledDocument.getStyle("strong");
            Vector<Style> vector = new Vector<Style>();
            if (style != null) {
                vector.addElement(style);
            }
            HTMLWriter.this.writeContent(writer, vector, element2, element);
            HTMLWriter.this.write(writer, "</" + HTMLWriter.this.convertCase("strong") + ">");
        }

        public StrongTranslator() {
            HTMLWriter.this = HTMLWriter.this;
        }
    }

    public class VarTranslator
    implements LeafTranslator {
        public void translate(Writer writer, Element element, Element element2) {
            element2.getAttributes();
            HTMLWriter.this.write(writer, "<");
            HTMLWriter.this.write(writer, HTMLWriter.this.convertCase("_var"));
            HTMLWriter.this.write(writer, ">");
            StyledDocument styledDocument = (StyledDocument)element2.getDocument();
            Style style = styledDocument.getStyle("_var");
            Vector<Style> vector = new Vector<Style>();
            if (style != null) {
                vector.addElement(style);
            }
            HTMLWriter.this.writeContent(writer, vector, element2, element);
            HTMLWriter.this.write(writer, "</" + HTMLWriter.this.convertCase("_var") + ">");
        }

        public VarTranslator() {
            HTMLWriter.this = HTMLWriter.this;
        }
    }

    public class PreLeafTranslator
    implements LeafTranslator {
        public void translate(Writer writer, Element element, Element element2) {
            StyledDocument styledDocument = (StyledDocument)element2.getDocument();
            Style style = styledDocument.getStyle("pre");
            Vector<Style> vector = new Vector<Style>();
            if (style != null) {
                vector.addElement(style);
            }
            HTMLWriter.this.writeContent(writer, vector, element2, element);
        }

        public PreLeafTranslator() {
            HTMLWriter.this = HTMLWriter.this;
        }
    }

    public class BaseFontTranslator
    implements LeafTranslator {
        public void translate(Writer writer, Element element, Element element2) {
            AttributeSet attributeSet = element2.getAttributes();
            HTMLWriter.this.write(writer, "<");
            HTMLWriter.this.write(writer, HTMLWriter.this.convertCase("basefont"));
            String string = (String)attributeSet.getAttribute("size");
            if (string != null) {
                HTMLWriter.this.write(writer, String.valueOf(SPACE) + HTMLWriter.this.convertCase("size") + EQUAL);
                HTMLWriter.this.write(writer, string);
            }
            HTMLWriter.this.write(writer, ">");
        }

        public BaseFontTranslator() {
            HTMLWriter.this = HTMLWriter.this;
        }
    }
}

