/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Integer
extends Number {
    public static final int MIN_VALUE = -2147483648;
    public static final int MAX_VALUE = 0x7FFFFFFF;
    public static final Class TYPE = Class.getPrimitiveClass("int");
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final char[] radixTenTenths = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    private static final char[] radixTenUnits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private int value;
    private static final long serialVersionUID = 1360826667806852920L;

    public static String toString(int n, int n2) {
        if (n2 < 2 || n2 > 36) {
            n2 = 10;
        }
        if (n2 == 10) {
            return Integer.toString(n);
        }
        char[] cArray = new char[33];
        boolean bl = n < 0;
        int n3 = 32;
        if (!bl) {
            n = -n;
        }
        while (n <= -n2) {
            cArray[n3--] = digits[-(n % n2)];
            n /= n2;
        }
        cArray[n3] = digits[-n];
        if (bl) {
            cArray[--n3] = 45;
        }
        return new String(cArray, n3, 33 - n3);
    }

    public static String toHexString(int n) {
        return Integer.toUnsignedString(n, 4);
    }

    public static String toOctalString(int n) {
        return Integer.toUnsignedString(n, 3);
    }

    public static String toBinaryString(int n) {
        return Integer.toUnsignedString(n, 1);
    }

    private static String toUnsignedString(int n, int n2) {
        char[] cArray = new char[32];
        int n3 = 32;
        int n4 = 1 << n2;
        int n5 = n4 - 1;
        do {
            cArray[--n3] = digits[n & n5];
        } while ((n >>>= n2) != 0);
        return new String(cArray, n3, 32 - n3);
    }

    public static String toString(int n) {
        char[] cArray = new char[12];
        boolean bl = n < 0;
        int n2 = 12;
        if (n == Integer.MIN_VALUE) {
            return "-2147483648";
        }
        if (bl) {
            n = -n;
        }
        do {
            int n3 = n % 100;
            cArray[--n2] = radixTenUnits[n3];
            cArray[--n2] = radixTenTenths[n3];
        } while ((n /= 100) != 0);
        if (cArray[n2] == '0') {
            ++n2;
        }
        if (bl) {
            cArray[--n2] = 45;
        }
        return new String(cArray, n2, 12 - n2);
    }

    public static int parseInt(String string, int n) throws NumberFormatException {
        if (string == null) {
            throw new NumberFormatException("null");
        }
        if (n < 2) {
            throw new NumberFormatException("radix " + n + " less than Character.MIN_RADIX");
        }
        if (n > 36) {
            throw new NumberFormatException("radix " + n + " greater than Character.MAX_RADIX");
        }
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        int n4 = string.length();
        if (n4 > 0) {
            int n5;
            int n6;
            if (string.charAt(0) == '-') {
                bl = true;
                n6 = Integer.MIN_VALUE;
                ++n3;
            } else {
                n6 = -2147483647;
            }
            int n7 = n6 / n;
            if (n3 < n4) {
                if ((n5 = Character.digit(string.charAt(n3++), n)) < 0) {
                    throw new NumberFormatException(string);
                }
                n2 = -n5;
            }
            while (n3 < n4) {
                if ((n5 = Character.digit(string.charAt(n3++), n)) < 0) {
                    throw new NumberFormatException(string);
                }
                if (n2 < n7) {
                    throw new NumberFormatException(string);
                }
                if ((n2 *= n) < n6 + n5) {
                    throw new NumberFormatException(string);
                }
                n2 -= n5;
            }
        } else {
            throw new NumberFormatException(string);
        }
        if (bl) {
            if (n3 > 1) {
                return n2;
            }
            throw new NumberFormatException(string);
        }
        return -n2;
    }

    public static int parseInt(String string) throws NumberFormatException {
        return Integer.parseInt(string, 10);
    }

    public static Integer valueOf(String string, int n) throws NumberFormatException {
        return new Integer(Integer.parseInt(string, n));
    }

    public static Integer valueOf(String string) throws NumberFormatException {
        return new Integer(Integer.parseInt(string, 10));
    }

    public Integer(int n) {
        this.value = n;
    }

    public Integer(String string) throws NumberFormatException {
        this.value = Integer.parseInt(string, 10);
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Integer) {
            return this.value == (Integer)object;
        }
        return false;
    }

    public static Integer getInteger(String string) {
        return Integer.getInteger(string, null);
    }

    public static Integer getInteger(String string, int n) {
        Integer n2 = Integer.getInteger(string, null);
        if (n2 == null) {
            return new Integer(n);
        }
        return n2;
    }

    public static Integer getInteger(String string, Integer n) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            try {
                return Integer.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return n;
    }

    public static Integer decode(String string) throws NumberFormatException {
        if (string.startsWith("0x")) {
            return Integer.valueOf(string.substring(2), 16);
        }
        if (string.startsWith("#")) {
            return Integer.valueOf(string.substring(1), 16);
        }
        if (string.startsWith("0") && string.length() > 1) {
            return Integer.valueOf(string.substring(1), 8);
        }
        return Integer.valueOf(string);
    }
}

