/*
 * Decompiled with CFR 0.152.
 */
package java.text;

final class CompactByteArray
implements Cloneable {
    public static final int UNICODECOUNT = 65536;
    private static final int DEBUGSHOWOVERLAPLIMIT = 100;
    private static final boolean DEBUGTRACE = false;
    private static final boolean DEBUGSMALL = false;
    private static final boolean DEBUGOVERLAP = false;
    private static final int DEBUGSMALLLIMIT = 30000;
    private static final int BLOCKSHIFT = 7;
    private static final int BLOCKCOUNT = 128;
    private static final int INDEXSHIFT = 9;
    private static final int INDEXCOUNT = 512;
    private static final int BLOCKMASK = 127;
    private byte[] values;
    private short[] indices;
    private boolean isCompact;

    public CompactByteArray() {
        this(0);
    }

    public CompactByteArray(byte by) {
        this.values = new byte[65536];
        this.indices = new short[512];
        int n = 0;
        while (n < 65536) {
            this.values[n] = by;
            ++n;
        }
        n = 0;
        while (n < 512) {
            this.indices[n] = (short)(n << 7);
            ++n;
        }
        this.isCompact = false;
    }

    public CompactByteArray(short[] sArray, byte[] byArray) {
        if (sArray.length != 512) {
            throw new IllegalArgumentException("Index out of bounds!");
        }
        int n = 0;
        while (n < 512) {
            short s = sArray[n];
            if (s < 0 || s >= byArray.length + 128) {
                throw new IllegalArgumentException("Index out of bounds!");
            }
            ++n;
        }
        this.indices = sArray;
        this.values = byArray;
        this.isCompact = false;
    }

    public byte elementAt(char c) {
        return this.values[(this.indices[c >> 7] & 0xFFFF) + (c & 0x7F)];
    }

    public void setElementAt(char c, byte by) {
        if (this.isCompact) {
            this.expand();
        }
        this.values[c] = by;
    }

    public void setElementAt(char n, char c, byte by) {
        if (this.isCompact) {
            this.expand();
        }
        int n2 = n;
        while (n2 <= c) {
            this.values[n2] = by;
            ++n2;
        }
    }

    public void compact() {
        if (!this.isCompact) {
            char[] cArray = new char[65536];
            int n = 128;
            int n2 = 0;
            while (n2 < 128) {
                cArray[n2] = (char)n2;
                n2 = (short)(n2 + 1);
            }
            this.indices[0] = 0;
            int n3 = 1;
            while (n3 < 512) {
                int n4 = n3 << 7;
                int n5 = this.FindOverlappingPosition(n4, cArray, n);
                int n6 = n5 + 128;
                if (n6 > n) {
                    n2 = (short)n;
                    while (n2 < n6) {
                        cArray[n2] = (char)(n2 - n5 + n4);
                        n2 = (short)(n2 + 1);
                    }
                    n = n6;
                }
                this.indices[n3] = (short)n5;
                n3 = (short)(n3 + 1);
            }
            byte[] byArray = new byte[n];
            n2 = 0;
            while (n2 < n) {
                byArray[n2] = this.values[cArray[n2]];
                n2 = (short)(n2 + 1);
            }
            this.values = null;
            this.values = byArray;
            this.isCompact = true;
        }
    }

    public short[] getIndexArray() {
        return this.indices;
    }

    public byte[] getStringArray() {
        return this.values;
    }

    public Object clone() {
        try {
            CompactByteArray compactByteArray = (CompactByteArray)super.clone();
            compactByteArray.values = (byte[])this.values.clone();
            compactByteArray.indices = (short[])this.indices.clone();
            return compactByteArray;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CompactByteArray compactByteArray = (CompactByteArray)object;
        int n = 0;
        while (n < 65536) {
            if (this.elementAt((char)n) != compactByteArray.elementAt((char)n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        int n2 = Math.min(3, this.values.length / 16);
        int n3 = 0;
        while (n3 < this.values.length) {
            n = n * 37 + this.values[n3];
            n3 += n2;
        }
        return n;
    }

    void writeArrays() {
        int n = this.values.length > 0 ? this.values.length : this.values.length + 65536;
        System.out.println("{");
        int n2 = 0;
        while (n2 < 511) {
            System.out.print("(short)" + (this.indices[n2] >= 0 ? this.indices[n2] : this.indices[n2] + 65536) + ", ");
            if (n2 != 0 && n2 % 10 == 0) {
                System.out.println();
            }
            ++n2;
        }
        System.out.println("(short)" + (this.indices[511] >= 0 ? this.indices[n2] : this.indices[n2] + 65536) + " }");
        System.out.println("{");
        n2 = 0;
        while (n2 < n - 1) {
            System.out.print("(byte)" + this.values[n2] + ", ");
            if (n2 != 0 && n2 % 10 == 0) {
                System.out.println();
            }
            ++n2;
        }
        System.out.println("(byte)" + this.values[n - 1] + " }");
    }

    void printIndex(short n, short s) {
        int n2 = n;
        while (n2 < s) {
            System.out.println(String.valueOf(n2) + " -> : " + (this.indices[n2] >= 0 ? this.indices[n2] : this.indices[n2] + 65536));
            ++n2;
        }
        System.out.println();
    }

    void printPlainArray(int n, int n2, char[] cArray) {
        if (cArray != null) {
            int n3 = n;
            while (n3 < n + n2) {
                System.out.print(" " + this.values[cArray[n3]]);
                ++n3;
            }
        } else {
            int n4 = n;
            while (n4 < n + n2) {
                System.out.print(" " + this.values[n4]);
                ++n4;
            }
        }
        System.out.println("    Range: start " + n + " , count " + n2);
    }

    private void expand() {
        if (this.isCompact) {
            byte[] byArray = new byte[65536];
            int n = 0;
            while (n < 65536) {
                byArray[n] = this.elementAt((char)n);
                ++n;
            }
            n = 0;
            while (n < 512) {
                this.indices[n] = (short)(n << 7);
                ++n;
            }
            this.values = null;
            this.values = byArray;
            this.isCompact = false;
        }
    }

    private short capacity() {
        return (short)this.values.length;
    }

    private byte[] getArray() {
        return this.values;
    }

    private int FindOverlappingPosition(int n, char[] cArray, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 128;
            if (n3 + 128 > n2) {
                n4 = (short)(n2 - n3);
            }
            int n5 = 0;
            while (n5 < n4) {
                if (this.values[n + n5] != this.values[cArray[n3 + n5]]) break;
                n5 = (short)(n5 + 1);
            }
            if (n5 == n4) break;
            n3 += 128;
        }
        return n3;
    }
}

