/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import sun.net.ProgressData;
import sun.net.ProgressEntry;
import sun.net.www.HeaderParser;
import sun.net.www.MessageHeader;
import sun.net.www.http.HttpClient;
import sun.net.www.protocol.http.AuthenticationInfo;
import sun.net.www.protocol.http.BasicAuthentication;
import sun.net.www.protocol.http.EmptyInputStream;
import sun.net.www.protocol.http.Handler;
import sun.net.www.protocol.http.HttpAuthenticator;

public class HttpURLConnection
extends java.net.HttpURLConnection {
    static final String version = System.getProperty("java.version");
    public static final String userAgent = System.getProperty("http.agent", "Java" + version);
    static final String httpVersion = "HTTP/1.0";
    static final String acceptString = "text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2";
    static final int maxRedirects = 5;
    protected HttpClient http;
    protected Handler handler;
    protected PrintStream ps;
    private static HttpAuthenticator defaultAuth;
    private MessageHeader requests = new MessageHeader();
    protected ProgressEntry pe;
    private MessageHeader responses = new MessageHeader();
    private InputStream inputStream;
    private ByteArrayOutputStream poster;
    private boolean setRequests = false;
    private boolean failedOnce = false;
    private boolean shouldFollowRedirects = true;

    private void writeRequests() throws IOException {
        if (!this.setRequests) {
            AuthenticationInfo authenticationInfo;
            this.requests.prepend(String.valueOf(this.method) + " " + this.http.getURLFile() + " " + httpVersion, null);
            this.requests.setIfNotSet("User-Agent", userAgent);
            int n = this.url.getPort();
            String string = this.url.getHost();
            if (n != -1 && n != 80) {
                string = String.valueOf(string) + ":" + String.valueOf(n);
            }
            this.requests.setIfNotSet("Host", string);
            this.requests.setIfNotSet("Accept", acceptString);
            if (!this.failedOnce && HttpClient.httpKeepAliveSet) {
                if (this.http.usingProxy && !this.method.equals("POST") && !this.method.equals("PUT")) {
                    this.requests.set("Proxy-Connection", "keep-alive");
                } else if (!this.http.usingProxy) {
                    this.requests.set("Connection", "keep-alive");
                }
            }
            if (this.http.usingProxy && (authenticationInfo = AuthenticationInfo.getProxyAuth(this.http.getProxyHostUsed(), this.http.getProxyPortUsed())) != null && authenticationInfo.supportsPreemptiveAuthorization()) {
                this.requests.setIfNotSet(authenticationInfo.getHeaderName(), authenticationInfo.getHeaderValue());
            }
            if ((authenticationInfo = AuthenticationInfo.getServerAuth(this.url)) != null && authenticationInfo.supportsPreemptiveAuthorization()) {
                this.requests.setIfNotSet(authenticationInfo.getHeaderName(), authenticationInfo.getHeaderValue());
            }
            if (this.poster != null) {
                ByteArrayOutputStream byteArrayOutputStream = this.poster;
                synchronized (byteArrayOutputStream) {
                    this.requests.setIfNotSet("Content-type", "application/x-www-form-urlencoded");
                    this.requests.set("Content-length", String.valueOf(this.poster.size()));
                }
            }
            this.setRequests = true;
        }
        this.http.writeRequests(this.requests);
        if (this.poster != null) {
            this.poster.writeTo(this.ps);
            this.ps.flush();
        }
        if (this.ps.checkError()) {
            this.disconnect();
            if (this.failedOnce) {
                throw new IOException("Error writing to server");
            }
            this.failedOnce = true;
            this.http = this.getNewClient(this.url);
            this.ps = (PrintStream)this.http.getOutputStream();
            this.connected = true;
            this.responses = new MessageHeader();
            this.requests = new MessageHeader();
            this.setRequests = false;
            this.writeRequests();
        }
    }

    protected HttpClient getNewClient(URL uRL) throws IOException {
        return new HttpClient(uRL, null, -1);
    }

    protected HttpClient getProxiedClient(URL uRL, String string, int n) throws IOException {
        return new HttpClient(uRL, string, n);
    }

    protected HttpURLConnection(URL uRL, Handler handler) throws IOException {
        super(uRL);
        this.handler = handler;
    }

    public HttpURLConnection(URL uRL, String string, int n) {
        super(uRL);
        this.handler = new Handler(string, n);
    }

    public static void setDefaultAuthenticator(HttpAuthenticator httpAuthenticator) {
        defaultAuth = httpAuthenticator;
    }

    public static InputStream openConnectionCheckRedirects(URLConnection uRLConnection) throws IOException {
        boolean bl;
        int n = 0;
        InputStream inputStream = null;
        do {
            HttpURLConnection httpURLConnection;
            int n2;
            if (uRLConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)uRLConnection).setInstanceFollowRedirects(false);
            }
            inputStream = uRLConnection.getInputStream();
            bl = false;
            if (!(uRLConnection instanceof HttpURLConnection) || (n2 = (httpURLConnection = (HttpURLConnection)uRLConnection).getResponseCode()) < 300 || n2 > 305 || n2 == 304) continue;
            URL uRL = httpURLConnection.getURL();
            String string = httpURLConnection.getHeaderField("Location");
            URL uRL2 = null;
            if (string != null) {
                uRL2 = new URL(uRL, string);
            }
            httpURLConnection.disconnect();
            if (uRL2 == null || !uRL.getProtocol().equals(uRL2.getProtocol()) || uRL.getPort() != uRL2.getPort() || !HttpURLConnection.hostsEqual(uRL, uRL2) || n >= 5) {
                throw new SecurityException("illegal URL redirect");
            }
            bl = true;
            uRLConnection = uRL2.openConnection();
            ++n;
        } while (bl);
        return inputStream;
    }

    private static boolean hostsEqual(URL uRL, URL uRL2) {
        String string = uRL.getHost();
        String string2 = uRL2.getHost();
        if (string == null) {
            return string2 == null;
        }
        if (string2 == null) {
            return false;
        }
        if (string.equalsIgnoreCase(string2)) {
            return true;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            InetAddress inetAddress2 = InetAddress.getByName(string2);
            return inetAddress.equals(inetAddress2);
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (SecurityException securityException) {}
        return false;
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.http = "http".equals(this.url.getProtocol()) && !this.failedOnce ? HttpClient.New(this.url) : new HttpClient(this.url, this.handler.proxy, this.handler.proxyPort);
        this.ps = (PrintStream)this.http.getOutputStream();
        this.connected = true;
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        try {
            if (!this.doOutput) {
                throw new ProtocolException("cannot write to a URLConnection if doOutput=false - call setDoOutput(true)");
            }
            if (this.method.equals("GET")) {
                this.setRequestMethod("POST");
            }
            if (!"POST".equals(this.method) && !"PUT".equals(this.method) && "http".equals(this.url.getProtocol())) {
                throw new ProtocolException("HTTP method " + this.method + " doesn't support output");
            }
            if (this.inputStream != null) {
                throw new ProtocolException("Cannot write output after reading input.");
            }
            this.connect();
            this.ps = (PrintStream)this.http.getOutputStream();
            if (this.poster == null) {
                this.poster = new ByteArrayOutputStream();
            }
            return this.poster;
        }
        catch (RuntimeException runtimeException) {
            this.disconnect();
            throw runtimeException;
        }
        catch (IOException iOException) {
            this.disconnect();
            throw iOException;
        }
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (!this.doInput) {
            throw new ProtocolException("Cannot read from URLConnection if doInput=false (call setDoInput(true))");
        }
        if (this.inputStream != null) {
            return this.inputStream;
        }
        int n = 0;
        AuthenticationInfo authenticationInfo = null;
        AuthenticationInfo authenticationInfo2 = null;
        try {
            do {
                this.pe = new ProgressEntry(this.url.getFile(), null);
                ProgressData.pdata.register(this.pe);
                this.connect();
                this.ps = (PrintStream)this.http.getOutputStream();
                this.writeRequests();
                this.http.parseHTTP(this.responses, this.pe);
                this.inputStream = this.http.getInputStream();
                int n2 = this.getResponseCode();
                if (n2 == 407) {
                    if (authenticationInfo2 != null) {
                        authenticationInfo2.removeFromCache();
                    }
                    if ((authenticationInfo2 = this.getHttpProxyAuthentication()) != null) {
                        this.disconnect();
                        ++n;
                        continue;
                    }
                }
                if (n2 == 401) {
                    if (authenticationInfo != null) {
                        authenticationInfo.removeFromCache();
                    }
                    if ((authenticationInfo = this.getServerAuthentication()) != null) {
                        this.disconnect();
                        ++n;
                        continue;
                    }
                }
                if (n2 == 200 || n2 >= 300 && n2 <= 305) {
                    if (authenticationInfo2 != null) {
                        authenticationInfo2.addToCache();
                    }
                    if (authenticationInfo != null) {
                        authenticationInfo.addToCache();
                    }
                }
                if (this.followRedirect()) {
                    ++n;
                    if (this.url.getProtocol().startsWith("http")) continue;
                    return this.url.openStream();
                }
                if (this.method.equals("HEAD") || this.method.equals("TRACE")) {
                    this.disconnect();
                    this.inputStream = new EmptyInputStream();
                    return this.inputStream;
                }
                String string = this.url.getFile();
                if (!(n2 < 400 || string == null || string.endsWith(".html") || string.endsWith(".htm") || string.endsWith("/") || string.endsWith(".txt"))) {
                    throw new FileNotFoundException(this.url.toString());
                }
                return this.inputStream;
            } while (n < 5);
            throw new ProtocolException("Server redirected too many times (" + n + ")");
        }
        catch (RuntimeException runtimeException) {
            this.disconnect();
            throw runtimeException;
        }
        catch (IOException iOException) {
            this.disconnect();
            throw iOException;
        }
    }

    private AuthenticationInfo getHttpProxyAuthentication() {
        AuthenticationInfo authenticationInfo = null;
        String string = this.getHeaderField("Proxy-authenticate");
        String string2 = this.http.getProxyHostUsed();
        int n = this.http.getProxyPortUsed();
        if (string2 != null && string != null) {
            HeaderParser headerParser = new HeaderParser(string);
            String string3 = headerParser.findValue("realm");
            String string4 = headerParser.findKey(0);
            authenticationInfo = AuthenticationInfo.getProxyAuth(string2, n, string3);
            if (authenticationInfo == null && defaultAuth != null && defaultAuth.schemeSupported(string4)) {
                try {
                    URL uRL = new URL("http", string2, n, "/");
                    String string5 = defaultAuth.authString(uRL, string4, string3);
                    if (string5 != null) {
                        authenticationInfo = new BasicAuthentication(true, string2, n, string3, string5);
                    }
                }
                catch (MalformedURLException malformedURLException) {}
            }
            if (authenticationInfo != null && !authenticationInfo.setHeaders(this, headerParser)) {
                authenticationInfo = null;
            }
        }
        return authenticationInfo;
    }

    private AuthenticationInfo getServerAuthentication() {
        AuthenticationInfo authenticationInfo = null;
        String string = this.getHeaderField("WWW-Authenticate");
        if (string != null) {
            String string2;
            HeaderParser headerParser = new HeaderParser(string);
            String string3 = headerParser.findValue("realm");
            String string4 = headerParser.findKey(0);
            authenticationInfo = AuthenticationInfo.getServerAuth(this.url, string3);
            if (authenticationInfo == null && defaultAuth != null && defaultAuth.schemeSupported(string4) && (string2 = defaultAuth.authString(this.url, string4, string3)) != null) {
                authenticationInfo = new BasicAuthentication(false, this.url, string3, string2);
            }
            if (authenticationInfo != null && !authenticationInfo.setHeaders(this, headerParser)) {
                authenticationInfo = null;
            }
        }
        return authenticationInfo;
    }

    private boolean followRedirect() throws IOException {
        if (!this.shouldFollowRedirects) {
            return false;
        }
        if (!java.net.HttpURLConnection.getFollowRedirects()) {
            return false;
        }
        int n = this.getResponseCode();
        if (n < 300 || n > 305 || n == 304) {
            return false;
        }
        String string = this.getHeaderField("Location");
        if (string == null) {
            return false;
        }
        this.disconnect();
        this.responses = new MessageHeader();
        if (n == 305) {
            URL uRL = new URL(string);
            this.http = this.getProxiedClient(this.url, uRL.getHost(), uRL.getPort());
            this.requests.set(0, String.valueOf(this.method) + " " + this.http.getURLFile() + " " + httpVersion, null);
            this.connected = true;
        } else {
            this.url = new URL(this.url, string);
            if (!this.url.getProtocol().startsWith("http")) {
                return true;
            }
            if (this.method.equals("POST") && !Boolean.getBoolean("http.strictPostRedirect")) {
                this.requests = new MessageHeader();
                this.setRequests = false;
                this.setRequestMethod("GET");
                this.poster = null;
                this.connect();
            } else {
                this.connect();
                this.requests.set(0, String.valueOf(this.method) + " " + this.http.getURLFile() + " " + httpVersion, null);
                this.requests.set("Host", String.valueOf(this.url.getHost()) + (this.url.getPort() == -1 || this.url.getPort() == 80 ? "" : ":" + String.valueOf(this.url.getPort())));
            }
        }
        return true;
    }

    public void disconnect() {
        this.responseCode = -1;
        if (this.pe != null) {
            ProgressData.pdata.unregister(this.pe);
            this.pe = null;
        }
        if (this.http != null) {
            this.http.closeServer();
            this.http = null;
            this.connected = false;
        }
    }

    public boolean usingProxy() {
        if (this.http != null) {
            return this.http.usingProxy;
        }
        return false;
    }

    public String getHeaderField(String string) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {}
        return this.responses.findValue(string);
    }

    public String getHeaderField(int n) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {}
        return this.responses.getValue(n);
    }

    public String getHeaderFieldKey(int n) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {}
        return this.responses.getKey(n);
    }

    public void setRequestProperty(String string, String string2) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        if ("set-cookie".equalsIgnoreCase(string)) {
            this.requests.add(string, string2);
            return;
        }
        this.requests.set(string, string2);
    }

    void setAuthenticationProperty(String string, String string2) {
        this.requests.set(string, string2);
    }

    public String getRequestProperty(String string) {
        return this.requests.findValue(string);
    }

    public void finalize() {
        if (this.pe != null) {
            ProgressData.pdata.unregister(this.pe);
            this.pe = null;
        }
    }

    public void setInstanceFollowRedirects(boolean bl) {
        this.shouldFollowRedirects = bl;
    }

    String getMethod() {
        return this.method;
    }
}

