/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.systemresource;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import sun.net.www.URLConnection;
import sun.net.www.protocol.systemresource.SystemResourceManager;

public class SystemResourceConnection
extends URLConnection {
    private static boolean debug;
    private Object resource;
    private SystemResourceManager manager;

    SystemResourceConnection(URL uRL) throws MalformedURLException, IOException {
        super(uRL);
        this.debug("SystemResourceConnection(" + uRL + ")");
        this.manager = new SystemResourceManager(uRL);
    }

    public void connect() throws IOException {
        this.debug("Looking for " + this.url + " in SystemResourceManager");
        Object object = this.manager.getLocalResource();
        if (object == null) {
            this.debug("Invalid resource name");
            this.resource = null;
            return;
        }
        this.debug("Found resource");
        this.resource = object;
    }

    public Object getContent() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.resource;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.resource instanceof InputStream) {
            return (InputStream)this.resource;
        }
        return this.manager.getLocalResourceStream();
    }

    private void debug(String string) {
        if (debug) {
            System.err.println(string);
        }
    }
}

