/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.rmi.server.LogStream;
import sun.misc.Ref;
import sun.rmi.transport.DGCImpl;

public class WeakRef
extends Ref {
    private int hashValue;
    private Object hardref;

    public WeakRef(Object object) {
        this.setHashValue(object);
        this.setThing(object);
    }

    public WeakRef() {
        this.setHashValue(null);
    }

    public synchronized void pin() {
        if (this.hardref == null) {
            if (DGCImpl.logLevel >= 20) {
                LogStream.log("dgc").println("WeakRef.pin: ref = " + this);
            }
            this.hardref = this.check();
        }
    }

    public synchronized void unpin() {
        if (this.check() == null && this.hardref != null) {
            if (DGCImpl.logLevel >= 20) {
                LogStream.log("dgc").println("WeakRef.unpin: ref = " + this);
            }
            this.setThing(this.hardref);
        }
        this.hardref = null;
    }

    public Object reconstitute() {
        return this.hardref;
    }

    public synchronized void setThing(Object object) {
        this.setHashValue(object);
        super.setThing(object);
        if (this.hardref != null) {
            this.hardref = object;
        }
    }

    private void setHashValue(Object object) {
        if (object != null) {
            this.hashValue = System.identityHashCode(object);
            return;
        }
        this.hashValue = 0;
    }

    public int hashCode() {
        return this.hashValue;
    }

    public boolean equals(Object object) {
        if (object instanceof WeakRef) {
            if (object == this) {
                return true;
            }
            Object object2 = this.get();
            return object2 != null && object2 == ((WeakRef)object).get();
        }
        return false;
    }
}

