; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      plothist grqqn denest
; ----------------------------------------------------------------------------
; Macro         aslm02
; ----------------------------------------------------------------------------
; Description   calculates the histogram, qq plot and kernel density estimator 
;		returns of DBS50
; ----------------------------------------------------------------------------
  library("stats")
  x=read("dbs50.dat")
  nobs=4740
; uncomment the following line for sending output to a file
; output("dbs50sum.out","reset")
  x=x[1:nobs]
  library("stats")
  descriptive(x,"z")
  library("plot")
  setsize(480,320)
  plothist(x)
  gr=grqqn(x)
  plot(gr)

  library("smoother")
  h=(max(x)-min(x))*0.05
  fh=denest(x,h,"qua")
  fh=setmask(fh,"line")
  library("plot")
  plotdisplay2=createdisplay(1,1)
  show(plotdisplay2,1,1,fh)
  tl="Density Estimate"
  xl="Return"
  yl="density fh"
  setgopt(plotdisplay2,1,1,"title",tl,"xlabel",xl,"ylabel",yl)
; uncomment the following line for sending output to a file
; output("dbs50sum.out","close")