; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      simex
; ----------------------------------------------------------------------------
; Macro         eiv10
; ----------------------------------------------------------------------------
; Description   estimates the parameters of nonlinear eiv model for Heidelberg
;		cement factory data - simulation extrapolation
; ----------------------------------------------------------------------------
library("xplore") 
library("eiv")
V=read("heid.dat")
y=V[,1]
w=V[,2]
z=V[,3]
sw2=var(w)
su2=sw2/4
lam=aseq(0.01,6,0.5)
B=20
gest=simex(y,w,z,su2,lam,B)
gest
