; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      linreg denbwsel denest denestp grcontour2
; ----------------------------------------------------------------------------
; Macro         growdist
; ----------------------------------------------------------------------------
; Description   analysis of worldwide income distribution
; ----------------------------------------------------------------------------
  library("stats")                                         ; loads the library stats
  
  z=read("temple.dat")                                     ; reads the data (Temple 98, n=78) 
  z                                                        ; shows the data
  x=z[,2:10]                                               ; puts the independent variables in x
  y=z[,1]                                                  ; puts the dependent variable in y
  
  {b,bse,bstan,bpval}=linreg (x,y)                         ; computes the linear regression (Temple 98, p.47)
  
; GROWTH ACCOUNTING
  
; Contributions to the average growth differential
  
  pkap=(x[,1]-mean(x[,1]))*b[2,]+(x[,2]-mean(x[,2]))*b[3,]       ; sources of the growth differential
  hkap=(x[,3]-mean(x[,3]))*b[4,]                                   ; with respect to the average country
  wagr=(x[,4]-mean(x[,4]))*b[5,]
  conv=(x[,5]-mean(x[,5]))*b[6,]
  fix=((x[,6]-mean(x[,6]))*b[7,])+((x[,7]-mean(x[,7]))*b[8,])+((x[,8]-mean(x[,8]))*b[9,])+((x[,9]-mean(x[,9]))*b[10,])
  
; Counterfactual worldwide income kernel density estimates
  
; Bandwidth selection
  
  library("smoother")                                               ; load the smoother and plot libraries
  library("plot") 
  
  I60=x[,5]./max(x[,5])
  I85=(x[,5].+y)./max(x[,5].+y)
  {hcrit1,crit1}=denbwsel(I60)                                    ; bandwidth selection with "gau" for income in 1960 
  {hcrit2,crit2}=denbwsel(I85)                                    ; and 1985 normalized relative to the maximum.
  
; Univariate density estimate with pointwise confidence intervals.
  
d=(max(I60)-min(I60))./200                                         ; discretization binwidth.
{fh60,clo60,cup60}=denci(I60,hcrit1,0.10,"gau",d)                  ; density estimate with pointwise confidence intervals. 
  
fh85=denest(I85,hcrit2,"gau",d)                                    ; density estimate
  
w1=(x[,5].+pkap.+hkap.+wagr.+conv.+fix.+mean(y))./max(x[,5].+pkap.+hkap.+wagr.+conv.+fix.+mean(y))
fhpred=denest(w1,hcrit2,"gau",d)
w2=(x[,5].+pkap.+hkap.+wagr.+mean(y))./max(x[,5].+pkap.+hkap.+wagr.+mean(y))
fhfac=denest(w2,hcrit2,"gau",d)
w3=(x[,5].+conv.+mean(y))./max(x[,5].+conv.+mean(y))
fhconv=denest(w3,hcrit2,"gau",d)
  
fh60=setmask(fh60,"line","blue")
clo60=setmask(clo60,"line","blue","thin","dashed")
cup60=setmask(cup60,"line","blue","thin","dashed")
fh85=setmask(fh85,"line","red")
fhfac=setmask(fhfac,"line","yellow")
fhconv=setmask(fhconv,"line","green")
fhpred=setmask(fhpred,"line","magenta")
  
disp1=createdisplay(2,2)
  
show(disp1,1,1,fh60,clo60,cup60,fh85)
show(disp1,1,2,fh85,fhpred)
show(disp1,2,1,fh60,fhfac)
show(disp1,2,2,fh60,fhconv)
  
setgopt(disp1,1,1,"title","Density Confidence Intervals","xlabel","Income in 1960 and 1985","ylabel","density estimates")
setgopt(disp1,1,2,"title","Predicted vs 1985","xlabel","Income (Predicted & 85)" )
setgopt(disp1,2,1,"title","1960 plus factor accumulation effect","xlabel","Income (60 and factor accumulation)")
setgopt(disp1,2,2,"title","1960 plus Neoclassical convergence effect","xlabel","Income (60 and convergence)")
  
; Multivariate density
  
library("graphic")

bi1=I60~I85
d=(max(bi1)-min(bi1))./20                   
fh1=denestp(bi1,0.05,"gau",d)                         ; bivariate density estimate
c1=(1:5).*max(fh1[,3])./10
gs1=grcontour2(fh1,c1)                                ; generates Contours
bi2=I60~w1
d=(max(bi2)-min(bi2))./20                   
fhpred=denestp(bi2,0.05,"gau",d)
c2=(1:5).*max(fhpred[,3])./10
gspred=grcontour2(fhpred,c2)
bi3=I60~w2
d=(max(bi3)-min(bi2))./20                   
fhfac=denestp(bi3,0.05,"gau",d)
c3=(1:5).*max(fhfac[,3])./10
gsfac=grcontour2(fhfac,c3)
bi4=I60~w3
d=(max(bi4)-min(bi4))./20                   
fhconv=denestp(bi4,0.05,"gau",d)
c4=(1:5).*max(fhconv[,3])./10
gsconv=grcontour2(fhconv,c4)

disp2=createdisplay(2,2)

z=setmask(I60~I60,"line","red")                            ; 45 Line

show(disp2,1,1,gs1,z)
show(disp2,1,2,gspred,z)
show(disp2,2,1,gsfac,z)
show(disp2,2,2,gsconv,z)

setgopt(disp2,1,1,"title","Bivariate Density Estimate","xlabel","Income (1960)","ylabel","Income (1985)")
setgopt(disp2,1,2,"title","2D Density Estimate","xlabel","Income (1960)","ylabel","Predicted Income in 1985")
setgopt(disp2,2,1,"title","2D Density Estimate","xlabel","Income (1960)","ylabel","Factor Accumulation")
setgopt(disp2,2,2,"title","2D Density Estimate","xlabel","Income (1960)","ylabel","Neoclassical Convergence")


