; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      haznar
; ----------------------------------------------------------------------------
; Macro         haz03
; ----------------------------------------------------------------------------
; Description   explains the use of quantlet haznar which calculates the size
;		of the risk set
; ----------------------------------------------------------------------------
 library("hazreg")
 y = 2|1|3|2|4|7|1|3|2        ; hypothetical survival
 c = 3|1|5|6|1|6|2|4|5        ; hypothetical censoring
 t = min(y~c,2)               ; censored time             
 delta = (y<=c)               ; censoring indicator            
 {data,ties} = hazdat(t,delta) 
 nar = haznar(data)           ; calculate the number at risk             
 nar
