; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      epscontnorm
; ----------------------------------------------------------------------------
; Macro         rkalm01
; ----------------------------------------------------------------------------
; Description   simulates and plots data from contaminated multivariate 
;		normal distribution
; ----------------------------------------------------------------------------
library("Xplore")
library("plot")
library("kalman")

randomize(0)
T = 500
eps = 0.1
mid=#(0,0)
Cid = #(2,1)~#(1,1)
mcont=#(3,3)
Ccont = #(3,0)~#(0,0.2)
erg=epscontnorm(T,eps,mid,Cid,mcont,Ccont,0)
color=2*erg.Ind+2 
data=erg.X
setmaskp(data,color, 3, 8) 
disp = createdisplay(1,1)
show(disp,1,1,data)
