; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      kfilter2 calibrIC rICfil
; ----------------------------------------------------------------------------
; Macro         rkalm09
; ----------------------------------------------------------------------------
; Description   calculates classical Kalman filter and rIC filter for
;		data without outliers
; ----------------------------------------------------------------------------
library("xplore")
library("plot")
library("kalman")

serie = read("kalman2.dat")
y = serie[,2]
mu = #(0,0)
Sig = #(0,0)~#(0,0)
H = #(1,0)'
F = #(0.5,1)~#(-0.3,0)
R = #(1,0)~#(0,0)
Q = 4
T = dim(y)

e=0.05
N=300
eps=0.01
itmax=15
aus=4
fact=1.2
expl=2
A0=0     
b0=-1    
typ= 1   


ergIC=calibrIC(T,Sig,H,F,Q,R,typ,A0,b0,e,N,eps,itmax,expl,fact,aus)

A=ergIC.A
b=ergIC.b

res = kfilter2(y,mu,Sig, H,F,Q,R)
fx = res.filtX
fy=(H*fx')'
res= rICfil(y,mu,Sig,H,F,Q,R,typ,A,b)
frx = res.filtX
fry=(H*frx')'

origy = serie[,1]~serie[,2]
origy = setmask(origy, "line", "blue", "thin")

fy = serie[,1]~fy
fy = setmask(fy, "line", "red", "thin")
fry = serie[,1]~fry
fry = setmask(fry, "line", "green", "thin")
flags = serie[,1]~(res.clipInd)
flags=paf(flags,flags[,2]==1)
flags[,2]=0
setmaskp(flags,4, 3, 4)
  
disp = createdisplay(1,1)
show(disp,1,1,origy,fy,fry,flags)
setgopt(disp,1,1, "title", "KalmanData2 in Observation Space")
setgopt(disp,1,1, "xlabel", "t") 
setgopt(disp,1,1, "ylabel", "y, y-rIC, y-Kalman") 
 
