; -----------------------------------------------------------------             
; Library        xlg                                                            
; -----------------------------------------------------------------             
;  See_also                                                                     
; -----------------------------------------------------------------
;   Macro        graph27
; -----------------------------------------------------------------
;   Description  Several plots in one display.
; -----------------------------------------------------------------
  disp = createdisplay(2,3)      ; display with 6 windows
  xmin = 0                       ; grid minimum 
  xmax = 2*pi                    ; grid maximum
  n    = 100                     ; number of grid points
  x  = xmin + (xmax-xmin)/(n-1) .* (0:n-1)  ; generates grid
  y1 = sin(x)                    ; computes sin(x)
  y2 = sin(2.*x)                 ; computes sin(2x)
  y3 = sin(3.*x)                 ; computes sin(3x)
  y4 = sin(4.*x)                 ; computes sin(4x)
  y5 = sin(5.*x)                 ; computes sin(5x)
  y6 = sin(6.*x)                 ; computes sin(6x)
  show (disp, 1, 1, x~y1)        ; shows sine curve x~sin(x)
  show (disp, 1, 2, x~y2)        ; shows sine curve x~sin(2x)
  show (disp, 1, 3, x~y3)        ; shows sine curve x~sin(3x)
  show (disp, 2, 1, x~y4)        ; shows sine curve x~sin(4x)
  show (disp, 2, 2, x~y5)        ; shows sine curve x~sin(5x)
  show (disp, 2, 3, x~y6)        ; shows sine curve x~sin(6x)





